<style>
.form-header-modern {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.form-card-modern {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
    border: none;
    overflow: hidden;
}

.form-card-modern .card-header {
    background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
    border-bottom: 2px solid #e2e8f0;
    padding: 1.25rem 1.5rem;
    font-weight: 600;
    color: #2d3748;
}

.form-card-modern .card-body {
    padding: 2rem;
}

.form-label-modern {
    font-weight: 600;
    color: #2d3748;
    margin-bottom: 0.5rem;
    font-size: 0.875rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.form-control-modern {
    border-radius: 10px;
    border: 2px solid #e2e8f0;
    padding: 0.75rem 1rem;
    transition: all 0.3s ease;
}

.form-control-modern:focus {
    border-color: #72A565;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    outline: none;
}

.btn-submit-modern {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    border: none;
    color: white;
    padding: 0.75rem 2rem;
    border-radius: 10px;
    font-weight: 600;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(102, 126, 234, 0.3);
}

.btn-submit-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(102, 126, 234, 0.4);
    color: white;
}

.form-group-modern {
    margin-bottom: 1.5rem;
}

.image-preview {
    width: 200px;
    height: 200px;
    border-radius: 15px;
    object-fit: cover;
    border: 4px solid #e2e8f0;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    margin-bottom: 1rem;
}

.status-switch-group {
    background: #f7fafc;
    padding: 1.5rem;
    border-radius: 10px;
    border-left: 4px solid #667eea;
}
</style>

<!-- Begin Page Content -->
<div class="container-fluid">
    <div class="form-header-modern">
        <h2 class="mb-2">
            <i class="fa-solid fa-edit"></i> Edit Driver Details
        </h2>
        <p class="mb-0 opacity-75">Update driver information, city assignment, and status</p>
    </div>

    <!-- Driver Details Form -->
    <form method="post" enctype="multipart/form-data" id="editCustomerForm" action="<?php echo base_url() . "drivers/updatedriverdata/" . $id; ?>">
        <div class="form-card-modern">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fa-solid fa-user text-primary"></i> Driver Information
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12 form-group-modern">
                        <label for="image" class="form-label-modern">
                            <i class="fa-solid fa-image"></i> Driver Profile Image
                        </label>
                        <?php if (isset($driverdetails['image']) && !empty($driverdetails['image'])): ?>
                            <div class="mb-2">
                                <img class="image-preview" src="<?php echo $driverdetails['image']; ?>" alt="Current Image">
                            </div>
                        <?php endif; ?>
                        <input type="file" class="form-control form-control-modern" id="image" name="imagefile">
                        <small class="text-muted">Leave empty to keep current image</small>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 form-group-modern">
                        <label for="customerName" class="form-label-modern">First Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control form-control-modern" id="customerName" name="firstName" required
                            value="<?php echo $driverdetails['firstName']; ?>">
                    </div>
                    <div class="col-md-6 form-group-modern">
                        <label for="lastName" class="form-label-modern">Last Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control form-control-modern" id="lastName" name="lastName" required
                            value="<?php echo $driverdetails['lastName']; ?>">
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 form-group-modern">
                        <label for="customerEmail" class="form-label-modern">Email</label>
                        <input type="email" class="form-control form-control-modern" id="customerEmail" 
                            value="<?php echo $driverdetails['email']; ?>" readonly>
                        <small class="text-muted">Email cannot be changed</small>
                    </div>
                    <div class="col-md-6 form-group-modern">
                        <label for="customerPhone" class="form-label-modern">Phone <span class="text-danger">*</span></label>
                        <input type="text" class="form-control form-control-modern" id="customerPhone" name="phoneNumber"
                            value="<?php echo $driverdetails['phoneNumber']; ?>" required>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 form-group-modern">
                        <label for="c_password" class="form-label-modern">New Password</label>
                        <input class="form-control form-control-modern" id="c_password" autocomplete="off" type="password" 
                            placeholder="Leave empty to keep current password" name="newpassword" minlength="6">
                        <small class="text-muted">If you fill this field, password will be changed. Minimum 6 characters.</small>
                        <input type="hidden" name="password" value="<?php echo $driverdetails['password']; ?>" />
                    </div>
                    <div class="col-md-6 form-group-modern">
                        <label for="cityId" class="form-label-modern">Assign City <span class="text-danger">*</span></label>
                        <select id="cityId" name="cityId" class="form-control form-control-modern" required>
                            <option value="">-- Select City --</option>
                            <?php if (isset($cities) && !empty($cities)): ?>
                                <?php foreach ($cities as $cityId => $city): ?>
                                    <option value="<?php echo $cityId; ?>" 
                                        <?php echo (isset($driverdetails['cityId']) && $driverdetails['cityId'] == $cityId) ? 'selected' : ''; ?>>
                                        <?php echo isset($city['cityName']) ? $city['cityName'] : 'Unknown'; ?>
                                    </option>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </select>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 form-group-modern">
                        <div class="status-switch-group">
                            <label class="form-label-modern mb-3">Status Management</label>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" type="checkbox" id="isApproved" name="isApproved" value="1"
                                            <?php echo (isset($driverdetails['isApproved']) && $driverdetails['isApproved']) ? 'checked' : ''; ?> 
                                            style="width: 3rem; height: 1.5rem;">
                                        <label class="form-check-label" for="isApproved">
                                            <strong>Approved</strong><br>
                                            <small class="text-muted">Driver is approved to work</small>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" type="checkbox" id="isActive" name="isActive" value="1"
                                            <?php echo (!isset($driverdetails['isActive']) || $driverdetails['isActive']) ? 'checked' : ''; ?> 
                                            style="width: 3rem; height: 1.5rem;">
                                        <label class="form-check-label" for="isActive">
                                            <strong>Active</strong><br>
                                            <small class="text-muted">Driver is currently active</small>
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-check form-switch mb-3">
                                        <input class="form-check-input" type="checkbox" id="isOnline" name="isOnline" value="1"
                                            <?php echo (isset($driverdetails['isOnline']) && $driverdetails['isOnline']) ? 'checked' : ''; ?> 
                                            style="width: 3rem; height: 1.5rem;">
                                        <label class="form-check-label" for="isOnline">
                                            <strong>Online</strong><br>
                                            <small class="text-muted">Driver is available for orders</small>
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="text-end">
                    <button type="submit" class="btn btn-submit-modern">
                        <i class="fa-solid fa-save"></i> Save Driver Changes
                    </button>
                    <a href="<?php echo base_url('drivers'); ?>" class="btn btn-secondary btn-modern">
                        <i class="fa-solid fa-times"></i> Cancel
                    </a>
                </div>
            </div>
        </div>
    </form>

    <!-- Vehicle Details Form -->
    <form id="editVehicleForm" method="post" enctype="multipart/form-data" action="<?php echo base_url() . "drivers/updatevahicladata/" . $id . '/' . $vehicledetails['id']; ?>">
        <div class="form-card-modern">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fa-solid fa-car text-primary"></i> Vehicle Details
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 form-group-modern">
                        <label for="carColor" class="form-label-modern">Car Color</label>
                        <input type="text" class="form-control form-control-modern" id="carColor" name="color"
                            value="<?php echo $vehicledetails['color']; ?>" required>
                    </div>
                    <div class="col-md-6 form-group-modern">
                        <label for="make" class="form-label-modern">Make</label>
                        <input type="text" class="form-control form-control-modern" id="make" name="make"
                            value="<?php echo $vehicledetails['make']; ?>" required>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6 form-group-modern">
                        <label for="model" class="form-label-modern">Model</label>
                        <input type="text" class="form-control form-control-modern" id="model" name="model"
                            value="<?php echo $vehicledetails['model']; ?>" required>
                    </div>
                    <div class="col-md-6 form-group-modern">
                        <label for="tagNumber" class="form-label-modern">License Plate</label>
                        <input type="text" class="form-control form-control-modern" id="tagNumber" name="tagNumber"
                            value="<?php echo $vehicledetails['tagNumber']; ?>" required>
                    </div>
                </div>

                <hr class="section-divider">

                <h6 class="mb-3">
                    <i class="fa-solid fa-images text-primary"></i> Driver License Images
                </h6>

                <div class="row">
                    <div class="col-md-6 form-group-modern">
                        <label for="drivingFrontUrl" class="form-label-modern">Driving License Front</label>
                        <?php if (isset($vehicledetails['drivingFrontUrl']) && !empty($vehicledetails['drivingFrontUrl'])): ?>
                            <div class="mb-2">
                                <img class="image-preview" src="<?php echo $vehicledetails['drivingFrontUrl']; ?>" alt="Current Front License">
                            </div>
                        <?php endif; ?>
                        <input type="file" class="form-control form-control-modern" id="image" name="drivingFront">
                        <small class="text-muted">Leave empty to keep current image</small>
                    </div>
                    <div class="col-md-6 form-group-modern">
                        <label for="drivingBackUrl" class="form-label-modern">Driving License Back</label>
                        <?php if (isset($vehicledetails['drivingBackUrl']) && !empty($vehicledetails['drivingBackUrl'])): ?>
                            <div class="mb-2">
                                <img class="image-preview" src="<?php echo $vehicledetails['drivingBackUrl']; ?>" alt="Current Back License">
                            </div>
                        <?php endif; ?>
                        <input type="file" class="form-control form-control-modern" id="image" name="drivingBack">
                        <small class="text-muted">Leave empty to keep current image</small>
                    </div>
                </div>

                <div class="text-end">
                    <button type="submit" class="btn btn-submit-modern">
                        <i class="fa-solid fa-save"></i> Save Vehicle Changes
                    </button>
                    <a href="<?php echo base_url('drivers'); ?>" class="btn btn-secondary btn-modern">
                        <i class="fa-solid fa-times"></i> Cancel
                    </a>
                </div>
            </div>
        </div>
    </form>
</div>
