<div class="admin-page-title">
    <div class="d-flex flex-column flex-lg-row justify-content-between align-items-lg-center gap-3">
        <div>
            <h1 class="mb-0">Dispute Details</h1>
            <span class="admin-page-subtitle">Manage dispute resolution, communication, and refund processing.</span>
        </div>
        <div>
            <a href="<?php echo base_url('Dispute'); ?>" class="cannabus-action-btn view">
                <i class="fa-solid fa-arrow-left"></i> Back to Disputes
            </a>
        </div>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        <!-- Left Column: Dispute Information -->
        <div class="col-md-8">
            <!-- Dispute Information Card -->
            <div class="admin-table-card mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Dispute Information</h6>
                </div>
                <div class="card-body">
                    <form action="<?php echo base_url(); ?>dispute/updatedisputedata/<?php echo $id ?>" method="post">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Ticket No<span class="form-required">*</span></label>
                                    <input type="text" class="form-control" disabled value="<?php echo isset($reminderdetails['ticketNo']) ? $reminderdetails['ticketNo'] : ''; ?>">
                                    <input type="hidden" name="ticketNo" value="<?php echo isset($reminderdetails['ticketNo']) ? $reminderdetails['ticketNo'] : ''; ?>">
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Status</label>
                                    <select name="status" class="form-control">
                                        <option value="open" <?php echo (isset($reminderdetails['status']) && $reminderdetails['status'] == 'open') ? 'selected' : ''; ?>>Open</option>
                                        <option value="in_progress" <?php echo (isset($reminderdetails['status']) && $reminderdetails['status'] == 'in_progress') ? 'selected' : ''; ?>>In Progress</option>
                                        <option value="resolved" <?php echo (isset($reminderdetails['status']) && $reminderdetails['status'] == 'resolved') ? 'selected' : ''; ?>>Resolved</option>
                                        <option value="closed" <?php echo (isset($reminderdetails['status']) && $reminderdetails['status'] == 'closed') ? 'selected' : ''; ?>>Closed</option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Customer Name<span class="form-required">*</span></label>
                                    <input type="text" name="userName" class="form-control" value="<?php echo isset($reminderdetails['userName']) ? $reminderdetails['userName'] : ''; ?>" placeholder="Customer Name">
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Email<span class="form-required">*</span></label>
                                    <input type="email" name="userEmail" class="form-control" value="<?php echo isset($reminderdetails['userEmail']) ? $reminderdetails['userEmail'] : ''; ?>" placeholder="Email">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Phone<span class="form-required">*</span></label>
                                    <input type="tel" name="phoneNumber" class="form-control" value="<?php echo isset($reminderdetails['phoneNumber']) ? $reminderdetails['phoneNumber'] : ''; ?>" placeholder="Phone Number">
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Driver/Rider Name</label>
                                    <input type="text" name="driverName" class="form-control" value="<?php echo isset($reminderdetails['driverName']) ? $reminderdetails['driverName'] : ''; ?>" placeholder="Driver/Rider Name">
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-label">Reason<span class="form-required">*</span></label>
                                    <input type="text" name="reason" class="form-control" value="<?php echo isset($reminderdetails['reason']) ? $reminderdetails['reason'] : ''; ?>" placeholder="Reason">
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Date Opened</label>
                                    <input type="date" name="dateOpened" class="form-control" value="<?php echo isset($reminderdetails['dateOpened']) ? $reminderdetails['dateOpened'] : ''; ?>">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label">Date Closed</label>
                                    <input type="date" name="dateClosed" class="form-control" value="<?php echo isset($reminderdetails['dateClosed']) ? $reminderdetails['dateClosed'] : ''; ?>">
                                </div>
                            </div>
                            
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-label">Staff Member Handling</label>
                                    <input type="text" name="staffName" class="form-control" value="<?php echo isset($reminderdetails['staffName']) ? $reminderdetails['staffName'] : ''; ?>" placeholder="Staff Member Name">
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Update Dispute</button>
                    </form>
                </div>
            </div>

            <!-- Comments/Communication Section -->
            <div class="admin-table-card mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Communication & Comments</h6>
                </div>
                <div class="card-body">
                    <!-- Display existing comments -->
                    <?php if (isset($reminderdetails['comments']) && !empty($reminderdetails['comments'])): ?>
                        <div class="comments-section mb-4">
                            <?php foreach ($reminderdetails['comments'] as $comment): ?>
                                <div class="comment-item mb-3 p-3 border rounded">
                                    <div class="d-flex justify-content-between align-items-start mb-2">
                                        <div>
                                            <strong><?php echo isset($comment['commenterName']) ? $comment['commenterName'] : 'Admin'; ?></strong>
                                            <span class="text-muted small ms-2"><?php echo isset($comment['commenterRole']) ? ucfirst($comment['commenterRole']) : 'Admin'; ?></span>
                                        </div>
                                        <small class="text-muted">
                                            <?php echo isset($comment['createdAt']) ? date('M d, Y H:i', $comment['createdAt'] / 1000) : 'N/A'; ?>
                                        </small>
                                    </div>
                                    <p class="mb-0"><?php echo isset($comment['comment']) ? htmlspecialchars($comment['comment']) : ''; ?></p>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php else: ?>
                        <p class="text-muted">No comments yet. Add a comment below to communicate with the parties involved.</p>
                    <?php endif; ?>

                    <!-- Add new comment form -->
                    <form action="<?php echo base_url(); ?>dispute/addDisputeComment/<?php echo $id ?>" method="post" class="mt-3">
                        <div class="form-group">
                            <label class="form-label">Add Comment</label>
                            <textarea name="comment" class="form-control" rows="4" placeholder="Enter your comment or message..." required></textarea>
                            <input type="hidden" name="commenterRole" value="admin">
                            <input type="hidden" name="commenterId" value="<?php echo isset($this->session->userdata['session_data']['u_id']) ? $this->session->userdata['session_data']['u_id'] : ''; ?>">
                            <input type="hidden" name="commenterName" value="Admin">
                        </div>
                        <button type="submit" class="btn btn-primary">Add Comment</button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Right Column: Resolution & Refund -->
        <div class="col-md-4">
            <!-- Resolution Section -->
            <div class="admin-table-card mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Resolution</h6>
                </div>
                <div class="card-body">
                    <form action="<?php echo base_url(); ?>dispute/resolveDispute/<?php echo $id ?>" method="post">
                        <div class="form-group">
                            <label class="form-label">Resolution Notes<span class="form-required">*</span></label>
                            <textarea name="resolutionNotes" class="form-control" rows="4" placeholder="Enter resolution notes..." required><?php echo isset($reminderdetails['resolutionNotes']) ? htmlspecialchars($reminderdetails['resolutionNotes']) : ''; ?></textarea>
                        </div>

                        <div class="form-group">
                            <div class="form-check">
                                <input type="checkbox" name="approveRefund" class="form-check-input" id="approveRefund" <?php echo (isset($reminderdetails['refundApproved']) && $reminderdetails['refundApproved']) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="approveRefund">Approve Refund</label>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="form-label">Refund Amount</label>
                            <input type="number" name="refundAmount" class="form-control" step="0.01" value="<?php echo isset($reminderdetails['refundAmount']) ? $reminderdetails['refundAmount'] : '0.00'; ?>" placeholder="0.00">
                        </div>

                        <button type="submit" class="btn btn-success btn-block">Resolve Dispute</button>
                    </form>
                </div>
            </div>

            <!-- Refund Processing Section -->
            <?php if (isset($reminderdetails['refundApproved']) && $reminderdetails['refundApproved'] && !isset($reminderdetails['refundDate'])): ?>
            <div class="admin-table-card mb-4">
                <div class="card-header bg-warning">
                    <h6 class="m-0 font-weight-bold">Issue Refund</h6>
                </div>
                <div class="card-body">
                    <p class="text-muted small">This dispute has been approved for refund. Click below to issue the refund.</p>
                    <form action="<?php echo base_url(); ?>dispute/issueRefund/<?php echo $id ?>" method="post">
                        <div class="form-group">
                            <label class="form-label">Refund Amount</label>
                            <input type="number" name="refundAmount" class="form-control" step="0.01" value="<?php echo isset($reminderdetails['refundAmount']) ? $reminderdetails['refundAmount'] : '0.00'; ?>" required>
                        </div>
                        <button type="submit" class="btn btn-warning btn-block">Issue Refund</button>
                    </form>
                </div>
            </div>
            <?php endif; ?>

            <!-- Dispute Status Info -->
            <div class="admin-table-card">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Dispute Status</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <strong>Status:</strong>
                        <span class="badge badge-<?php 
                            $status = isset($reminderdetails['status']) ? $reminderdetails['status'] : 'open';
                            echo ($status == 'resolved' || $status == 'closed') ? 'success' : (($status == 'in_progress') ? 'warning' : 'danger');
                        ?> ml-2">
                            <?php echo ucfirst(str_replace('_', ' ', $status)); ?>
                        </span>
                    </div>
                    
                    <?php if (isset($reminderdetails['resolvedAt'])): ?>
                        <div class="mb-3">
                            <strong>Resolved At:</strong><br>
                            <small class="text-muted"><?php echo date('M d, Y H:i', $reminderdetails['resolvedAt'] / 1000); ?></small>
                        </div>
                    <?php endif; ?>

                    <?php if (isset($reminderdetails['refundDate'])): ?>
                        <div class="mb-3">
                            <strong>Refund Issued:</strong><br>
                            <small class="text-muted"><?php echo date('M d, Y H:i', $reminderdetails['refundDate'] / 1000); ?></small><br>
                            <strong>Amount:</strong> $<?php echo isset($reminderdetails['refundAmount']) ? number_format($reminderdetails['refundAmount'], 2) : '0.00'; ?>
                        </div>
                    <?php endif; ?>

                    <?php if (isset($reminderdetails['orderId'])): ?>
                        <div class="mb-3">
                            <strong>Order ID:</strong><br>
                            <a href="<?php echo base_url('Orders'); ?>" class="small"><?php echo $reminderdetails['orderId']; ?></a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
