<style>
.loyalty-history-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(114, 165, 101, 0.2);
}

.stats-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-left: 4px solid;
    height: 100%;
}

.stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.15);
}

.stats-card.primary { border-left-color: #72A565; }
.stats-card.success { border-left-color: #48bb78; }
.stats-card.warning { border-left-color: #ed8936; }
.stats-card.danger { border-left-color: #f56565; }

.filter-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 2rem;
}

.history-table-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    overflow: hidden;
}

.history-table-card .card-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 1.25rem 1.5rem;
    border: none;
}

.history-table-card table thead {
    background: #f7fafc;
}

.history-table-card table thead th {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    color: #4a5568;
    border: none;
    padding: 1rem;
}

.history-table-card table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #e2e8f0;
}

.history-table-card table tbody tr:hover {
    background: #f7fafc;
}

.history-table-card table tbody td {
    padding: 1.25rem 1rem;
    vertical-align: middle;
}

.badge-modern {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-weight: 500;
    font-size: 0.75rem;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.badge-earned {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    color: white;
}

.badge-redeemed {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    color: white;
}

.badge-expired {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.badge-birthday {
    background: linear-gradient(135deg, #9f7aea 0%, #805ad5 100%);
    color: white;
}

.points-positive {
    color: #48bb78;
    font-weight: 600;
}

.points-negative {
    color: #f56565;
    font-weight: 600;
}
</style>

<!-- Header Section -->
<div class="loyalty-history-header">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h2 class="mb-2">
                <i class="fa-solid fa-history"></i> Customer Loyalty History
            </h2>
            <p class="mb-0 opacity-75">View and analyze customer loyalty point transactions and activity</p>
        </div>
        <div>
            <a href="<?php echo base_url('loyalty'); ?>" class="btn btn-light btn-modern">
                <i class="fa-solid fa-cog"></i> Settings
            </a>
        </div>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-md-3 mb-3">
        <div class="stats-card primary">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="text-muted mb-1">Total Transactions</h6>
                    <h3 class="mb-0"><?php echo number_format($stats['totalTransactions']); ?></h3>
                </div>
                <div class="text-primary" style="font-size: 2.5rem;">
                    <i class="fa-solid fa-receipt"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="stats-card success">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="text-muted mb-1">Points Earned</h6>
                    <h3 class="mb-0"><?php echo number_format($stats['totalPointsEarned']); ?></h3>
                </div>
                <div class="text-success" style="font-size: 2.5rem;">
                    <i class="fa-solid fa-arrow-up"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="stats-card warning">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="text-muted mb-1">Points Redeemed</h6>
                    <h3 class="mb-0"><?php echo number_format($stats['totalPointsRedeemed']); ?></h3>
                </div>
                <div class="text-warning" style="font-size: 2.5rem;">
                    <i class="fa-solid fa-arrow-down"></i>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3 mb-3">
        <div class="stats-card danger">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h6 class="text-muted mb-1">Points Expired</h6>
                    <h3 class="mb-0"><?php echo number_format($stats['totalPointsExpired']); ?></h3>
                </div>
                <div class="text-danger" style="font-size: 2.5rem;">
                    <i class="fa-solid fa-clock"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="filter-card">
    <form method="get" action="<?php echo base_url('loyalty/history'); ?>">
        <div class="row">
            <div class="col-md-4 mb-3">
                <label class="form-label fw-bold">Customer</label>
                <select name="customerId" class="form-select">
                    <option value="">All Customers</option>
                    <?php foreach ($customers as $customerId => $customer): ?>
                        <option value="<?php echo $customerId; ?>" <?php echo ($selectedCustomerId == $customerId) ? 'selected' : ''; ?>>
                            <?php 
                            $name = isset($customer['firstName']) ? $customer['firstName'] : '';
                            $name .= isset($customer['lastName']) ? ' ' . $customer['lastName'] : '';
                            $name = trim($name);
                            if (empty($name)) $name = isset($customer['email']) ? $customer['email'] : 'Unknown';
                            echo htmlspecialchars($name);
                            ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-3 mb-3">
                <label class="form-label fw-bold">From Date</label>
                <input type="date" name="fromDate" class="form-select" value="<?php echo $fromDate; ?>">
            </div>
            <div class="col-md-3 mb-3">
                <label class="form-label fw-bold">To Date</label>
                <input type="date" name="toDate" class="form-select" value="<?php echo $toDate; ?>">
            </div>
            <div class="col-md-2 mb-3">
                <label class="form-label fw-bold">&nbsp;</label>
                <button type="submit" class="btn btn-primary w-100" style="background: linear-gradient(135deg, #72A565 0%, #91A134 100%); border: none;">
                    <i class="fa-solid fa-filter"></i> Filter
                </button>
            </div>
        </div>
    </form>
</div>

<!-- Transactions Table -->
<div class="history-table-card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fa-solid fa-list"></i> Loyalty Transactions
        </h5>
    </div>
    <div class="card-body p-0">
        <?php if (empty($transactions)): ?>
            <div class="text-center py-5">
                <i class="fa-solid fa-inbox fa-3x text-muted mb-3"></i>
                <p class="text-muted">No loyalty transactions found for the selected filters.</p>
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover mb-0" id="transactionsTable">
                    <thead>
                        <tr>
                            <th>Date & Time</th>
                            <th>Customer</th>
                            <th>Type</th>
                            <th>Points</th>
                            <th>Description</th>
                            <th>Order/Reference</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($transactions as $transactionId => $transaction): 
                            $customerId = isset($transaction['customerId']) ? $transaction['customerId'] : '';
                            $customer = isset($customers[$customerId]) ? $customers[$customerId] : null;
                            $customerName = 'Unknown';
                            if ($customer) {
                                $name = isset($customer['firstName']) ? $customer['firstName'] : '';
                                $name .= isset($customer['lastName']) ? ' ' . $customer['lastName'] : '';
                                $name = trim($name);
                                if (empty($name)) $name = isset($customer['email']) ? $customer['email'] : 'Unknown';
                                $customerName = $name;
                            }
                            $type = isset($transaction['type']) ? $transaction['type'] : 'earned';
                            $points = isset($transaction['points']) ? intval($transaction['points']) : 0;
                            $timestamp = isset($transaction['timestamp']) ? $transaction['timestamp'] : time() * 1000;
                        ?>
                        <tr>
                            <td>
                                <?php echo date('M d, Y', $timestamp / 1000); ?><br>
                                <small class="text-muted"><?php echo date('h:i A', $timestamp / 1000); ?></small>
                            </td>
                            <td>
                                <strong><?php echo htmlspecialchars($customerName); ?></strong>
                                <?php if ($customer): ?>
                                    <br><small class="text-muted"><?php echo htmlspecialchars($customerId); ?></small>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php 
                                $badgeClass = 'badge-earned';
                                $badgeIcon = 'fa-arrow-up';
                                $badgeText = 'Earned';
                                
                                if ($type == 'redeemed') {
                                    $badgeClass = 'badge-redeemed';
                                    $badgeIcon = 'fa-arrow-down';
                                    $badgeText = 'Redeemed';
                                } elseif ($type == 'expired') {
                                    $badgeClass = 'badge-expired';
                                    $badgeIcon = 'fa-clock';
                                    $badgeText = 'Expired';
                                } elseif ($type == 'birthday') {
                                    $badgeClass = 'badge-birthday';
                                    $badgeIcon = 'fa-birthday-cake';
                                    $badgeText = 'Birthday Bonus';
                                }
                                ?>
                                <span class="badge-modern <?php echo $badgeClass; ?>">
                                    <i class="fa-solid <?php echo $badgeIcon; ?>"></i>
                                    <?php echo $badgeText; ?>
                                </span>
                            </td>
                            <td>
                                <?php if ($type == 'earned' || $type == 'birthday'): ?>
                                    <span class="points-positive">+<?php echo number_format($points); ?></span>
                                <?php else: ?>
                                    <span class="points-negative">-<?php echo number_format($points); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php echo htmlspecialchars(isset($transaction['description']) ? $transaction['description'] : 'N/A'); ?>
                                <?php if (isset($transaction['reason'])): ?>
                                    <br><small class="text-muted"><?php echo htmlspecialchars($transaction['reason']); ?></small>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if (isset($transaction['orderId'])): ?>
                                    <a href="<?php echo base_url('orders/view/' . $transaction['orderId']); ?>" class="text-primary">
                                        Order #<?php echo htmlspecialchars($transaction['orderId']); ?>
                                    </a>
                                <?php elseif (isset($transaction['rewardId'])): ?>
                                    <span class="text-muted">Reward #<?php echo htmlspecialchars($transaction['rewardId']); ?></span>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- DataTables -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<script>
$(document).ready(function() {
    $('#transactionsTable').DataTable({
        order: [[0, 'desc']],
        pageLength: 25,
        language: {
            search: "Search transactions:",
            lengthMenu: "Show _MENU_ transactions per page",
            info: "Showing _START_ to _END_ of _TOTAL_ transactions",
            paginate: {
                first: "First",
                last: "Last",
                next: "Next",
                previous: "Previous"
            }
        }
    });
});
</script>
