<style>
.order-management-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.order-stats-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-left: 4px solid;
}

.order-stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.15);
}

.order-stats-card.primary { border-left-color: #667eea; }
.order-stats-card.success { border-left-color: #48bb78; }
.order-stats-card.warning { border-left-color: #ed8936; }
.order-stats-card.danger { border-left-color: #f56565; }
.order-stats-card.info { border-left-color: #4299e1; }

.filter-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 2rem;
}

.order-table-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    overflow: hidden;
}

.order-table-card .card-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 1.25rem 1.5rem;
    border: none;
}

.order-table-card table thead {
    background: #f7fafc;
}

.order-table-card table thead th {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    color: #4a5568;
    border: none;
    padding: 1rem;
}

.order-table-card table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #e2e8f0;
}

.order-table-card table tbody tr:hover {
    background: #f7fafc;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.order-table-card table tbody td {
    padding: 1.25rem 1rem;
    vertical-align: middle;
}

.badge-modern {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-weight: 500;
    font-size: 0.75rem;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.badge-modern i {
    font-size: 0.7rem;
}

.badge-primary-modern {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
}

.badge-success-modern {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    color: white;
}

.badge-warning-modern {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    color: white;
}

.badge-danger-modern {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.badge-info-modern {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
}

.badge-secondary-modern {
    background: linear-gradient(135deg, #a0aec0 0%, #718096 100%);
    color: white;
}

.btn-modern {
    border-radius: 10px;
    padding: 0.6rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
}

.btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}

.btn-modern-primary {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    border: none;
    color: white;
}

.stats-number {
    font-size: 2rem;
    font-weight: 700;
    margin: 0;
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.filter-icon {
    width: 40px;
    height: 40px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    margin-bottom: 1rem;
}

.order-link {
    color: #667eea;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s ease;
}

.order-link:hover {
    color: #764ba2;
    text-decoration: none;
}

.blocked-badge {
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% {
        opacity: 1;
    }
    50% {
        opacity: 0.7;
    }
}
</style>

<!-- Header Section -->
<div class="order-management-header">
    <div class="row align-items-center">
        <div class="col-md-6">
            <h2 class="mb-2">
                <i class="fa-solid fa-shopping-cart"></i> Order Management
            </h2>
            <p class="mb-0 opacity-75">Track, monitor, and manage all orders with distance, zone, and pricing details</p>
        </div>
    </div>
</div>

<!-- Statistics Cards -->
<?php
$totalOrders = count($orders);
$pendingOrders = 0;
$deliveredOrders = 0;
$blockedOrders = 0;
$totalRevenue = 0;

foreach ($orders as $order) {
    $status = isset($order['orderStatus']) ? $order['orderStatus'] : 'pending';
    if ($status == 'pending') $pendingOrders++;
    if ($status == 'delivered' || $status == 'deliver') $deliveredOrders++;
    
    if (isset($order['isBlocked']) && $order['isBlocked']) {
        $blockedOrders++;
    }
    
    $totalRevenue += isset($order['totalAmount']) ? $order['totalAmount'] : 0;
}
?>
<div class="row mb-4">
    <div class="col-md-3">
        <div class="order-stats-card primary">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon">
                        <i class="fa-solid fa-shopping-cart"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Total Orders</p>
                    <h3 class="stats-number mb-0"><?php echo $totalOrders; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="order-stats-card warning">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon" style="background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);">
                        <i class="fa-solid fa-clock"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Pending Orders</p>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo $pendingOrders; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="order-stats-card success">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon" style="background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);">
                        <i class="fa-solid fa-check-circle"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Delivered</p>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #48bb78 0%, #38a169 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo $deliveredOrders; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="order-stats-card <?php echo $blockedOrders > 0 ? 'danger' : 'info'; ?>">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <div class="filter-icon" style="background: linear-gradient(135deg, <?php echo $blockedOrders > 0 ? '#f56565 0%, #e53e3e 100%' : '#4299e1 0%, #3182ce 100%'; ?>);">
                        <i class="fa-solid fa-ban"></i>
                    </div>
                </div>
                <div class="flex-grow-1 ms-3">
                    <p class="text-muted mb-1 small">Blocked Orders</p>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, <?php echo $blockedOrders > 0 ? '#f56565 0%, #e53e3e 100%' : '#4299e1 0%, #3182ce 100%'; ?>); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo $blockedOrders; ?></h3>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="filter-card">
    <div class="d-flex align-items-center mb-3">
        <i class="fa-solid fa-filter text-primary me-2"></i>
        <h5 class="mb-0">Filter Orders</h5>
    </div>
    <form method="get" action="<?php echo base_url('orders'); ?>" class="row g-3">
        <div class="col-md-3">
            <label for="filter_city" class="form-label fw-bold">City</label>
            <select class="form-control form-select" id="filter_city" name="filter_city">
                <option value="">All Cities</option>
                <?php foreach ($cities as $cityId => $city): ?>
                    <option value="<?php echo $cityId; ?>" <?php echo (isset($filterCity) && $filterCity == $cityId) ? 'selected' : ''; ?>>
                        <?php echo isset($city['cityName']) ? $city['cityName'] : 'Unknown'; ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-2">
            <label for="filter_status" class="form-label fw-bold">Status</label>
            <select class="form-control form-select" id="filter_status" name="filter_status">
                <option value="all" <?php echo (!isset($filterStatus) || $filterStatus == 'all') ? 'selected' : ''; ?>>All Status</option>
                <option value="pending" <?php echo (isset($filterStatus) && $filterStatus == 'pending') ? 'selected' : ''; ?>>Pending</option>
                <option value="accepted" <?php echo (isset($filterStatus) && $filterStatus == 'accepted') ? 'selected' : ''; ?>>Accepted</option>
                <option value="picked" <?php echo (isset($filterStatus) && $filterStatus == 'picked') ? 'selected' : ''; ?>>Picked</option>
                <option value="delivered" <?php echo (isset($filterStatus) && $filterStatus == 'delivered') ? 'selected' : ''; ?>>Delivered</option>
                <option value="blocked" <?php echo (isset($filterStatus) && $filterStatus == 'blocked') ? 'selected' : ''; ?>>Blocked</option>
            </select>
        </div>
        <div class="col-md-2">
            <label for="filter_fulfillment" class="form-label fw-bold">Fulfillment</label>
            <select class="form-control form-select" id="filter_fulfillment" name="filter_fulfillment">
                <option value="all" <?php echo (!isset($filterFulfillment) || $filterFulfillment == 'all') ? 'selected' : ''; ?>>All Types</option>
                <option value="cannabus_inventory" <?php echo (isset($filterFulfillment) && $filterFulfillment == 'cannabus_inventory') ? 'selected' : ''; ?>>Cannabus Inventory</option>
                <option value="storefront_pickup" <?php echo (isset($filterFulfillment) && $filterFulfillment == 'storefront_pickup') ? 'selected' : ''; ?>>Storefront Pickup</option>
            </select>
        </div>
        <div class="col-md-2">
            <label for="filter_date_from" class="form-label fw-bold">Date From</label>
            <input type="date" class="form-control" id="filter_date_from" name="filter_date_from" value="<?php echo isset($filterDateFrom) ? $filterDateFrom : ''; ?>">
        </div>
        <div class="col-md-2">
            <label for="filter_date_to" class="form-label fw-bold">Date To</label>
            <input type="date" class="form-control" id="filter_date_to" name="filter_date_to" value="<?php echo isset($filterDateTo) ? $filterDateTo : ''; ?>">
        </div>
        <div class="col-md-1">
            <label class="form-label fw-bold">&nbsp;</label>
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-modern btn-modern-primary w-100">
                    <i class="fa-solid fa-filter"></i>
                </button>
                <a href="<?php echo base_url('orders'); ?>" class="btn btn-secondary btn-modern">
                    <i class="fa-solid fa-times"></i>
                </a>
            </div>
        </div>
    </form>
</div>

<!-- Orders Table -->
<div class="order-table-card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fa-solid fa-table"></i> Orders List
        </h5>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0" id="ordersTable">
                <thead>
                    <tr>
                        <th>Order #</th>
                        <th>Customer</th>
                        <th>City</th>
                        <th>Zone</th>
                        <th>Distance</th>
                        <th>Type</th>
                        <th>Cart Total</th>
                        <th>Delivery Fee</th>
                        <th>Total</th>
                        <th>Status</th>
                        <th>Date</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if (!empty($orders)) {
                        foreach ($orders as $orderId => $order) {
                            $orderNumber = 'ORD-' . substr($orderId, 0, 8);
                            $customerName = 'N/A';
                            
                            if (isset($order['customerId'])) {
                                $customer = $this->common->readdatadocument('Users', $order['customerId']);
                                if (!empty($customer)) {
                                    $customerName = isset($customer['firstName']) ? $customer['firstName'] . ' ' . (isset($customer['lastName']) ? $customer['lastName'] : '') : 'Unknown';
                                }
                            }
                            
                            $orderDate = isset($order['date']) ? date('Y-m-d H:i', $order['date'] / 1000) : 'N/A';
                            $status = isset($order['orderStatus']) ? $order['orderStatus'] : 'pending';
                            
                            // Determine fulfillment type
                            $fulfillmentType = 'Mixed';
                            if (isset($order['cannabusItems']) && isset($order['storefrontItems'])) {
                                if (empty($order['cannabusItems']) && !empty($order['storefrontItems'])) {
                                    $fulfillmentType = 'Storefront';
                                } elseif (!empty($order['cannabusItems']) && empty($order['storefrontItems'])) {
                                    $fulfillmentType = 'Cannabus';
                                }
                            }
                            
                            // Status badge colors
                            $statusColors = array(
                                'pending' => 'warning-modern',
                                'accepted' => 'info-modern',
                                'picked' => 'primary-modern',
                                'delivered' => 'success-modern',
                                'deliver' => 'success-modern',
                                'cancelled' => 'danger-modern',
                                'blocked' => 'danger-modern'
                            );
                            $statusColor = isset($statusColors[$status]) ? $statusColors[$status] : 'secondary-modern';
                    ?>
                    <tr <?php echo (isset($order['isBlocked']) && $order['isBlocked']) ? 'style="background-color: #fee;"' : ''; ?>>
                        <td>
                            <a href="<?php echo base_url('orders/view/' . $orderId); ?>" class="order-link">
                                <?php echo $orderNumber; ?>
                            </a>
                        </td>
                        <td><?php echo $customerName; ?></td>
                        <td>
                            <span class="badge-modern badge-info-modern">
                                <i class="fa-solid fa-city"></i>
                                <?php echo isset($order['cityName']) ? $order['cityName'] : 'N/A'; ?>
                            </span>
                        </td>
                        <td>
                            <?php if (isset($order['zone'])): ?>
                                <span class="badge-modern badge-primary-modern">
                                    <?php echo strtoupper($order['zone']); ?>
                                </span>
                            <?php else: ?>
                                <span class="text-muted">N/A</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if (isset($order['chargeableDistance'])): ?>
                                <strong><?php echo number_format($order['chargeableDistance'], 2); ?></strong> mi
                            <?php else: ?>
                                <span class="text-muted">N/A</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if ($fulfillmentType == 'Cannabus'): ?>
                                <span class="badge-modern badge-info-modern">
                                    <i class="fa-solid fa-box"></i> Cannabus
                                </span>
                            <?php elseif ($fulfillmentType == 'Storefront'): ?>
                                <span class="badge-modern badge-warning-modern">
                                    <i class="fa-solid fa-store"></i> Storefront
                                </span>
                            <?php else: ?>
                                <span class="badge-modern badge-primary-modern">
                                    <i class="fa-solid fa-layer-group"></i> Mixed
                                </span>
                            <?php endif; ?>
                        </td>
                        <td>$<?php echo isset($order['cartTotal']) ? number_format($order['cartTotal'], 2) : '0.00'; ?></td>
                        <td>$<?php echo isset($order['deliveryFee']) ? number_format($order['deliveryFee'], 2) : '0.00'; ?></td>
                        <td><strong>$<?php echo isset($order['totalAmount']) ? number_format($order['totalAmount'], 2) : '0.00'; ?></strong></td>
                        <td>
                            <?php if (isset($order['isBlocked']) && $order['isBlocked']): ?>
                                <span class="badge-modern badge-danger-modern blocked-badge">
                                    <i class="fa-solid fa-ban"></i> Blocked
                                </span>
                            <?php else: ?>
                                <span class="badge-modern badge-<?php echo $statusColor; ?>">
                                    <?php echo ucfirst(str_replace('_', ' ', $status)); ?>
                                </span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo $orderDate; ?></td>
                        <td>
                            <a href="<?php echo base_url('orders/view/' . $orderId); ?>" class="btn btn-sm btn-primary btn-modern">
                                <i class="fa-solid fa-eye"></i> View
                            </a>
                        </td>
                    </tr>
                    <?php
                        }
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
$(document).ready(function() {
    $('#ordersTable').DataTable({
        "order": [[ 10, "desc" ]],
        "pageLength": 25,
        "language": {
            "search": "<i class='fa-solid fa-search'></i> Search:",
            "lengthMenu": "Show _MENU_ orders per page",
            "info": "Showing _START_ to _END_ of _TOTAL_ orders",
            "infoEmpty": "No orders found",
            "infoFiltered": "(filtered from _MAX_ total orders)"
        }
    });
});
</script>
