<style>
.order-management-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(114, 165, 101, 0.2);
}

.order-stats-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-left: 4px solid;
    height: 100%;
}

.order-stats-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.15);
}

.order-stats-card.primary { border-left-color: #72A565; }
.order-stats-card.success { border-left-color: #48bb78; }
.order-stats-card.warning { border-left-color: #ed8936; }
.order-stats-card.info { border-left-color: #4299e1; }

.order-table-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    overflow: hidden;
}

.order-table-card .card-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 1.25rem 1.5rem;
    border: none;
}

.order-table-card table thead {
    background: #f7fafc;
}

.order-table-card table thead th {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    color: #4a5568;
    border: none;
    padding: 1rem;
}

.order-table-card table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #e2e8f0;
}

.order-table-card table tbody tr:hover {
    background: #f7fafc;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.order-table-card table tbody td {
    padding: 1.25rem 1rem;
    vertical-align: middle;
}

.badge-modern {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-weight: 500;
    font-size: 0.75rem;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.badge-primary-modern {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
}

.badge-success-modern {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    color: white;
}

.badge-warning-modern {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    color: white;
}

.badge-danger-modern {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.badge-info-modern {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
}

.btn-modern {
    border-radius: 10px;
    padding: 0.5rem 1rem;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    border: none;
    font-size: 0.875rem;
}

.btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}

.btn-modern-primary {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
}

.btn-modern-info {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
}

.stats-number {
    font-size: 2rem;
    font-weight: 700;
    margin: 0;
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.dropdown-toggle::after {
    display: none;
}

.action-dropdown .dropdown-menu {
    border-radius: 10px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.15);
    border: none;
    padding: 0.5rem;
}

.action-dropdown .dropdown-item {
    border-radius: 8px;
    padding: 0.75rem 1rem;
    transition: all 0.2s ease;
    margin-bottom: 0.25rem;
}

.action-dropdown .dropdown-item:hover {
    background: #f7fafc;
    transform: translateX(5px);
}

.action-dropdown .dropdown-item i {
    width: 20px;
    text-align: center;
}
</style>

<!-- Header Section -->
<div class="order-management-header">
    <div class="row align-items-center">
        <div class="col-md-8">
            <h2 class="mb-2">
                <i class="fa-solid fa-shopping-cart"></i> Order Management
            </h2>
            <p class="mb-0 opacity-75">Manage orders, track status, and monitor delivery performance</p>
        </div>
        <div class="col-md-4 text-end">
            <div class="text-white">
                <i class="fa-solid fa-clock"></i> Last Updated: <?php echo date('M d, Y H:i'); ?>
            </div>
        </div>
    </div>
</div>

<!-- Statistics Cards -->
<?php
$totalOrders = !empty($trips) ? count($trips) : 0;
$completedOrders = 0;
$pendingOrders = 0;
$cancelledOrders = 0;
$totalRevenue = 0;

if (!empty($trips)) {
    foreach ($trips as $order) {
        $status = isset($order['orderStatus']) ? $order['orderStatus'] : 'pending';
        $amount = isset($order['price']) ? floatval($order['price']) : 0;
        
        if (in_array($status, array('delivered', 'deliver', 'rate', 'rated', 'proccessed'))) {
            $completedOrders++;
            $totalRevenue += $amount;
        } elseif ($status == 'cancelled' || $status == 'cancel') {
            $cancelledOrders++;
        } else {
            $pendingOrders++;
        }
    }
}
?>
<div class="row mb-4">
    <div class="col-md-3">
        <div class="order-stats-card primary">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <i class="fa-solid fa-shopping-cart fa-2x text-muted opacity-50"></i>
                </div>
                <div class="flex-grow-1 ms-3">
                    <h6 class="text-muted mb-1">Total Orders</h6>
                    <h3 class="stats-number mb-0"><?php echo $totalOrders; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="order-stats-card success">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <i class="fa-solid fa-check-circle fa-2x text-muted opacity-50"></i>
                </div>
                <div class="flex-grow-1 ms-3">
                    <h6 class="text-muted mb-1">Completed</h6>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #48bb78 0%, #38a169 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo $completedOrders; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="order-stats-card warning">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <i class="fa-solid fa-clock fa-2x text-muted opacity-50"></i>
                </div>
                <div class="flex-grow-1 ms-3">
                    <h6 class="text-muted mb-1">Pending</h6>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo $pendingOrders; ?></h3>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="order-stats-card info">
            <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                    <i class="fa-solid fa-dollar-sign fa-2x text-muted opacity-50"></i>
                </div>
                <div class="flex-grow-1 ms-3">
                    <h6 class="text-muted mb-1">Total Revenue</h6>
                    <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">$<?php echo number_format($totalRevenue, 2); ?></h3>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Orders Table -->
<div class="order-table-card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fa-solid fa-table"></i> All Orders
        </h5>
    </div>
    <div class="card-body p-0">
        <?php if (!empty($trips)): ?>
        <div class="table-responsive">
            <table class="table table-hover mb-0" id="ordersTable">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Vendor</th>
                        <th>Address</th>
                        <th>Status</th>
                        <th>Total Products</th>
                        <th>Price</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($trips as $v => $d): 
                        $status = isset($d['orderStatus']) ? $d['orderStatus'] : 'pending';
                        $vendorName = function_exists('getusername') ? getusername($d['vendorId']) : 'Unknown Vendor';
                        $address = isset($d['address']['address']) ? $d['address']['address'] : 'N/A';
                    ?>
                    <tr>
                        <td class="text-nowrap">
                            <strong><?php echo date("M d, Y", $d['date'] / 1000); ?></strong><br>
                            <small class="text-muted"><?php echo date("H:i", $d['date'] / 1000); ?></small>
                        </td>
                        <td><?php echo htmlspecialchars($vendorName); ?></td>
                        <td>
                            <small><?php echo htmlspecialchars($address); ?></small>
                        </td>
                        <td>
                            <?php
                            $badgeClass = 'badge-info-modern';
                            $badgeIcon = 'fa-info-circle';
                            $badgeText = ucfirst(str_replace('_', ' ', $status));
                            
                            switch ($status) {
                                case 'process':
                                case 'processing':
                                    $badgeClass = 'badge-info-modern';
                                    $badgeIcon = 'fa-spinner';
                                    $badgeText = 'Processing';
                                    break;
                                case 'booked':
                                case 'driverAccepted':
                                    $badgeClass = 'badge-warning-modern';
                                    $badgeIcon = 'fa-clock';
                                    $badgeText = ($status == 'driverAccepted') ? 'Driver Arriving' : 'Booked';
                                    break;
                                case 'dispute':
                                case 'disputed':
                                    $badgeClass = 'badge-info-modern';
                                    $badgeIcon = 'fa-exclamation-triangle';
                                    $badgeText = 'Disputed';
                                    break;
                                case 'cancel':
                                case 'cancelled':
                                    $badgeClass = 'badge-danger-modern';
                                    $badgeIcon = 'fa-times-circle';
                                    $badgeText = 'Cancelled';
                                    break;
                                case 'deliver':
                                case 'delivered':
                                    $badgeClass = 'badge-success-modern';
                                    $badgeIcon = 'fa-check-circle';
                                    $badgeText = 'Delivered';
                                    break;
                                case 'proccessed':
                                case 'rated':
                                    $badgeClass = 'badge-success-modern';
                                    $badgeIcon = 'fa-star';
                                    $badgeText = ($status == 'rated') ? 'Rated' : 'Processed';
                                    break;
                            }
                            ?>
                            <span class="badge-modern <?php echo $badgeClass; ?>">
                                <i class="fa-solid <?php echo $badgeIcon; ?>"></i>
                                <?php echo $badgeText; ?>
                            </span>
                        </td>
                        <td>
                            <strong><?php echo isset($d['totalQuantity']) ? $d['totalQuantity'] : 0; ?></strong>
                        </td>
                        <td>
                            <strong>$<?php echo isset($d['price']) ? number_format($d['price'], 2) : '0.00'; ?></strong>
                        </td>
                        <td>
                            <div class="dropdown action-dropdown">
                                <button class="btn btn-sm btn-modern btn-modern-info" type="button" 
                                        data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="fa-solid fa-ellipsis-v"></i>
                                </button>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <li>
                                        <a class="dropdown-item" href="<?php echo base_url('Orders/vieworder/' . $v); ?>">
                                            <i class="fa-solid fa-eye text-primary"></i> View Order
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php else: ?>
        <div class="text-center py-5">
            <i class="fa-solid fa-shopping-cart fa-3x text-muted mb-3"></i>
            <p class="text-muted">No orders found</p>
        </div>
        <?php endif; ?>
    </div>
</div>

<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
$(document).ready(function() {
    $('#ordersTable').DataTable({
        "order": [[ 0, "desc" ]],
        "pageLength": 25,
        "language": {
            "search": "<i class='fa-solid fa-search'></i> Search:",
            "lengthMenu": "Show _MENU_ orders per page",
            "info": "Showing _START_ to _END_ of _TOTAL_ orders",
            "infoEmpty": "No orders found",
            "infoFiltered": "(filtered from _MAX_ total orders)"
        }
    });
});
</script>
