<style>
.report-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(114, 165, 101, 0.2);
}

.report-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-left: 4px solid;
    height: 100%;
}

.report-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.15);
}

.report-card.primary { border-left-color: #72A565; }
.report-card.success { border-left-color: #48bb78; }
.report-card.info { border-left-color: #4299e1; }
.report-card.warning { border-left-color: #ed8936; }

.report-table-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    overflow: hidden;
    margin-bottom: 2rem;
}

.report-table-card .card-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 1.25rem 1.5rem;
    border: none;
}

.report-table-card table thead {
    background: #f7fafc;
}

.report-table-card table thead th {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    color: #4a5568;
    border: none;
    padding: 1rem;
}

.report-table-card table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #e2e8f0;
}

.report-table-card table tbody tr:hover {
    background: #f7fafc;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.report-table-card table tbody td {
    padding: 1.25rem 1rem;
    vertical-align: middle;
}

.filter-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 2rem;
}

.stats-number {
    font-size: 2rem;
    font-weight: 700;
    margin: 0;
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}
</style>

<!-- Begin Page Content -->
<div class="container-fluid">
    <!-- Header Section -->
    <div class="report-header">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h2 class="mb-2">
                    <i class="fa-solid fa-chart-line"></i> Delivery Reports & Analytics
                </h2>
                <p class="mb-0 opacity-75">Comprehensive analytics for orders, revenue, and delivery performance</p>
            </div>
            <div class="col-md-4 text-end">
                <div class="text-white">
                    <i class="fa-solid fa-chart-bar"></i> Analytics Dashboard
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="filter-card mb-4">
        <div class="d-flex align-items-center mb-3">
            <i class="fa-solid fa-filter text-primary me-2"></i>
            <h5 class="mb-0">Filter Reports</h5>
        </div>
        <div class="card-body">
            <form method="get" action="<?php echo base_url('Reports/delivery'); ?>">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>From Date</label>
                            <input type="date" name="fromDate" class="form-control" value="<?php echo isset($fromDate) ? $fromDate : date('Y-m-d', strtotime('-30 days')); ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>To Date</label>
                            <input type="date" name="toDate" class="form-control" value="<?php echo isset($toDate) ? $toDate : date('Y-m-d'); ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>City</label>
                            <select name="cityId" class="form-control">
                                <option value="">All Cities</option>
                                <?php foreach ($cities as $cityId => $city): ?>
                                    <option value="<?php echo $cityId; ?>" <?php echo (isset($selectedCityId) && $selectedCityId == $cityId) ? 'selected' : ''; ?>>
                                        <?php echo isset($city['cityName']) ? $city['cityName'] : 'Unknown'; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <button type="submit" class="btn btn-primary btn-block">Generate Report</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="report-card primary">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fa-solid fa-shopping-cart fa-2x text-muted opacity-50"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <h6 class="text-muted mb-1">Total Orders</h6>
                        <h3 class="stats-number mb-0"><?php echo isset($stats['totalOrders']) ? $stats['totalOrders'] : 0; ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="report-card success">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fa-solid fa-dollar-sign fa-2x text-muted opacity-50"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <h6 class="text-muted mb-1">Total Revenue</h6>
                        <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #48bb78 0%, #38a169 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">$<?php echo isset($stats['totalRevenue']) ? number_format($stats['totalRevenue'], 2) : '0.00'; ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="report-card info">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fa-solid fa-store fa-2x text-muted opacity-50"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <h6 class="text-muted mb-1">Multi-Vendor Orders</h6>
                        <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo isset($stats['multiVendorOrders']) ? $stats['multiVendorOrders'] : 0; ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="report-card warning">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fa-solid fa-building fa-2x text-muted opacity-50"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <h6 class="text-muted mb-1">Storefront Orders</h6>
                        <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;"><?php echo isset($stats['storefrontOrders']) ? $stats['storefrontOrders'] : 0; ?></h3>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Orders by City -->
    <?php if (!empty($stats['ordersByCity'])): ?>
    <div class="report-table-card">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fa-solid fa-city"></i> Orders by City
            </h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>City</th>
                            <th>Orders</th>
                            <th>Revenue</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($stats['ordersByCity'] as $cityName => $count): ?>
                        <tr>
                            <td><?php echo $cityName; ?></td>
                            <td><?php echo $count; ?></td>
                            <td>$<?php echo isset($stats['revenueByCity'][$cityName]) ? number_format($stats['revenueByCity'][$cityName], 2) : '0.00'; ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Orders by Zone -->
    <?php if (!empty($stats['ordersByZone'])): ?>
    <div class="report-table-card">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fa-solid fa-map-marked-alt"></i> Orders by Zone
            </h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Zone</th>
                            <th>Orders</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($stats['ordersByZone'] as $zone => $count): ?>
                        <tr>
                            <td><?php echo strtoupper($zone); ?></td>
                            <td><?php echo $count; ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Orders by Status -->
    <?php if (!empty($stats['ordersByStatus'])): ?>
    <div class="report-table-card">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fa-solid fa-info-circle"></i> Orders by Status
            </h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Status</th>
                            <th>Count</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($stats['ordersByStatus'] as $status => $count): 
                            $statusLabel = ucfirst(str_replace('_', ' ', $status));
                        ?>
                        <tr>
                            <td>
                                <strong><?php echo htmlspecialchars($statusLabel); ?></strong>
                            </td>
                            <td>
                                <span class="badge badge-primary" style="background: linear-gradient(135deg, #72A565 0%, #91A134 100%); color: white; padding: 0.5rem 1rem; border-radius: 20px;">
                                    <?php echo $count; ?>
                                </span>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <?php if (empty($stats['ordersByCity']) && empty($stats['ordersByZone']) && empty($stats['ordersByStatus'])): ?>
    <div class="report-table-card">
        <div class="card-body text-center py-5">
            <i class="fa-solid fa-chart-bar fa-3x text-muted mb-3"></i>
            <h5 class="text-muted">No Data Found</h5>
            <p class="text-muted">No delivery data found for the selected period. Try adjusting your filters.</p>
        </div>
    </div>
    <?php endif; ?>
</div>

<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
$(document).ready(function() {
    $('.datatableexport').DataTable({
        "order": [[ 0, "desc" ]],
        "pageLength": 25,
        "language": {
            "search": "<i class='fa-solid fa-search'></i> Search:",
            "lengthMenu": "Show _MENU_ records per page",
            "info": "Showing _START_ to _END_ of _TOTAL_ records",
            "infoEmpty": "No records found",
            "infoFiltered": "(filtered from _MAX_ total records)"
        }
    });
});
</script>
