<style>
.revenue-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(114, 165, 101, 0.2);
}

.revenue-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-left: 4px solid;
    height: 100%;
}

.revenue-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.15);
}

.revenue-card.primary { border-left-color: #72A565; }
.revenue-card.success { border-left-color: #48bb78; }
.revenue-card.info { border-left-color: #4299e1; }
.revenue-card.warning { border-left-color: #ed8936; }
.revenue-card.danger { border-left-color: #f56565; }

.revenue-table-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    overflow: hidden;
    margin-bottom: 2rem;
}

.revenue-table-card .card-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 1.25rem 1.5rem;
    border: none;
}

.revenue-table-card table thead {
    background: #f7fafc;
}

.revenue-table-card table thead th {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    color: #4a5568;
    border: none;
    padding: 1rem;
}

.revenue-table-card table tbody tr {
    transition: all 0.3s ease;
    border-bottom: 1px solid #e2e8f0;
}

.revenue-table-card table tbody tr:hover {
    background: #f7fafc;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.revenue-table-card table tbody td {
    padding: 1.25rem 1rem;
    vertical-align: middle;
}

.stats-number {
    font-size: 2rem;
    font-weight: 700;
    margin: 0;
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.filter-card {
    background: white;
    border-radius: 15px;
    padding: 1.5rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 2rem;
}
</style>

<!-- Begin Page Content -->
<div class="container-fluid">
    <!-- Header Section -->
    <div class="revenue-header">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h2 class="mb-2">
                    <i class="fa-solid fa-dollar-sign"></i> Revenue & Financial Reports
                </h2>
                <p class="mb-0 opacity-75">Monitor revenue, commissions, vendor earnings, and financial metrics</p>
            </div>
            <div class="col-md-4 text-end">
                <div class="text-white">
                    <i class="fa-solid fa-chart-line"></i> Real-time Analytics
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="filter-card mb-4">
        <div class="d-flex align-items-center mb-3">
            <i class="fa-solid fa-filter text-primary me-2"></i>
            <h5 class="mb-0">Filter Reports</h5>
        </div>
        <div class="card-body">
            <form method="get" action="<?php echo base_url('Reports/revenue'); ?>">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>From Date</label>
                            <input type="date" name="fromDate" class="form-control" value="<?php echo isset($fromDate) ? $fromDate : date('Y-m-d', strtotime('-30 days')); ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>To Date</label>
                            <input type="date" name="toDate" class="form-control" value="<?php echo isset($toDate) ? $toDate : date('Y-m-d'); ?>">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Vendor</label>
                            <select name="vendorId" class="form-control">
                                <option value="">All Vendors</option>
                                <?php if (!empty($vendors)): ?>
                                    <?php foreach ($vendors as $vendorId => $vendor): ?>
                                        <option value="<?php echo $vendorId; ?>" <?php echo (isset($selectedVendorId) && $selectedVendorId == $vendorId) ? 'selected' : ''; ?>>
                                            <?php echo isset($vendor['shopName']) ? $vendor['shopName'] : (isset($vendor['firstName']) ? $vendor['firstName'] : 'Unknown Vendor'); ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <button type="submit" class="btn btn-primary btn-block">Generate Report</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Financial Summary Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="revenue-card primary">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fa-solid fa-dollar-sign fa-2x text-muted opacity-50"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <h6 class="text-muted mb-1">Total Revenue</h6>
                        <h3 class="stats-number mb-0">$<?php echo isset($financials['totalRevenue']) ? number_format($financials['totalRevenue'], 2) : '0.00'; ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="revenue-card info">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fa-solid fa-percent fa-2x text-muted opacity-50"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <h6 class="text-muted mb-1">Platform Commission</h6>
                        <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">$<?php echo isset($financials['platformCommission']) ? number_format($financials['platformCommission'], 2) : '0.00'; ?></h3>
                        <small class="text-muted"><?php echo isset($financials['commissionRate']) ? ($financials['commissionRate'] * 100) : '10'; ?>% rate</small>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="revenue-card success">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fa-solid fa-store fa-2x text-muted opacity-50"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <h6 class="text-muted mb-1">Vendor Earnings</h6>
                        <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #48bb78 0%, #38a169 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">$<?php echo isset($financials['vendorEarnings']) ? number_format($financials['vendorEarnings'], 2) : '0.00'; ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="revenue-card primary">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fa-solid fa-chart-line fa-2x text-muted opacity-50"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <h6 class="text-muted mb-1">Net Revenue</h6>
                        <h3 class="stats-number mb-0">$<?php echo isset($financials['netRevenue']) ? number_format($financials['netRevenue'], 2) : '0.00'; ?></h3>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Additional Financial Metrics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="revenue-card warning">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fa-solid fa-motorcycle fa-2x text-muted opacity-50"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <h6 class="text-muted mb-1">Rider Payouts</h6>
                        <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">$<?php echo isset($financials['riderPayouts']) ? number_format($financials['riderPayouts'], 2) : '0.00'; ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="revenue-card danger">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fa-solid fa-undo fa-2x text-muted opacity-50"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <h6 class="text-muted mb-1">Refunds Issued</h6>
                        <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">$<?php echo isset($financials['refundsIssued']) ? number_format($financials['refundsIssued'], 2) : '0.00'; ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="revenue-card info">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fa-solid fa-credit-card fa-2x text-muted opacity-50"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <h6 class="text-muted mb-1">Processing Fees</h6>
                        <h3 class="stats-number mb-0" style="background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">$<?php echo isset($financials['paymentProcessingFees']) ? number_format($financials['paymentProcessingFees'], 2) : '0.00'; ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="revenue-card primary">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0">
                        <i class="fa-solid fa-shopping-cart fa-2x text-muted opacity-50"></i>
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <h6 class="text-muted mb-1">Total Orders</h6>
                        <h3 class="stats-number mb-0"><?php echo isset($financials['ordersCount']) ? $financials['ordersCount'] : 0; ?></h3>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Revenue by Vendor -->
    <?php if (!empty($financials['revenueByVendor'])): ?>
    <div class="revenue-table-card">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fa-solid fa-store"></i> Revenue by Vendor
            </h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered datatableexport">
                    <thead>
                        <tr>
                            <th>Vendor Name</th>
                            <th>Total Revenue</th>
                            <th>Vendor Earnings</th>
                            <th>Orders Count</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($financials['revenueByVendor'] as $vendor): ?>
                        <tr>
                            <td><?php echo isset($vendor['vendorName']) ? $vendor['vendorName'] : 'Unknown Vendor'; ?></td>
                            <td>$<?php echo isset($vendor['totalRevenue']) ? number_format($vendor['totalRevenue'], 2) : '0.00'; ?></td>
                            <td>$<?php echo isset($vendor['earnings']) ? number_format($vendor['earnings'], 2) : '0.00'; ?></td>
                            <td><?php echo isset($vendor['ordersCount']) ? $vendor['ordersCount'] : 0; ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Revenue by Category -->
    <?php if (!empty($financials['revenueByCategory'])): ?>
    <div class="revenue-table-card">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fa-solid fa-tags"></i> Revenue by Category
            </h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered datatableexport">
                    <thead>
                        <tr>
                            <th>Category</th>
                            <th>Total Revenue</th>
                            <th>Orders Count</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($financials['revenueByCategory'] as $category): ?>
                        <tr>
                            <td><?php echo isset($category['categoryName']) ? $category['categoryName'] : 'Unknown Category'; ?></td>
                            <td>$<?php echo isset($category['totalRevenue']) ? number_format($category['totalRevenue'], 2) : '0.00'; ?></td>
                            <td><?php echo isset($category['ordersCount']) ? $category['ordersCount'] : 0; ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Revenue by Day Chart -->
    <?php if (!empty($financials['revenueByDay'])): ?>
    <div class="revenue-table-card">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="fa-solid fa-chart-line"></i> Revenue Trend (Daily)
            </h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Revenue</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        // Sort by date
                        ksort($financials['revenueByDay']);
                        foreach ($financials['revenueByDay'] as $date => $revenue): 
                        ?>
                        <tr>
                            <td><?php echo date('M d, Y', strtotime($date)); ?></td>
                            <td>$<?php echo number_format($revenue, 2); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if (empty($financials['revenueByVendor']) && empty($financials['revenueByCategory'])): ?>
    <div class="revenue-table-card">
        <div class="card-body text-center py-5">
            <i class="fa-solid fa-chart-line fa-3x text-muted mb-3"></i>
            <h5 class="text-muted">No Revenue Data Found</h5>
            <p class="text-muted">No revenue data found for the selected period. Try adjusting your filters.</p>
        </div>
    </div>
    <?php endif; ?>
</div>
