<style>
.vendor-detail-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.detail-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border: none;
    overflow: hidden;
}

.detail-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.12);
}

.detail-card .card-header {
    background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
    border-bottom: 2px solid #e2e8f0;
    padding: 1.25rem 1.5rem;
    font-weight: 600;
    color: #2d3748;
}

.detail-card .card-body {
    padding: 1.5rem;
}

.vendor-profile-image {
    width: 150px;
    height: 150px;
    border-radius: 15px;
    object-fit: cover;
    border: 4px solid white;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
}

.vendor-profile-placeholder {
    width: 150px;
    height: 150px;
    border-radius: 15px;
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 3rem;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
}

.info-item {
    padding: 1rem;
    background: #f7fafc;
    border-radius: 10px;
    margin-bottom: 1rem;
    border-left: 4px solid #667eea;
    transition: all 0.3s ease;
}

.info-item:hover {
    background: #edf2f7;
    transform: translateX(5px);
}

.info-item-label {
    font-size: 0.75rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    color: #718096;
    font-weight: 600;
    margin-bottom: 0.5rem;
}

.info-item-value {
    font-size: 1rem;
    color: #2d3748;
    font-weight: 500;
}

.badge-lg-modern {
    padding: 0.75rem 1.5rem;
    border-radius: 25px;
    font-weight: 600;
    font-size: 0.875rem;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.driver-card {
    background: white;
    border: 2px solid #e2e8f0;
    border-radius: 10px;
    padding: 1rem;
    margin-bottom: 0.75rem;
    transition: all 0.3s ease;
}

.driver-card:hover {
    border-color: #667eea;
    box-shadow: 0 5px 15px rgba(102, 126, 234, 0.1);
    transform: translateX(5px);
}

.action-btn-modern {
    border-radius: 10px;
    padding: 0.75rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    width: 100%;
    margin-bottom: 0.5rem;
}

.action-btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}

.alert-modern {
    border-radius: 10px;
    border: none;
    padding: 1.25rem;
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}

.distance-badge {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-weight: 600;
    font-size: 1.1rem;
    display: inline-block;
    margin-top: 0.5rem;
}
</style>

<!-- Header -->
<div class="vendor-detail-header">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h2 class="mb-2">
                <i class="fa-solid fa-store"></i> Vendor Details
            </h2>
            <p class="mb-0 opacity-75">Complete vendor information and configuration</p>
        </div>
        <div>
            <a href="<?php echo base_url('vendors/editvendor/' . $vendorId); ?>" class="btn btn-light btn-modern">
                <i class="fa-solid fa-edit"></i> Edit Vendor
            </a>
            <a href="<?php echo base_url('vendors'); ?>" class="btn btn-light btn-modern">
                <i class="fa-solid fa-arrow-left"></i> Back to List
            </a>
        </div>
    </div>
</div>

<div class="row">
    <!-- Main Content -->
    <div class="col-md-8">
        <!-- Vendor Information -->
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fa-solid fa-user-circle text-primary"></i> Vendor Information
                </h5>
            </div>
            <div class="card-body">
                <div class="row mb-4">
                    <div class="col-md-4 text-center">
                        <?php if (isset($vendor['image']) && !empty($vendor['image'])): ?>
                            <img src="<?php echo $vendor['image']; ?>" alt="Vendor Image" class="vendor-profile-image">
                        <?php else: ?>
                            <div class="vendor-profile-placeholder">
                                <i class="fa-solid fa-user"></i>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-8">
                        <h3 class="mb-3"><?php echo isset($vendor['firstName']) ? $vendor['firstName'] : ''; ?> <?php echo isset($vendor['lastName']) ? $vendor['lastName'] : ''; ?></h3>
                        <div class="info-item">
                            <div class="info-item-label">
                                <i class="fa-solid fa-envelope"></i> Email Address
                            </div>
                            <div class="info-item-value"><?php echo isset($vendor['email']) ? $vendor['email'] : '-'; ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-item-label">
                                <i class="fa-solid fa-phone"></i> Phone Number
                            </div>
                            <div class="info-item-value"><?php echo isset($vendor['phoneNumber']) ? $vendor['phoneNumber'] : '-'; ?></div>
                        </div>
                        <?php if (isset($vendor['shopName']) && !empty($vendor['shopName'])): ?>
                        <div class="info-item">
                            <div class="info-item-label">
                                <i class="fa-solid fa-store"></i> Store Name
                            </div>
                            <div class="info-item-value"><?php echo $vendor['shopName']; ?></div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">Fulfillment Type</div>
                            <div>
                                <?php 
                                $fulfillmentType = isset($vendor['fulfillment_type']) ? $vendor['fulfillment_type'] : 'storefront_pickup';
                                $typeLabel = ($fulfillmentType == 'cannabus_inventory') ? 'Cannabus Inventory' : 'Storefront Pickup';
                                $typeBadge = ($fulfillmentType == 'cannabus_inventory') ? 'badge-primary-modern' : 'badge-warning-modern';
                                $typeIcon = ($fulfillmentType == 'cannabus_inventory') ? 'fa-box' : 'fa-store';
                                ?>
                                <span class="badge-lg-modern <?php echo $typeBadge; ?>">
                                    <i class="fa-solid <?php echo $typeIcon; ?>"></i> <?php echo $typeLabel; ?>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">Status</div>
                            <div>
                                <?php 
                                $isApproved = isset($vendor['isApproved']) ? $vendor['isApproved'] : false;
                                $isActive = isset($vendor['isActive']) ? $vendor['isActive'] : true;
                                ?>
                                <?php if ($isApproved && $isActive): ?>
                                    <span class="badge-lg-modern badge-success-modern">
                                        <i class="fa-solid fa-check-circle"></i> Active
                                    </span>
                                <?php elseif ($isApproved && !$isActive): ?>
                                    <span class="badge-lg-modern badge-secondary-modern">
                                        <i class="fa-solid fa-pause-circle"></i> Inactive
                                    </span>
                                <?php else: ?>
                                    <span class="badge-lg-modern badge-danger-modern">
                                        <i class="fa-solid fa-clock"></i> Pending Approval
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="info-item">
                    <div class="info-item-label">
                        <i class="fa-solid fa-map-marker-alt"></i> Address
                    </div>
                    <div class="info-item-value"><?php echo isset($vendor['address']) ? $vendor['address'] : 'Not provided'; ?></div>
                </div>

                <?php if (isset($vendor['latitude']) && isset($vendor['longitude'])): ?>
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">Latitude</div>
                            <div class="info-item-value"><?php echo $vendor['latitude']; ?></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">Longitude</div>
                            <div class="info-item-value"><?php echo $vendor['longitude']; ?></div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- City & HQ Information -->
        <?php if (isset($city) && !empty($city)): ?>
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fa-solid fa-city text-primary"></i> City Assignment & HQ Reference
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">Assigned City</div>
                            <div>
                                <span class="badge-lg-modern badge-info-modern">
                                    <i class="fa-solid fa-city"></i> <?php echo isset($city['cityName']) ? $city['cityName'] : 'Unknown'; ?>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">City HQ Address</div>
                            <div class="info-item-value"><?php echo isset($city['hqAddress']) ? $city['hqAddress'] : 'Not configured'; ?></div>
                        </div>
                    </div>
                </div>
                <?php if (isset($city['hqLatitude']) && isset($city['hqLongitude'])): ?>
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">HQ Latitude</div>
                            <div class="info-item-value"><?php echo $city['hqLatitude']; ?></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-item-label">HQ Longitude</div>
                            <div class="info-item-value"><?php echo $city['hqLongitude']; ?></div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php else: ?>
        <div class="detail-card border-warning">
            <div class="card-body">
                <div class="alert alert-modern alert-warning mb-0">
                    <i class="fa-solid fa-exclamation-triangle"></i> This vendor is not assigned to any city.
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Distance Logic Information -->
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fa-solid fa-route text-primary"></i> Distance Calculation Logic
                </h5>
            </div>
            <div class="card-body">
                <?php if ($fulfillmentType == 'cannabus_inventory'): ?>
                    <div class="alert alert-modern alert-info">
                        <h6 class="mb-2">
                            <i class="fa-solid fa-info-circle"></i> Cannabus Inventory Vendor
                        </h6>
                        <p class="mb-2">
                            <strong>Distance Formula:</strong> HQ → Customer only
                        </p>
                        <small>This vendor does not add distance to delivery calculations. Products are already with the driver.</small>
                    </div>
                <?php else: ?>
                    <div class="alert alert-modern alert-warning">
                        <h6 class="mb-2">
                            <i class="fa-solid fa-store"></i> Storefront Pickup Vendor
                        </h6>
                        <p class="mb-2">
                            <strong>Distance Formula:</strong> HQ → Vendor → Customer
                        </p>
                        <small>Driver must pick up items from this vendor location before delivering to customer.</small>
                    </div>
                    <?php if (isset($city) && isset($city['hqLatitude']) && isset($city['hqLongitude']) && isset($vendor['latitude']) && isset($vendor['longitude'])): ?>
                        <?php
                        $this->load->helper('delivery');
                        $hqToVendor = calculate_distance($city['hqLatitude'], $city['hqLongitude'], $vendor['latitude'], $vendor['longitude']);
                        ?>
                        <div class="text-center mt-3">
                            <div class="info-item-label">Distance from City HQ</div>
                            <div class="distance-badge">
                                <i class="fa-solid fa-route"></i> <?php echo round($hqToVendor, 2); ?> miles
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>

                <div class="mt-4">
                    <h6 class="mb-3">
                        <i class="fa-solid fa-info-circle text-primary"></i> Multi-Vendor Order Logic
                    </h6>
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <i class="fa-solid fa-check-circle text-success me-2"></i>
                            If customer orders from multiple <strong>storefront vendors</strong> → Only the <strong>farthest vendor</strong> from HQ is used for distance calculation
                        </li>
                        <li class="mb-2">
                            <i class="fa-solid fa-check-circle text-success me-2"></i>
                            If customer orders from <strong>Cannabus inventory</strong> + storefront vendors → Only storefront distance counts
                        </li>
                        <li>
                            <i class="fa-solid fa-check-circle text-success me-2"></i>
                            Cannabus inventory vendors <strong>never add distance</strong>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- Sidebar -->
    <div class="col-md-4">
        <!-- Assigned Drivers -->
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fa-solid fa-users text-primary"></i> Assigned Drivers
                </h5>
            </div>
            <div class="card-body">
                <?php if (!empty($assignedDrivers)): ?>
                    <?php foreach ($assignedDrivers as $driverId => $driver): ?>
                    <div class="driver-card">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <strong><?php echo isset($driver['firstName']) ? $driver['firstName'] : ''; ?> <?php echo isset($driver['lastName']) ? $driver['lastName'] : ''; ?></strong>
                                <br><small class="text-muted"><?php echo isset($driver['email']) ? $driver['email'] : ''; ?></small>
                            </div>
                            <span class="badge-modern badge-primary-modern">
                                <i class="fa-solid fa-check"></i>
                            </span>
                        </div>
                    </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="text-center py-4">
                        <i class="fa-solid fa-users-slash fa-3x text-muted mb-3"></i>
                        <p class="text-muted mb-0">No drivers assigned to this vendor.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="detail-card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="fa-solid fa-bolt text-primary"></i> Quick Actions
                </h5>
            </div>
            <div class="card-body">
                <a href="<?php echo base_url('vendors/editvendor/' . $vendorId); ?>" class="btn btn-primary action-btn-modern">
                    <i class="fa-solid fa-edit"></i> Edit Vendor
                </a>
                <?php if ($isApproved && $isActive): ?>
                    <a href="<?php echo base_url('vendors/disablevendor/' . $vendorId); ?>" class="btn btn-warning action-btn-modern">
                        <i class="fa-solid fa-ban"></i> Deactivate
                    </a>
                <?php elseif ($isApproved && !$isActive): ?>
                    <a href="<?php echo base_url('vendors/activatevendor/' . $vendorId); ?>" class="btn btn-success action-btn-modern">
                        <i class="fa-solid fa-check-circle"></i> Activate
                    </a>
                <?php else: ?>
                    <a href="<?php echo base_url('vendors/approveVendor/' . $vendorId); ?>" class="btn btn-success action-btn-modern">
                        <i class="fa-solid fa-check"></i> Approve Vendor
                    </a>
                <?php endif; ?>
                <a href="<?php echo base_url('vendors/deletevendor/' . $vendorId); ?>" 
                   class="btn btn-danger action-btn-modern"
                   onclick="return confirm('Are you sure you want to delete this vendor? This action cannot be undone.');">
                    <i class="fa-solid fa-trash"></i> Delete Vendor
                </a>
            </div>
        </div>
    </div>
</div>
