<?php
function formatDate($timestamp)
{
    // Convert milliseconds to seconds
    $seconds = $timestamp / 1000;
    // Format the timestamp as a readable date
    return date("Y-m-d H:i:s", $seconds);
}

// Fallback function to display "N/A" for empty fields
function displayValue($value)
{
    return !empty($value) ? $value : 'N/A';
}

// Fallback function to check for URLs and return 'N/A' if empty
function displayUrl($url, $label)
{
    return !empty($url) ? "<a class='btn btn-success px-3' href='$url' target='blank'>$label</a>" : 'N/A';
}
?>
<style>
.imgDrive {
    height: 200px;
    width: 200px;
    display: block;
    margin: auto;
    border: 4px solid #72A565;
    border-radius: 50%;
    aspect-ratio: 1;
}
</style>

<div class="fmon">
    <h3 class="text-center mb-4 fmon fw-bold">Driver Details</h3>
    <hr>
    <div class="card-body">
        <h5 class="card-title fw-bold">Profile Picture</h5>
        <div class="row">
            <div class="col-md-12 my-2">
                <?php if (!empty($driverdetails['image'])): ?>
                <img src="<?php echo $driverdetails['image']; ?>" alt="Driver Image" class="imgDrive">
                <?php else: ?>
                <p>N/A</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <hr>
    <div class="card-body fmon">
        <h5 class="card-title fw-bold mb-2">Basic Information</h5>
        <div class="row">
            <div class="col-md-4">
                <p><strong>First Name:</strong> <?php echo displayValue($driverdetails['firstName']); ?></p>
            </div>
            <div class="col-md-4">
                <p><strong>Last Name:</strong> <?php echo displayValue($driverdetails['lastName']); ?></p>
            </div>
            <div class="col-md-4">
                <p><strong>Email:</strong> <?php echo displayValue($driverdetails['email']); ?></p>
            </div>
            <div class="col-md-4">
                <p><strong>Phone Number:</strong> <?php echo displayValue($driverdetails['phoneNumber']); ?></p>
            </div>
            <div class="col-md-4">
                <p><strong>User Role:</strong> <?php echo displayValue($driverdetails['userRole']); ?></p>
            </div>
            <div class="col-md-4">
                <p><strong>Is Approved:</strong> <?php echo $driverdetails['isApproved'] ? 'Yes' : 'No'; ?></p>
            </div>
            <div class="col-md-4">
                <p><strong>Average Rating:</strong> <?php echo displayValue($driverdetails['averageRating']); ?></p>
            </div>
            <div class="col-md-4">
                <p><strong>Reviews Count:</strong> <?php echo displayValue($driverdetails['reviewsCount']); ?></p>
            </div>
            <div class="col-md-4">
                <p><strong>Rating Count:</strong> <?php echo displayValue($driverdetails['ratingCount']); ?></p>
            </div>
            <div class="col-md-4">
                <p><strong>Is Online:</strong> <?php echo !empty($driverdetails['isOnline']) ? 'Yes' : 'No'; ?></p>
            </div>
        </div>
    </div>

    <hr>

    <div class="card-body">
        <h5 class="card-title fw-bold mb-2">Vehicle Details</h5>
        <div class="row">
            <div class="col-md-4">
                <p><strong>Vehicle ID:</strong> <?php echo displayValue($vehicledetails['id']); ?></p>
            </div>
            <div class="col-md-4">
                <p><strong>Make:</strong> <?php echo displayValue($vehicledetails['make']); ?></p>
            </div>
            <div class="col-md-4">
                <p><strong>Model:</strong> <?php echo displayValue($vehicledetails['model']); ?></p>
            </div>
            <div class="col-md-4">
                <p><strong>Color:</strong> <?php echo displayValue($vehicledetails['color']); ?></p>
            </div>
            <div class="col-md-4">
                <p><strong>Tag Number:</strong> <?php echo displayValue($vehicledetails['tagNumber']); ?></p>
            </div>
            <div class="col-md-4">
                <p><strong>Driving License:</strong> <?php echo displayValue($vehicledetails['drivingLicense']); ?></p>
            </div>
            <div class="col-md-4">
                <p><strong>User Date:</strong> <?php echo formatDate($driverdetails['userDate']); ?></p>
            </div>
            <div class="col-md-4">
                <p><strong>Front Driving License :</strong>
                    <?php echo displayUrl($vehicledetails['drivingFrontUrl'], 'View Front License'); ?></p>
            </div>
            <div class="col-md-4">
                <p><strong>Back Driving License :</strong>
                    <?php echo displayUrl($vehicledetails['drivingBackUrl'], 'View Back License'); ?></p>
            </div>
        </div>
    </div>




</div>