<style>
.zone-test-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 2rem;
    border-radius: 15px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
}

.zone-test-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-bottom: 1.5rem;
    border: none;
    overflow: hidden;
}

.zone-test-card .card-header {
    background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
    border-bottom: 2px solid #e2e8f0;
    padding: 1.25rem 1.5rem;
    font-weight: 600;
    color: #2d3748;
}

.zone-test-card .card-body {
    padding: 2rem;
}

.form-label-modern {
    font-weight: 600;
    color: #2d3748;
    margin-bottom: 0.5rem;
    font-size: 0.875rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.form-control-modern {
    border-radius: 10px;
    border: 2px solid #e2e8f0;
    padding: 0.75rem 1rem;
    transition: all 0.3s ease;
    font-size: 1rem;
}

.form-control-modern:focus {
    border-color: #72A565;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    outline: none;
}

.form-group-modern {
    margin-bottom: 1.5rem;
}

.item-row-modern {
    background: #f7fafc;
    border: 2px solid #e2e8f0;
    border-radius: 10px;
    padding: 1.5rem;
    margin-bottom: 1rem;
    transition: all 0.3s ease;
}

.item-row-modern:hover {
    border-color: #72A565;
    box-shadow: 0 5px 15px rgba(102, 126, 234, 0.1);
    transform: translateX(5px);
}

.btn-modern {
    border-radius: 10px;
    padding: 0.6rem 1.5rem;
    font-weight: 500;
    transition: all 0.3s ease;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
}

.btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0,0,0,0.15);
}

.btn-modern-primary {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    border: none;
    color: white;
}

.results-card {
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    margin-top: 2rem;
    border: none;
    overflow: hidden;
}

.results-card .card-header {
    background: linear-gradient(135deg, #72A565 0%, #91A134 100%);
    color: white;
    padding: 1.25rem 1.5rem;
    border: none;
}

.info-box-modern {
    background: #f7fafc;
    border-left: 4px solid #667eea;
    padding: 1rem;
    border-radius: 8px;
    margin-bottom: 1rem;
}

.badge-zone {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-weight: 600;
    font-size: 0.875rem;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.badge-zone-1 {
    background: linear-gradient(135deg, #48bb78 0%, #38a169 100%);
    color: white;
}

.badge-zone-2 {
    background: linear-gradient(135deg, #4299e1 0%, #3182ce 100%);
    color: white;
}

.badge-zone-3 {
    background: linear-gradient(135deg, #ed8936 0%, #dd6b20 100%);
    color: white;
}

.badge-zone-4 {
    background: linear-gradient(135deg, #f56565 0%, #e53e3e 100%);
    color: white;
}

.table-modern {
    border-radius: 10px;
    overflow: hidden;
}

.table-modern thead {
    background: #f7fafc;
}

.table-modern thead th {
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.75rem;
    letter-spacing: 0.5px;
    color: #4a5568;
    border: none;
    padding: 1rem;
}

.table-modern tbody tr {
    transition: all 0.3s ease;
}

.table-modern tbody tr:hover {
    background: #f7fafc;
}

.hq-info-box {
    background: linear-gradient(135deg, #e6fffa 0%, #b2f5ea 100%);
    border-left: 4px solid #38a169;
    padding: 1rem;
    border-radius: 8px;
    margin-top: 0.5rem;
}
</style>

<!-- Header Section -->
<div class="zone-test-header">
    <div class="row align-items-center">
        <div class="col-md-8">
            <h2 class="mb-2">
                <i class="fa-solid fa-route"></i> Delivery Zone Testing Tool
            </h2>
            <p class="mb-0 opacity-75">Test distance calculations, zone assignments, and pricing for different order scenarios</p>
        </div>
    </div>
</div>

<!-- Test Form -->
<div class="zone-test-card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fa-solid fa-calculator text-primary"></i> Test Configuration
        </h5>
    </div>
    <div class="card-body">
        <form id="zoneTestForm">
            <!-- City Selection -->
            <div class="form-group-modern">
                <label for="cityId" class="form-label-modern">Select City <span class="text-danger">*</span></label>
                <select name="cityId" id="cityId" class="form-control form-control-modern" required>
                    <option value="">-- Select City --</option>
                    <?php foreach ($cities as $cityId => $city): ?>
                        <option value="<?php echo $cityId; ?>" 
                            data-hq-lat="<?php echo isset($city['hqLatitude']) ? $city['hqLatitude'] : ''; ?>"
                            data-hq-lon="<?php echo isset($city['hqLongitude']) ? $city['hqLongitude'] : ''; ?>"
                            data-hq-address="<?php echo isset($city['hqAddress']) ? htmlspecialchars($city['hqAddress']) : ''; ?>">
                            <?php echo isset($city['cityName']) ? $city['cityName'] : 'Unknown'; ?>
                            <?php if (!isset($city['hqLatitude']) || !isset($city['hqLongitude'])): ?>
                                <span class="text-danger">(HQ not configured)</span>
                            <?php endif; ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <div id="hqInfo" class="hq-info-box" style="display: none;">
                    <strong><i class="fa-solid fa-map-marker-alt"></i> HQ Address:</strong> <span id="hqAddress"></span><br>
                    <strong>Coordinates:</strong> <span id="hqCoords"></span>
                </div>
            </div>

            <!-- Customer Coordinates -->
            <div class="row">
                <div class="col-md-6 form-group-modern">
                    <label for="customerLat" class="form-label-modern">Customer Latitude <span class="text-danger">*</span></label>
                    <input type="number" 
                        step="any" 
                        min="-90" 
                        max="90" 
                        name="customerLat" 
                        id="customerLat" 
                        class="form-control form-control-modern" 
                        placeholder="e.g., 29.7604" 
                        required>
                </div>
                <div class="col-md-6 form-group-modern">
                    <label for="customerLon" class="form-label-modern">Customer Longitude <span class="text-danger">*</span></label>
                    <input type="number" 
                        step="any" 
                        min="-180" 
                        max="180" 
                        name="customerLon" 
                        id="customerLon" 
                        class="form-control form-control-modern" 
                        placeholder="e.g., -95.3698" 
                        required>
                </div>
            </div>

            <!-- Order Items -->
            <div class="form-group-modern">
                <label class="form-label-modern">Order Items</label>
                <div id="itemsContainer">
                    <div class="item-row-modern">
                        <div class="row">
                            <div class="col-md-6 form-group-modern">
                                <label class="form-label-modern">Vendor <span class="text-danger">*</span></label>
                                <select name="vendorId[]" class="form-control form-control-modern vendor-select" required>
                                    <option value="">-- Select Vendor --</option>
                                    <!-- Vendors will be loaded via AJAX -->
                                </select>
                            </div>
                            <div class="col-md-5 form-group-modern">
                                <label class="form-label-modern">Product</label>
                                <select name="productId[]" class="form-control form-control-modern product-select">
                                    <option value="">-- Select Product --</option>
                                    <!-- Products will be loaded via AJAX based on vendor -->
                                </select>
                            </div>
                            <div class="col-md-1 form-group-modern">
                                <label class="form-label-modern">&nbsp;</label>
                                <button type="button" class="btn btn-danger btn-modern w-100 remove-item" title="Remove Item">
                                    <i class="fa-solid fa-trash"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="button" class="btn btn-modern btn-modern-primary" id="addItem">
                    <i class="fa-solid fa-plus"></i> Add Item
                </button>
            </div>

            <!-- Action Buttons -->
            <div class="row mt-4">
                <div class="col-md-12 text-end">
                    <button type="button" class="btn btn-secondary btn-modern" id="clearForm">
                        <i class="fa-solid fa-eraser"></i> Clear
                    </button>
                    <button type="submit" class="btn btn-modern btn-modern-primary">
                        <i class="fa-solid fa-calculator"></i> Calculate Zone
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Results Section -->
<div id="resultsSection" class="results-card" style="display: none;">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fa-solid fa-chart-line"></i> Calculation Results
        </h5>
    </div>
    <div class="card-body">
        <div id="resultsContent"></div>
    </div>
</div>

<script src="<?php echo base_url('assets/js/jquery.min.js'); ?>"></script>
<script>
var vendorsData = {};
var productsData = {};

$(document).ready(function() {
    // Load vendors on page load
    loadVendors();
    
    // Update HQ info when city is selected
    $('#cityId').on('change', function() {
        var selected = $(this).find('option:selected');
        var hqLat = selected.data('hq-lat');
        var hqLon = selected.data('hq-lon');
        var hqAddress = selected.data('hq-address');
        
        if (hqLat && hqLon) {
            $('#hqAddress').text(hqAddress || 'Not set');
            $('#hqCoords').text(hqLat + ', ' + hqLon);
            $('#hqInfo').show();
        } else {
            $('#hqInfo').hide();
        }
        
        // Reload vendors for the selected city
        loadVendors();
    });
    
    // Load vendors
    function loadVendors() {
        $.ajax({
            url: '<?php echo base_url("dashboard/getvendorsforzonetest"); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    vendorsData = response.vendors;
                    updateVendorDropdowns();
                }
            }
        });
    }
    
    // Update all vendor dropdowns
    function updateVendorDropdowns() {
        $('.vendor-select').each(function() {
            var currentValue = $(this).val();
            $(this).empty().append('<option value="">-- Select Vendor --</option>');
            
            for (var vendorId in vendorsData) {
                var vendor = vendorsData[vendorId];
                var vendorName = vendor.shopName || (vendor.firstName + ' ' + (vendor.lastName || ''));
                var selected = (vendorId == currentValue) ? 'selected' : '';
                $(this).append('<option value="' + vendorId + '" data-fulfillment="' + (vendor.fulfillment_type || 'storefront_pickup') + '" ' + selected + '>' + vendorName + '</option>');
            }
        });
    }
    
    // Load products when vendor is selected
    $(document).on('change', '.vendor-select', function() {
        var vendorId = $(this).val();
        var productSelect = $(this).closest('.item-row-modern').find('.product-select');
        
        productSelect.empty().append('<option value="">-- Select Product --</option>');
        
        if (vendorId) {
            loadProducts(vendorId, productSelect);
        }
    });
    
    // Load products for a vendor
    function loadProducts(vendorId, productSelect) {
        $.ajax({
            url: '<?php echo base_url("dashboard/getproductsforzonetest"); ?>',
            type: 'GET',
            data: { vendorId: vendorId },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    response.products.forEach(function(product) {
                        productSelect.append('<option value="' + product.id + '">' + product.name + ' - $' + product.price + '</option>');
                    });
                }
            }
        });
    }
    
    // Add item row
    $('#addItem').on('click', function() {
        var itemHtml = `
            <div class="item-row-modern">
                <div class="row">
                    <div class="col-md-6 form-group-modern">
                        <label class="form-label-modern">Vendor <span class="text-danger">*</span></label>
                        <select name="vendorId[]" class="form-control form-control-modern vendor-select" required>
                            <option value="">-- Select Vendor --</option>
                        </select>
                    </div>
                    <div class="col-md-5 form-group-modern">
                        <label class="form-label-modern">Product</label>
                        <select name="productId[]" class="form-control form-control-modern product-select">
                            <option value="">-- Select Product --</option>
                        </select>
                    </div>
                    <div class="col-md-1 form-group-modern">
                        <label class="form-label-modern">&nbsp;</label>
                        <button type="button" class="btn btn-danger btn-modern w-100 remove-item" title="Remove Item">
                            <i class="fa-solid fa-trash"></i>
                        </button>
                    </div>
                </div>
            </div>
        `;
        $('#itemsContainer').append(itemHtml);
        updateVendorDropdowns();
    });
    
    // Remove item row
    $(document).on('click', '.remove-item', function() {
        if ($('.item-row-modern').length > 1) {
            $(this).closest('.item-row-modern').remove();
        } else {
            alert('At least one item is required');
        }
    });
    
    // Clear form
    $('#clearForm').on('click', function() {
        $('#zoneTestForm')[0].reset();
        $('#resultsSection').hide();
        $('#hqInfo').hide();
        $('#itemsContainer').html(`
            <div class="item-row-modern">
                <div class="row">
                    <div class="col-md-6 form-group-modern">
                        <label class="form-label-modern">Vendor <span class="text-danger">*</span></label>
                        <select name="vendorId[]" class="form-control form-control-modern vendor-select" required>
                            <option value="">-- Select Vendor --</option>
                        </select>
                    </div>
                    <div class="col-md-5 form-group-modern">
                        <label class="form-label-modern">Product</label>
                        <select name="productId[]" class="form-control form-control-modern product-select">
                            <option value="">-- Select Product --</option>
                        </select>
                    </div>
                    <div class="col-md-1 form-group-modern">
                        <label class="form-label-modern">&nbsp;</label>
                        <button type="button" class="btn btn-danger btn-modern w-100 remove-item" title="Remove Item">
                            <i class="fa-solid fa-trash"></i>
                        </button>
                    </div>
                </div>
            </div>
        `);
        updateVendorDropdowns();
    });
    
    // Submit form
    $('#zoneTestForm').on('submit', function(e) {
        e.preventDefault();
        
        var cityId = $('#cityId').val();
        var customerLat = $('#customerLat').val();
        var customerLon = $('#customerLon').val();
        
        if (!cityId || !customerLat || !customerLon) {
            alert('Please fill in all required fields');
            return;
        }
        
        // Collect items
        var items = [];
        var hasValidItem = false;
        
        $('.item-row-modern').each(function() {
            var vendorId = $(this).find('.vendor-select').val();
            var productId = $(this).find('.product-select').val();
            
            if (vendorId) {
                hasValidItem = true;
                items.push({
                    vendorId: vendorId,
                    productId: productId || ''
                });
            }
        });
        
        if (!hasValidItem) {
            alert('Please add at least one item with a vendor');
            return;
        }
        
        // Show loading
        $('#resultsContent').html('<div class="text-center py-5"><i class="fa fa-spinner fa-spin fa-3x text-primary"></i><p class="mt-3">Calculating zone and pricing...</p></div>');
        $('#resultsSection').show();
        $('html, body').animate({ scrollTop: $('#resultsSection').offset().top - 100 }, 500);
        
        // Make AJAX request
        $.ajax({
            url: '<?php echo base_url("dashboard/calculatezonetest"); ?>',
            type: 'POST',
            data: {
                cityId: cityId,
                customerLat: customerLat,
                customerLon: customerLon,
                items: JSON.stringify(items)
            },
            dataType: 'json',
            success: function(response) {
                
                if (response.success) {
                    displayResults(response.data);
                } else {
                    $('#resultsContent').html('<div class="alert alert-danger"><i class="fa-solid fa-exclamation-triangle"></i> ' + response.message + '</div>');
                }
            },
            error: function(xhr, status, error) {
                $('#resultsContent').html('<div class="alert alert-danger"><i class="fa-solid fa-exclamation-triangle"></i> Error: ' + error + '</div>');
            }
        });
    });
    
    function displayResults(data) {
        var html = '';
        
        // Summary Cards
        html += '<div class="row mb-4">';
        html += '<div class="col-md-4">';
        html += '<div class="info-box-modern text-center">';
        html += '<h3 class="mb-1">' + data.zone.key.toUpperCase() + '</h3>';
        html += '<p class="mb-0 text-muted">Assigned Zone</p>';
        html += '</div>';
        html += '</div>';
        html += '<div class="col-md-4">';
        html += '<div class="info-box-modern text-center">';
        html += '<h3 class="mb-1">' + data.zone.distance.toFixed(2) + ' mi</h3>';
        html += '<p class="mb-0 text-muted">Chargeable Distance</p>';
        html += '</div>';
        html += '</div>';
        html += '<div class="col-md-4">';
        html += '<div class="info-box-modern text-center">';
        html += '<h3 class="mb-1">$' + data.pricing.fee.toFixed(2) + '</h3>';
        html += '<p class="mb-0 text-muted">Delivery Fee</p>';
        html += '</div>';
        html += '</div>';
        html += '</div>';
        
        // City & Customer Info
        html += '<div class="row mb-4">';
        html += '<div class="col-md-6">';
        html += '<h5 class="mb-3"><i class="fa-solid fa-city text-primary"></i> City & Customer Information</h5>';
        html += '<table class="table table-modern">';
        html += '<tr><th width="40%">City</th><td><strong>' + data.city.name + '</strong></td></tr>';
        html += '<tr><th>HQ Address</th><td>' + (data.city.hqAddress || 'Not set') + '</td></tr>';
        html += '<tr><th>HQ Coordinates</th><td>' + data.city.hqLat + ', ' + data.city.hqLon + '</td></tr>';
        html += '<tr><th>Customer Coordinates</th><td>' + data.customer.lat + ', ' + data.customer.lon + '</td></tr>';
        html += '<tr><th>HQ → Customer</th><td><strong>' + data.distances.hqToCustomer.toFixed(2) + ' miles</strong></td></tr>';
        html += '</table>';
        html += '</div>';
        
        // Zone & Pricing
        html += '<div class="col-md-6">';
        html += '<h5 class="mb-3"><i class="fa-solid fa-map-marked-alt text-primary"></i> Zone & Pricing</h5>';
        html += '<table class="table table-modern">';
        
        var zoneClass = 'badge-zone-' + data.zone.key.replace('zone', '');
        html += '<tr><th width="40%">Zone</th><td><span class="badge-zone ' + zoneClass + '">' + data.zone.key.toUpperCase() + '</span></td></tr>';
        html += '<tr><th>Zone Range</th><td>' + data.zone.minDistance + ' - ' + (data.zone.maxDistance == 999999 ? '∞' : data.zone.maxDistance) + ' miles</td></tr>';
        html += '<tr><th>Chargeable Distance</th><td><strong>' + data.zone.distance.toFixed(2) + ' miles</strong></td></tr>';
        html += '<tr><th>Delivery Fee</th><td><strong class="text-success">$' + data.pricing.fee.toFixed(2) + '</strong></td></tr>';
        html += '<tr><th>Minimum Order</th><td><strong>$' + data.pricing.minimumOrder.toFixed(2) + '</strong></td></tr>';
        if (data.pricing.storefrontMinimumOrder) {
            html += '<tr><th>Zone 2 Storefront Min</th><td><strong>$' + data.pricing.storefrontMinimumOrder.toFixed(2) + '</strong></td></tr>';
        }
        html += '</table>';
        html += '</div>';
        html += '</div>';
        
        // Order Type
        html += '<div class="row mb-4">';
        html += '<div class="col-md-12">';
        html += '<h5 class="mb-3"><i class="fa-solid fa-info-circle text-primary"></i> Order Type Detection</h5>';
        html += '<div class="row">';
        html += '<div class="col-md-4">';
        html += '<div class="info-box-modern text-center">';
        html += '<i class="fa-solid fa-' + (data.orderType.hasCannabusInventory ? 'check-circle text-success' : 'times-circle text-danger') + ' fa-2x mb-2"></i>';
        html += '<p class="mb-0"><strong>Cannabus Inventory:</strong> ' + (data.orderType.hasCannabusInventory ? 'Yes' : 'No') + '</p>';
        html += '</div>';
        html += '</div>';
        html += '<div class="col-md-4">';
        html += '<div class="info-box-modern text-center">';
        html += '<i class="fa-solid fa-' + (data.orderType.hasStorefront ? 'check-circle text-success' : 'times-circle text-danger') + ' fa-2x mb-2"></i>';
        html += '<p class="mb-0"><strong>Storefront Pickup:</strong> ' + (data.orderType.hasStorefront ? 'Yes' : 'No') + '</p>';
        html += '</div>';
        html += '</div>';
        html += '<div class="col-md-4">';
        html += '<div class="info-box-modern text-center">';
        html += '<i class="fa-solid fa-' + (data.orderType.isMultiVendor ? 'check-circle text-warning' : 'times-circle text-danger') + ' fa-2x mb-2"></i>';
        html += '<p class="mb-0"><strong>Multi-Vendor:</strong> ' + (data.orderType.isMultiVendor ? 'Yes' : 'No') + '</p>';
        html += '</div>';
        html += '</div>';
        html += '</div>';
        html += '</div>';
        html += '</div>';
        
        // Vendor Details
        if (data.vendors && data.vendors.length > 0) {
            html += '<div class="row mb-4">';
            html += '<div class="col-md-12">';
            html += '<h5 class="mb-3"><i class="fa-solid fa-store text-primary"></i> Vendor Distance Details</h5>';
            html += '<table class="table table-modern">';
            html += '<thead><tr>';
            html += '<th>Vendor</th>';
            html += '<th>Fulfillment Type</th>';
            html += '<th>HQ → Vendor</th>';
            html += '<th>Vendor → Customer</th>';
            html += '<th>Total Distance</th>';
            html += '<th>Status</th>';
            html += '</tr></thead>';
            html += '<tbody>';
            
            data.vendors.forEach(function(vendor) {
                var isFarthest = data.farthestVendor && data.farthestVendor.vendorId === vendor.vendorId;
                var rowClass = isFarthest ? 'table-warning' : '';
                html += '<tr class="' + rowClass + '">';
                html += '<td><strong>' + vendor.vendorName + '</strong>';
                if (isFarthest) {
                    html += ' <span class="badge badge-warning"><i class="fa-solid fa-star"></i> Farthest</span>';
                }
                html += '</td>';
                
                var fulfillmentBadge = vendor.fulfillmentType == 'cannabus_inventory' 
                    ? '<span class="badge badge-info">Cannabus Inventory</span>'
                    : '<span class="badge badge-warning">Storefront Pickup</span>';
                html += '<td>' + fulfillmentBadge + '</td>';
                html += '<td>' + vendor.hqToVendor.toFixed(2) + ' mi</td>';
                html += '<td>' + vendor.vendorToCustomer.toFixed(2) + ' mi</td>';
                html += '<td><strong>' + vendor.totalDistance.toFixed(2) + ' mi</strong></td>';
                html += '<td>';
                if (vendor.fulfillmentType == 'cannabus_inventory') {
                    html += '<span class="text-muted">No distance added</span>';
                } else if (isFarthest) {
                    html += '<span class="badge badge-warning">Used for calculation</span>';
                } else {
                    html += '<span class="text-muted">-</span>';
                }
                html += '</td>';
                html += '</tr>';
            });
            
            html += '</tbody></table>';
            html += '</div>';
            html += '</div>';
        }
        
        // Distance Calculation Explanation
        html += '<div class="row">';
        html += '<div class="col-md-12">';
        html += '<h5 class="mb-3"><i class="fa-solid fa-calculator text-primary"></i> Distance Calculation Logic</h5>';
        html += '<div class="alert alert-info">';
        
        if (data.orderType.hasCannabusInventory && !data.orderType.hasStorefront) {
            html += '<strong><i class="fa-solid fa-box"></i> Cannabus Inventory Order:</strong><br>';
            html += 'Distance = HQ → Customer = <strong>' + data.distances.hqToCustomer.toFixed(2) + ' miles</strong><br>';
            html += '<small class="text-muted">Cannabus inventory items do not add distance to the calculation.</small>';
        } else if (data.orderType.hasStorefront) {
            if (data.orderType.isMultiVendor && data.farthestVendor) {
                html += '<strong><i class="fa-solid fa-layer-group"></i> Multi-Vendor Storefront Order:</strong><br>';
                html += 'Using <strong>farthest vendor</strong> from HQ for distance calculation<br>';
                html += 'Distance = HQ → Farthest Vendor + Farthest Vendor → Customer<br>';
                html += '= ' + data.farthestVendor.hqToVendor.toFixed(2) + ' + ' + data.farthestVendor.vendorToCustomer.toFixed(2) + ' = <strong>' + data.zone.distance.toFixed(2) + ' miles</strong>';
            } else {
                html += '<strong><i class="fa-solid fa-store"></i> Storefront Pickup Order:</strong><br>';
                html += 'Distance = HQ → Vendor + Vendor → Customer = <strong>' + data.zone.distance.toFixed(2) + ' miles</strong>';
            }
        }
        
        html += '</div>';
        html += '</div>';
        html += '</div>';
        
        $('#resultsContent').html(html);
    }
});
</script>
