<?php
   
require APPPATH . 'libraries/REST_Controller.php';
     
class Products extends REST_Controller {
    
	
    // Product methods

    public function index_get($id = 0)
	{
        $data = $this->common->readdatacollection('Products');
        
        $this->response($data, REST_Controller::HTTP_OK);
	}
      
    
    public function create_post()
    {
        $input = $this->input->post();
        $input['createdDate'] = date('d-m-Y h:i:s A');
        $input['quantity'] = (int) $input['quantity'];
        $input['price'] = (int) $input['price'];
        $this->common->addnewdatamodel('Products', $input);
     
        $this->response($input, REST_Controller::HTTP_OK);
    } 
     
    
    public function update_post($id)
    {
        $input = $this->input->post();
        $input['quantity'] = (int) $input['quantity'];
        $input['price'] = (float) $input['price'];
        $this->common->updatedatamodel('Products', $id, $input);
     
        $this->response($input, REST_Controller::HTTP_OK);
    }
     
    
    public function remove_delete($id)
    {
        $this->common->deletedatamodel('Products', $id);
       
        $this->response(['Product deleted successfully.'], REST_Controller::HTTP_OK);
    }
    	
}