<link
  rel="stylesheet"
  href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"
/>

<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<style>
  .swiper-container {
    overflow: hidden;
  }
  .swiper-button-prev {
    left:unset !important;
    right:unset !important
  }
  .activity-user-card-title{
    margin-right: auto;
  }
  .info-card-detail{
    padding-right: 10px;
  }
</style>

<main class="">
  <div class="container">
    <div class="my-5">
      <div class="row">
        <div class="col-md-12 my-2">
          <form class="d-flex position-relative mt-2 mt-md-0" role="search">
            <input class="form-control me-2 search w-100 bg-white pe-4" type="search" placeholder="Search"
              aria-label="Search" style="width: 350px" />
            <img src="../assets/images/icons/searchicon.png" alt="" width="15px" height="15px" class="searchIcon" />
          </form>
        </div>
      </div>
      <div class="row my-2">

        <!-- Loader Overlay -->
        <div id="loaderOverlay2" class="d-flex justify-content-center align-items-center" style=" width:100%; height:100%; 
            background: rgba(255,255,255,0.8); z-index: 9999; display: none;">
          <div class="spinner-border text-primary" role="status" style="width:3rem; height:3rem;">
            <span class="visually-hidden">Loading...</span>
          </div>
        </div>

      </div>

      <!-- <div class="col-md-12 my-2">
                <button class="btn btnLoad d-block mx-auto  btn-same">                Load More
                </button>
              </div> -->
    </div>
  </div>
  </div>
</main>
 
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCkDJWMAbK59HWDyHOb50Fajk-XpmonOZw&libraries=places"></script>


<script>
  console.log("inscript")
  // ✅ Declare Firestore globally
  let db;

  const container = document.querySelector(".row.my-2");
  const loadBtn = document.createElement('button');
  loadBtn.className = 'btn btn-save btn-same mt-3 d-block mx-auto';
  loadBtn.textContent = 'Load More';
  const searchInput = document.querySelector('.search');

  let alertsByDate = [];
  let allAlertsByDate = [];
  let shownGroups = 3;
  // Utility: Reverse geocode lat/lng → address

  function showLoader() {
    document.getElementById("loaderOverlay2").style.display = "flex";
  }

  function hideLoader() {
  //  document.getElementById("loaderOverlay2").style.display = "none";
  }

  firebase.auth().onAuthStateChanged(async user => {
        if (!user) return;
    showLoader(); // ✅ Show spinner before fetching
        // ✅ Initialize Firestore globally
        db = firebase.firestore();

        const userDoc = await db.collection("Users").doc(user.uid).get();
        const userData = userDoc.data();
        const userFriendsMap = userData.userFriends || {};
        const friendIds = Object.keys(userFriendsMap);

    const quoteRef = db.collection("QuoteAlert");

    // Own quotes
    const ownSnap = await quoteRef
      .where("userId", "==", user.uid)
      .get();

    const ownQuotes = ownSnap.docs
      .map(d => ({ id: d.id, ...d.data(), date: new Date(d.data().createdDate) }))
      .filter(d => d.isUserArchived === false || d.isUserArchived === undefined);

    console.log("own", ownQuotes);

    let friendQuotes = [];
    for (let i = 0; i < friendIds.length; i += 10) {
      const chunk = friendIds.slice(i, i + 10);
      const friendSnap = await quoteRef
        .where("userId", "in", chunk)
        .get();

      friendQuotes.push(
        ...friendSnap.docs
          .map(d => ({ id: d.id, ...d.data(), date: new Date(d.data().createdDate) }))
          .filter(d => d.isUserArchived === false || d.isUserArchived === undefined)
      );
    }

        let allQuotes = [...ownQuotes, ...friendQuotes].sort((a, b) => b.date - a.date);
        
        allQuotes = allQuotes.filter(
      (item, index, self) => index === self.findIndex(q => q.id === item.id)
    );
    console.log("all",allQuotes)
    const userIds = [
      ...new Set(allQuotes.flatMap(q => [q.userId, q.LawId, q.imigrationLawId].filter(Boolean)))
    ];
    const userMap = {};

    for (const uid of userIds) {
      const uDoc = await db.collection("Users").doc(uid).get();
      if (uDoc.exists) userMap[uid] = uDoc.data();
    }

    for (const q of allQuotes) {
      const userData = userMap[q.userId] || {};

      const criminalAttorney = q.LawId ? userMap[q.LawId] : null;
      const immigrationLawId = q.imigrationLawId || q.immigrationLawId;
      const immigrationAttorney = immigrationLawId ? userMap[immigrationLawId] : null;

      q.userName = userData.Name || 'N/A';
      q.userDOB = userData.userDOB || null;

      if (q.userLat && q.userLng) {
        q.address = await getAddressFromCoords(q.userLat, q.userLng);
      } else {
        q.address = "Unknown location";
      }

      q.criminalAttorneyName = q.LawId
        ? (criminalAttorney ? criminalAttorney.Name : 'N/A')
        : 'Opted Out';

      q.immigrationAttorneyName = immigrationLawId
        ? (immigrationAttorney ? immigrationAttorney.Name : 'N/A')
        : 'Opted Out';

      q.attorneyName = `${q.criminalAttorneyName}, ${q.immigrationAttorneyName}`;
      q.ANumber = userData.ANumber || 'N/A';
      q.countryOfCitizenship = userData.countryOfCitizenship || 'N/A';
      q.visaType = userData.visaType || 'N/A';
      q.visaExpiryDate = userData.visaExpryDate || userData.visaExpiryDate || 'N/A';
    }

    const grouped = {};
    allQuotes.forEach(a => {
      const key = a.date.toDateString();
      (grouped[key] ||= []).push(a);
    });

    allAlertsByDate = Object.entries(grouped).map(([day, items]) => ({ day, items }));
    alertsByDate = [...allAlertsByDate];
    renderGroups();
    // hideLoader()
  });


  function getAddressFromCoords(lat, lng) {
    return new Promise((resolve, reject) => {
      const geocoder = new google.maps.Geocoder();
      const latlng = { lat: parseFloat(lat), lng: parseFloat(lng) };

      geocoder.geocode({ location: latlng }, (results, status) => {
        if (status === "OK") {
          if (results[0]) {
            resolve(results[0].formatted_address);
          } else {
            resolve("Unknown location");
          }
        } else {
          console.error("Geocoder failed: " + status);
          reject("Geocoder failed: " + status);
        }
      });
    });
  }

  function formatCustomDate(date) {
    return date.toLocaleDateString('en-US', {
      day: '2-digit',
      month: 'long',
      year: 'numeric'
    }) + ' , ' + date.toLocaleTimeString('en-US', {
      hour: '2-digit',
      minute: '2-digit',
      hour12: true
    });
  }

  function setupSequentialVideoPlayback() {
    document.querySelectorAll('.autoplay-video').forEach(video => {
      video.addEventListener('ended', () => {
        const urls = JSON.parse(video.getAttribute('data-urls'));
        let currentIndex = parseInt(video.getAttribute('data-index'), 10);

        if (currentIndex + 1 < urls.length) {
          currentIndex += 1;
          const nextUrl = urls[currentIndex];

          video.setAttribute('data-index', currentIndex);
          video.querySelector('source').src = nextUrl;
          video.load();
          video.play();
        }
      });
    });
  }

  renderGroups = function () {
    container.innerHTML = '';
    alertsByDate.slice(0, shownGroups).forEach(({ day, items }, index) => {
      const colapseId = `grp-${index}`;
      const html = `
        <p><a class="btn border-0 fp2" data-bs-toggle="collapse" href="#${colapseId}">
          <i class="fa fa-chevron-right"></i> ${day}
        </a></p>
        <div class="collapse show mb-3" id="${colapseId}">
          ${items.map(item => renderCard(item)).join('')}
        </div>`;
      container.insertAdjacentHTML('beforeend', html);
    });

    if (shownGroups < alertsByDate.length) {
      loadBtn.onclick = () => {
        shownGroups += 3;
        renderGroups();
      };
      container.appendChild(loadBtn);
    }

    setupSequentialVideoPlayback();
  };

  function renderCard(item) {
    const videoHtml = (item.videoUrls || []).length
      ? `<video 
            class="video-cl w-100 mb-2 autoplay-video" 
            data-index="0"
            data-urls='${JSON.stringify(item.videoUrls)}'
            muted 
            autoplay 
            playsinline 
            controls>
            <source src="${item.videoUrls[0]}" type="video/mp4">
         </video>`
      : '<p class="text-muted">No videos available.</p>';

    const formattedDate = formatCustomDate(item.date);
    const userDOB = item.userDOB ? formatDOB(new Date(item.userDOB)) : 'N/A';
    const userAddress = item.address || 'N/A';
    const userName = item.userName || 'N/A';
    
    return `
     <div class="col-md-12 my-2">
      <div class="card stCard">
        <div class="card-body">
          <div class="col-md-12 d-flex justify-content-end">
          <div class="mr-auto activity-user-card-title">
            <p class="fp2 mb-2">Legal Emergency Alert for ${item.title}</p>
            <p class="ft7 mb-0" style="line-height:normal">${formattedDate}</p>
          </div>
            <div class="d-flex gap-2 align-items-center">
              ${item.isFalse ? `<img src="<?= base_url('assets/images/icons/warning.png'); ?>" alt="Warning" style="width: 20px; height: 20px;" title="False Alert" />` : ""}
              <button onclick="archiveQuote('${item.id}')" class="btn btn-sm py-1 px-2 btn-ar" title="Archive">
                <img src="<?= base_url(); ?>/assets/images/icons/ari.png"/> <small>Archive</small>
              </button>
            </div>
          </div>

          <div class="row g-2">
            <div class="col-md-6">

              <div class="d-flex flex-wrap flex-column gap-3">
                <div class="d-flex flex-wrap align-items-center">

                  <!-- 🟦 PERSONAL INFO -->
                  <p class="fw-bold text-primary mb-0 mt-2 w-100">Personal Info</p>
                  <p class="mb-0 info-card-detail"><strong>Name:</strong> ${userName}</p>
                  <p class="mb-0 info-card-detail"><strong>Date of Birth:</strong> ${userDOB}</p>
                  <p class="mb-0 info-card-detail"><strong>Address:</strong> ${userAddress}</p>
                  <p class="mb-0 info-card-detail"><strong>Citizenship:</strong> ${item.countryOfCitizenship}</p>

                  <!-- 🟩 IMMIGRATION INFO -->
                  <p class="fw-bold text-success mb-0  mt-2 w-100">Immigration Info</p>
                  <p class="mb-0 info-card-detail"><strong>A-Number:</strong> ${item.ANumber}</p>
                  <p class="mb-0 info-card-detail"><strong>Visa Type:</strong> ${item.visaType}</p>
                  <p class="mb-0 info-card-detail"><strong>Visa Expiry Date:</strong> ${item.visaExpiryDate}</p>
                  

                  <!-- 🟥 CASE DETAILS -->
                  <p class="fw-bold text-danger mb-0 mt-2 w-100">Case Details</p>
                  <p class="mb-0 info-card-detail"><strong>Detained at:</strong> ${item.detainedPlace || 'N/A'}</p>
                  <p class="mb-0 info-card-detail"><strong>Charges:</strong>
                    ${
                      Array.isArray(item.offense) && item.offense.length
                        ? item.offense.map(off =>
                            `${off.chargedesc || 'Unknown'} (${off.severity || '-'}) - ${off.warrantissuedagency || 'Agency Unknown'}`
                          ).join('<br>')
                        : 'N/A'
                    }
                  </p>
                  <p class="mb-0 info-card-detail"><strong>Attorney Alerted:</strong> ${item.isAttorneyAlerted ? 'Yes' : 'No'}</p>
                  <p class="mb-0 info-card-detail"><strong>Designated Attorneys:</strong> ${item.attorneyName}</p>
                  <p class="mb-0 info-card-detail"><strong>Criminal Attorney:</strong> ${item.criminalAttorneyName}</p>
                  <p class="mb-0 info-card-detail"><strong>Immigration Attorney:</strong> ${item.immigrationAttorneyName}</p>

                </div>
              </div>
            </div>
            <div class="col-md-6">${videoHtml}</div>
          </div>

          <div class="d-flex justify-content-end gap-2 mt-2 flex-wrap">
            <button onclick="fetchArrestDetails('${item.title}', '${item.id}')" class="btn btn-save py-1 btn-same btn-width">
              Arrest Details
            </button>
            <a href="<?= base_url('site/findattorny'); ?>?id=${item.id}" 
              class="btn btn-save btn-same btn-width"
              onclick='storeAlert(this)' 
              data-item='${JSON.stringify(item).replace(/"/g, "&quot;")}' >
              Find Attorney
            </a>
            <button onclick="deleteQuote('${item.id}')" class="btn btn-danger py-1 btn-same d-flex align-items-center gap-1 btn-width">
              <i class="fa fa-trash"></i> Delete
            </button>
          </div>
        </div>
      </div>
    </div>

      `;
  }

  async function archiveQuote(id) {
    const result = await Swal.fire({
      title: 'Move to Archive?',
      text: 'You can restore this alert within 30 days of when the alert occurred.',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'Yes, archive it',
      cancelButtonText: 'Cancel',
      reverseButtons: true
    });

    if (result.isConfirmed) {
      try {
        await db.collection("QuoteAlert").doc(id).update({ isUserArchived: true });
        Swal.fire("Archived", "This alert has been archived.", "success");
        location.reload();
      } catch (error) {
        console.error(error);
        Swal.fire("Error", "Failed to archive the alert.", "error");
      }
    }
  }

  function formatDOB(date) {
    return date.toLocaleDateString('en-US', {
      day: '2-digit',
      month: 'long',
      year: 'numeric'
    });
  }

  async function deleteQuote(id) {
    const confirm = await Swal.fire({
      title: "Permanently Delete?",
      text: "This action cannot be undone.",
      icon: "warning",
      showCancelButton: true,
      confirmButtonText: "Yes, delete it!",
      cancelButtonText: "Cancel"
    });

    if (confirm.isConfirmed) {
      try {
        await db.collection("QuoteAlert").doc(id).delete();
        Swal.fire("Deleted!", "The activity has been deleted.", "success");
        await reloadAlerts();
      } catch (error) {
        console.error(error);
        Swal.fire("Error", "Failed to delete the activity.", "error");
      }
    }
  }

  async function reloadAlerts() {
    const user = firebase.auth().currentUser;
    if (!user) return;
    //  showLoader(); // ✅ Start spinner
    const userDoc = await db.collection("Users").doc(user.uid).get();
    const userData = userDoc.data();
    const userFriendsMap = userData.userFriends || {};
    const friendIds = Object.keys(userFriendsMap);

    const quoteRef = db.collection("QuoteAlert");
    const ownSnap = await quoteRef.where("userId", "==", user.uid).where("isUserArchived", "==", false).get();
    const ownQuotes = ownSnap.docs.map(d => ({ id: d.id, ...d.data(), date: new Date(d.data().createdDate) }));

    let friendQuotes = [];
    for (let i = 0; i < friendIds.length; i += 10) {
      const chunk = friendIds.slice(i, i + 10);
      const friendSnap = await quoteRef.where("userId", "in", chunk).where("isUserArchived", "==", false).get();
      friendQuotes.push(...friendSnap.docs.map(d => ({ id: d.id, ...d.data(), date: new Date(d.data().createdDate) })));
    }

    const allQuotes = [...ownQuotes, ...friendQuotes].sort((a, b) => b.date - a.date);

    const userIds = [...new Set(allQuotes.flatMap(q => [q.userId, q.LawId].filter(Boolean)))];
    const userMap = {};

    for (const uid of userIds) {
      const uDoc = await db.collection("Users").doc(uid).get();
      if (uDoc.exists) {
        userMap[uid] = uDoc.data();
      }
    }

    // allQuotes.forEach(q => {
    //   const userData = userMap[q.userId] || {};
    //   const attorneyData = q.LawId ? userMap[q.LawId] : null;

    //   q.userName = userData.Name || 'N/A';
    //   q.userDOB = userData.userDOB || null;
    //   q.address = userData.address || 'N/A';
    //   q.attorneyName = attorneyData ? attorneyData.Name : 'Opted Out';
    // });
    for (const q of allQuotes) {
      const userData = userMap[q.userId] || {};
      const attorneyData = q.LawId ? userMap[q.LawId] : null;

      q.userName = userData.Name || 'N/A';
      q.userDOB = userData.userDOB || null;

      if (q.userLat && q.userLng) {
        q.address = await getAddressFromCoords(q.userLat, q.userLng); // ✅ works now
      } else {
        q.address = "Unknown location";
      }

      q.attorneyName = attorneyData ? attorneyData.Name : 'N/A';
    }


    const grouped = {};
    allQuotes.forEach(a => {
      const key = a.date.toDateString();
      (grouped[key] ||= []).push(a);
    });

    allAlertsByDate = Object.entries(grouped).map(([day, items]) => ({ day, items }));
    alertsByDate = [...allAlertsByDate];
    shownGroups = 3;
    renderGroups();
    //  hideLoader(); // ✅ Always hide loader
  }

  async function fetchArrestDetails(name, alertId) {
    try {
      const upperName = name.toUpperCase();
      let arrest = null;

      // 1️⃣ Try API
      try {
        const res = await fetch(`https://us-central1-duepro-2cf60.cloudfunctions.net/widgets/searchnew?name=${encodeURIComponent(upperName)}`);
        const result = await res.json();

        if (result.success !== 0 && result.result) {
          arrest = result.result;
        }
      } catch (apiError) {
        console.warn("API fetch failed:", apiError);
      }

      // 2️⃣ If API fails, use Firestore
      if (!arrest) {
        const alertDoc = await db.collection("QuoteAlert").doc(alertId).get();
        if (alertDoc.exists) {
          const alertData = alertDoc.data();
          if (alertData.offense && Array.isArray(alertData.offense) && alertData.offense.length > 0) {
            arrest = { fullName: name, offense: alertData.offense };
          }
        }
      }

      // 3️⃣ Show result or not found
      if (!arrest) {
        return Swal.fire("No Record", "No arrest record found.", "info");
      }

      const arrestDate = arrest.arrestDate ? new Date(arrest.arrestDate).toLocaleString() : "N/A";

      Swal.fire({
        title: `Arrest Details`,
        html: `
          <p><strong>Name:</strong> ${arrest.fullName || name}</p>
          <p><strong>Gender:</strong> ${arrest.gender || 'N/A'}</p>
          <p><strong>Age:</strong> ${arrest.age || 'N/A'}</p>
          <p><strong>Address:</strong> ${arrest.address || 'N/A'}</p>
          <p><strong>City/State/Zip:</strong> ${arrest.cityStateZip || 'N/A'}</p>
          <p><strong>Offense:</strong><br />
            ${
              Array.isArray(arrest.offense) && arrest.offense.length
                ? arrest.offense.map(o =>
                    `${o.chargedesc || 'Unknown'} (${o.severity || '-'}) - ${o.warrantissuedagency || 'Unknown Agency'}`
                  ).join('<br>')
                : 'N/A'
            }
          </p>
          <p><strong>Detention:</strong> ${arrest.detention || 'N/A'}</p>
          <p><strong>Arrest Date:</strong> ${arrestDate}</p>
        `,
        confirmButtonText: 'Close'
      });
    } catch (err) {
      console.error(err);
      Swal.fire("Error", "Failed to fetch arrest details.", "error");
    }
  }
</script>
