<!-- main -->
<main class="">
  <div class="container">
    <div class="my-5" id="contractDetails">
      <!-- Loading state -->
      <div class="text-center py-5">
        <div class="spinner-border text-primary" role="status">
          <span class="visually-hidden">Loading...</span>
        </div>
        <p class="mt-3">Loading contract details...</p>
        <!-- HTML -->


      </div>
      
    </div>
  </div>
  
  <!-- Modal -->
  <!-- <div class="modal fade" id="exampleModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h1 class="modal-title fp-1">Payment Method</h1>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <p class="fp-3">Law Pay</p>
          <p class="fp-2">
            As a Part of your Application, Lawpay will verify your info
            and Request Payment Details
            <a href="#">LawPay Privacy Policy</a>
          </p>
        </div>
      </div>
    </div>
  </div> -->
  <!-- Modal -->
  <div class="modal fade" id="exampleModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h1 class="modal-title fp-1">Payment Method</h1>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <div id="card-element" class="my-3 border border-1 form-control"></div>
          <div id="payment-options" style="display:none;">
            <button id="full-payment-btn" class="btn btn-primary w-100 mb-2">
              Pay Full Amount ($<span id="full-amount">0</span>)
            </button>
            <button id="downpayment-btn" class="btn btn-secondary w-100">
              Pay Downpayment ($<span id="downpayment-amount">0</span>)
            </button>
          </div>
          <div id="stripe-element" style="display:none;">
            <div id="card-element" class="mb-3"></div>
            <button id="submit-payment" class="btn btn-success w-100">
              Confirm Payment
            </button>
          </div>
        </div>
      </div>
    </div>
  </div>
</main>



<style>
  .contract-details-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
    gap: 1rem;
    margin: 1rem 0;
  }
  .detail-item {
    display: flex;
    justify-content: space-between;
    padding: 0.5rem;
    border-bottom: 1px solid #eee;
  }
  .detail-label {
    font-weight: bold;
  }
  .detail-value {
    color: #555;
  }
  #signature-pad {
    border: 1px solid #ddd;
    background-color: #f9f9f9;
  }
</style>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" ></script>
<script src="https://js.stripe.com/v3/"></script>
<!-- <script>
  const stripe = Stripe('pk_test_51QFoufDBtwv2fMPqDWx3VuNchIylGpQiqtS7pTY630DwQ0DbVfLjL0caZYMYh6upVaQIUIDLpWq1ACC1mNGvpYG800tit7lPTX');
  let elements;
  let cardElement;
  let paymentIntentClientSecret;
  let quoteData;
  let userData;
  let hasSigned = false;
  let quoteId;
  let lawId;

  document.addEventListener('DOMContentLoaded', async () => {
    const db = firebase.firestore();
    const urlParams = new URLSearchParams(window.location.search);
    lawId = urlParams.get('lawId');
    quoteId = urlParams.get('quoteId');
    const container = document.getElementById('contractDetails');

    if (!lawId || !quoteId) {
      container.innerHTML = `
        <div class="alert alert-danger">
          Missing required parameters. Please ensure both lawId and quoteId are provided.
        </div>
      `;
      return;
    }

    try {
      // Fetch quote details
      const quoteDoc = await db.collection("QuoteAlert").doc(quoteId).get();
      if (!quoteDoc.exists) throw new Error("Quote not found");
      quoteData = quoteDoc.data();

      // Fetch user details
      const userDoc = await db.collection("Users").doc(quoteData.userId).get();
      if (!userDoc.exists) throw new Error("User not found");
      userData = userDoc.data();

      // Fetch emergency contact
      let guarantorName = "N/A";
      try {
        const emergencyContacts = await db.collection("Users")
          .doc(quoteData.userId)
          .collection("EmergencyContacts")
          .limit(1)
          .get();

        if (!emergencyContacts.empty) {
          guarantorName = emergencyContacts.docs[0].data().name || "N/A";
        }
      } catch (e) {
        console.error("Error fetching emergency contacts:", e);
      }

      // Format date
      const createdDate = new Date(quoteData.createdDate);
      const today = new Date();
      const dateStr = `${today.getMonth() + 1}/${today.getDate()}/${today.getFullYear()}`;

      container.innerHTML = `
        <p class="fp-1">Contract Details</p>
        <div class="contract-details-grid">
          <div class="detail-item"><span class="detail-label">Date:</span><span class="detail-value">${dateStr}</span></div>
          <div class="detail-item"><span class="detail-label">Client Name:</span><span class="detail-value">${userData.Name || 'N/A'}</span></div>
          <div class="detail-item"><span class="detail-label">County:</span><span class="detail-value">${quoteData.county || 'N/A'}</span></div>
          <div class="detail-item"><span class="detail-label">Charges:</span><span class="detail-value">${quoteData.chargesOffence || 'N/A'}</span></div>
          <div class="detail-item"><span class="detail-label">Retainer Fee:</span><span class="detail-value">$${quoteData.qoutesPrice || '0'}</span></div>
          <div class="detail-item"><span class="detail-label">Down Payment Amount:</span><span class="detail-value">$${quoteData.qoutesDeposite || '0'}</span></div>
          <div class="detail-item"><span class="detail-label">Paid on Date:</span><span class="detail-value">${quoteData.paidDate || 'Not paid yet'}</span></div>
          <div class="detail-item"><span class="detail-label">Paid on Day of Month:</span><span class="detail-value">${quoteData.paidDate ? new Date(quoteData.paidDate).getDate() : 'N/A'}</span></div>
          <div class="detail-item"><span class="detail-label">Guarantor Name:</span><span class="detail-value">${guarantorName}</span></div>
          <div class="detail-item"><span class="detail-label">Signature Date:</span><span class="detail-value">${dateStr}</span></div>
        </div>

        <p class="fp-1">e-signs</p>
        <p class="fp-2">Sign a Contract</p>
        <div class="row">
          <div class="col-md-4 my-2">
            <canvas id="signature-pad" width="400" height="200"></canvas>
          </div>
        </div>
        <div>
          <button class="btn btn-sm btn-save" onclick="clearSignature()">Clear</button>
          <button class="btn btn-save" data-bs-toggle="modal" data-bs-target="#exampleModal" id="pay">Finish & Pay</button>
          <button class="d-none" onclick="saveSignature()">Save</button>
        </div>
        <img class="d-none" id="signature-image" alt="Saved Signature" />
      `;

      // Signature Pad & Payment Handlers
      initSignaturePad();
      setupPaymentHandlers();

    } catch (error) {
      console.error("Error loading contract:", error);
      container.innerHTML = `
        <div class="alert alert-danger">
          Error loading contract details: ${error.message}
        </div>
      `;
    }
  });

  function setupPaymentHandlers() {
    const payBtn = document.getElementById('pay');
    if (!payBtn) return console.warn('Pay button not found');

    payBtn.addEventListener('click', async function (e) {
      e.preventDefault();

      const canvas = document.getElementById("signature-pad");
      const ctx = canvas.getContext("2d");
      const signatureData = ctx.getImageData(0, 0, canvas.width, canvas.height).data;
      hasSigned = signatureData.some(channel => channel !== 0);

      if (!hasSigned) {
        Swal.fire('Signature Required', 'Please sign the contract before proceeding to payment', 'warning');
        return;
      }

      document.getElementById('full-amount').textContent = (quoteData.qoutesPrice / 100).toFixed(2);
      document.getElementById('downpayment-amount').textContent = (quoteData.qoutesDeposite / 100).toFixed(2);
      document.getElementById('payment-options').style.display = 'block';

      $('#exampleModal').on('shown.bs.modal', function () {
        if (!elements) {
          elements = stripe.elements();
          cardElement = elements.create('card');
          cardElement.mount('#card-element');
        }
      });
    });

    document.getElementById('full-payment-btn').addEventListener('click', async function () {
      await initiateStripePayment(quoteData.qoutesPrice, 'full');
    });

    document.getElementById('downpayment-btn').addEventListener('click', async function () {
      await initiateStripePayment(quoteData.qoutesDeposite, 'downpayment');
    });

    document.getElementById('submit-payment').addEventListener('click', async function () {
      const { error, paymentIntent } = await stripe.confirmCardPayment(paymentIntentClientSecret, {
        payment_method: {
          card: cardElement,
          billing_details: {
            name: userData.Name,
            email: userData.email
          }
        }
      });

      if (error) {
        Swal.fire('Payment Failed', error.message, 'error');
      } else if (paymentIntent.status === 'succeeded') {
        await savePaymentDetails(paymentIntent);
        Swal.fire('Payment Successful!', `Your $${paymentIntent.amount / 100} payment was processed`, 'success')
          .then(() => {
            $('#exampleModal').modal('hide');
            window.location.href = '/payment-success';
          });
      }
    });
  }

  async function initiateStripePayment(amount, paymentType) {
    try {
      const response = await fetch('/create-payment-intent', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({
          amount,
          currency: 'usd',
          metadata: {
            quoteId,
            paymentType,
            userId: quoteData.userId,
            lawId
          }
        }),
      });

      const { clientSecret } = await response.json();
      paymentIntentClientSecret = clientSecret;

      document.getElementById('payment-options').style.display = 'none';
      document.getElementById('stripe-element').style.display = 'block';

    } catch (err) {
      console.error('Stripe payment error:', err);
      Swal.fire('Error', 'Could not initiate payment', 'error');
    }
  }

  async function savePaymentDetails(paymentIntent) {
    const db = firebase.firestore();
    const batch = db.batch();

    const canvas = document.getElementById("signature-pad");
    const signatureData = canvas.toDataURL();

    const quoteRef = db.collection("QuoteAlert").doc(quoteId);
    batch.update(quoteRef, {
      signature: signatureData,
      signatureDate: new Date(),
      paidDate: new Date(),
      paidAmount: paymentIntent.amount,
      paidStatus: paymentIntent.metadata.paymentType === 'full' ? 'paid_in_full' : 'downpayment_paid'
    });

    const paymentsRef = db.collection("Payments").doc();
    batch.set(paymentsRef, {
      amount: paymentIntent.amount,
      currency: paymentIntent.currency,
      paymentIntentId: paymentIntent.id,
      status: paymentIntent.status,
      quoteId,
      userId: quoteData.userId,
      lawId,
      createdAt: new Date(),
      paymentType: paymentIntent.metadata.paymentType
    });

    await batch.commit();
  }

  function initSignaturePad() {
    const canvas = document.getElementById("signature-pad");
    const ctx = canvas.getContext("2d");
    let isDrawing = false;

    canvas.width = canvas.offsetWidth;
    canvas.height = canvas.offsetHeight;

    canvas.addEventListener("mousedown", startDrawing);
    canvas.addEventListener("mousemove", draw);
    canvas.addEventListener("mouseup", stopDrawing);
    canvas.addEventListener("touchstart", startDrawing, { passive: false });
    canvas.addEventListener("touchmove", draw, { passive: false });
    canvas.addEventListener("touchend", stopDrawing);

    function getPosition(e) {
      if (e.touches) {
        return {
          x: e.touches[0].clientX - canvas.getBoundingClientRect().left,
          y: e.touches[0].clientY - canvas.getBoundingClientRect().top
        };
      }
      return { x: e.offsetX, y: e.offsetY };
    }

    function startDrawing(e) {
      e.preventDefault();
      isDrawing = true;
      const pos = getPosition(e);
      ctx.beginPath();
      ctx.moveTo(pos.x, pos.y);
      ctx.lineWidth = 2;
      ctx.strokeStyle = "#000";
      ctx.lineCap = "round";
    }

    function draw(e) {
      if (!isDrawing) return;
      e.preventDefault();
      const pos = getPosition(e);
      ctx.lineTo(pos.x, pos.y);
      ctx.stroke();
    }

    function stopDrawing(e) {
      e.preventDefault();
      isDrawing = false;
    }

    window.clearSignature = function () {
      ctx.clearRect(0, 0, canvas.width, canvas.height);
      document.getElementById("signature-image").src = "";
    };

    window.saveSignature = function () {
      const dataURL = canvas.toDataURL();
      document.getElementById("signature-image").src = dataURL;
    };
  }
  </script>
    -->

    <!-- <script>
  const stripe = Stripe('pk_live_51QFoufDBtwv2fMPqH893SayfEPn0JOASLUsVysih4wtZFpJ4K7n8lefX2oVnA5SVrmLUvMLGcu5arMhbddIPHroW00Z7JiRlo6');
  let elements;
  let cardElement;
  let quoteData;
  let userData;
  let hasSigned = false;
  let quoteId;
  let lawId;

  document.addEventListener('DOMContentLoaded', async () => {
    const db = firebase.firestore();
    const urlParams = new URLSearchParams(window.location.search);
    lawId = urlParams.get('lawId');
    quoteId = urlParams.get('quoteId');
    const container = document.getElementById('contractDetails');

    if (!lawId || !quoteId) {
      container.innerHTML = `
        <div class="alert alert-danger">
          Missing required parameters. Please ensure both lawId and quoteId are provided.
        </div>
      `;
      return;
    }

    try {
      // Fetch quote details
      const quoteDoc = await db.collection("QuoteAlert").doc(quoteId).get();
      if (!quoteDoc.exists) throw new Error("Quote not found");
      quoteData = quoteDoc.data();

      // Fetch user details
      const userDoc = await db.collection("Users").doc(quoteData.userId).get();
      if (!userDoc.exists) throw new Error("User not found");
      userData = userDoc.data();

      // Fetch emergency contact
      let guarantorName = "N/A";
      try {
        const emergencyContacts = await db.collection("Users")
          .doc(quoteData.userId)
          .collection("EmergencyContacts")
          .limit(1)
          .get();

        if (!emergencyContacts.empty) {
          guarantorName = emergencyContacts.docs[0].data().name || "N/A";
        }
      } catch (e) {
        console.error("Error fetching emergency contacts:", e);
      }

      // Format date
      const createdDate = new Date(quoteData.createdDate);
      const today = new Date();
      const dateStr = `${today.getMonth() + 1}/${today.getDate()}/${today.getFullYear()}`;

      container.innerHTML = `
        <p class="fp-1">Contract Details</p>
        <div class="contract-details-grid">
          <div class="detail-item"><span class="detail-label">Date:</span><span class="detail-value">${dateStr}</span></div>
          <div class="detail-item"><span class="detail-label">Client Name:</span><span class="detail-value">${userData.Name || 'N/A'}</span></div>
          <div class="detail-item"><span class="detail-label">County:</span><span class="detail-value">${quoteData.county || 'N/A'}</span></div>
          <div class="detail-item"><span class="detail-label">Charges:</span><span class="detail-value">${quoteData.chargesOffence || 'N/A'}</span></div>
          <div class="detail-item"><span class="detail-label">Retainer Fee:</span><span class="detail-value">$${quoteData.qoutesPrice || '0'}</span></div>
          <div class="detail-item"><span class="detail-label">Down Payment Amount:</span><span class="detail-value">$${quoteData.qoutesDeposite || '0'}</span></div>
          <div class="detail-item"><span class="detail-label">Paid on Date:</span><span class="detail-value">${quoteData.paidDate
    ? quoteData.paidDate.toDate().toLocaleDateString()  
    : 'Not paid yet'}</span></div>
          <div class="detail-item"><span class="detail-label">Paid on Day of Month:</span><span class="detail-value">${
      quoteData.paidDate ? quoteData.paidDate.toDate().getDate() : 'N/A'
    }</span></div>
          <div class="detail-item"><span class="detail-label">Guarantor Name:</span><span class="detail-value">${guarantorName}</span></div>
          <div class="detail-item"><span class="detail-label">Signature Date:</span><span class="detail-value">${dateStr}</span></div>
        </div>

        <p class="fp-1">e-signs</p>
        <p class="fp-2">Sign a Contract</p>
        <div class="row">
          <div class="col-md-4 my-2">
            <canvas id="signature-pad" width="400" height="200"></canvas>
          </div>
        </div>
        <div>
          <button class="btn btn-sm btn-save" onclick="clearSignature()">Clear</button>
          <button class="btn btn-save" data-bs-toggle="modal" data-bs-target="#exampleModal" id="pay">Finish & Pay</button>
        </div>
      `;

      // Signature Pad & Payment Handlers
      initSignaturePad();
      setupPaymentHandlers();

    } catch (error) {
      console.error("Error loading contract:", error);
      container.innerHTML = `
        <div class="alert alert-danger">
          Error loading contract details: ${error.message}
        </div>
      `;
    }
  });

  function setupPaymentHandlers() {
    const payBtn = document.getElementById('pay');
    if (!payBtn) return console.warn('Pay button not found');

    payBtn.addEventListener('click', async function (e) {
      e.preventDefault();

      const canvas = document.getElementById("signature-pad");
      const ctx = canvas.getContext("2d");
      const signatureData = ctx.getImageData(0, 0, canvas.width, canvas.height).data;
      hasSigned = signatureData.some(channel => channel !== 0);

      if (!hasSigned) {
        Swal.fire('Signature Required', 'Please sign the contract before proceeding to payment', 'warning');
        return;
      }

      document.getElementById('full-amount').textContent = quoteData.qoutesPrice;
      document.getElementById('downpayment-amount').textContent = quoteData.qoutesDeposite;
      document.getElementById('payment-options').style.display = 'block';

      $('#exampleModal').on('shown.bs.modal', function () {
        if (!elements) {
          elements = stripe.elements();
          cardElement = elements.create('card');
          cardElement.mount('#card-element');
        }
      });
    });

    document.getElementById('full-payment-btn').addEventListener('click', async function () {
      await processPayment(quoteData.qoutesPrice, '1');
    });

    document.getElementById('downpayment-btn').addEventListener('click', async function () {
      await processPayment(quoteData.qoutesDeposite, '1');
    });
  }

  async function processPayment(amount, paidStatus) {
    try {
      // First upload the signature image to Firebase Storage
      const canvas = document.getElementById("signature-pad");
      const signatureDataURL = canvas.toDataURL();
      
      // Convert data URL to blob
      const blob = await (await fetch(signatureDataURL)).blob();
      const storageRef = firebase.storage().ref();
      const signatureRef = storageRef.child(`SignDocs/${quoteId}_${new Date().getTime()}.png`);
      
      // Show loading indicator
      Swal.fire({
        title: 'Processing Payment',
        html: 'Please wait while we process your payment and signature...',
        allowOutsideClick: false,
        didOpen: () => {
          Swal.showLoading();
        }
      });

      // Upload signature image
      const uploadTask = await signatureRef.put(blob);
      const signatureUrl = await uploadTask.ref.getDownloadURL();

      // Update QuoteAlert document
      const db = firebase.firestore();
      await db.collection("QuoteAlert").doc(quoteId).update({
        signatureImage: signatureUrl,
        paidStatus: paidStatus,
        paidDate: new Date(),
        isFullPaid: paidStatus === '1',
        paymentId: `manual_${new Date().getTime()}`,
        clientSecret: `manual_${new Date().getTime()}`
      });

      // Hide loading and show success
      Swal.fire({
        icon: 'success',
        title: 'Payment Processed!',
        text: 'Your payment and signature have been successfully recorded.',
        confirmButtonText: 'OK'
      }).then(() => {
        $('#exampleModal').modal('hide');
        window.history.back(); // 👈 Go back to previous page
      });

    } catch (error) {
      console.error('Payment processing error:', error);
      Swal.fire({
        icon: 'error',
        title: 'Payment Failed',
        text: 'There was an error processing your payment. Please try again.',
        confirmButtonText: 'OK'
      });
    }
  }

  function initSignaturePad() {
    const canvas = document.getElementById("signature-pad");
    const ctx = canvas.getContext("2d");
    let isDrawing = false;

    canvas.width = canvas.offsetWidth;
    canvas.height = canvas.offsetHeight;

    canvas.addEventListener("mousedown", startDrawing);
    canvas.addEventListener("mousemove", draw);
    canvas.addEventListener("mouseup", stopDrawing);
    canvas.addEventListener("touchstart", startDrawing, { passive: false });
    canvas.addEventListener("touchmove", draw, { passive: false });
    canvas.addEventListener("touchend", stopDrawing);

    function getPosition(e) {
      if (e.touches) {
        return {
          x: e.touches[0].clientX - canvas.getBoundingClientRect().left,
          y: e.touches[0].clientY - canvas.getBoundingClientRect().top
        };
      }
      return { x: e.offsetX, y: e.offsetY };
    }

    function startDrawing(e) {
      e.preventDefault();
      isDrawing = true;
      const pos = getPosition(e);
      ctx.beginPath();
      ctx.moveTo(pos.x, pos.y);
      ctx.lineWidth = 2;
      ctx.strokeStyle = "#000";
      ctx.lineCap = "round";
    }

    function draw(e) {
      if (!isDrawing) return;
      e.preventDefault();
      const pos = getPosition(e);
      ctx.lineTo(pos.x, pos.y);
      ctx.stroke();
    }

    function stopDrawing(e) {
      e.preventDefault();
      isDrawing = false;
    }

    window.clearSignature = function () {
      ctx.clearRect(0, 0, canvas.width, canvas.height);
    };
  }
</script> -->

<script>
  // live
  // const stripe = Stripe('pk_live_51QFoufDBtwv2fMPqH893SayfEPn0JOASLUsVysih4wtZFpJ4K7n8lefX2oVnA5SVrmLUvMLGcu5arMhbddIPHroW00Z7JiRlo6');
  // test
  const stripe = Stripe('pk_test_51Plp8hHy6FyzXGcJpCU4v3gvt8rg46T6if8qspqMXX6McpcMflENFMp2HgyEp9C9G9aLfX1LpX0eNoMMUbKzJqKZ00hasa4ncI');
  let elements;
  let cardElement;
  let quoteData;
  let userData;
  let hasSigned = false;
  let quoteId;
  let lawId;

  document.addEventListener('DOMContentLoaded', async () => {
    const db = firebase.firestore();
    const urlParams = new URLSearchParams(window.location.search);
    lawId = urlParams.get('lawId');
      quoteId = urlParams.get('quoteId');
    if (quoteId && quoteId.includes('?')) {
    quoteId = quoteId.split('?')[0];  // take only the real ID
    }

    console.log("quote_id",quoteId)
    console.log('lawid',lawId )
    const container = document.getElementById('contractDetails');

    if (!lawId || !quoteId) {
      container.innerHTML = `
        <div class="alert alert-danger">
          Missing required parameters. Please ensure both lawId and quoteId are provided.
        </div>
      `;
      return;
    }

    try {
      // Fetch quote details
      const quoteDoc = await db.collection("QuoteAlert").doc(quoteId).get();
      if (!quoteDoc.exists) throw new Error("Quote not found");
      quoteData = quoteDoc.data();

      // Fetch user details
      const userDoc = await db.collection("Users").doc(quoteData.userId).get();
      if (!userDoc.exists) throw new Error("User not found");
      userData = userDoc.data();

      // Fetch emergency contact
      let guarantorName = "N/A";
      try {
        const emergencyContacts = await db.collection("Users")
          .doc(quoteData.userId)
          .collection("EmergencyContacts")
          .limit(1)
          .get();

        if (!emergencyContacts.empty) {
          guarantorName = emergencyContacts.docs[0].data().name || "N/A";
        }
      } catch (e) {
        console.error("Error fetching emergency contacts:", e);
      }
    // JavaScript



      // Format date
      const createdDate = new Date(quoteData.createdDate);
      const today = new Date();
      const dateStr = `${today.getMonth() + 1}/${today.getDate()}/${today.getFullYear()}`;

      container.innerHTML = `
        <div class="d-flex justify-content-between align-items-center">
        <p class="fp-1">Contract Details</p>
        <button id="viewDocBtn" class="btn btn-save btn-width d-flex justify-content-center align-items-center">View Document</button>
        </div>
        <div class="contract-details-grid">
          <div class="detail-item"><span class="detail-label">Date:</span><span class="detail-value">${dateStr}</span></div>
          <div class="detail-item"><span class="detail-label">Client Name:</span><span class="detail-value">${userData.Name || 'N/A'}</span></div>
          <div class="detail-item"><span class="detail-label">County:</span><span class="detail-value">${quoteData.county || 'N/A'}</span></div>
          <div class="detail-item">
        <span class="detail-label">Charges:</span>
        <span class="detail-value">
          ${
            Array.isArray(quoteData.offense) && quoteData.offense.length
              ? quoteData.offense.map(off =>
                  `${off.chargedesc || 'Unknown'} (${off.severity || '-'}) - ${off.warrantissuedagency || 'Unknown Agency'}`
                ).join('<br>')
              : 'N/A'
          }
        </span>
      </div>

          <div class="detail-item"><span class="detail-label">Retainer Fee:</span><span class="detail-value">$${quoteData.qoutesPrice || '0'}</span></div>
          <div class="detail-item"><span class="detail-label">Down Payment Amount:</span><span class="detail-value">$${quoteData.qoutesDeposite || '0'}</span></div>
          <div class="detail-item"><span class="detail-label">Paid on Date:</span><span class="detail-value">${quoteData.paidDate
    ? quoteData.paidDate.toDate().toLocaleDateString()  
    : 'Not paid yet'}</span></div>
          <div class="detail-item"><span class="detail-label">Paid on Day of Month:</span><span class="detail-value">${
      quoteData.paidDate ? quoteData.paidDate.toDate().getDate() : 'N/A'
    }</span></div>
          <div class="detail-item"><span class="detail-label">Guarantor Name:</span><span class="detail-value">${
      quoteData.userId === firebase.auth().currentUser.uid
        ? (userData.Name || 'N/A')
        : guarantorName
    }</span></div>
          <div class="detail-item"><span class="detail-label">Signature Date:</span><span class="detail-value">${dateStr}</span></div>
        </div>

      
        <div class="d-flex justify-content-end">
        
          <button class="btn btn-save btn-width d-flex justify-content-center align-items-center" data-bs-toggle="modal" data-bs-target="#exampleModal" id="pay">Finish & Pay</button>
        </div>
      `;
      // 🔹 Check if envelope has been signed
      const payBtn = document.getElementById('pay');
      
      // Signature Pad & Payment Handlers
      // initSignaturePad();
      setupPaymentHandlers();
      const urlParams = new URLSearchParams(window.location.search);
      const userId = urlParams.get('lawId'); // this is the userId
      let qid=  urlParams.get('quoteId');
      const viewDocBtn = document.getElementById('viewDocBtn');
      
      if (quoteData.isEnvelopSign === true) {
          // Enable Finish & Pay button
          payBtn.disabled = false;
          viewDocBtn.disabled = true;
        } else {
          viewDocBtn.disabled = false;
          payBtn.disabled = true;
          payBtn.addEventListener('click', function (e) {
              e.preventDefault();
              Swal.fire(
                'Please view and sign document first',
                '',
                'warning'
              );
          });
      }
      
      viewDocBtn.addEventListener("click", async () => {

          try {
            const db = firebase.firestore();
            const currentUser = firebase.auth().currentUser;
            if (!currentUser || !currentUser.email) {
              Swal.fire("Error", "No logged-in user email found", "error");
              return;
            }

            // 1️⃣ Get DocuSign Bearer token
            const tokenResp = await fetch(
              // "http://137.184.111.69/test_docusign_apis/index.php/docusign/token",
              "https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/token",
              
              // "https://sugarfest.online/docusign_apis/index.php/docusign/token",
              { headers: { Accept: "application/json" } }
            );
            if (!tokenResp.ok) throw new Error("Failed to get token");
            const tokenData = await tokenResp.json();
            if (!tokenData.success || !tokenData.access_token) {
              throw new Error("Token API did not return a valid token");
            }
            const accessToken = tokenData.access_token;

            // 2️⃣ Find templateId for this lawId
            const lawUserDoc = await db.collection("Users").doc(lawId).get();
            if (!lawUserDoc.exists) throw new Error("Lawyer user not found");
            const lawUserData = lawUserDoc.data();
            if (!lawUserData.LawFirmId)
              throw new Error("LawFirmId not found in user document");

            const lawFirmDoc = await db.collection("LawFirm")
              .doc(lawUserData.LawFirmId)
              .get();
            if (!lawFirmDoc.exists) throw new Error("LawFirm document not found");
            // const templateId = lawFirmDoc.data().templateId;
            // if (!templateId) throw new Error("templateId not found in LawFirm document");
            let templateId;
            if (qid) {
              const quoteDoc = await db.collection("QuoteAlert").doc(qid).get();
              if (quoteDoc.exists) {
                const quoteData = quoteDoc.data();
                if (quoteData.template_id) {
                  templateId = quoteData.template_id; // Use template_id from QuoteAlert
                }
              }
            }

            // ✅ If no template_id in QuoteAlert, fallback to LawFirm's templateId
            if (!templateId) {
              templateId = lawFirmDoc.data().templateId;
            }
            if (!templateId) throw new Error("No templateId found in QuoteAlert or LawFirm");
                // 3️⃣ Prepare payload for DocuSign
                const today = new Date();
                const otherData = {
                  date: today.toISOString().slice(0, 10),
                  clientName: userData.Name || "N/A",
                  county: quoteData.county || "N/A",
                  charges: Array.isArray(quoteData.offense) && quoteData.offense.length
                    ? quoteData.offense.map(off =>
                        `${off.chargedesc || "Unknown"} (${off.severity || "-"})`
                      ).join(", ")
                    : "N/A",
                  retainerFee: quoteData.qoutesPrice || 0,
                  downPaymentAmount: quoteData.qoutesDeposite || 0,
                  paidOnDate: quoteData.paidDate
                    ? quoteData.paidDate.toDate().toISOString().slice(0, 10)
                    : "Not paid yet",
                  monthlyPayment: quoteData.monthlyPayment || 0,
                  paidOnDayOfMonth: quoteData.paidDate
                    ? quoteData.paidDate.toDate().getDate()
                    : "N/A",
                  guarantorName:
                    quoteData.userId === currentUser.uid
                      ? (userData.Name || "N/A")
                      : guarantorName,
                  signatureDate: today.toISOString().slice(0, 10)
                };

                console.log("template_id", templateId);
                console.log("name", userData.Name);
                console.log("email", userData.email);
                console.log("doc_id", quoteId);

                // ⚠️ Build URL-encoded form body (not FormData)
                const params = new URLSearchParams();
                params.append("templateId", templateId);
                // match iOS returnUrl (signingCallback)
                params.append("returnUrl",  'https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/signingCallback');
                // params.append("returnUrl",  'http://137.184.111.69/test_docusign_apis/index.php/docusign/signingCallback');
                // params.append("returnUrl",  'https://sugarfest.online/docusign_apis/index.php/docusign/signingCallback');
                params.append("webUrl",  window.location.href);
                params.append("name", userData.Name || "N/A");
                params.append("email", userData.email || "N/A");
                params.append("doc_id", quoteId);
                params.append("attorney_email", lawUserDoc.email || "N/A");
                
                
                // if backend needs attorney_email you can add:
                params.append("attorney_email", currentUser.email);
                // params.append("otherdata", JSON.stringify(otherData));
                // ✅ send each field in otherdata like iOS
            // Object.entries(otherData).forEach(([k, v]) => {
            //   params.append(`otherdata[${k}]`, v);
            // });
            params.append("otherdata", JSON.stringify(otherData));
                Swal.fire({
                  title: "Preparing Document...",
                  allowOutsideClick: false,
                  didOpen: () => Swal.showLoading(),
                });

            // 4️⃣ Call DocuSign envelope-from-template API
            const apiUrl =
              "https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/envelope-from-template";
              // "http://137.184.111.69/test_docusign_apis/index.php/docusign/envelope-from-template";
              // "https://sugarfest.online/docusign_apis/index.php/docusign/envelope-from-template";
            const docusignResp = await fetch(apiUrl, {
              method: "POST",
              headers: {
                "Authorization": `Bearer ${accessToken}`,
                "Accept": "application/json",
                "Content-Type": "application/x-www-form-urlencoded"
              },
              body: params.toString(),
            });

            if (!docusignResp.ok) {
              const errText = await docusignResp.text();
              throw new Error(errText || "DocuSign API call failed");
            }

            const result = await docusignResp.json();
            console.log("result",result)
            Swal.close();

            // ✅ The API should return the signing URL inside result.data.recipientView.url
            if (result.data && result.data.recipientView && result.data.recipientView.url) {
              // window.open(result.data.recipientView.url, "_blank");
              window.location.href=result.data.recipientView.url
            } else {
              Swal.fire("Info", "Envelope created but no URL returned.", "info");
              console.log(result);
            }

          } catch (err) {
          console.error("DocuSign API error:", err);
          Swal.fire("Error", err.message || "Failed to load document", "error");
        }
      });


    } catch (error) {
      console.error("Error loading contract:", error);
      container.innerHTML = `
        <div class="alert alert-danger">
          Error loading contract details: ${error.message}
        </div>
      `;
    }
  });


  // document.addEventListener('DOMContentLoaded', async () => {
  //   const db = firebase.firestore();
  //   const urlParams = new URLSearchParams(window.location.search);
  //   let lawId = urlParams.get('lawId');
  //   let quoteId = urlParams.get('quoteId');
  //   if (quoteId && quoteId.includes('?')) quoteId = quoteId.split('?')[0];

  //   if (!lawId || !quoteId) {
  //     document.getElementById('contractDetails').innerHTML = `<div class="alert alert-danger">Missing required parameters.</div>`;
  //     return;
  //   }

  //   // Fetch quote & user
  //   const quoteDoc = await db.collection("QuoteAlert").doc(quoteId).get();
  //   const quoteData = quoteDoc.exists ? quoteDoc.data() : null;
  //   const userDoc = await db.collection("Users").doc(quoteData.userId).get();
  //   const userData = userDoc.exists ? userDoc.data() : null;

  //   // Render contract details (your existing HTML rendering code here)...

  //   // Setup DocuSign View Document button
  //   document.getElementById('viewDocBtn').addEventListener("click", async () => {
  //     try {
  //       const tokenResp = await fetch("https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/token", { headers: { Accept: "application/json" } });
  //       const tokenData = await tokenResp.json();
  //       const accessToken = tokenData.access_token;

  //       // Get templateId (from QuoteAlert or LawFirm)
  //       let templateId = quoteData.template_id;
  //       if (!templateId) {
  //         const lawUserDoc = await db.collection("Users").doc(lawId).get();
  //         const lawFirmDoc = await db.collection("LawFirm").doc(lawUserDoc.data().LawFirmId).get();
  //         templateId = lawFirmDoc.data().templateId;
  //       }

  //       const today = new Date();
  //       const otherData = {
  //         date: today.toISOString().slice(0, 10),
  //         clientName: userData.Name || "N/A",
  //         county: quoteData.county || "N/A",
  //         charges: Array.isArray(quoteData.offense) ? quoteData.offense.map(off => `${off.chargedesc || "Unknown"} (${off.severity || "-"})`).join(", ") : "N/A",
  //         retainerFee: quoteData.qoutesPrice || 0,
  //         downPaymentAmount: quoteData.qoutesDeposite || 0,
  //         paidOnDate: quoteData.paidDate ? quoteData.paidDate.toDate().toISOString().slice(0, 10) : "Not paid yet",
  //         monthlyPayment: quoteData.monthlyPayment || 0,
  //         paidOnDayOfMonth: quoteData.paidDate ? quoteData.paidDate.toDate().getDate() : "N/A",
  //         guarantorName: userData.Name || "N/A",
  //         signatureDate: today.toISOString().slice(0, 10)
  //       };

  //       const params = new URLSearchParams();
  //       params.append("templateId", templateId);
  //       params.append("returnUrl", 'https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/signingCallback');
  //       params.append("webUrl", window.location.href);
  //       params.append("name", userData.Name || "N/A");
  //       params.append("email", userData.email || "N/A");
  //       params.append("doc_id", quoteId);
  //       params.append("otherdata", JSON.stringify(otherData));

  //       Swal.fire({ title: "Preparing Document...", allowOutsideClick: false, didOpen: () => Swal.showLoading() });

  //       const docusignResp = await fetch("https://buzzwaretechserver.site/test_docusign_apis/index.php/docusign/envelope-from-template", {
  //         method: "POST",
  //         headers: {
  //           "Authorization": `Bearer ${accessToken}`,
  //           "Accept": "application/json",
  //           "Content-Type": "application/x-www-form-urlencoded"
  //         },
  //         body: params.toString(),
  //       });
  //       const result = await docusignResp.json();
  //       Swal.close();

  //       if (result.data?.recipientView?.url) window.location.href = result.data.recipientView.url;
  //       else Swal.fire("Info", "Envelope created but no URL returned.", "info");

  //     } catch (err) {
  //       console.error("DocuSign error:", err);
  //       Swal.fire("Error", err.message || "Failed to load document", "error");
  //     }
  //   });

  //   // ---------------- Stripe & MyCase Flow ----------------
  //   const payBtn = document.getElementById('pay');
  //   payBtn.addEventListener('click', async (e) => {
  //     e.preventDefault();

  //     try {
  //       // 1️⃣ Create MyCase Client & Case
  //       Swal.fire({ title: "Processing Client & Case...", allowOutsideClick: false, didOpen: () => Swal.showLoading() });
  //       const lawFirmId = lawId; // adjust if needed
  //       const myCaseToken = await fetchMyCaseToken(lawFirmId);
  //       const { clientId, caseId } = await createClientAndCaseIfNeeded(lawFirmId, null, quoteData, userData);
  //       console.log("✅ MyCase Result:", { clientId, caseId });
  //       Swal.close();

  //       // 2️⃣ Open Stripe Payment Modal
  //       document.getElementById('full-amount').textContent = quoteData.qoutesPrice;
  //       document.getElementById('downpayment-amount').textContent = quoteData.qoutesDeposite;
  //       document.getElementById('payment-options').style.display = 'block';
  //       $('#exampleModal').modal('show');

  //       if (!elements) {
  //         elements = stripe.elements();
  //         cardElement = elements.create('card');
  //         cardElement.mount('#card-element');
  //       }

  //       document.getElementById('full-payment-btn').onclick = () => processPayment(quoteData.qoutesPrice, 'full');
  //       document.getElementById('downpayment-btn').onclick = () => processPayment(quoteData.qoutesDeposite, 'partial');

  //     } catch (err) {
  //       Swal.close();
  //       Swal.fire("Error", "Failed to process MyCase client/case: " + err.message, "error");
  //     }
  //   });

  // });

  // ---------- MyCase helper functions (fetchMyCaseToken, createMyCaseClient, createMyCaseCase, createClientAndCaseIfNeeded) ----------
  // Use your existing implementations from your code

  // ---------- Stripe payment function ----------
  // Use your existing processPayment(amount, paymentType) function


  function setupPaymentHandlers() {
    const payBtn = document.getElementById('pay');
    if (!payBtn) return console.warn('Pay button not found');

    payBtn.addEventListener('click', async function (e) {
      e.preventDefault();

      // const canvas = document.getElementById("signature-pad");
      // const ctx = canvas.getContext("2d");
      // const signatureData = ctx.getImageData(0, 0, canvas.width, canvas.height).data;
      // hasSigned = signatureData.some(channel => channel !== 0);

      // if (!hasSigned) {
      //   Swal.fire('Signature Required', 'Please sign the contract before proceeding to payment', 'warning');
      //   return;
      // }

      document.getElementById('full-amount').textContent = quoteData.qoutesPrice;
      document.getElementById('downpayment-amount').textContent = quoteData.qoutesDeposite;
      if(quoteData.qoutesDeposite==0){
        document.getElementById('downpayment-btn').style.display="none"
      }
      document.getElementById('payment-options').style.display = 'block';

      $('#exampleModal').on('shown.bs.modal', function () {
        if (!elements) {
          elements = stripe.elements();
          cardElement = elements.create('card');
          cardElement.mount('#card-element');
        }
      });
    });

    document.getElementById('full-payment-btn').addEventListener('click', async function () {
      await processPayment(quoteData.qoutesPrice, 'full');
    });

    document.getElementById('downpayment-btn').addEventListener('click', async function () {
      await processPayment(quoteData.qoutesDeposite, 'partial');
    });
  }

  async function processPayment(amount, paymentType) {
    try {
      // // First upload the signature image to Firebase Storage
      // const canvas = document.getElementById("signature-pad");
      // const signatureDataURL = canvas.toDataURL();
      
      // // Convert data URL to blob
      // const blob = await (await fetch(signatureDataURL)).blob();
      const storageRef = firebase.storage().ref();
      // const signatureRef = storageRef.child(`SignDocs/${quoteId}_${new Date().getTime()}.png`);
      
      // Show loading indicator
      Swal.fire({
        title: 'Processing Payment',
        html: 'Please wait while we process your payment and signature...',
        allowOutsideClick: false,
        didOpen: () => {
          Swal.showLoading();
        }
      });

      // Upload signature image
      // const uploadTask = await signatureRef.put(blob);
      // const signatureUrl = await uploadTask.ref.getDownloadURL();

      // Create payment intent via CodeIgniter endpoint
      const response = await fetch('<?php echo site_url("site/create_payment_intent"); ?>', {
              method: 'POST',
              headers: {
                  'Content-Type': 'application/json',
                  'X-Requested-With': 'XMLHttpRequest'
              },
              body: JSON.stringify({
                  amount: Math.round(amount * 100), // Convert to cents
                  currency: 'usd',
                  quoteId: quoteId,
                  paymentType: paymentType,
                  lawId: lawId
              })
          });

          if (!response.ok) {
              const errorData = await response.json();
              throw new Error(errorData.error || 'Failed to create payment intent');
          }

      const { clientSecret } = await response.json();

      // Confirm the payment with Stripe
      const { paymentIntent, error } = await stripe.confirmCardPayment(clientSecret, {
        payment_method: {
          card: cardElement,
          billing_details: {
            name: userData.Name || 'Client',
          },
        }
      });

      if (error) {
        throw error;
      }

      if (paymentIntent.status === 'succeeded') {
        // Update QuoteAlert document with payment details
        const db = firebase.firestore();
        await db.collection("QuoteAlert").doc(quoteId).update({
          // signatureImage: signatureUrl,
          // paidStatus: paymentType === 'full' ? '1' : '0',
          paidStatus: "1",
          paidDate: new Date(),
          isFullPaid: paymentType === 'full',
          paymentId: paymentIntent.id,
          clientSecret: clientSecret,
          paymentMethod: 'stripe'
        });

        // Hide loading and show success
        Swal.fire({
          icon: 'success',
          title: 'Payment Successful!',
          text: `Your ${paymentType} payment of $${amount} has been processed.`,
          confirmButtonText: 'OK'
        }).then(() => {
          $('#exampleModal').modal('hide');
        window.location.href = "<?= base_url('site/quotesUser') ?>";
        });
      } else {
        throw new Error('Payment not completed');
      }

    } catch (error) {
      console.error('Payment processing error:', error);
      Swal.fire({
        icon: 'error',
        title: 'Payment Failed',
        text: error.message || 'There was an error processing your payment. Please try again.',
        confirmButtonText: 'OK'
      });
    }
  }

  // function initSignaturePad() {
  //   const canvas = document.getElementById("signature-pad");
  //   const ctx = canvas.getContext("2d");
  //   let isDrawing = false;

  //   canvas.width = canvas.offsetWidth;
  //   canvas.height = canvas.offsetHeight;

  //   canvas.addEventListener("mousedown", startDrawing);
  //   canvas.addEventListener("mousemove", draw);
  //   canvas.addEventListener("mouseup", stopDrawing);
  //   canvas.addEventListener("touchstart", startDrawing, { passive: false });
  //   canvas.addEventListener("touchmove", draw, { passive: false });
  //   canvas.addEventListener("touchend", stopDrawing);

  //   function getPosition(e) {
  //     if (e.touches) {
  //       return {
  //         x: e.touches[0].clientX - canvas.getBoundingClientRect().left,
  //         y: e.touches[0].clientY - canvas.getBoundingClientRect().top
  //       };
  //     }
  //     return { x: e.offsetX, y: e.offsetY };
  //   }

  //   function startDrawing(e) {
  //     e.preventDefault();
  //     isDrawing = true;
  //     const pos = getPosition(e);
  //     ctx.beginPath();
  //     ctx.moveTo(pos.x, pos.y);
  //     ctx.lineWidth = 2;
  //     ctx.strokeStyle = "#000";
  //     ctx.lineCap = "round";
  //   }

  //   function draw(e) {
  //     if (!isDrawing) return;
  //     e.preventDefault();
  //     const pos = getPosition(e);
  //     ctx.lineTo(pos.x, pos.y);
  //     ctx.stroke();
  //   }

  //   function stopDrawing(e) {
  //     e.preventDefault();
  //     isDrawing = false;
  //   }

  //   window.clearSignature = function () {
  //     ctx.clearRect(0, 0, canvas.width, canvas.height);
  //   };
  // }



</script>
