 <!-- main -->
 <main class="">
   <div class="d-block d-md-none">
     <div class="d-flex justify-content-end mt-3">
            <button
              class="btn btn-sm btn-save d-block d-md-none"
              data-bs-toggle="offcanvas"
              data-bs-target="#offcanvasExample"
              aria-controls="offcanvasExample"
            >
         Chats
       </button>
     </div>

          <div
            class="offcanvas offcanvas-start"
            tabindex="-1"
            id="offcanvasExample"
            aria-labelledby="offcanvasExampleLabel"
          >
       <div class="offcanvas-header">
         <h5 class="offcanvas-title" id="offcanvasExampleLabel">Chats</h5>
              <button
                type="button"
                class="btn-close"
                data-bs-dismiss="offcanvas"
                aria-label="Close"
              ></button>
       </div>
       <div class="offcanvas-body">
              <form
                class="d-flex position-relative mt-md-0 align-items-center"
                role="search"
              >
                <input
                  class="form-control me-2 search pe-4 bg-white"
                  type="search"
                  placeholder="Search"
                  aria-label="Search"
                  style="width: 350px"
                />
                <img
                  src="../assets/images/icons/searchicon.png"
                  alt=""
                  width="15px"
                  height="15px"
                  class="searchIcon"
                />
         </form>
         <div class="overCard position-relative h500 p-3">

         </div>
       </div>
     </div>
   </div>
   <div class="chat-web">
     <div class="sidebar px-2 d-none d-md-block border border-left-2">
       <!-- Contacts / Chat List -->
       <div class="chat-list-header py-2  d-flex gap-2">

                <form
                class="d-flex position-relative mt-md-0 align-items-center w-100"
                role="search"
              >
                <input
                  class="form-control search pe-4 bg-white"
                  type="search"
                  placeholder="Search"
                  aria-label="Search"
                />
                <img
                  src="../assets/images/icons/searchicon.png"
                  alt=""
                  width="15px"
                  height="15px"
                  class="searchIcon"
                />
         </form>




       </div>
            <div class="chat-list ps-3">
         <!-- Example chat item -->

       </div>
     </div>

     <div class="chat-area">
       <!-- Header -->
       <div class="chat-header p-1 border border-bottom-2">
         <div class="d-flex align-items-center gap-2">
                <img
                  class="chatImage"
                  src="../assets/images/th.jpeg"
                  alt=""
                />
           <p class="mb-0 ff1"></p>
           <p class="mb-0 ff2"></p>
         </div>
       </div>

       <!-- Messages -->
       <div class="chat-messages">
         <div class="row justify-content-end my-2">
           <div class="col-md-8 recieverChat align-self-start">

           </div>
         </div>
         <!-- reciver chat -->
         <div class="row justify-content-end my-2">
           <div class="col-md-8 recieverChat align-self-start">

           </div>
         </div>

         <!-- sender  chat -->
         <div class="row justify-content-start my-2">
           <div class="col-md-8 recieverChat align-self-start">

           </div>
         </div>
         <div class="row justify-content-start my-2">
           <div class="col-md-8 recieverChat align-self-start">

           </div>
         </div>
       </div>

       <!-- Input -->
       <div class="chat-input">
         <div class="writeMessage">
           <div class="row">
             <div class="col-md-12">
               <div class="d-flex gap-2">
                      <input
                        class="form-control formInput"
                        type="text"
                        name=""
                        id=""
                        placeholder="Write Message"
                      />
                 <button class="btn SendMessgeBTn ms-2">
                   <i class="fa-solid fa-paper-plane text-white"></i>
                 </button>

                 <div class="dropdown">
  <button
    class="btn btn-round w-fit "
    type="button"
    id="sendMessageDropdown"
    data-bs-toggle="dropdown"
    aria-expanded="false"
  >
                     +
                   </button>
                   <ul class="dropdown-menu" aria-labelledby="sendMessageDropdown">
                     <li>
                       <p class="dropdown-item d-item mb-0 m1 text-muted">Send message To</p>
                     </li>
                     <hr class="mt-0">
                     <li><a class="dropdown-item d-item" href="#" id="startAttorneyChat" role="button">Criminal Defense
                         Attorney</a></li>
                     <li><a class="dropdown-item d-item" href="#" id="startImmigrationAttorneyChat"
                         role="button">Immigration Attorney</a></li>
                     <li><a class="dropdown-item d-item" href="#" id="startEmergencyChat" role="button">My Emergency
                         Contact</a></li>
                     <li><a class="dropdown-item d-item" href="#" id="EmergencyContact" role="button">Emergency
                         Contact</a></li>
                   </ul>
                 </div>
               </div>
             </div>
           </div>
         </div>
       </div>
       <div class="modal fade" id="emergencyModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
          <div class="modal-content p-3">
            <div id="emergencyContactList"></div>
            <div id="friendsList"></div>

          </div>
        </div>
      </div>

     </div>
   </div>
 </main>
 

<script>
  document.addEventListener('DOMContentLoaded', async () => {

    const db = firebase.firestore();
    const auth = firebase.auth();
    let currentUser = null;
    let currentChatId = null;
    let unsubscribeChats = null;
    let unsubscribeMessages = null;
    let currentChatType = null;
    let designatedContacts = {
      attorney: null,
      immigrationAttorney: null,
      emergency: null
    };
    function updateNotificationBadge(count) {
    const badge = document.querySelector('#messageNotificationBadge');
    if (!badge) return;

    if (count > 0) {
      badge.style.display = 'inline-block';
      badge.textContent = count;
    } else {
      badge.style.display = 'none';
    }
  }

  function trackUnreadMessages() {
    db.collection('Chats')
      .where(`participants.${currentUser.uid}`, '==', true)
      .onSnapshot(async (snapshot) => {
        let unreadCount = 0;

        for (const doc of snapshot.docs) {
          const chatData = doc.data();
          const lastMessage = chatData.lastMessage;

          if (!lastMessage?.isRead && lastMessage.toID === currentUser.uid) {
            unreadCount++;

            // prevent repeated notifications
            if (lastMessage.timestamp > (window.lastMessageNotifiedAt || 0)) {
              showToastNotification(`Message from ${lastMessage.fromName}`, lastMessage.content);
              window.lastMessageNotifiedAt = lastMessage.timestamp;
            }
          }
        }

        updateNotificationBadge(unreadCount); // Already part of your script
      });
  }
   let chatListLoading = false;
  // Start chat with attorney
  document.querySelector('#startAttorneyChat')?.addEventListener('click', () => {
    startNewChat('attorney');
  });

  // Start chat with immigration attorney
  document.querySelector('#startImmigrationAttorneyChat')?.addEventListener('click', () => {
    startNewChat('immigrationAttorney');
  });

  // Start chat with emergency contact
  document.querySelector('#startEmergencyChat')?.addEventListener('click', () => {
    startNewChat('emergency');
  });

  document.querySelector('#EmergencyContact')
  ?.addEventListener('click', openEmergencyMenu);


  // Initialize chat when user is authenticated
  auth.onAuthStateChanged(async (user) => {
    if (!user) return;
    
    currentUser = user;
   await loadDesignatedContacts();
    // await initChat();
      const receiverIdFromURL = new URLSearchParams(window.location.search).get("receiverId");
  if (receiverIdFromURL) {
    await startDirectChat(receiverIdFromURL);
     await initChat(); // <-- add this back
  } else {
    await initChat(); // fallback to default list
  }
  //  trackUnreadMessages(); // 👈 Add this line if missing
  });
 async function loadDesignatedContacts() {
    const userDoc = await db.collection('Users').doc(currentUser.uid).get();
    const userData = userDoc.data();
    designatedContacts.attorney = userData.designatedLawyerId;
    designatedContacts.immigrationAttorney = userData.designatedImmigrationLawyerId;
    designatedContacts.emergency = userData.designatedEmgContact;
  }

  async function startDirectChat(receiverId) {
    // Check if chat exists
    const existingChat = await db.collection('Chats')
      .where(`participants.${currentUser.uid}`, '==', true)
      .where(`participants.${receiverId}`, '==', true)
      .limit(1)
      .get();

    if (!existingChat.empty) {
      const otherUserDoc = await db.collection('Users').doc(receiverId).get();
      await openChat(existingChat.docs[0].id, otherUserDoc.data());
      return;
    }

    // Create new chat if doesn't exist
    const otherUserDoc = await db.collection('Users').doc(receiverId).get();
    const otherUser = otherUserDoc.data();

    const newChat = {
      participants: {
        [currentUser.uid]: true,
        [receiverId]: true
      },
      lastMessage: {

      }
    };

    const chatRef = await db.collection('Chats').add(newChat);
    await chatRef.collection('Conversations').add(newChat.lastMessage);

    await openChat(chatRef.id, otherUser);
  }

  async function initChat() {
      loadChatList();
      
      
        // Send message button
        document.querySelector('.SendMessgeBTn').addEventListener('click', async () => {
          if (!isSending) {
            await sendMessage();
          }
        });

        // Enter key
        document.querySelector('.formInput').addEventListener('keypress', async (e) => {
          if (e.key === 'Enter') {
            e.preventDefault();
            if (!isSending) {
              await sendMessage();
            }
          }
        });
  
          document.querySelectorAll('.d-item').forEach(item => {
        item.addEventListener('click', async (e) => {
          e.preventDefault();
          const text = e.target.textContent.trim().toLowerCase();
          let type = null;
          if (text.includes('immigration attorney')) {
            type = 'immigrationAttorney';
          } else if (text.includes('attorney')) {
            type = 'attorney';
          } else if (text.includes('emergency')) {
            type = 'emergency';
          }
          if (type && currentChatType !== type) {
            currentChatType = type;
            await loadChatList();
          }
        });
      });
    }
 
  async function loadChatList() {
    if (chatListLoading) return;
    chatListLoading = true;

    // Unsubscribe previous listener to prevent duplicates
    if (unsubscribeChats) {
      unsubscribeChats();
      unsubscribeChats = null;
    }

    const desktopChatList = document.querySelector('.chat-list');
    const mobileChatList = document.querySelector('.overCard');

    // Clear only if we're changing types
    desktopChatList.innerHTML = '<div class="text-center py-3">Loading chats...</div>';
    mobileChatList.innerHTML = '<div class="text-center py-3">Loading chats...</div>';

    let query = db.collection('Chats')
      .where(`participants.${currentUser.uid}`, '==', true);

    // If we have a specific type, filter for that contact
    if (currentChatType && designatedContacts[currentChatType]) {
      query = query.where(`participants.${designatedContacts[currentChatType]}`, '==', true);
    }

    unsubscribeChats = query.onSnapshot(async (snapshot) => {
      chatListLoading = false;
      
      const desktopChatList = document.querySelector('.chat-list');
      const mobileChatList = document.querySelector('.overCard');

      // Clear existing chats
      desktopChatList.innerHTML = '';
      mobileChatList.innerHTML = '';

      if (snapshot.empty) {
        const noChatsMsg = currentChatType 
          ? `No ${currentChatType} chats found` 
          : 'No chats yet';
        
        desktopChatList.innerHTML = `<div class="text-center py-3">${noChatsMsg}</div>`;
        mobileChatList.innerHTML = `<div class="text-center py-3">${noChatsMsg}</div>`;
        return;
      }

      const chats = [];
      const otherUserIds = new Set();

      for (const doc of snapshot.docs) {
        const chat = doc.data();
        const otherUserId = Object.keys(chat.participants).find(id => id !== currentUser.uid);

        // Prevent duplicates
        if (otherUserIds.has(otherUserId)) continue;
        otherUserIds.add(otherUserId);

        const otherUserDoc = await db.collection('Users').doc(otherUserId).get();
        if (!otherUserDoc.exists) continue;

        const otherUser = otherUserDoc.data();
        chats.push({
          id: doc.id,
          otherUser,
          lastMessage: chat.lastMessage
        });
      }

      // Sort chats by last message timestamp
      chats.sort((a, b) => (b.lastMessage?.timestamp || 0) - (a.lastMessage?.timestamp || 0));

     chats.forEach((chat, index) => {
        // autoSelect is true for the first chat (most recent)
        const autoSelect = index === 0 && !currentChatId;
        
        const desktopChatPreview = createChatPreview(chat.id, chat.otherUser, chat.lastMessage, false, autoSelect);
        const mobileChatPreview = createChatPreview(chat.id, chat.otherUser, chat.lastMessage, true, autoSelect);

        desktopChatList.appendChild(desktopChatPreview);
        mobileChatList.appendChild(mobileChatPreview);

        // Set currentChatId if auto-selected
        if (autoSelect) currentChatId = chat.id;
      });


      // Remove previous active highlights
      document.querySelectorAll('.chat').forEach(c => c.classList.remove('activChat'));

      // Highlight the current chat (if any)
      if (currentChatId) {
        const desktopCurrent = desktopChatList.querySelector(`.chat[data-chat-id="${currentChatId}"]`);
        const mobileCurrent = mobileChatList.querySelector(`.chat[data-chat-id="${currentChatId}"]`);
        if (desktopCurrent) desktopCurrent.classList.add('activChat');
        if (mobileCurrent) mobileCurrent.classList.add('activChat');
      }

      // If we're filtering by type and only have one chat, open it automatically
      if (currentChatType && chats.length === 1 && currentChatId !== chats[0].id) {
        await openChat(chats[0].id, chats[0].otherUser);
      }
    }, error => {
      console.error("Chat list error:", error);
      chatListLoading = false;
    });
  }
  // function createChatPreview(chatId, otherUser, lastMessage, isMobile, autoSelect = false) {
  //   const chatPreview = document.createElement('a');
  //   chatPreview.href = '#';
    
  //   // Add activChat if unread or if we want to auto-select this chat
  //   const isUnread = lastMessage && !lastMessage.isRead;
  //   chatPreview.className = `chat d-flex my-2 ${isUnread || autoSelect ? 'activChat' : ''}`;

  //   const userImage = otherUser.imageUrl || '../assets/images/th.jpeg';
  //   const userTitle = otherUser.title || 
  //     (otherUser.userType === 'attorney' ? 'Attorney' : 'Emergency Contact');

  //   chatPreview.innerHTML = `
  //     <img class="chatImage" src="${userImage}" alt="${otherUser.Name || 'User'}">
  //     <div class="ms-2">
  //       <p class="fs16 m-0">${otherUser.Name || 'Unknown User'}</p>
  //       <p class="fs10 m-0 lstmesage">${lastMessage?.content || ""}</p>

  //     </div>
  //   `;

  //   chatPreview.addEventListener('click', async (e) => {
  //     e.preventDefault();
  //     await openChat(chatId, otherUser);

  //       // Update highlights
  //     document.querySelectorAll('.chat').forEach(c => c.classList.remove('activChat'));
  //     chatPreview.classList.add('activChat');

  //       // Find and highlight corresponding chat in other list
  //     const otherList = isMobile ? '.chat-list' : '.overCard';
  //     const correspondingChat = document.querySelector(`${otherList} .chat[data-chat-id="${chatId}"]`);
  //     if (correspondingChat) correspondingChat.classList.add('activChat');
  //   });

  //   chatPreview.setAttribute('data-chat-id', chatId);

  //   // Auto-click if this is the default chat
  //   if (autoSelect) {
  //     setTimeout(() => chatPreview.click(), 50);
  //   }

  //   return chatPreview;
  // }

  let hasAutoSelectedChat = false; // 🔥 only once auto-select

function createChatPreview(chatId, otherUser, lastMessage, isMobile, autoSelect = false) {
  const chatPreview = document.createElement('a');
  chatPreview.href = '#';

  const isUnread = lastMessage && !lastMessage.isRead;
  chatPreview.className = `chat d-flex my-2 ${isUnread ? 'activChat' : ''}`;

  const userImage = otherUser.imageUrl || '../assets/images/th.jpeg';

  chatPreview.innerHTML = `
    <img class="chatImage" src="${userImage}" alt="${otherUser.Name || 'User'}">
    <div class="ms-2">
      <p class="fs16 m-0">${otherUser.Name || 'Unknown User'}</p>
      <p class="fs10 m-0 lstmesage">${lastMessage?.content || ""}</p>
    </div>
  `;

  chatPreview.setAttribute('data-chat-id', chatId);

  // Click handler
  chatPreview.addEventListener('click', async (e) => {
    e.preventDefault();
    await openChat(chatId, otherUser);

    // Remove old active
    document.querySelectorAll('.chat').forEach(c => c.classList.remove('activChat'));
    // chatPreview.classList.add('activChat');

    // Mirror highlight to opposite list
    const otherList = isMobile ? '.chat-list' : '.overCard';
    const matching = document.querySelector(`${otherList} .chat[data-chat-id="${chatId}"]`);
    if (matching) matching.classList.add('activChat');
  });

  // ✅ Auto-select only ONCE — not again
  // if (autoSelect && !hasAutoSelectedChat) {
  //   hasAutoSelectedChat = true;
  //   setTimeout(() => chatPreview.click(), 50);
  // }

  return chatPreview;
}


  async function openChat(chatId, otherUser) {
    currentChatId = chatId;
    const chatMessages = document.querySelector('.chat-messages');
    
    // Update chat header
    document.querySelector('.chat-header p.ff1').textContent = otherUser.Name || 'Unknown User';
    document.querySelector('.chat-header img.chatImage').src = otherUser.imageUrl || '../assets/images/th.jpeg';
    
    // Mark messages as read
    await db.collection('Chats').doc(chatId).update({
      'lastMessage.isRead': true
    });
    
    // Clear existing messages
    chatMessages.innerHTML = '<div class="text-center py-3">Loading messages...</div>';
    
    // Unsubscribe from previous message listener if exists
    if (unsubscribeMessages) unsubscribeMessages();
    
    // Batch fetch all user profiles in the chat
    const chatDoc = await db.collection('Chats').doc(chatId).get();
    const participantIds = Object.keys(chatDoc.data().participants);
    const userPromises = participantIds.map(id => db.collection('Users').doc(id).get());
    const userSnapshots = await Promise.all(userPromises);
    const users = userSnapshots.reduce((acc, snap) => {
      if (snap.exists) acc[snap.id] = snap.data();
      return acc;
    }, {});
    
    // Subscribe to messages
    unsubscribeMessages = db.collection('Chats').doc(chatId)
      .collection('Conversations')
      .orderBy('timestamp', 'asc')
      .onSnapshot((snapshot) => {
        chatMessages.innerHTML = '';
        
        snapshot.forEach(doc => {
          const message = doc.data();
          displayMessage(message, users[message.fromID]);
        });
        
        // Scroll to bottom after all messages are rendered
        setTimeout(() => {
          chatMessages.scrollTop = chatMessages.scrollHeight;
        }, 100);
      });
    // Close emergency modal if open
    const modalEl = document.getElementById('emergencyModal');
    const modalInstance = bootstrap.Modal.getInstance(modalEl);
    if (modalInstance) {
        modalInstance.hide();
    }

    // Remove backdrop (Bootstrap sometimes leaves it)
    document.querySelectorAll('.modal-backdrop').forEach(b => b.remove());
    document.body.classList.remove('modal-open');
    document.body.style.removeProperty('padding-right');

    // Close mobile offcanvas if open
    const offcanvas = bootstrap.Offcanvas.getInstance(document.getElementById('offcanvasExample'));
    if (offcanvas) offcanvas.hide();
    await initChat();  // refresh chat list

  }

  function displayMessage(message, sender) {
    
    const chatMessages = document.querySelector('.chat-messages');
    const isSent = message.fromID === currentUser.uid;
    
    const messageDiv = document.createElement('div');
    messageDiv.className = `row justify-content-${isSent ? 'end' : 'start'} my-2`;
    
    // Use cached user data instead of fetching for each message
    const senderImage = sender?.imageUrl || '../assets/images/th.jpeg';
    const senderName = isSent ? 'You' : sender?.Name || 'Unknown';
    
    messageDiv.innerHTML = `
      <div class="col-md-8 recieverChat align-self-start">
        <div class="d-flex ${isSent ? 'justify-content-end' : ''}">
          ${!isSent ? `<img class="messImage me-1" src="${senderImage}" alt="Profile Image">` : ''}
          <div class="message">
            <div class="messageBox${isSent ? '' : 'Sender'} p-2">
              <p class="m1">${message.content}</p>
            </div>
            <div class="d-flex justify-content-between">
              <p class="m2">${formatTime(message.timestamp)}</p>
              <p class="m2">${senderName}</p>
            </div>
          </div>
          ${isSent ? `<img class="messImage ms-1" src="${senderImage}" alt="Your Profile">` : ''}
        </div>
      </div>
    `;
    
    chatMessages.appendChild(messageDiv);
  }

 
  //  async function sendMessage() {
  //   const input = document.querySelector('.formInput');
  //   const content = input.value.trim();
  //   if (!content || !currentChatId) return;

  //   try {
  //     // Get current user data
  //     const currentUserDoc = await db.collection('Users').doc(currentUser.uid).get();
  //     const currentUserData = currentUserDoc.data();

  //     // Get chat data
  //     const chatDoc = await db.collection('Chats').doc(currentChatId).get();
  //     const chatData = chatDoc.data();

  //     // Prepare new message
  //     const newMessage = {
  //       content,
  //       fromID: currentUser.uid,
  //       fromName: currentUserData.Name || 'You',
  //       toID: Object.keys(chatData.participants).find(id => id !== currentUser.uid),
  //       isRead: false,
  //       messageId: generateId(),
  //       timestamp: Date.now(),
  //       type: 'text'
  //     };

  //     // Add message to conversations
  //     await db.collection('Chats').doc(currentChatId)
  //       .collection('Conversations')
  //       .add(newMessage);

  //     // Update last message without triggering full refresh
  //     await db.collection('Chats').doc(currentChatId).update({
  //       'lastMessage': newMessage
  //     });

  //     input.value = '';
      
  //     // Scroll to bottom
  //     const chatMessages = document.querySelector('.chat-messages');
  //     setTimeout(() => {
  //       chatMessages.scrollTop = chatMessages.scrollHeight;
  //     }, 100);
  //   } catch (error) {
  //     console.error('Error sending message:', error);
  //     Swal.fire('Error', 'Failed to send message', 'error');
  //   }
  // }

  let isSending = false;

  async function sendMessage() {
    if (isSending) return;
    isSending = true;

    try {
      const input = document.querySelector('.formInput');
      const content = input.value.trim();
      if (!content || !currentChatId) return;

      const currentUserDoc = await db.collection('Users').doc(currentUser.uid).get();
      const currentUserData = currentUserDoc.data();

      // Get chat data
      const chatDoc = await db.collection('Chats').doc(currentChatId).get();
      const chatData = chatDoc.data();

      // Prepare new message
      const newMessage = {
        content,
        fromID: currentUser.uid,
        fromName: currentUserData.Name || 'You',
        toID: Object.keys(chatData.participants).find(id => id !== currentUser.uid),
        isRead: false,
        messageId: generateId(),
        timestamp: Date.now(),
        type: 'text'
      };

      // Add message to conversations
      await db.collection('Chats').doc(currentChatId)
        .collection('Conversations')
        .add(newMessage);

      // Update last message without triggering full refresh
      await db.collection('Chats').doc(currentChatId).update({
        'lastMessage': newMessage
      });

      input.value = '';

      // Scroll to bottom
      const chatMessages = document.querySelector('.chat-messages');
      setTimeout(() => {
        chatMessages.scrollTop = chatMessages.scrollHeight;
      }, 100);
    } catch (error) {
      console.error('Error sending message:', error);
      Swal.fire('Error', 'Failed to send message', 'error');
    } finally {
      isSending = false; // Unlock after everything
    }
  }


  async function startNewChat(type) {
    if (!designatedContacts[type]) {
      const userDoc = await db.collection('Users').doc(currentUser.uid).get();
      const userData = userDoc.data();
      designatedContacts.attorney = userData.designatedLawyerId;
      designatedContacts.immigrationAttorney = userData.designatedImmigrationLawyerId;
      designatedContacts.emergency = userData.designatedEmgContact;
    }

    const otherUserId = designatedContacts[type];
    
    if (!otherUserId) {
      const errorMessage = type === 'attorney' 
        ? 'Please add an attorney in your profile settings' 
        : 'Please add an emergency contact in your profile settings';
      Swal.fire('Info', errorMessage, 'info');
      return;
    }
    
    // Check if chat already exists
    const existingChat = await db.collection('Chats')
      .where(`participants.${currentUser.uid}`, '==', true)
      .where(`participants.${otherUserId}`, '==', true)
      .limit(1)
      .get();
    
    if (!existingChat.empty) {
      const otherUserDoc = await db.collection('Users').doc(otherUserId).get();
      await openChat(existingChat.docs[0].id, otherUserDoc.data());
      return;
    }
    
    // Get other user's details
    const otherUserDoc = await db.collection('Users').doc(otherUserId).get();
    const otherUser = otherUserDoc.data();
    
    // Create new chat
    const newChat = {
      participants: {
        [currentUser.uid]: true,
        [otherUserId]: true
      },
      lastMessage: {
       
      }
    };
    
    const chatRef = await db.collection('Chats').add(newChat);
    await chatRef.collection('Conversations').add(newChat.lastMessage);
    
    await openChat(chatRef.id, otherUser);
  }

  // Helper functions
  function formatTime(timestamp) {
    const date = new Date(timestamp);
    return date.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit' });
  }

 async function openEmergencyMenu() {
  const userDoc = await db.collection("Users").doc(currentUser.uid).get();
  const userData = userDoc.data();

  const emergencyContactId = userData.designatedEmgContact;

  const friendsDiv = document.getElementById("friendsList");
  friendsDiv.innerHTML = "Loading...";

  // 👉 Load people who added me (userFriends)
  const userFriends = userData.userFriends ? Object.keys(userData.userFriends) : [];

  if (userFriends.length === 0) {
    friendsDiv.innerHTML = `<p>No friends added you yet.</p>`;
  } else {
    friendsDiv.innerHTML = "";

    for (let friendId of userFriends) {
      const fDoc = await db.collection("Users").doc(friendId).get();
      const fData = fDoc.data();

      console.log("fData",fData);
      console.log("friendId",friendId);
      

      friendsDiv.innerHTML += `
      <div class="d-flex justify-content-between align-items-start border rounded p-3 mb-2 flex-wrap bg-light">

        <!-- User Info -->
        <div class="me-3 mb-2">
          <strong>${fData.Name || "Unnamed User"}</strong><br>
          <small class="text-muted">${fData.email || ""}</small>
        </div>

        <!-- Buttons -->
        <div class="d-flex flex-column gap-2">
          <button class="btn btn-attorney btn-sm" onclick="startDirectChat('${friendId}')">
            Message User
          </button>
          <button class="btn btn-attorney btn-sm" onclick="contactFriendAttorney('${friendId}')">
            Message Attorney
          </button>
        </div>
      </div>
      `
    }
  }

  // Show popup
  const modal = new bootstrap.Modal(document.getElementById('emergencyModal'));
  modal.show();
  }


  async function contactFriendAttorney(friendId) {
    // get friend data
    const fDoc = await db.collection("Users").doc(friendId).get();
    const fData = fDoc.data();

    const attorneyId = fData.designatedLawyerId;
    const immigrationId = fData.designatedImmigrationLawyerId;

    if (!attorneyId && !immigrationId) {
      Swal.fire("No Attorney", "This user has no attorney assigned", "info");
      return;
    }

    // If they have both attorneys → ask user which one
    if (attorneyId && immigrationId) {
      Swal.fire({
        title: "Select Attorney",
        showCancelButton: true,
        confirmButtonText: "Criminal Defense",
        cancelButtonText: "Immigration",
      }).then((result) => {
        if (result.isConfirmed) {
          startDirectChat(attorneyId);
        } else {
          startDirectChat(immigrationId);
        }
      });

      return;
    }

    // Only one attorney exists
    const selectedId = attorneyId || immigrationId;
    startDirectChat(selectedId);
  }


 
  function generateId() {
  return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
    const r = Math.random() * 16 | 0, v = c == 'x' ? r : (r & 0x3 | 0x8);
    return v.toString(16);
  });
  }

  window.addEventListener('beforeunload', () => {
    if (unsubscribeChats) unsubscribeChats();
    if (unsubscribeMessages) unsubscribeMessages();
  });
// make them available to inline onclick handlers
window.startDirectChat = startDirectChat;
window.contactFriendAttorney = contactFriendAttorney;
window.openEmergencyMenu = openEmergencyMenu; // if you call it from HTML  
});




</script>

<style>
  .m1 {
    white-space: pre-wrap;
    word-break: break-word;
  }
  .chat-messages {
    overflow-anchor: none;
  }
  .chat-messages > div:last-child {
    overflow-anchor: auto;
    height: 1px;
  }
  .lstmesage{
     white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
  max-width: 150px; /* Adjust as needed */
  display: block;
  } 
  .btn-attorney {
    background-color: #0412CA !important;
    color: #fff !important;
    border: none !important;
  }
  .btn-attorney:hover {
    background-color: #021093 !important; /* slightly darker on hover */
    color: #fff !important;
  }
</style>