 <!-- main -->
   
      <!-- main -->
<main class="mb-5">
  <div class="container">
    <div class="my-5">
      <div class="row g-2" id="attorneyDetails">
        <!-- Content will be dynamically inserted here -->
        <div class="col-12 text-center py-5">
          <div class="spinner-border text-primary" role="status">
            <span class="visually-hidden">Loading...</span>
          </div>
          <p class="mt-3">Loading attorney details...</p>
        </div>
      </div>
    </div>
  </div>
</main>



<!-- <script>
document.addEventListener('DOMContentLoaded', () => {
  firebase.auth().onAuthStateChanged(async (user) => {
    const container = document.getElementById('attorneyDetails');

    if (!user) {
      container.innerHTML = `
        <div class="col-12 text-center py-5">
          <p class="text-danger">Please log in to view this page</p>
          <a href="/login" class="btn btn-primary">Login</a>
        </div>`;
      return;
    }

    const db = firebase.firestore();
    const urlParams = new URLSearchParams(window.location.search);
    const lawId = urlParams.get('lawId');

    if (!lawId) {
      container.innerHTML = `
        <div class="col-12 text-center py-5">
          <p class="text-danger">No attorney ID provided</p>
          <a href="<?= base_url('site/quotesUser') ?>" class="btn btn-primary">Go Back</a>
        </div>`;
      return;
    }

    try {
      // Fetch Law Firm
      const lawFirmSnap = await db.collection("LawFirm")
        .where("userId", "==", lawId)
        .limit(1)
        .get();

      let firmData = {};
      let firmImageUrl = "../assets/images/placeholder.png";
      if (!lawFirmSnap.empty) {
        firmData = lawFirmSnap.docs[0].data();
        firmImageUrl = firmData.imageUrl || firmImageUrl;
      }

      // Fetch attorney user
      const attorneyDoc = await db.collection("Users").doc(lawId).get();
      if (!attorneyDoc.exists) throw new Error("Attorney not found");

      const attorney = attorneyDoc.data();

      container.innerHTML = `
        <div class="col-md-3">
          <img class="img-fluid img-atr" src="${firmImageUrl}" alt="${attorney.Name || 'Attorney'}" />
        </div>
        <div class="col-md-9">
          <div>
            <div class="d-flex justify-content-between align-items-center">
              <div>
                <p class="fp-1">${attorney.Name || 'Attorney Name'}</p>
                <p class="fp-2">${attorney.title || 'Attorney'}</p>
              </div>
              <div>
                <a href="<?= base_url('site/chatUser') ?>?receiverId=${lawId}" class="btn btn-save start-chat-btn">
                  <i class="fa-regular fa-message"></i>
                </a>
              </div>
            </div>

            ${attorney.logoImage ? `
              <img class="logo-image" src="${attorney.logoImage}" alt="Firm Logo" />
            ` : ''}

            <div class="d-flex gap-3 align-items-center flex-wrap mt-3">
              <div class="d-flex gap-2 align-items-center">
                <img class="icon-image" src="../assets/images/ph.png" alt="Phone" />
                <p class="fp-5">${attorney.userPhone || 'Phone not available'}</p>
              </div>
              <div class="d-flex gap-2 align-items-center">
                <img class="icon-image" src="../assets/images/ml.png" alt="Email" />
                <p class="fp-5">${attorney.email || 'Email not available'}</p>
              </div>
              <div class="d-flex gap-2 align-items-center">
                <img class="icon-image" src="../assets/images/locn.png" alt="Location" />
                <p class="fp-5">${attorney.address || 'Address not available'}</p>
              </div>
            </div>

            ${firmData.bioPractice ? `
              <div class="mt-3">
                <p class="fp-6 mb-1"><strong>About:</strong></p>
                <p class="fp-5">${firmData.bioPractice}</p>
              </div>
            ` : ''}

            ${firmData.userlat && firmData.userlon ? `
              <div class="my-3">
                <iframe width="100%" height="300" frameborder="0" style="border:0"
                  src="https://www.google.com/maps?q=${firmData.userlat},${firmData.userlon}&hl=es;z=14&output=embed"
                  allowfullscreen>
                </iframe>
              </div>
            ` : ''}
          </div>
          <button class="btn btn-danger">Request</button>
        </div>
      `;
    } catch (error) {
      console.error("Error loading attorney:", error);
      container.innerHTML = `
        <div class="col-12 text-center py-5">
          <p class="text-danger">Error loading attorney details</p>
          <p class="text-muted">${error.message}</p>
          <a href="<?= base_url('site/quotesUser') ?>" class="btn btn-primary">Go Back</a>
        </div>`;
    }
  });
});
</script> -->
<script>
document.addEventListener('DOMContentLoaded', () => {
  firebase.auth().onAuthStateChanged(async (user) => {
    const container = document.getElementById('attorneyDetails');

    if (!user) {
      container.innerHTML = `
        <div class="col-12 text-center py-5">
          <p class="text-danger">Please log in to view this page</p>
          <a href="/login" class="btn btn-primary">Login</a>
        </div>`;
      return;
    }

    const db = firebase.firestore();
    const urlParams = new URLSearchParams(window.location.search);
    const lawId = urlParams.get('lawId');
    const quoteId = urlParams.get('quoteId'); // ✅ same as your other page

    if (!lawId) {
      container.innerHTML = `
        <div class="col-12 text-center py-5">
          <p class="text-danger">No attorney ID provided</p>
          <a href="<?= base_url('site/quotesUser') ?>" class="btn btn-primary">Go Back</a>
        </div>`;
      return;
    }

    let quoteData = null;
    try {
      // ✅ Fetch quoteData by ID
      if (quoteId) {
        const quoteSnap = await db.collection("QuoteAlert").doc(quoteId).get();
        if (quoteSnap.exists) {
          quoteData = { id: quoteSnap.id, ...quoteSnap.data() };
        }
      }

      // Fetch Law Firm
      const lawFirmSnap = await db.collection("LawFirm")
        .where("userId", "==", lawId)
        .limit(1)
        .get();

      let firmData = {};
      let firmImageUrl = "../assets/images/placeholder.png";
      if (!lawFirmSnap.empty) {
        firmData = lawFirmSnap.docs[0].data();
        firmImageUrl = firmData.imageUrl || firmImageUrl;
      }

      // Fetch attorney user
      const attorneyDoc = await db.collection("Users").doc(lawId).get();
      if (!attorneyDoc.exists) throw new Error("Attorney not found");

      const attorney = attorneyDoc.data();

      container.innerHTML = `
        <div class="col-md-3">
          <img class="img-fluid img-atr" src="${firmImageUrl}" alt="${attorney.Name || 'Attorney'}" />
        </div>
        <div class="col-md-9">
          <div>
            <div class="d-flex justify-content-between align-items-center">
              <div>
                <p class="fp-1">${attorney.Name || 'Attorney Name'}</p>
                <p class="fp-2">${attorney.title || 'Attorney'}</p>
              </div>
              <div>
                <a href="<?= base_url('site/chatUser') ?>?receiverId=${lawId}" class="btn btn-save start-chat-btn">
                  <i class="fa-regular fa-message"></i>
                </a>
              </div>
            </div>

            ${attorney.logoImage ? `
              <img class="logo-image" src="${attorney.logoImage}" alt="Firm Logo" />
            ` : ''}

            <div class="d-flex gap-3 align-items-center flex-wrap mt-3">
              <div class="d-flex gap-2 align-items-center">
                <img class="icon-image" src="../assets/images/ph.png" alt="Phone" />
                <p class="fp-5">${firmData.phone || 'Phone not available'}</p>
              </div>
              <div class="d-flex gap-2 align-items-center">
                <img class="icon-image" src="../assets/images/ml.png" alt="Email" />
                <p class="fp-5">${firmData.email || 'Email not available'}</p>
              </div>
              <div class="d-flex gap-2 align-items-center">
                <img class="icon-image" src="../assets/images/locn.png" alt="Location" />
                <p class="fp-5">${firmData.address || 'Address not available'}</p>
              </div>
            </div>

            ${firmData.bioPractice ? `
              <div class="mt-3">
                <p class="fp-6 mb-1"><strong>About:</strong></p>
                <p class="fp-5">${firmData.bioPractice}</p>
              </div>
            ` : ''}

            ${firmData.userlat && firmData.userlon ? `
              <div class="my-3">
                <iframe width="100%" height="300" frameborder="0" style="border:0"
                  src="https://www.google.com/maps?q=${firmData.userlat},${firmData.userlon}&hl=es;z=14&output=embed"
                  allowfullscreen>
                </iframe>
              </div>
            ` : ''}

           <div class="d-flex justify-content-end">
            <button id="requestQuoteBtn" class="btn btn-save btn-width mt-3 d-flex justify-content-center align-items-center">Request Quote</button>
           </div>
          </div>
        </div>
      `;

      // ✅ Request Quote handler
      document.getElementById("requestQuoteBtn").addEventListener("click", async () => {
        if (!quoteData?.id) {
          Swal.fire({
            icon: 'error',
            title: 'Quote not loaded',
            text: 'Cannot proceed without quote data.',
          });
          return;
        }

        try {
          Swal.fire({
            title: 'Submitting...',
            allowOutsideClick: false,
            didOpen: () => Swal.showLoading()
          });

          const { id, ...newQuoteData } = quoteData;
          newQuoteData.LawId = lawId;
          newQuoteData.createdDate = Date.now();

          await db.collection("QuoteAlert").add(newQuoteData);

          const redirectUrl = "<?= base_url('site/activityUser') ?>";
          let redirectTimer = setTimeout(() => {
            window.location.href = redirectUrl;
          }, 6000);

          Swal.fire({
            icon: 'success',
            title: 'Request for quote submitted!',
            confirmButtonText: 'OK',
            timer: 6000,
            timerProgressBar: true,
            willClose: () => clearTimeout(redirectTimer)
          }).then((result) => {
            if (result.isConfirmed) {
              // window.location.href = redirectUrl;
            }
          });

        } catch (err) {
          console.error("Error creating quote:", err);
          Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: 'Could not create a new quote. Please try again.',
          });
        }
      });

    } catch (error) {
      console.error("Error loading attorney:", error);
      container.innerHTML = `
        <div class="col-12 text-center py-5">
          <p class="text-danger">Error loading attorney details</p>
          <p class="text-muted">${error.message}</p>
          <a href="<?= base_url('site/quotesUser') ?>" class="btn btn-primary">Go Back</a>
        </div>`;
    }
  });
});
</script>

