<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>DuePro</title>
    <link rel="shortcut icon" type="image/x-icon" href="../assets/images/Fav.png" />
    <!-- bootstrap style link -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
    <!-- font-awesome cdn -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" />
    <!-- custom css -->
    <link rel="stylesheet" href="../assets/css/style.css" />

    <!-- Firebase Core (compat) -->
<script src="https://www.gstatic.com/firebasejs/9.6.1/firebase-app-compat.js"></script>
<!-- Firebase Auth (compat) -->
<script src="https://www.gstatic.com/firebasejs/9.6.1/firebase-auth-compat.js"></script>
<!-- Firebase Firestore (compat) -->
<script src="https://www.gstatic.com/firebasejs/9.6.1/firebase-firestore-compat.js"></script>
<!-- Firebase storage (compat) -->
<script src="https://www.gstatic.com/firebasejs/9.22.2/firebase-storage-compat.js"></script>
<!-- toastify -->
<!-- Toastify CSS -->
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">

<!-- Toastify JS -->
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
<!-- Open Graph meta tags -->
<meta property="og:title" content="DuePro" />
<meta property="og:description" content="DuePro empowers individuals and attorneys by simplifying legal alerts and emergency notifications." />
<meta property="og:url" content="https://duepro.com/" />
<meta property="og:type" content="website" />
<meta property="og:image" content="	https://duepro.com//assets/images/lg1.webp" />
<meta property="og:image:width" content="600" />
<meta property="og:image:height" content="600" />
</head>

<body class="">
    <div class="wrapper">
        <!-- navbar -->


        <nav class="navbar navbar-expand-lg">
            <div class="container-fluid z-2">
                <a class="navbar-brand" href="<?= base_url('site/emergency'); ?>">
                    <img src="../assets/images/logo.png" alt="" />
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="navbarSupportedContent">
                    <ul class="navbar-nav mb-2 mb-lg-0 ms-auto">



                        <!-- <?php
                            if($alertsEnabled == 'yes'){
                        ?>
                        <li class="nav-item">
                            <a href="<?= base_url('site/emergency'); ?>" class="nav-link">Alert</a>
                        </li>
                        <?php
                            }
                        ?> -->
 <li class="nav-item">
                            <a href="<?= base_url('site/emergency'); ?>" class="nav-link">Alert</a>
                        </li>
                      <li class="nav-item">
  <a href="<?= base_url('site/activityUser'); ?>" class="nav-link" data-i18n="activity"></a>
</li>
<li class="nav-item">
  <a href="<?= base_url('site/quotesUser'); ?>" class="nav-link" data-i18n="quotes"></a>
</li>
<li class="nav-item position-relative">
  <a href="<?= base_url('site/chatUser'); ?>" class="nav-link" data-i18n="messages"></a>
   <span id="messageNotificationBadge"
          style="position:absolute; top:0; right:0; background:#333ED4; color:white; border-radius:50%; font-size:10px; padding:2px 6px; display:none;">
    </span>
</li>
<li class="nav-item d-block my-auto">
  <a href="<?= base_url('site/activityLawer'); ?>" class="btn btn-sm btn-p mt-1 nav-link" style="padding-inline: 0.5rem !important" data-i18n="switch_to_quoting"></a>
</li>

                        <li class="nav-item mx-2 ms-md-4">
                            <!-- Profile Dropdown -->
                            <div class="dropdown">
                                <a class="d-flex align-items-center text-decoration-none" href="#" role="button" id="profileDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                                    <img src="../assets/images/th.jpeg" alt="Profile" class="rounded-circle me-2" width="40" height="40"  id="userImage1"/>
                                </a>

                                <ul class="dropdown-menu dropdown-menu-end p-3 shadow drop-d-m-w" aria-labelledby="profileDropdown" style="min-width: 250px">
                                    <!-- Image, Name, and Button -->
                                    <li class="d-flex align-items-center mb-2 flex-column">
                                        <img src="../assets/images/fp.png" alt="Profile" class="round-img me-2" width="40" height="40" id="userImage2"/>
                                        <div>
                                            <div class="f-p1 mb-0" id="username">John Doe</div>
                                        </div>
                                    </li>

                                    <!-- Dropdown Links -->

                                    <!-- <li>
                    <a
                      class="dropdown-item d-flex align-items-center justify-content-between"
                      href="./emergency.html"
                      >Alert
                      <img src="../assets/images/icons/icon-lef.png" alt=""
                    /></a>
                  </li>
                  <li>
                    <a
                      class="dropdown-item d-flex align-items-center justify-content-between"
                      href="./activity_user.html"
                      >Activity
                      <img src="../assets/images/icons/icon-lef.png" alt=""
                    /></a>
                  </li>

                  <li>
                    <a
                      class="dropdown-item d-flex align-items-center justify-content-between"
                      href="./quotes_user.html"
                      >Quotes
                      <img src="../assets/images/icons/icon-lef.png" alt=""
                    /></a>
                  </li>

                  <li>
                    <a
                      class="dropdown-item d-flex align-items-center justify-content-between"
                      href="./chat.html"
                      >Messages
                      <img src="../assets/images/icons/icon-lef.png" alt=""
                    /></a>
                  </li> -->
                                 <li><p class="fw-bold mb-0" data-i18n="settings"></p></li>
<li><a class="dropdown-item ..." href="<?= base_url('site/profileUser'); ?>" data-i18n="personal_info"></a></li>
<li><a class="dropdown-item ..." href="<?= base_url('site/addimmigration'); ?>" data-i18n="immigration_info"></a></li>
<li><a class="dropdown-item ..." href="<?= base_url('site/attornyContact'); ?>" data-i18n="attorney_contact"></a></li>
<li><a class="dropdown-item ..." href="<?= base_url('site/emergencyContact'); ?>" data-i18n="emergency_contact"></a></li>
<li><a class="dropdown-item ..." href="<?= base_url('site/emergencyUsers'); ?>" data-i18n="emergency_users"></a></li>
<li><a class="dropdown-item ..." href="<?= base_url('site/archive'); ?>" >Archived Alerts</a></li>
<li><a class="dropdown-item ..." href="<?= base_url('site/userNotifications'); ?>" data-i18n="notifications"></a></li>
<li><a class="dropdown-item ..." href="<?= base_url('site/langauge'); ?>" data-i18n="language"></a></li>
<li><a class="dropdown-item ..." href="<?= base_url('site/userSupport'); ?>" data-i18n="support"></a></li>
<li><a class="dropdown-item ..." href="<?= base_url('site/userSecurity'); ?>" data-i18n="login_security"></a></li>
<li><a class="dropdown-item ..." href="<?= base_url('site/addfrim'); ?>" data-i18n="add_law_firm"></a></li>

<li><button id="deleteAccountBtn" class="btn border-0 p-0 m-0">Delete Account</button>
</li>
<li><p class="fw-bold mb-0" data-i18n="legal"></p></li>
<li><a class="dropdown-item ..." href="https://app.termly.io/policy-viewer/policy.html?policyUUID=0ffbd8d6-df2a-4426-bcd0-8ee8904a61d7" data-i18n="privacy_policy"></a></li>
<li><a class="dropdown-item ..." href="https://app.termly.io/policy-viewer/policy.html?policyUUID=c4f4ed40-c862-4d76-a565-2993af9ee285" data-i18n="terms_of_service"></a></li>
<li><a class="dropdown-item ..." href="#" onclick="logoutUser()" data-i18n="logout"></a></li>


                                </ul>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>
        <!-- nav bar end -->
         <script src="https://unpkg.com/i18next@latest/i18next.min.js"></script>

          <script>
  function logoutUser() {
    Swal.fire({
      title: "Are you sure?",
      text: "You will be logged out.",
      icon: "warning",
      showCancelButton: true,
      confirmButtonText: "Yes, logout",
      cancelButtonText: "Cancel",
    }).then((result) => {
      if (result.isConfirmed) {
        firebase.auth().signOut().then(() => {
          // Clear sessionStorage
          sessionStorage.removeItem("user");

          Swal.fire({
            icon: "success",
            title: "Logged Out",
            text: "You have been successfully logged out.",
            timer: 2000,
            showConfirmButton: false
          }).then(() => {
            window.location.href = "<?= base_url('/'); ?>"; // Redirect to homepage or login
          });
        }).catch((error) => {
          Swal.fire({
            icon: "error",
            title: "Logout Failed",
            text: error.message
          });
        });
      }
    });
  }
  let inactivityTime = function () {
  let time;
  const maxInactivity = 60 * 60 * 1000; // 1 hour (60 minutes); 

  // Reset timer on any user activity
  function resetTimer() {
    clearTimeout(time);
    time = setTimeout(autoLogout, maxInactivity);
  }

  // Detect user actions
  window.onload = resetTimer;
  document.onmousemove = resetTimer;
  document.onkeypress = resetTimer;
  document.onclick = resetTimer;
  document.onscroll = resetTimer;

  // Auto logout
  function autoLogout() {
    firebase.auth().signOut().then(() => {
      sessionStorage.removeItem("user");
      Swal.fire({
        icon: "info",
        title: "Session Timed Out",
        text: "You’ve been logged out due to inactivity.",
        timer: 3000,
        showConfirmButton: false,
      }).then(() => {
        window.location.href = "/";
      });
    });
  }
};

// Start tracking inactivity
inactivityTime();

</script>
<script>
  // ✅ Correct Firebase Config  ---> real one
  //  const firebaseConfig = {
  //    apiKey: "AIzaSyCkDJWMAbK59HWDyHOb50Fajk-XpmonOZw",
  //    authDomain: "duepro-2cf60.firebaseapp.com",
  //    projectId: "duepro-2cf60",
  //    storageBucket: "duepro-2cf60.firebasestorage.app", // ✅ corrected
  //    messagingSenderId: "626020023304",
  //    appId: "1:626020023304:web:618ae729d21b9ec4daa5bd",
  //    measurementId: "G-D38W7PD70R"
  //  };
  // for testing
  const firebaseConfig = {
    apiKey: "AIzaSyDg1_W33W26alDtLkpmhHoGvVjZYOIJibo",
    authDomain: "freeme-6e63a.firebaseapp.com",
    projectId: "freeme-6e63a",
    storageBucket: "freeme-6e63a.firebasestorage.app",
    messagingSenderId: "721532160627",
    appId: "1:721532160627:web:8827f39f6a6d9211527806",
    measurementId: "G-F5H1XMFWMS"
  };

  firebase.initializeApp(firebaseConfig);
</script>

      <script>
  const user = JSON.parse(sessionStorage.getItem("user"));
  if (!user) {
  
    window.location.href = "<?= base_url('/') ?>"; // redirect to login
  }
</script>
 <!-- <script>
  firebase.auth().onAuthStateChanged(async (user) => {
  if (user) {
    const doc = await firebase.firestore().collection("Users").doc(user.uid).get();

    if (doc.exists) {
      const data = doc.data();
       console.log(data.isDeactive);
     
      if (data.isDeactive) {
        Swal.fire("Account Deactivated", "Your account has been deactivated. Please contact support.", "warning");
        await firebase.auth().signOut();
          window.location.href = "/duepro";
        return;
      }

      // continue to dashboard or homepage
     // Or your intended page
    }
  }
});

 </script> -->
 <!-- <script>
  firebase.auth().onAuthStateChanged(async (user) => {
    if (user) {
      const doc = await firebase.firestore().collection("Users").doc(user.uid).get();

      if (doc.exists) {
        const data = doc.data();
          console.log("user daa",data)
         const defaultImage = "<?= base_url('assets/images/th.jpeg') ?>";
const imageUrl = data.imageUrl ? data.imageUrl : defaultImage;

document.getElementById("userImage1").src = imageUrl;
document.getElementById("userImage2").src = imageUrl;
document.getElementById("username").textContent = data.Name || "U User";

        console.log(data.isDeactive);

        if (data.isDeactive) {
          Swal.fire({
            title: "Account Deactivated",
            text: "Your account has been deactivated. Please contact support.",
            icon: "warning",
            confirmButtonText: "OK",
            timer: 10000, // 10 seconds
            allowOutsideClick: false,
            allowEscapeKey: false,
            timerProgressBar: true,
          }).then(() => {
            window.location.href = "/duepro"; // redirect after alert
          });

          return;
        }

        // Continue to dashboard/home
      }
    }
  });
</script> -->
<script>
  firebase.auth().onAuthStateChanged(async (user) => {
    if (user) {
      const userRef = firebase.firestore().collection("Users").doc(user.uid);
      const doc = await userRef.get();

      if (doc.exists) {
        const data = doc.data();
        console.log("user data", data);
 const defaultImage = "<?= base_url('assets/images/th.jpeg') ?>";
const imageUrl = data.imageUrl ? data.imageUrl : defaultImage;

document.getElementById("userImage1").src = imageUrl;
document.getElementById("userImage2").src = imageUrl;
document.getElementById("username").textContent = data.Name || "U User";

        if (data.isDeactive) {
          Swal.fire({
            title: "Account Deactivated",
            text: "Your account has been deactivated. Do you want to reactivate it?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonText: "Yes, Reactivate",
            cancelButtonText: "No",
            allowOutsideClick: false,
            allowEscapeKey: false,
            timer: 15000,
            timerProgressBar: true,
          }).then(async (result) => {
            if (result.isConfirmed) {
              try {
                await userRef.update({ isDeactive: false });
                Swal.fire({
                  title: "Reactivated!",
                  text: "Your account has been reactivated. Redirecting...",
                  icon: "success",
                  timer: 3000,
                  showConfirmButton: false,
                }).then(() => {
                  window.location.reload();
                });
              } catch (err) {
                console.error("Reactivation failed:", err);
                Swal.fire("Error", "Could not reactivate account. Please try again.", "error");
              }
            } else {
              window.location.href = "<?= base_url('/') ?>";
            }
          });

          return;
        }

        // Proceed to dashboard
      }
    } else {
      window.location.href = "<?= base_url('/') ?>";
    }
  });
</script>
<script src="<?= base_url('assets/js/lang.js'); ?>"></script>
<script>
 const lang = localStorage.getItem('lang') || 'en';
  applyTranslations(lang);
</script>




<script>
  document.getElementById("deleteAccountBtn").addEventListener("click", async () => {
    const user = firebase.auth().currentUser;

    if (!user) {
      Swal.fire("Error", "No user is currently logged in.", "error");
      return;
    }

    const uid = user.uid;

    const confirmDelete = await Swal.fire({
      title: "Are you sure?",
      text: "This will permanently delete your account and all associated data.",
      icon: "warning",
      showCancelButton: true,
      confirmButtonText: "Yes, delete it",
      cancelButtonText: "Cancel",
    });

    if (!confirmDelete.isConfirmed) return;

    try {
      const response = await fetch("https://us-central1-duepro-2cf60.cloudfunctions.net/widgets/delete-user", {
        method: "DELETE",
        headers: {
          "Content-Type": "application/json"
        },
        body: JSON.stringify({ uid })
      });

      if (!response.ok) {
        const errorText = await response.text();
        throw new Error("Failed to delete account: " + errorText);
      }

      // Optionally delete from Firebase Auth as well
      // await user.delete();

      Swal.fire("Deleted!", "Your account has been successfully deleted.", "success").then(() => {
        window.location.href = "<?= base_url('login') ?>";
      });

    } catch (err) {
      console.error("Account deletion error:", err);
      Swal.fire("Error", err.message, "error");
    }
  });
</script>
<script>
  let cuUser = null;
  let lastNotifiedAt = Number(localStorage.getItem('lastNotifiedAt') || 0);
  const auth2 = firebase.auth();
  const db2 = firebase.firestore();
  let globalChatUnsubscribe = null;

  function updateNotificationBadge(count) {
    const badge = document.querySelector('#messageNotificationBadge');
    if (!badge) return;
    badge.style.display = count > 0 ? 'inline-block' : 'none';
    badge.textContent = count;
  }

  function showToastNotification(title, message) {
    Toastify({
      text: `${title}: ${message}`,
      duration: 4000,
      gravity: "top",
      position: "right",
      backgroundColor: "#333",
      close: true
    }).showToast();
  }

  function trackGlobalMessages() {
    if (!cuUser || globalChatUnsubscribe) return;

    globalChatUnsubscribe = db2.collection('Chats')
      .where(`participants.${cuUser.uid}`, '==', true)
      .onSnapshot(async (snapshot) => {
        let unreadCount = 0;

        for (const doc of snapshot.docs) {
          const chat = doc.data();
          const lastMsg = chat.lastMessage;

          if (!lastMsg?.isRead && lastMsg.toID === cuUser.uid) {
            unreadCount++;

            if (lastMsg.timestamp > lastNotifiedAt) {
              showToastNotification(`Message from ${lastMsg.fromName}`, lastMsg.content);
              lastNotifiedAt = lastMsg.timestamp;
              localStorage.setItem('lastNotifiedAt', lastNotifiedAt);
            }
          }
        }

        updateNotificationBadge(unreadCount);
      });
  }

  auth2.onAuthStateChanged((user) => {
    if (!user) return;
    cuUser = user;
    trackGlobalMessages();
  });
</script>

