  <!-- main -->
    <main class="">
        <div class="container-fluid ">
            <div class="my-5">
         <p class="f6" data-i18n="languages"></p>


                <!-- <button class="btn d-block m-auto mt-5 ripple-btn"><img src="../assets/images/buttton.png" alt=""
                        id="rippleeffect"></button> -->
                <div class="row justify-content-center align-items-center " style="height: 100%;">
                    <div class="col-md-6">
                        <form>
                            <div class="card p-3" >
                                <div class="d-flex justify-content-between align-items-center">
                                    <label for="lang-en" class="mb-0">English</label>
                                    <input type="radio" name="language" id="lang-en" class="form-check-input" />
                                </div>
                            </div>

                            <div class="card p-3 mt-2" >
                                <div class="d-flex justify-content-between align-items-center">
                                    <label for="lang-es" class="mb-0">Español</label>
                                    <input type="radio" name="language" id="lang-es" class="form-check-input" />
                                </div>
                            </div>

                            <div class="row justify-content-center">
                                <div class="col-md-6 mt-2">
                                  <button type="submit" class="btn btn-save w-100" data-i18n="save"></button>
 
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </main>

    <script>
  // Initialize Firebase
  firebase.initializeApp(firebaseConfig);
  const db = firebase.firestore();
  const auth = firebase.auth();

  const form = document.querySelector("form");
  const langInputs = document.querySelectorAll('input[name="language"]');

  auth.onAuthStateChanged(async (user) => {
    if (!user) {
      Swal.fire("Unauthorized", "Please log in to continue.", "warning");
      return;
    }

    const userRef = db.collection("Users").doc(user.uid);
    const userDoc = await userRef.get();

    let currentLang = userDoc.data()?.language || "en";

    // Set the correct radio button
    document.getElementById(`lang-${currentLang}`).checked = true;

    // 🔹 Handle form submission
    form.addEventListener("submit", async (e) => {
      e.preventDefault();
      const selectedLang = document.querySelector('input[name="language"]:checked')?.id.replace("lang-", "");

      try {
        await userRef.update({ language: selectedLang });
        applyTranslations(selectedLang)
      // When language is changed
localStorage.setItem('lang', selectedLang);

        Swal.fire("Success", "Language updated successfully.", "success");
      } catch (err) {
        console.error("Error updating language:", err);
        Swal.fire("Error", err.message, "error");
      }
    });
  });
</script>
