      <!-- main -->
      <main class="">
        <div class="container">
          <div class="my-5">
          <p class="fp-1 mb-0" data-i18n="notifications"></p>

          <div class="text-end mb-2">
  <button id="clear-notifications" class="btn btn-sm btn-danger">
    <i class="fa fa-trash"></i> Clear All
  </button>
</div>
             <div id="notifications-container" class="row my-2 g-3"></div>
<p id="no-notifications" class="text-center text-muted mt-4 alert alert-primary" style="display: none;" data-i18n="no_new_notifications"></p> 

          </div>
        </div>
      </main>

    <!-- <script>
  const db = firebase.firestore();

  firebase.auth().onAuthStateChanged((user) => {
    if (user) {
      const userId = user.uid;

      db.collection("Notification")
        .where("userId", "==", userId)
       
        .onSnapshot((snapshot) => {
          const container = document.getElementById("notifications-container");
          const noNotifications = document.getElementById("no-notifications");
          container.innerHTML = ""; // Clear previous content

          if (snapshot.empty) {
            noNotifications.style.display = "block";
            return;
          }

          noNotifications.style.display = "none";

          snapshot.forEach((doc) => {
            const data = doc.data();

            const card = `
              <div class="col-md-12">
                <div class="card m-card">
                  <div class="card-body">
                    <div class="d-flex align-items-center gap-2">
                      <img src="../assets/images/icons/bigbell.png" alt="" />
                      <div class="w-100">
                        <div class="d-flex justify-content-between align-items-center">
                          <p class="f8 mb-0">${data.title || "Notification"}</p>
                          <p class="f9 mb-0">${timeAgo(data.timestamp)}</p>
                        </div>
                        <p class="f10 mb-0">${data.message}</p>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            `;

            container.insertAdjacentHTML("beforeend", card);
          });
        });
    } else {
      // user not logged in
      console.log("User not logged in");
    }
  });

  // Helper function to convert timestamp to "1min ago" format
  function timeAgo(timestamp) {
    const now = Date.now();
    const diff = now - timestamp;
    const minutes = Math.floor(diff / 60000);
    if (minutes < 1) return "Just now";
    if (minutes < 60) return `${minutes}min ago`;
    const hours = Math.floor(minutes / 60);
    if (hours < 24) return `${hours}h ago`;
    const days = Math.floor(hours / 24);
    return `${days}d ago`;
  }
</script> -->

<script>
  const db = firebase.firestore();
  const container = document.getElementById("notifications-container");
  const noNotifications = document.getElementById("no-notifications");
  const clearBtn = document.getElementById("clear-notifications");

  firebase.auth().onAuthStateChanged((user) => {
    if (!user) return console.log("User not logged in");

    const userId = user.uid;
db.collection("Notification")
  .where("userId", "==", userId)
  .onSnapshot((snapshot) => {
    const sortedDocs = snapshot.docs.sort((a, b) => b.data().timestamp - a.data().timestamp); // client-side sort
      container.innerHTML = "";

        if (sortedDocs.empty) {
          noNotifications.style.display = "block";
          clearBtn.style.display = "none";
          return;
        }

        noNotifications.style.display = "none";
        clearBtn.style.display = "inline-block";

        sortedDocs.forEach((doc) => {
          const data = doc.data();

          const card = `
            <div class="col-md-12">
              <div class="card m-card">
                <div class="card-body">
                  <div class="d-flex align-items-center gap-2">
                    <img src="../assets/images/icons/bigbell.png" alt="" />
                    <div class="w-100">
                      <div class="d-flex justify-content-between align-items-center">
                        <p class="f8 mb-0">${data.title || "Notification"}</p>
                        <p class="f9 mb-0">${timeAgo(data.timestamp)}</p>
                      </div>
                      <p class="f10 mb-0">${data.message}</p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          `;

          container.insertAdjacentHTML("beforeend", card);
        });
  });


    // 🔴 Clear all notifications
    clearBtn.addEventListener("click", async () => {
      const confirm = await Swal.fire({
        title: "Are you sure?",
        text: "All your notifications will be permanently deleted.",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "Yes, clear all!",
        cancelButtonText: "Cancel"
      });

      if (confirm.isConfirmed) {
        try {
          const snap = await db.collection("Notification").where("userId", "==", userId).get();
          const batch = db.batch();
          snap.forEach((doc) => batch.delete(doc.ref));
          await batch.commit();

          Swal.fire("Cleared", "All notifications deleted.", "success");
        } catch (err) {
          console.error("Failed to clear:", err);
          Swal.fire("Error", "Failed to clear notifications.", "error");
        }
      }
    });
  });

  function timeAgo(timestamp) {
    const now = Date.now();
    const diff = now - timestamp;
    const minutes = Math.floor(diff / 60000);
    if (minutes < 1) return "Just now";
    if (minutes < 60) return `${minutes}min ago`;
    const hours = Math.floor(minutes / 60);
    if (hours < 24) return `${hours}h ago`;
    const days = Math.floor(hours / 24);
    return `${days}d ago`;
  }
</script>
