<style>
  .atr-img-p{
    width: 100% !important;
    height:270px !important;
  }
  .positionABS{
      position:absolute;
      bottom:0;
      right:0;
  }
  
  @media(max-width:768px){
    .btn-video{
      width: 100%;
    }
     .positionABS{
      position:static;
     
  }
  }
</style>
<main class="mb-5">
  <div class="container">
    <div class="my-5">
      <div class="d-flex justify-content-center">
        <!-- Nav tabs -->
       <ul
  class="nav nav-tabs n-tabs gap-2 justify-content-center w-fit"
  id="contentTabs"
  role="tablist"
>
  <li class="nav-item" role="presentation">
    <button
      class="nav-link active"
      id="articles-tab"
      data-bs-toggle="tab"
      data-bs-target="#articles"
      type="button"
      role="tab"
      aria-controls="articles"
      aria-selected="true"
      data-i18n="active_quotes"
    ></button>
  </li>
  <li class="nav-item" role="presentation">
    <button
      class="nav-link"
      id="videos-tab"
      data-bs-toggle="tab"
      data-bs-target="#videos"
      type="button"
      role="tab"
      aria-controls="videos"
      aria-selected="false"
      data-i18n="inactive_quotes"
    ></button>
  </li>
</ul>

      </div>

      <!-- Tab panes -->
      <div class="tab-content" id="contentTabsContent">
        <div
          class="tab-pane fade show active"
          id="articles"
          role="tabpanel"
          aria-labelledby="articles-tab"
        >
          <div class="row">
            <div class="col-md-12 my-2">
              <form class="d-flex position-relative mt-2 mt-md-0" role="search">
                <input
                  class="form-control me-2 search w-100 bg-white pe-4"
                  type="search"
                  placeholder="Search"
                  aria-label="Search"
                  style="width: 350px"
                />
                <img
                  src="<?= base_url('assets/images/icons/searchicon.png') ?>"
                  alt=""
                  width="15px"
                  height="15px"
                  class="searchIcon"
                />
              </form>
            </div>
          </div>
          <div class="row my-2">
           

            <div class="col-md-12 my-2">
             <button class="btn btnLoad d-block mx-auto btn-same" data-i18n="load_more"></button>
            </div>
          </div>
        </div>
        <div
          class="tab-pane fade"
          id="videos"
          role="tabpanel"
          aria-labelledby="videos-tab"
        >
          <div class="row">
            <div class="col-md-12 my-2">
              <form class="d-flex position-relative mt-2 mt-md-0" role="search">
                <input
                  class="form-control me-2 search w-100 bg-white pe-4"
                  type="search"
                  placeholder="Search"
                  aria-label="Search"
                  style="width: 350px"
                />
                <img
                  src="<?= base_url('assets/images/icons/searchicon.png') ?>"
                  alt=""
                  width="15px"
                  height="15px"
                  class="searchIcon"
                />
              </form>
            </div>
          </div>
          <div class="row my-2">
           

            <div class="col-md-12 my-2">
              <button class="btn btnLoad d-block mx-auto btn-same" data-i18n="load_more"></button>

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</main>
<!-- <script>
firebase.auth().onAuthStateChanged(async (user) => {
  if (!user) return;
  const db = firebase.firestore();
  const uid = user.uid;
console.log("uid",uid)
  const snapshot = await db.collection("QuoteAlert")
    .where("LawId", "==", uid)
    .get();

  const quotesWithUser = await Promise.all(snapshot.docs.map(async (doc) => {
    const data = doc.data();
    console.log(data.userId)
    const userDoc = await db.collection("Users").doc(data.userId).get();
    const userData = userDoc.exists ? userDoc.data() : {};

    // Fetch designated attorney name if designatedLawyerId exists
    let designatedLawyerName = "N/A";
    if (userData.designatedLawyerId) {
      const lawyerDoc = await db.collection("Users").doc(userData.designatedLawyerId).get();
      if (lawyerDoc.exists) {
        designatedLawyerName = lawyerDoc.data().Name || "N/A";
      }
    }

    return {
      id: doc.id,
      ...data,
      userName: userData.Name || "Unknown",
      userImage: userData.imageUrl || "<?= base_url('assets/images/th.jpeg') ?>",
      userDOB: userData.userDOB ? new Date(userData.userDOB).toLocaleDateString() : "N/A",
      designatedLawyerName,
      date: new Date(data.createdDate),
    };
  }));

  // const all = quotesWithUser.filter(q => q.qoutesPrice > 0);
  // const active = all.filter(q => q.isActive);
  // const inactive = all.filter(q => !q.isActive);
  const all = quotesWithUser
  .filter(q => q.qoutesPrice > 0)
  .sort((a, b) => new Date(b.createdDate) - new Date(a.createdDate)); // Newest first

const active = all.filter(q => q.isActive);
const inactive = all.filter(q => !q.isActive);
  let shownActive = 3, shownInactive = 3;

  function renderTab(quotes, containerRow, shownCount) {
    containerRow.innerHTML = "";
    const slice = quotes.slice(0, shownCount);
    slice.forEach(q => {
      const dateStr = q.date.toLocaleDateString(undefined, { month: 'long', day: '2-digit', year: 'numeric' });
      const timeStr = q.date.toLocaleTimeString();
      containerRow.insertAdjacentHTML("beforeend", `
        <div class="col-md-12 my-2">
          <div class="card stCard">
            <div class="card-body">
              <div class="row g-2">
                <div class="col-md-3">
                  <img class="atr-img-p" src="${q.userImage}" alt="User" />
                </div>
                <div class="col-md-9">
                 <div class="d-flex justify-content-end">
                    ${q.paidStatus == 0 
                      ? '<p class="badge badge-danger bg-danger">Pending</p>' 
                      : '<p class="badge badge-success bg-success">Hired</p>'}
                  </div>
                  <p class="fp2 mb-0">Quote for ${q.title}</p>
                  <p class="ft7">DOB: <strong>${q.userDOB}</strong></p>
                  <p class="ft7 my-1">Incident on ${dateStr} ${timeStr}</p>
                  <div class="d-flex align-items-center gap-4 flex-wrap">
                    <p class="ft7">Charge(s): <strong>${q.chargesOffence || 'N/A'}</strong></p>
                    <p class="ft7">Quote: <strong>$${q.qoutesPrice}</strong></p>
                    <p class="ft7">Deposit: <strong>$${q.qoutesDeposite}</strong></p>
                    <p class="ft7">Detained At: <strong>${q.detainedPlace || 'N/A'}</strong></p>
                    <p class="ft7">Attorney Alerted: <strong>${q.isAttorneyAlerted ? "Yes" : "No"}</strong></p>
                    <p class="ft7">Designated Attorney: <strong>${q.designatedLawyerName}</strong></p>
                  </div>
                  <div class="d-flex gap-2 mt-2 flex-wrap">
                    <button class="btn btn-save py-1 px-3 btn-arrest" data-name="${q.userName}">Arrest Details</button>
                    ${q.videoUrls?.length ? `<button class="btn btn-secondary btn-sm btn-video border-15 px-3" data-videos='${JSON.stringify(q.videoUrls)}'>View Videos</button>` : ''}
                     <button class="btn btn-danger btn-sm px-3 btn-delete" data-id="${q.id}">
    <i class="fa fa-trash"></i> Delete
  </button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      `);
    });
    if (shownCount < quotes.length) {
      containerRow.insertAdjacentHTML("beforeend", `
        <div class="col-md-12 my-2">
          <button class="btn btnLoad d-block mx-auto btn-same">Load More</button>
        </div>
      `);
    }
  }

  async function deleteQuote(quoteId) {
  const confirm = await Swal.fire({
    title: "Are you sure?",
    text: "This will permanently delete this quote.",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Yes, delete it!",
    cancelButtonText: "Cancel"
  });

  if (confirm.isConfirmed) {
    try {
      await firebase.firestore().collection("QuoteAlert").doc(quoteId).delete();
      Swal.fire("Deleted", "The quote has been deleted.", "success");

      // ✅ Reload full data and re-render
      await loadAndRenderQuotes();
    } catch (err) {
      console.error("Delete failed:", err);
      Swal.fire("Error", "Failed to delete the quote.", "error");
    }
  }
}


async function loadAndRenderQuotes() {
  const db = firebase.firestore();
  const user = firebase.auth().currentUser;
  if (!user) return;

  const uid = user.uid;
  const snapshot = await db.collection("QuoteAlert")
    .where("LawId", "==", uid)
    .get();

  const quotesWithUser = await Promise.all(snapshot.docs.map(async (doc) => {
    const data = doc.data();
    const userDoc = await db.collection("Users").doc(data.userId).get();
    const userData = userDoc.exists ? userDoc.data() : {};

    let designatedLawyerName = "N/A";
    if (userData.designatedLawyerId) {
      const lawyerDoc = await db.collection("Users").doc(userData.designatedLawyerId).get();
      if (lawyerDoc.exists) {
        designatedLawyerName = lawyerDoc.data().Name || "N/A";
      }
    }

    return {
      id: doc.id,
      ...data,
      userName: userData.Name || "Unknown",
      userImage: userData.imageUrl || "<?= base_url('assets/images/th.jpeg') ?>",
      userDOB: userData.userDOB ? new Date(userData.userDOB).toLocaleDateString() : "N/A",
      designatedLawyerName,
      date: new Date(data.createdDate),
    };
  }));

  const all = quotesWithUser
    .filter(q => q.qoutesPrice > 0)
    .sort((a, b) => new Date(b.createdDate) - new Date(a.createdDate));

  active = all.filter(q => q.isActive);
  inactive = all.filter(q => !q.isActive);
  shownActive = 3;
  shownInactive = 3;

  renderTab(active, activeRow, shownActive);
  renderTab(inactive, inactiveRow, shownInactive);
}
  const activeRow = document.querySelector("#articles .row.my-2");
  const inactiveRow = document.querySelector("#videos .row.my-2");
  const activeSearch = document.querySelector("#articles .search");
  const inactiveSearch = document.querySelector("#videos .search");

  renderTab(active, activeRow, shownActive);
  renderTab(inactive, inactiveRow, shownInactive);

  activeRow.addEventListener("click", e => {
    if (e.target.matches(".btnLoad")) renderTab(active, activeRow, shownActive += 3);
    if (e.target.matches(".btn-arrest")) fetchArrestDetails(e.target.dataset.name);
    if (e.target.matches(".btn-video")) showVideos(JSON.parse(e.target.dataset.videos));
    if (e.target.closest(".btn-delete")) {
  const id = e.target.closest(".btn-delete").dataset.id;
  deleteQuote(id);
}

  });

  inactiveRow.addEventListener("click", e => {
    if (e.target.matches(".btnLoad")) renderTab(inactive, inactiveRow, shownInactive += 3);
    if (e.target.matches(".btn-arrest")) fetchArrestDetails(e.target.dataset.name);
    if (e.target.matches(".btn-video")) showVideos(JSON.parse(e.target.dataset.videos));
    if (e.target.closest(".btn-delete")) {
  const id = e.target.closest(".btn-delete").dataset.id;
  deleteQuote(id);
}

  });

  function setupSearch(quotes, row, input) {
    input.addEventListener("input", () => {
      const term = input.value.trim().toLowerCase();
      const filtered = quotes.filter(q =>
        q.title.toLowerCase().includes(term) ||
        (q.chargesOffence && q.chargesOffence.toLowerCase().includes(term))
      );
      renderTab(filtered, row, filtered.length);
    });
  }

  setupSearch(active, activeRow, activeSearch);
  setupSearch(inactive, inactiveRow, inactiveSearch);


async function fetchArrestDetails(name) {
  console.log("Search name:", name);
  console.log("Encoded:", encodeURIComponent(name));

  try {
    const res = await fetch(
      `https://us-central1-duepro-2cf60.cloudfunctions.net/widgets/searchnew?name=${encodeURIComponent(name)}`,
      {
        method: 'GET',
        headers: { 'Content-Type': 'application/json' },
      }
    );

    const result = await res.json();

    if (result.success === 0 || !result.result) {
      return Swal.fire("No Record", result.msg || "No arrest record found.", "info");
    }

    const arrest = result.result;
    const arrestDate = arrest.arrestDate ? new Date(arrest.arrestDate).toLocaleString() : "N/A";

    Swal.fire({
      title: `Arrest Details`,
      html: `
        <p><strong>Name:</strong> ${arrest.fullName}</p>
        <p><strong>Gender:</strong> ${arrest.gender || 'N/A'}</p>
        <p><strong>Age:</strong> ${arrest.age || 'N/A'}</p>
        <p><strong>Address:</strong> ${arrest.address || 'N/A'}</p>
        <p><strong>City/State/Zip:</strong> ${arrest.cityStateZip || 'N/A'}</p>
        <p><strong>Offense:</strong> ${arrest.offense || 'N/A'}</p>
        <p><strong>Detention:</strong> ${arrest.detention || 'N/A'}</p>
        <p><strong>Arrest Date:</strong> ${arrestDate}</p>
      `,
      confirmButtonText: 'Close'
    });
  } catch (err) {
    console.error(err);
    Swal.fire("Error", "Failed to fetch arrest details.", "error");
  }
}


  function showVideos(videoUrls) {
    const embedHTML = videoUrls.map(url => `
      <video controls width="100%" class="my-2">
        <source src="${url}" type="video/webm" />
        Your browser does not support the video tag.
      </video>`).join("");
    Swal.fire({
      title: 'Recorded Videos',
      html: `<div style="max-height:400px;overflow-y:auto">${embedHTML}</div>`,
      width: 700
    });
  }
});


</script> -->

<script>
let active = [], inactive = [];
let shownActive = 3, shownInactive = 3;
let activeRow, inactiveRow, activeSearch, inactiveSearch;

firebase.auth().onAuthStateChanged(async (user) => {
  if (!user) return;
  const db = firebase.firestore();
  const uid = user.uid;

  activeRow = document.querySelector("#articles .row.my-2");
  inactiveRow = document.querySelector("#videos .row.my-2");
  activeSearch = document.querySelector("#articles .search");
  inactiveSearch = document.querySelector("#videos .search");

  await loadAndRenderQuotes();

  activeRow.addEventListener("click", e => {
    if (e.target.matches(".btnLoad")) renderTab(active, activeRow, shownActive += 3);
    if (e.target.matches(".btn-arrest")) fetchArrestDetails(e.target.dataset.name);
    if (e.target.matches(".btn-video")) showVideos(JSON.parse(e.target.dataset.videos));
    if (e.target.closest(".btn-delete")) {
      const id = e.target.closest(".btn-delete").dataset.id;
      deleteQuote(id);
    }
  });

  inactiveRow.addEventListener("click", e => {
    if (e.target.matches(".btnLoad")) renderTab(inactive, inactiveRow, shownInactive += 3);
    if (e.target.matches(".btn-arrest")) fetchArrestDetails(e.target.dataset.name,e.target.dataset.id);
    if (e.target.matches(".btn-video")) showVideos(JSON.parse(e.target.dataset.videos));
    if (e.target.closest(".btn-delete")) {
      const id = e.target.closest(".btn-delete").dataset.id;
      deleteQuote(id);
    }
  });

  setupSearch(active, activeRow, activeSearch);
  setupSearch(inactive, inactiveRow, inactiveSearch);
});

async function loadAndRenderQuotes() {
  const db = firebase.firestore();
  const user = firebase.auth().currentUser;
  if (!user) return;

  const uid = user.uid;
  const snapshot = await db.collection("QuoteAlert")
    .where("LawId", "==", uid).get();

  const quotesWithUser = await Promise.all(snapshot.docs.map(async (doc) => {
    const data = doc.data();
    const userDoc = await db.collection("Users").doc(data.userId).get();
    const userData = userDoc.exists ? userDoc.data() : {};

    let designatedLawyerName = "N/A";
    if (userData.designatedLawyerId) {
      const lawyerDoc = await db.collection("Users").doc(userData.designatedLawyerId).get();
      if (lawyerDoc.exists) {
        designatedLawyerName = lawyerDoc.data().Name || "N/A";
      }
    }

    return {
      id: doc.id,
      ...data,
      userName: userData.Name || "Unknown",
      userImage: userData.imageUrl || "<?= base_url('assets/images/th.jpeg') ?>",
      userDOB: userData.userDOB ? new Date(userData.userDOB).toLocaleDateString() : "N/A",
      designatedLawyerName,
      date: new Date(data.createdDate),
    };
  }));

  const all = quotesWithUser.filter(q => q.qoutesPrice > 0)
    .sort((a, b) => new Date(b.createdDate) - new Date(a.createdDate));

  active = all.filter(q => q.isActive);
  inactive = all.filter(q => !q.isActive);
  shownActive = 3;
  shownInactive = 3;

  renderTab(active, activeRow, shownActive);
  renderTab(inactive, inactiveRow, shownInactive);
}

function renderTab(quotes, containerRow, shownCount) {
  containerRow.innerHTML = "";
  const slice = quotes.slice(0, shownCount);
  slice.forEach(q => {
    const dateStr = q.date.toLocaleDateString(undefined, { month: 'long', day: '2-digit', year: 'numeric' });
    const timeStr = q.date.toLocaleTimeString();
    containerRow.insertAdjacentHTML("beforeend", `
      <div class="col-md-12 my-2">
        <div class="card stCard">
          <div class="card-body">
            <div class="row g-2">
              <div class="col-md-3">
                <img class="atr-img-p" src="${q.userImage}" alt="User" />
              </div>
              <div class="col-md-9 position-relative">
                <div class="d-flex justify-content-between align-items-center my-1">
                 <p class="fp2 mb-0">Quote for ${q.title}</p>
                  ${q.paidStatus == 0 ? '<p class="badge badge-danger bg-danger">Pending</p>' : '<p class="badge badge-success bg-success">Hired</p>'}
                </div>
               
                <p class="ft7 my-1">DOB: <strong>${q.userDOB}</strong></p>
                <p class="ft7 my-1">Incident on ${dateStr} ${timeStr}</p>
                <div class="d-flex align-items-center gap-4 flex-wrap my-1">
                 <p class="ft7 mb-0">Charge(s):
  <strong>
    ${
      Array.isArray(q.offense) && q.offense.length
        ? q.offense.map(o =>
            `${o.chargedesc || 'Unknown'} (${o.severity || '-'}) - ${o.warrantissuedagency || 'Unknown Agency'}`
          ).join('<br>')
        : 'N/A'
    }
  </strong>
</p>

                  <p class="ft7 mb-0">Quote: <strong>$${q.qoutesPrice}</strong></p>
                  <p class="ft7 mb-0">Deposit: <strong>$${q.qoutesDeposite}</strong></p>
                 
                </div>
                <div class="d-flex align-items-center gap-4 flex-wrap my-1">
                 <p class="ft7">Detained At: <strong>${q.detainedPlace || 'N/A'}</strong></p>
                  <p class="ft7">Attorney Alerted: <strong>${q.isAttorneyAlerted ? "Yes" : "No"}</strong></p>
                  <p class="ft7">Designated Attorney: <strong>${q.designatedLawyerName}</strong></p>
                </div>
                <div class="d-flex gap-2 mt-2 flex-wrap positionABS">
                  <button class="btn btn-save py-1 px-3 btn-arrest btn-width" data-name="${q.userName}" data-id="${q.id}">Arrest Details</button>
                  ${q.videoUrls?.length ? `<button class="btn btn-secondary btn-sm btn-video border-15 px-3 border-15 btn-width" data-videos='${JSON.stringify(q.videoUrls)}'>View Videos</button>` : ''}
                  <button class="btn btn-danger btn-sm px-3 btn-delete border-15 btn-width" data-id="${q.id}"><i class="fa fa-trash"></i> Delete</button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    `);
  });

  if (shownCount < quotes.length) {
    containerRow.insertAdjacentHTML("beforeend", `
      <div class="col-md-12 my-2">
        <button class="btn btnLoad d-block mx-auto btn-same">Load More</button>
      </div>
    `);
  }
}

async function deleteQuote(quoteId) {
  const confirm = await Swal.fire({
    title: "Are you sure?",
    text: "This will permanently delete this quote.",
    icon: "warning",
    showCancelButton: true,
    confirmButtonText: "Yes, delete it!",
    cancelButtonText: "Cancel"
  });

  if (confirm.isConfirmed) {
    try {
      await firebase.firestore().collection("QuoteAlert").doc(quoteId).delete();
      Swal.fire("Deleted", "The quote has been deleted.", "success");
      await loadAndRenderQuotes();
    } catch (err) {
      console.error("Delete failed:", err);
      Swal.fire("Error", "Failed to delete the quote.", "error");
    }
  }
}

// function setupSearch(quotes, row, input) {
//   input.addEventListener("input", () => {
//     const term = input.value.trim().toLowerCase();
//     const filtered = quotes.filter(q =>
//       q.title.toLowerCase().includes(term) ||
//       (q.chargesOffence && q.chargesOffence.toLowerCase().includes(term))
//     );
//     renderTab(filtered, row, filtered.length);
//   });
// }
function setupSearch(quotes, row, input) {
  input.addEventListener("input", () => {
    const term = input.value.trim().toLowerCase();

    const filtered = quotes.filter(q =>
      q.title.toLowerCase().includes(term) ||
      (Array.isArray(q.offense) && q.offense.some(o =>
        o.chargedesc?.toLowerCase().includes(term) ||
        o.severity?.toLowerCase().includes(term) ||
        o.warrantissuedagency?.toLowerCase().includes(term)
      ))
    );

    renderTab(filtered, row, filtered.length);
  });
}

function showVideos(videoUrls) {
  const embedHTML = videoUrls.map(url => `
    <video controls width="100%" class="my-2">
      <source src="${url}" type="video/webm" />
      Your browser does not support the video tag.
    </video>`).join("");
  Swal.fire({
    title: 'Recorded Videos',
    html: `<div style="max-height:400px;overflow-y:auto">${embedHTML}</div>`,
    width: 700
  });
}

// async function fetchArrestDetails(name) {
//   try {
//     const res = await fetch(`https://us-central1-duepro-2cf60.cloudfunctions.net/widgets/searchnew?name=${encodeURIComponent(name)}`);
//     const result = await res.json();

//     if (result.success === 0 || !result.result) {
//       return Swal.fire("No Record", result.msg || "No arrest record found.", "info");
//     }

//     const arrest = result.result;
//     const arrestDate = arrest.arrestDate ? new Date(arrest.arrestDate).toLocaleString() : "N/A";

//     Swal.fire({
//       title: `Arrest Details`,
//       html: `
//         <p><strong>Name:</strong> ${arrest.fullName}</p>
//         <p><strong>Gender:</strong> ${arrest.gender || 'N/A'}</p>
//         <p><strong>Age:</strong> ${arrest.age || 'N/A'}</p>
//         <p><strong>Address:</strong> ${arrest.address || 'N/A'}</p>
//         <p><strong>City/State/Zip:</strong> ${arrest.cityStateZip || 'N/A'}</p>
//        <p><strong>Offense:</strong><br>
//   ${
//     Array.isArray(arrest.offense) && arrest.offense.length
//       ? arrest.offense.map(o => `${o.chargedesc || 'N/A'} (${o.severity || 'N/A'})`).join('<br>')
//       : 'N/A'
//   }
// </p>

//         <p><strong>Detention:</strong> ${arrest.detention || 'N/A'}</p>
//         <p><strong>Arrest Date:</strong> ${arrestDate}</p>`,
//       confirmButtonText: 'Close'
//     });
//   } catch (err) {
//     console.error(err);
//     Swal.fire("Error", "Failed to fetch arrest details.", "error");
//   }
// }
async function fetchArrestDetails(name, alertId) {
  try {
    const upperName = name.toUpperCase();
    let arrest = null;

    // 🔹 Try API first
    try {
      const res = await fetch(`https://us-central1-duepro-2cf60.cloudfunctions.net/widgets/searchnew?name=${encodeURIComponent(upperName)}`);
      const result = await res.json();
      if (result.success !== 0 && result.result) {
        arrest = result.result;
      }
    } catch (apiError) {
      console.warn("API fetch failed:", apiError);
    }

    // 🔹 If API failed, fallback to Firestore
    if (!arrest) {
      const alertDoc = await firebase.firestore().collection("QuoteAlert").doc(alertId).get();
      if (alertDoc.exists) {
        const data = alertDoc.data();
        if (Array.isArray(data.offense) && data.offense.length > 0) {
          arrest = {
            fullName: name,
            offense: data.offense,
            detention: data.detainedPlace || 'N/A'
          };
        }
      }
    }

    // 🔹 If no arrest found anywhere
    if (!arrest) {
      return Swal.fire("No Record", "No arrest record found.", "info");
    }

    const arrestDate = arrest.arrestDate ? new Date(arrest.arrestDate).toLocaleString() : "N/A";

    Swal.fire({
      title: `Arrest Details`,
      html: `
        <p><strong>Name:</strong> ${arrest.fullName || name}</p>
        <p><strong>Gender:</strong> ${arrest.gender || 'N/A'}</p>
        <p><strong>Age:</strong> ${arrest.age || 'N/A'}</p>
        <p><strong>Address:</strong> ${arrest.address || 'N/A'}</p>
        <p><strong>City/State/Zip:</strong> ${arrest.cityStateZip || 'N/A'}</p>
        <p><strong>Offense:</strong><br>
          ${
            Array.isArray(arrest.offense) && arrest.offense.length
              ? arrest.offense.map(o =>
                  `${o.chargedesc || 'Unknown'} (${o.severity || '-'}) - ${o.warrantissuedagency || 'Unknown Agency'}`
                ).join('<br>')
              : 'N/A'
          }
        </p>
        <p><strong>Detention:</strong> ${arrest.detention || 'N/A'}</p>
        <p><strong>Arrest Date:</strong> ${arrestDate}</p>
      `,
      confirmButtonText: 'Close'
    });

  } catch (err) {
    console.error(err);
    Swal.fire("Error", "Failed to fetch arrest details.", "error");
  }
}

</script>

