<style>
  .atr-img-p{
    width: 100% !important;
    height:209px !important;
  }
  .stCard{
      /* height:245px !important; */
  }
  .st-image{
      cursor:pointer;
  }
  .btn-view{
      position:absolute;
      right:0;
      bottom:0;
  }
  @media(max-width:768px){
       .btn-view{
      position:static;
   
  }
  }
</style>
<main class="atr-img-p mb-5">
  <div class="container">
    <div class="my-5">
      <div class="d-flex justify-content-center">
        <!-- Nav tabs -->
        <ul
          class="nav nav-tabs n-tabs gap-2 justify-content-center w-fit"
          id="contentTabs"
          role="tablist"
        >
          <li class="nav-item" role="presentation">
            <button
              class="nav-link active"
              id="articles-tab"
              data-bs-toggle="tab"
              data-bs-target="#articles"
              type="button"
              role="tab"
              aria-controls="articles"
              aria-selected="true"
            >
              Active Quotes
            </button>
          </li>
          <li class="nav-item" role="presentation">
            <button
              class="nav-link"
              id="videos-tab"
              data-bs-toggle="tab"
              data-bs-target="#videos"
              type="button"
              role="tab"
              aria-controls="videos"
              aria-selected="false"
            >
              Inactive Quotes
            </button>
          </li>
        </ul>
      </div>

      <!-- Tab panes -->
      <div class="tab-content" id="contentTabsContent">
        <div
          class="tab-pane fade show active"
          id="articles"
          role="tabpanel"
          aria-labelledby="articles-tab"
        >
          <div class="row">
            <div class="col-md-12 my-2">
              <form class="d-flex position-relative mt-2 mt-md-0" role="search">
                <input
                  class="form-control me-2 search w-100 bg-white pe-4"
                  type="search"
                  placeholder="Search"
                  aria-label="Search"
                  style="width: 350px"
                />
                <img
                  src="<?= base_url('assets/images/icons/searchicon.png') ?>"
                  alt=""
                  width="15px"
                  height="15px"
                  class="searchIcon"
                />
              </form>
            </div>
          </div>
          <div class="row my-2">
          
           

            <div class="col-md-12 my-2">
              <button class="btn btnLoad d-block mx-auto btn-same">
                Load More
              </button>
            </div>
          </div>
        </div>
        <div
          class="tab-pane fade"
          id="videos"
          role="tabpanel"
          aria-labelledby="videos-tab"
        >
          <div class="row">
            <div class="col-md-12 my-2">
              <form class="d-flex position-relative mt-2 mt-md-0" role="search">
                <input
                  class="form-control me-2 search w-100 bg-white pe-4"
                  type="search"
                  placeholder="Search"
                  aria-label="Search"
                  style="width: 350px"
                />
                <img
                  src="<?= base_url('assets/images/icons/searchicon.png') ?>"
                  alt=""
                  width="15px"
                  height="15px"
                  class="searchIcon"
                />
              </form>
            </div>
          </div>
          <div class="row my-2">
          
           

            <div class="col-md-12 my-2">
              <button class="btn btnLoad d-block mx-auto btn-same">
                Load More
              </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</main>

<script>
firebase.auth().onAuthStateChanged(async (user) => {
  if (!user) return;

  const db = firebase.firestore();
  const uid = user.uid;

  // Step 1: Fetch own + friends' quotes
  const userDoc = await db.collection("Users").doc(uid).get();
  const userData = userDoc.data();
  const userFriendsMap = userData.userFriends || {};
  const friendIds = Object.keys(userFriendsMap);

  const quoteRef = db.collection("QuoteAlert");

  // Fetch own quotes and handle undefined isUserArchived
  const ownSnap = await quoteRef
    .where("userId", "==", uid)
    .get();
  
  const ownQuotes = ownSnap.docs.map(d => {
    const data = d.data();
    // Treat undefined/null isUserArchived as false
    const isUserArchived = data.isUserArchived === true;
    return {
      id: d.id,
      ...data,
      date: new Date(data.createdDate),
      isUserArchived: isUserArchived
    };
  }).filter(q => !q.isUserArchived && q.qoutesPrice > 0); // Filter out archived quotes

  let friendQuotes = [];
  for (let i = 0; i < friendIds.length; i += 10) {
    const chunk = friendIds.slice(i, i + 10);
    const friendSnap = await quoteRef
      .where("userId", "in", chunk)
      .get();
    
    const chunkQuotes = friendSnap.docs.map(d => {
      const data = d.data();
      // Treat undefined/null isUserArchived as false
      const isUserArchived = data.isUserArchived === true;
      return {
        id: d.id,
        ...data,
        date: new Date(data.createdDate),
        isUserArchived: isUserArchived
      };
    }).filter(q => !q.isUserArchived && q.qoutesPrice > 0); // Filter out archived quotes
    
    friendQuotes.push(...chunkQuotes);
  }

//   const all = [...ownQuotes, ...friendQuotes]
//     .sort((a, b) => b.date - a.date); // Using Date objects (more reliable)
    const all = [...ownQuotes, ...friendQuotes]
  .sort((a, b) => new Date(b.date) - new Date(a.date)) // Sort newest first
  .filter((item, index, self) => 
    index === self.findIndex(q => q.id === item.id)    // Keep only one per ID
  );

  // Step 2: Load LawFirm images into map
  const lawFirmMap = new Map();

  const lawFirmSnapshot = await db.collection("LawFirm").get();

  lawFirmSnapshot.docs.forEach(doc => {
    const data = doc.data();
    lawFirmMap.set(data.userId, {
      imageUrl: data.imageUrl || "<?= base_url('assets/images/placeholder.png') ?>"
    });
  });

  // Step 3: Add attorney image
  all.forEach(q => {
    const lawFirmInfo = lawFirmMap.get(q.LawId) || {};
    q.attorneyImage = lawFirmInfo.imageUrl || "<?= base_url('assets/images/placeholder.png') ?>";
  });

  // Step 4: Filter active/inactive
  const active = all.filter(q => q.isActive);
  const inactive = all.filter(q => !q.isActive);
  let shownActive = 3, shownInactive = 3;

  // Step 5: Render function
  function renderTab(quotes, containerRow, shownCount) {
    containerRow.innerHTML = "";
    const slice = quotes.slice(0, shownCount);
    slice.forEach(q => {
      const dateStr = q.date.toLocaleDateString(undefined, {
        month: 'long', day: '2-digit', year: 'numeric'
      });
      const timeStr = q.date.toLocaleTimeString();
      containerRow.insertAdjacentHTML("beforeend", `
        <div class="col-md-12 my-2">
          <div class="card stCard" data-law-id="${
  !q.acceptedAttorneyType
    ? q.LawId
    : q.acceptedAttorneyType === 'Criminal Defense'
      ? q.LawId
      : q.imigrationLawId
}"
  data-quote-id="${q.id}">
            <div class="card-body">
              <div class="row g-2">
                <div class="col-md-3 st-image">
                  <img class="atr-img-p" src="${q.attorneyImage}" alt="Attorney" />
                </div>
                <div class="col-md-9 position-relative">
                  <div class="d-flex justify-content-between align-items-center">
                    <p class="fp2 mb-0">Quote for ${q.title}</p>
                    ${q.paidStatus == 0 
                      ? '<p class="badge badge-danger bg-danger">Pending</p>' 
                      : '<p class="badge badge-success bg-success">Hired</p>'}
                  </div>
                
                  <p class="ft7 my-2">Incident on ${dateStr} ${timeStr}</p>
                  <div class="d-flex align-items-start gap-1 flex-column mt-2">
                  <p class="ft7">Charge(s): 
  <strong>
    ${
      Array.isArray(q.offense) && q.offense.length
        ? q.offense.map(o => o.chargedesc || 'N/A').join(', ')
        : 'N/A'
    }
  </strong>
</p>

                    <p class="ft7">Quote: <strong>$${q.qoutesPrice}</strong></p>
                    <p class="ft7">Deposit: <strong>$${q.qoutesDeposite}</strong></p>
                  
                  </div>
                <div class="d-flex justify-content-end">
       
         <button class="btn btn-save  mt-2 btn-width btn-view d-flex justify-content-center align-items-center">View</button>
            </div>
                </div>
              </div>
            </div>
            
          </div>
        </div>
      `);
    });

    if (shownCount < quotes.length) {
      containerRow.insertAdjacentHTML("beforeend", `
        <div class="col-md-12 my-2">
          <button class="btn btnLoad d-block mx-auto btn-same">Load More</button>
        </div>
      `);
    }

    // Step 7: Setup click handlers for cards and buttons 
    containerRow.querySelectorAll('.stCard').forEach(card => {
  const quoteId = card.getAttribute('data-quote-id');
  const lawId = card.getAttribute('data-law-id');
  const immigrationLawId = card.getAttribute('data-immigration-law-id');

  // Card click (excluding button)
  card.addEventListener('click', (e) => {
    if (e.target.classList.contains('btn-view')) return; // skip button itself
    window.location.href = `<?= base_url('site/attorneyDetail') ?>?lawId=${encodeURIComponent(lawId)}&quoteId=${encodeURIComponent(quoteId)}&immigrationLawId=${encodeURIComponent(immigrationLawId)}`;
  });

  // View button click (same action)
  const viewBtn = card.querySelector('.btn-view');
  if (viewBtn) {
    viewBtn.addEventListener('click', (e) => {
      e.stopPropagation(); // prevent bubbling
      window.location.href = `<?= base_url('site/attorneyDetail') ?>?lawId=${encodeURIComponent(lawId)}&quoteId=${encodeURIComponent(quoteId)}&immigrationLawId=${encodeURIComponent(immigrationLawId)}`;
    });
  }
});

    
 
  }

  // Step 6: Setup rows + search + load more
  const activeRow = document.querySelector("#articles .row.my-2");
  const inactiveRow = document.querySelector("#videos .row.my-2");
  const activeSearch = document.querySelector("#articles .search");
  const inactiveSearch = document.querySelector("#videos .search");

  renderTab(active, activeRow, shownActive);
  renderTab(inactive, inactiveRow, shownInactive);

  activeRow.addEventListener("click", e => {
    if (e.target.matches(".btnLoad")) renderTab(active, activeRow, shownActive += 3);
  });
  inactiveRow.addEventListener("click", e => {
    if (e.target.matches(".btnLoad")) renderTab(inactive, inactiveRow, shownInactive += 3);
  });

  function setupSearch(quotes, row, input) {
    input.addEventListener("input", () => {
      const term = input.value.trim().toLowerCase();

      const filtered = quotes.filter(q =>
        q.title.toLowerCase().includes(term) ||
        (Array.isArray(q.offense) &&
          q.offense.some(o =>
            o.chargedesc && o.chargedesc.toLowerCase().includes(term)
          )
        )
      );

      renderTab(filtered, row, filtered.length);
    });
  }

  setupSearch(active, activeRow, activeSearch);
  setupSearch(inactive, inactiveRow, inactiveSearch);
});
</script>