<!-- <!DOCTYPE html>
<html>
<head>
    <title>Subscription Success</title>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body>

<script>
     const auth = firebase.auth();
  const db = firebase.firestore();

  auth.onAuthStateChanged(async (user) => {
    if (!user) return;

    const uid = user.uid;
    const selectedPlan = sessionStorage.getItem("selectedPlan") || "unknown";
    const productId = selectedPlan === "monthly" ? "prod_SYFh0J2mrzJS4V" : "prod_SYGkcGjBZb1Edz"; // replace with your Stripe Product IDs

    try {
      await db.collection("Users").doc(uid).update({
        subscription_active: true,
        subscription_product_id: productId,
        // updated_at: firebase.firestore.FieldValue.serverTimestamp()
          updated_at: Date.now() 
      });

      Swal.fire({
        icon: "success",
        title: "Subscription Activated",
        text: "Thank you for subscribing!"
      });
    } catch (err) {
      console.error("Error updating Firestore:", err);
      Swal.fire({
        icon: "error",
        title: "Firestore Error",
        text: "Subscription succeeded, but database update failed."
      });
    }
  });
</script>
</body>
</html> -->

<!DOCTYPE html>
<html>
<head>
    <title>Subscription Success</title>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body>

<script>
  const auth = firebase.auth();
  const db = firebase.firestore();

  auth.onAuthStateChanged(async (user) => {
    if (!user) return;

    const uid = user.uid;
    const selectedPlan = sessionStorage.getItem("selectedPlan") || "unknown";
    // for live 
    // const productId = selectedPlan === "monthly" ? "prod_SYFh0J2mrzJS4V" : "prod_SYGkcGjBZb1Edz"; // Replace with your Stripe Product IDs
// for testing
   const productId = selectedPlan === "monthly" ? "prod_SimxAEGGcRk8ek" : "prod_SimyEQVguD1H39"; // Replace with your Stripe Product IDs
    try {
      await db.collection("Users").doc(uid).update({
        subscription_active: true,
        subscription_product_id: productId,
        updated_at: Date.now() 
      });

      // Show success alert
      Swal.fire({
        icon: "success",
        title: "Subscription Activated!",
        text: "You will be redirected shortly...",
        timer: 3000, // Auto-close after 3 seconds
        timerProgressBar: true,
        showConfirmButton: true,
        allowOutsideClick: false,
        willClose: () => {
          // Redirect when timer ends or user clicks OK
          window.location.href = "<?= base_url('site/activityLawer') ?>";
        }
      });

      // Fallback redirect (in case Swal fails)
      setTimeout(() => {
        window.location.href = "<?= base_url('site/activityLawer') ?>";
      }, 3000);

    } catch (err) {
      console.error("Error updating Firestore:", err);
      Swal.fire({
        icon: "error",
        title: "Firestore Error",
        text: "Subscription succeeded, but database update failed.",
        willClose: () => {
          window.location.href = "<?= base_url('site/activityLawer') ?>";
        }
      });
    }
  });
</script>
</body>
</html>