// lang.js
// const translations = {
//   en: {
//     activity: "Activity",
//     quotes: "Quotes",
//     messages: "Messages",
//     clients: "Clients",
//     switch_to_alerting: "Switch to alerting",
//     settings: "Settings",
//     personal_info: "Personal Information",
//     law_firm_info: "Law Firm Information",
//     language: "Language",
//     notifications: "Notifications",
//     support: "Support",
//     login_security: "Login & Security",
//     payments: "Payments & Earnings",
//     legal: "Legal",
//     privacy_policy: "Privacy Policy",
//     terms_of_service: "Terms of Service",
//     logout: "Logout",
//   },
//   es: {
//     activity: "Actividad",
//     quotes: "Citas",
//     messages: "Mensajes",
//     clients: "Clientes",
//     switch_to_alerting: "Cambiar a alerta",
//     settings: "Configuración",
//     personal_info: "Información personal",
//     law_firm_info: "Información del bufete",
//     language: "Idioma",
//     notifications: "Notificaciones",
//     support: "Soporte",
//     login_security: "Inicio de sesión y seguridad",
//     payments: "Pagos y ganancias",
//     legal: "Legal",
//     privacy_policy: "Política de privacidad",
//     terms_of_service: "Términos del servicio",
//     logout: "Cerrar sesión",
//   },
// };
const translations = {
  en: {
    alert: "Alert",
    activity: "Activity",
    quotes: "Quotes",
    messages: "Messages",
    switch_to_quoting: "Switch to quoting",
    settings: "Settings",
    personal_info: "Personal Information",
    immigration_info: "Immigration Info (optional)",
    attorney_contact: "Designate Attorney(s)",
    emergency_contact: "Emergency Contact",
    emergency_users: "Emergency Users",
    notifications: "Notifications",
    support: "Support",
    login_security: "Login & Security",
    add_law_firm: "Add Law Firm",
    legal: "Legal",
    privacy_policy: "Privacy Policy",
    terms_of_service: "Terms Of Service",
    logout: "Logout",
    clients: "Clients",
    switch_to_alerting: "Switch to alerting",
    payments: "Payments & Earnings",
    law_firm_info: "Law Firm Information",
    language: "Language",
    languages: "Languages",
    save: "Save",
    client_activity: "Client Activity",
    prospective_client_activity: "Prospective Client Activity",
    opt_out: "Opt Out",
    submit: "Submit",
    active_quotes: "Active Quotes",
    inactive_quotes: "Inactive Quotes",
    load_more: "Load More",
    personal_information: "Personal Information",
    legal_name: "Legal Name",
    dob: "Date of Birth",
    address: "Address",
    email_address: "Email Address",
    mobile: "Mobile",
    pin_code: "4-digit Pin Code",
    practice_label: "Tell us about your practice",
    practice_areas_label: "Practice Areas",
    practice_area_criminal_defense: "Criminal Defense",
    practice_area_immigration: "Immigration",
    mobile_label: "Mobile",
    address_label: "Address",
    counties_served_label: "Counties Served",
    county1: "County 1",
    county2: "County 2",
    county3: "County 3",
    county4: "County 4",
    email_label: "Email",
    website_label: "Website",
    intro_video_label: "Law firm intro video",
    photo_label: "Law firm photo",
    supporting_document_label: "Supporting Document",
    upload_prompt: "Tap to Upload",
    add_law_firm: "Add your law firm",
    notifications: "Notifications",
    no_new_notifications: "No new notifications",
    support: "Support",
    full_name: "Full Name",
    enter_full_name: "Enter Full Name",
    email: "Email",
    enter_email: "Enter email",
    message: "Message",
    enter_message: "Enter Message",
    submit: "Submit",
    login_security: "Login & Security",
    login_info: "Login Information",
    email_address: "Email Address",
    change_email: "Change email",
    enter_new_email: "Enter new email",
    change_password: "Change Password",
    old_password: "Old Password",
    enter_old_password: "Enter old password",
    new_password: "New Password",
    confirm_password: "Confirm Password",
    deactivate_account: "Deactivate Account",
    are_you_sure: "Are you sure?",
    deactivate_confirm: "Do you really want to deactivate your account?",
    cancel: "Cancel",
    deactivate: "Deactivate",
    current_password: "Current Password",
    continue: "Continue",
    update_email: "Update Email",
    phone_number: "Phone Number",
    change_phone: "Change phone number",
    update_phone: "Update Phone",
    earnings: "Earnings",
    monthly_earning: "You've made $30,000 this Month",
    status: "Status",
    date: "Date",
    paid_out: "Paid Out",
    payout_method: "Payout Method",
    transactions: "Transactions",
    ytd_summary: "Year-to-date summary",
    summary_period: "Jan 1-May 21, 2025",
    gross_earnings: "Gross Earnings",
    adjustments: "Adjustments",
    service_fee: "DuePro service Fee",
    tax_withheld: "Tax withheld",
    total_usd: "Total(USD)",
    legal_emergency: "Legal emergency?",
    tap_to_record: "Tap the button to activate alerts and begin recording.",
    attorney_contact: "Designate Attorney(s)",
    loading: "Loading...",
    full_name_label: "Full Name",
    full_name_placeholder: "Enter Full Name",
    email_label: "Email",
    email_placeholder: "Enter Email",
    mobile_label: "Mobile",
    mobile_placeholder: "+1 234 567 8901",
    save_button: "Save",
    emergency_contact_label: "Emergency Contact",
    archived: "Archived Alerts",
    payout_method: "Payout Method",
    delete_account: "Delete Account",
    sync_my_case_label: "Sync with MyCase",
  },
  es: {
    delete_account: "Eliminar cuenta",
    payout_method: "Método de pago",
    archived: "Alertas archivadas",
    alert: "Alerta",
    activity: "Actividad",
    quotes: "Citas",
    messages: "Mensajes",
    immigration_info: "Información de inmigración (opcional)",
    switch_to_quoting: "Cambiar a cotización",
    settings: "Configuración",
    personal_info: "Información personal",
    attorney_contact: "Designar abogado(s)",
    emergency_contact: "Contacto de emergencia",
    emergency_users: "Usuarios de emergencia",
    notifications: "Notificaciones",
    support: "Soporte",
    login_security: "Seguridad de inicio",
    add_law_firm: "Agregar bufete de abogados",
    legal: "Legal",
    privacy_policy: "Política de privacidad",
    terms_of_service: "Términos del servicio",
    logout: "Cerrar sesión",
    clients: "Clientes",

    switch_to_alerting: "Cambiar a alerta",
    payments: "Pagos y Ganancias",
    law_firm_info: "Información del Bufete",
    language: "Idioma",
    languages: "Idiomas",
    save: "Guardar",
    client_activity: "Actividad del cliente",
    prospective_client_activity: "Actividad del cliente potencial",
    opt_out: "Darse de baja",
    submit: "Enviar",
    active_quotes: "Citas activas",
    inactive_quotes: "Citas inactivas",
    load_more: "Cargar más",
    personal_information: "Información personal",
    legal_name: "Nombre legal",
    dob: "Fecha de nacimiento",
    address: "Dirección",
    email_address: "Correo electrónico",
    mobile: "Móvil",
    pin_code: "Código PIN de 4 dígitos",
    practice_label: "Cuéntenos sobre su práctica",
    practice_areas_label: "Áreas de práctica",
    practice_area_criminal_defense: "Defensa penal",
    mobile_label: "Móvil",
    address_label: "Dirección",
    counties_served_label: "Condados atendidos",
    county1: "Condado 1",
    county2: "Condado 2",
    county3: "Condado 3",
    county4: "Condado 4",
    email_label: "Correo electrónico",
    website_label: "Sitio web",
    intro_video_label: "Video introductorio del bufete",
    photo_label: "Foto del bufete",
    supporting_document_label: "Documento de respaldo",
    sync_my_case_label: "Sincronizar con MyCase",
    upload_prompt: "Toca para subir",
    add_law_firm: "Agrega tu bufete de abogados",
    notifications: "Notificaciones",
    no_new_notifications: "No hay notificaciones nuevas",
    support: "Soporte",
    full_name: "Nombre completo",
    enter_full_name: "Ingrese nombre completo",
    email: "Correo electrónico",
    enter_email: "Ingrese correo electrónico",
    message: "Mensaje",
    enter_message: "Ingrese mensaje",
    submit: "Enviar",
    login_security: "Inicio de sesión y seguridad",
    login_info: "Información de inicio de sesión",
    email_address: "Correo electrónico",
    change_email: "Cambiar correo",
    enter_new_email: "Ingrese nuevo correo electrónico",
    change_password: "Cambiar contraseña",
    old_password: "Contraseña anterior",
    enter_old_password: "Ingrese la contraseña anterior",
    new_password: "Nueva contraseña",
    confirm_password: "Confirmar contraseña",
    deactivate_account: "Desactivar cuenta",
    are_you_sure: "¿Estás seguro?",
    deactivate_confirm: "¿Realmente deseas desactivar tu cuenta?",
    cancel: "Cancelar",
    deactivate: "Desactivar",
    current_password: "Contraseña actual",
    continue: "Continuar",
    update_email: "Actualizar correo",
    phone_number: "Número de teléfono",
    change_phone: "Cambiar número de teléfono",
    update_phone: "Actualizar teléfono",

    earnings: "Ganancias",
    monthly_earning: "Has ganado  $30,000  este mes",
    status: "Estado",
    date: "Fecha",
    paid_out: "Pagado",
    payout_method: "Método de pago",
    transactions: "Transacciones",
    ytd_summary: "Resumen del año hasta la fecha",
    summary_period: "1 de enero - 21 de mayo de 2025",
    gross_earnings: "Ganancias brutas",
    adjustments: "Ajustes",
    service_fee: "Comisión de servicio DuePro",
    tax_withheld: "Impuesto retenido",
    total_usd: "Total (USD)",
    legal_emergency: "¿Emergencia legal?",
    tap_to_record: "Toca el botón para activar alertas y comenzar a grabar.",
    attorney_contact: "Contacto del Abogado",
    loading: "Cargando...",
    full_name_label: "Nombre Completo",
    full_name_placeholder: "Ingrese su nombre completo",
    email_label: "Correo Electrónico",
    email_placeholder: "Ingrese su correo",
    mobile_label: "Móvil",
    mobile_placeholder: "+34 612 345 678",
    save_button: "Guardar",
    emergency_contact_label: "Contacto de Emergencia",
  },
};

function applyTranslations(lang = "en") {
  document.querySelectorAll("[data-i18n]").forEach((el) => {
    const key = el.getAttribute("data-i18n");
    el.textContent = translations[lang]?.[key] || key;
  });
}
