<div class="container mt-4">
    <h3 class="mb-4">Volunteer Activities for <strong><?= $user_name ?></strong></h3>


    <?php if (!empty($activities)) : ?>
        <?php foreach ($activities as $activity): ?>
            <div class="card mb-3">
                <div class="card-body">
                    <!-- <h5 class="card-title"><?= $activity['description'] ?? 'No Description' ?></h5> -->
                    <p><strong>Location:</strong> <?= $activity['city'] ?? '' ?>, <?= $activity['country'] ?? '' ?></p>
                    <p><strong>Number of Trash Removed:</strong> <?= $activity['removedTrash'] ?? 0 ?> </p>
                    <?php
    // Convert timestamps (milliseconds to seconds)
    $startTimestamp = $activity['startTime'] / 1000;
    $endTimestamp = $activity['endTime'] / 1000;

    $date = date('d M Y', $activity['date'] / 1000);
    $startTimeFormatted = date('h:i:s A', $startTimestamp); // now includes seconds
    $endTimeFormatted = date('h:i:s A', $endTimestamp);
?>

<p><strong>Date:</strong> <?= $date ?></p>
<p><strong>Start Time:</strong> <?= $startTimeFormatted ?></p>
<p><strong>End Time:</strong> <?= $endTimeFormatted ?></p>



                    <?php if (!empty($activity['trashGallery']) && is_array($activity['trashGallery'])): ?>
                        <div class="d-flex flex-wrap">
                            <?php foreach ($activity['trashGallery'] as $img): ?>
                                <a href="<?= $img ?>" target="_blank">
                                    <img src="<?= $img ?>" class="gallery-img" />
                                </a>
                            <?php endforeach; ?>
                        </div>
                    <?php else: ?>
                        <p>No trash gallery images available.</p>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    <?php else: ?>
        <div class="alert alert-info">No activities found for this user.</div>
    <?php endif; ?>
</div>