<!-- Begin Page Content -->
<div class="container-fluid">
    <!-- <div class="row column_title">
        <div class="col-md-12">
            <div class="page_title">
                <h2>User Answers</h2>
            </div>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">DataTables Example</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="songTable" width="100%" cellspacing="0">
                    <thead class="thead-dark">
                        <tr>
                            <th>User</th>
                            <th>Question</th>
                            <th>Answer</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if (!empty($customerlist)) {
                            $count = 1;
                            foreach ($customerlist as $id => $customerlists) {
                        ?>
                                <tr>
                                    <?php echo $customerlists['firstName']; ?> <?php echo $customerlists['lastName']; ?></td> 
                                    <td>John Al</td>
                                    <td><?php echo output($customerlists['question']); ?></td>
                                    <td> <?php echo ($customerlists['answer'] ? 'Yes' : 'No'); ?></td>
                                    <td>
                                        <button class="btn btn-danger btn-block mt-2" data-toggle="modal" data-target="#exampleModa2" onclick="showConfirmation('<?php echo output($id); ?>','answer', 'deleteAnswer');">Delete</button>

                                    </td>
                                </tr>
                        <?php }
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div> -->

    <div class="row column_title mb-4">
        <div class="col-md-12">
            <div class="page_title">
                <h2>Questions</h2>
            </div>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-header py-3">         
            <button id="openAddQuestionModal" class="btn btn-primary">Add New Question</button>
     
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="songTable" width="100%" cellspacing="0">
                    <thead class="thead-dark">
                        <tr>
                            <th>Question</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        if (!empty($questions)) {
                            foreach ($questions as $id => $questionData) {
                        ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($questionData['question'], ENT_QUOTES, 'UTF-8'); ?></td>
                                    <td>
                                        <button class="btn btn-warning btn-block mt-2" data-toggle="modal" data-target="#editQuestionModal" onclick="editQuestion('<?php echo htmlspecialchars($id, ENT_QUOTES, 'UTF-8'); ?>', '<?php echo htmlspecialchars($questionData['question'], ENT_QUOTES, 'UTF-8'); ?>')">Edit</button>
                                        <!-- <button class="btn btn-danger btn-block mt-2" onclick="showConfirmation('<?php echo htmlspecialchars($id, ENT_QUOTES, 'UTF-8'); ?>', '<?php echo htmlspecialchars($questionData['question'], ENT_QUOTES, 'UTF-8'); ?>', 'deleteQuestion')">Delete</button> -->
                                        <button class="btn btn-danger btn-block mt-2" data-toggle="modal" data-target="#exampleModa2" onclick="showConfirmation('<?php echo output($id); ?>','question', 'deleteQuestion');">Delete</button>
                                    </td>
                                </tr>
                            <?php
                            }
                        } else {
                            ?>
                            <tr>
                                <td colspan="2" class="text-center">No questions found.</td>
                            </tr>
                        <?php
                        }
                        ?>
                    </tbody>

                </table>
            </div>
        </div>
    </div>

</div>

<!-- Modal for Adding Question -->
<div class="modal fade" id="addQuestionModal" tabindex="-1" aria-labelledby="addQuestionModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addQuestionModalLabel">Add Question</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="addQuestionForm" action="<?= base_url('Customer/addQuestion') ?>" method="post">
                    <div class="mb-3">
                        <label for="question" class="form-label">Question</label>
                        <input type="text" class="form-control" id="question" name="question" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Add Question</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- edit modal -->
<div class="modal fade" id="editQuestionModal" tabindex="-1" aria-labelledby="editQuestionModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editQuestionModalLabel">Edit Question</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="editQuestionForm" method="post" action="<?= base_url('customer/updateQuestion') ?>">
                    <input type="hidden" id="editQuestionId" name="id" value="">
                    <div class="mb-3">
                        <label for="editQuestionText" class="form-label">Question</label>
                        <input type="text" class="form-control" id="editQuestionText" name="question" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Update Question</button>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- edit modal end -->

<!-- /.container-fluid -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <form method="post" action="<?= base_url('customer/sendWarning') ?>">
        <input id="user-id" type="hidden" name="userid" value="" />
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Send Warning to "<spna id="user-name"></spna>"
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form>

                        <div class="form-group">
                            <label for="message-text" class="col-form-label">Warning Message:</label>
                            <textarea class="form-control" id="message-text" rows="5" name="message" required></textarea>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Send Warning</button>
                </div>
            </div>
        </div>
    </form>
</div>
<div class="modal fade" id="exampleModa2" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <form method="get" name="cform" action="">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel2"></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary" id="submitBtn"></button>
                </div>
            </div>
        </div>
    </form>
</div>


<script>

</script>

<script>
    // for updating questions
    function editQuestion(id, question) {
        document.getElementById('editQuestionId').value = id;
        document.getElementById('editQuestionText').value = question;
    }

    function showAddQuestionModal() {
        var addQuestionModal = new bootstrap.Modal(document.getElementById('addQuestionModal'));
        addQuestionModal.show();
    }

    // Attach event listener to button to open modal for adding question
    document.getElementById('openAddQuestionModal').addEventListener('click', function() {
        showAddQuestionModal();
    });
    ///////////////

    function showModal(userid, username) {
        document.getElementById('user-name').innerText = username;
        document.getElementById('user-id').value = userid;
    }

    function showConfirmation(userid, username, action) {
        let url = "";
        let message = "";
        let btnTitle = "";
        switch (action) {

            case 'deleteAnswer':
                url = "<?php echo base_url(); ?>customer/deleteAnswer/" + userid;
                message = "Are you sure you want to delete this record";
                btnTitle = "Delete Question";
                break;
            case 'deleteQuestion':
                url = "<?php echo base_url(); ?>customer/deleteQuestion/" + userid;
                message = "Are you sure you want to delete this record";
                btnTitle = "Delete Question";
                break;
            case 'deleteImage':
                url = "<?php echo base_url(); ?>customer/deleteImage/" + userid;
                message = "Are you sure you want to remove profile phot of user '" + username + "'?";
                btnTitle = "Remove Profile Photo";
                break;
            case 'banCustomer':
                url = "<?php echo base_url(); ?>customer/banCustomer/" + userid;
                message = "Are you sure you want to ban user '" + username + "'?";
                btnTitle = "Ban User";
                break;
            case 'unBanCustomer':
                url = "<?php echo base_url(); ?>customer/unBanCustomer/" + userid;
                message = "Are you sure you want to Unbanned user '" + username + "'?";
                btnTitle = "Unban User";
                break;
            case 'suspendCustomer':
                url = "<?php echo base_url(); ?>customer/suspendCustomer/" + userid;
                message = "Are you sure you want to deactivate user '" + username + "'?";
                btnTitle = "Deactivate User";
                break;
            case 'unSuspendCustomer':
                url = "<?php echo base_url(); ?>customer/unSuspendCustomer/" + userid;
                message = "Are you sure you want to activate user '" + username + "'?";
                btnTitle = "Activate User";
                break;
            case 'deleteCustomer':
                url = "<?php echo base_url(); ?>customer/remove/" + userid + "/user";
                message = "Are you sure you want to delete user '" + username + "'?";
                btnTitle = "Delete User";
                break;
            default:
                return false;
        }

        document.getElementById('exampleModalLabel2').innerText = message;
        document.getElementById('submitBtn').innerText = btnTitle;
        document.cform.action = url;
    }
</script>