<div class="container mt-5">
        <h2 class="mb-4">Support and Feedback</h2>
        
        <!-- Submit Support Request Form -->
        <div class="card mb-4">
            <div class="card-header">
                <h5>Submit a Support Request</h5>
            </div>
            <div class="card-body">
                <form id="supportForm">
                    <!-- Issue Type -->
                    <div class="form-group">
                        <label for="issueType">Issue Type</label>
                        <select class="form-control" id="issueType" required>
                            <option value="">Select Issue Type</option>
                            <option value="Technical">Technical Issue</option>
                            <option value="Payment">Payment Inquiry</option>
                            <option value="Other">Other</option>
                        </select>
                    </div>

                    <!-- Description -->
                    <div class="form-group">
                        <label for="issueDescription">Description</label>
                        <textarea class="form-control" id="issueDescription" rows="4" placeholder="Describe your issue in detail" required></textarea>
                    </div>

                    <!-- Attachment -->
                    <div class="form-group">
                        <label for="attachment">Attach File (optional)</label>
                        <input type="file" class="form-control-file" id="attachment" accept=".jpg,.png,.pdf,.doc,.docx">
                    </div>

                    <!-- Submit Button -->
                    <button type="submit" class="btn btn-primary">Submit Request</button>
                </form>
            </div>
        </div>

        <!-- Support Request Tracker -->
        <div class="card">
            <div class="card-header">
                <h5>Your Support Requests</h5>
            </div>
            <div class="card-body">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Issue Type</th>
                            <th>Description</th>
                            <th>Status</th>
                            <th>Date Submitted</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Dummy Data -->
                        <tr>
                            <td>1</td>
                            <td>Technical Issue</td>
                            <td>Unable to log in to the app.</td>
                            <td><span class="badge badge-warning">In Progress</span></td>
                            <td>2024-12-29</td>
                        </tr>
                        <tr>
                            <td>2</td>
                            <td>Payment Inquiry</td>
                            <td>Charged twice for subscription.</td>
                            <td><span class="badge badge-success">Resolved</span></td>
                            <td>2024-12-28</td>
                        </tr>
                        <tr>
                            <td>3</td>
                            <td>Other</td>
                            <td>Suggestion for a new feature.</td>
                            <td><span class="badge badge-secondary">Pending</span></td>
                            <td>2024-12-27</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>