<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Analytics Dashboard</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <style>
    .card-icon {
      font-size: 24px;
      margin-right: 10px;
    }
  </style>
</head>
<body>

<div class="container-fluid mt-4">
  <div class="row mb-4">
    <div class="col-12">
      <h2>Analytics Overview</h2>
    </div>
  </div>

  <!-- Stats Cards -->
  <div class="row">
    <div class="col-md-4">
      <div class="card shadow p-3">
        <div class="d-flex align-items-center">
          <i class="fa fa-users card-icon text-primary"></i>
          <div>
            <h5>Vendors</h5>
            <h3 id="vendorCount">--</h3>
          </div>
        </div>
      </div>
    </div>

    <div class="col-md-4">
      <div class="card shadow p-3">
        <div class="d-flex align-items-center">
          <i class="fa fa-cube card-icon text-success"></i>
          <div>
            <h5>Products</h5>
            <h3 id="productCount">--</h3>
          </div>
        </div>
      </div>
    </div>

    <div class="col-md-4">
      <div class="card shadow p-3">
        <div class="d-flex align-items-center">
          <i class="fa fa-briefcase card-icon text-warning"></i>
          <div>
            <h5>Service Providers</h5>
            <h3 id="providerCount">--</h3>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Chart Section -->
  <div class="row mt-5">
    <div class="col-md-6">
      <div class="card shadow p-3">
        <h5 class="mb-3">Product Distribution</h5>
        <canvas id="productChart" height="150"></canvas>
      </div>
    </div>

    <div class="col-md-6">
      <div class="card shadow p-3">
        <h5 class="mb-3">Service Provider Types</h5>
        <canvas id="serviceChart" height="150"></canvas>
      </div>
    </div>
  </div>
</div>

<!-- Bootstrap & Font Awesome -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

<script>
// Dummy Stats
const vendorCount = 12;
const productCount = 34;
const providerCount = 7;

// Inject counts
document.getElementById("vendorCount").textContent = vendorCount;
document.getElementById("productCount").textContent = productCount;
document.getElementById("providerCount").textContent = providerCount;

// Product Distribution Chart
const productChart = new Chart(document.getElementById('productChart'), {
  type: 'bar',
  data: {
    labels: ['Electronics', 'Clothing', 'Appliances', 'Books'],
    datasets: [{
      label: 'Products',
      data: [10, 8, 6, 10],
      backgroundColor: ['#0d6efd', '#20c997', '#ffc107', '#6f42c1']
    }]
  },
  options: {
    responsive: true,
    scales: {
      y: { beginAtZero: true }
    }
  }
});

// Service Provider Types Chart
const serviceChart = new Chart(document.getElementById('serviceChart'), {
  type: 'doughnut',
  data: {
    labels: ['Plumber', 'Electrician', 'Mechanic', 'Cleaner'],
    datasets: [{
      label: 'Service Providers',
      data: [2, 3, 1, 1],
      backgroundColor: ['#198754', '#0dcaf0', '#dc3545', '#6c757d']
    }]
  },
  options: {
    responsive: true,
    plugins: {
      legend: { position: 'bottom' }
    }
  }
});
</script>

</body>
</html>
