<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Products</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<!-- Begin Page Content -->
<div class="container-fluid mt-4">
  <div class="row column_title">
    <div class="col-md-12">
      <div class="page_title">
        <h2>Products</h2>
      </div>
    </div>
  </div>

  <button type="button" class="btn btn-primary" style="float: right; display: none;">Add Product</button>
  <br><br><br>

  <div class="card shadow">
    <div class="card-header py-3"></div>
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-bordered" id="productTable" width="100%" cellspacing="0">
          <thead class="thead-dark">
            <tr>
              <th>Product Name</th>
              <th>Category</th>
              <th>Price</th>
              <th>Status</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody id="productTbody">
            <!-- Rows will be injected via JavaScript -->
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="exampleModa2" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <form method="get" name="cform" action="">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel2"></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary" id="submitBtn"></button>
        </div>
      </div>
    </div>
  </form>
</div>

<!-- Bootstrap & jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
// Dummy Product Data
const products = [
  { id: 'p001', name: 'Wireless Headphones', category: 'Electronics', price: '$120', status: 'Available' },
  { id: 'p002', name: 'Coffee Maker', category: 'Appliances', price: '$85', status: 'Out of Stock' },
  { id: 'p003', name: 'Gaming Mouse', category: 'Accessories', price: '$45', status: 'Available' }
];

// Render Products
function renderProducts() {
  const tbody = document.getElementById('productTbody');
  tbody.innerHTML = '';
  products.forEach(p => {
    tbody.innerHTML += `
      <tr>
        <td>${p.name}</td>
        <td>${p.category}</td>
        <td>${p.price}</td>
        <td>${p.status}</td>
        <td>
          <button class="btn btn-warning btn-block mt-2">Edit</button>
          <button class="btn btn-danger btn-block mt-2" data-toggle="modal" data-target="#exampleModa2" onclick="showConfirmation('${p.id}','${p.name}', 'deleteProduct')">Delete</button>
        </td>
      </tr>
    `;
  });
}

// Confirmation Modal Handler
function showConfirmation(productId, productName, action) {
  let url = '';
  let message = '';
  let btnTitle = '';

  if (action === 'deleteProduct') {
    url = '#'; // dummy
    message = `Are you sure you want to delete product '${productName}'?`;
    btnTitle = 'Delete Product';
  }

  document.getElementById('exampleModalLabel2').innerText = message;
  document.getElementById('submitBtn').innerText = btnTitle;
  document.cform.action = url;
}

renderProducts();
</script>

</body>
</html>
