<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Service Providers</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<!-- Begin Page Content -->
<div class="container-fluid mt-4">
  <div class="row column_title">
    <div class="col-md-12">
      <div class="page_title">
        <h2>Service Providers</h2>
      </div>
    </div>
  </div>

  <button type="button" class="btn btn-primary" style="float: right; display: none;">Add Service Provider</button>
  <br><br><br>

  <div class="card shadow">
    <div class="card-header py-3"></div>
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-bordered" id="providerTable" width="100%" cellspacing="0">
          <thead class="thead-dark">
            <tr>
              <th>Name</th>
              <th>Email</th>
              <th>Service Type</th>
              <th>Phone</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody id="providerTbody">
            <!-- JS Will inject rows here -->
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="exampleModa2" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <form method="get" name="cform" action="">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel2"></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary" id="submitBtn"></button>
        </div>
      </div>
    </div>
  </form>
</div>

<!-- Bootstrap + jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
// Dummy Service Provider Data
const providers = [
  { id: 'sp001', name: 'John Electrician', email: 'john@services.com', service: 'Electrical', phone: '0300-1112233' },
  { id: 'sp002', name: 'Anna Plumber', email: 'anna@waterfix.com', service: 'Plumbing', phone: '0315-9988776' },
  { id: 'sp003', name: 'Kareem Mechanic', email: 'kareem@autohelp.com', service: 'Auto Repair', phone: '0333-4455667' }
];

// Render Service Providers
function renderProviders() {
  const tbody = document.getElementById('providerTbody');
  tbody.innerHTML = '';
  providers.forEach(p => {
    tbody.innerHTML += `
      <tr>
        <td>${p.name}</td>
        <td>${p.email}</td>
        <td>${p.service}</td>
        <td>${p.phone}</td>
        <td>
          <button class="btn btn-info btn-block mt-2">Edit</button>
          <button class="btn btn-danger btn-block mt-2" data-toggle="modal" data-target="#exampleModa2" onclick="showConfirmation('${p.id}','${p.name}', 'deleteProvider')">Delete</button>
        </td>
      </tr>
    `;
  });
}

// Delete Confirmation
function showConfirmation(providerId, providerName, action) {
  let url = '#';
  let message = '';
  let btnTitle = '';

  if (action === 'deleteProvider') {
    message = `Are you sure you want to delete service provider '${providerName}'?`;
    btnTitle = 'Delete Provider';
  }

  document.getElementById('exampleModalLabel2').innerText = message;
  document.getElementById('submitBtn').innerText = btnTitle;
  document.cform.action = url;
}

renderProviders();
</script>

</body>
</html>
