

<!-- Begin Page Content -->
<div class="container-fluid mt-4">
  <div class="row column_title">
    <div class="col-md-12">
      <div class="page_title">
        <h2>Vendors</h2>
      </div>
    </div>
  </div>

  <button type="button" class="btn btn-primary" style="float: right; display: none;">Add Vendor</button>
  <br><br><br>

  <div class="card shadow">
    <div class="card-header py-3"></div>
    <div class="card-body">
      <div class="table-responsive">
        <table class="table table-bordered" id="vendorTable" width="100%" cellspacing="0">
          <thead class="thead-dark">
            <tr>
              <th>Name</th>
              <th>Email</th>
              <th>DOB</th>
              <th>Gender</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody id="vendorTbody">
            <!-- Rows will be injected via JavaScript -->
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="exampleModa2" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <form method="get" name="cform" action="">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel2"></h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary" id="submitBtn"></button>
        </div>
      </div>
    </div>
  </form>
</div>

<!-- Bootstrap & jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
// Dummy Vendor Data
const vendors = [
  { id: 'v001', name: 'Vendor One', email: 'vendor1@mail.com', dob: '1988-01-01', gender: 'Male' },
  { id: 'v002', name: 'Vendor Two', email: 'vendor2@mail.com', dob: '1992-06-15', gender: 'Female' },
  { id: 'v003', name: 'Vendor Three', email: 'vendor3@mail.com', dob: '1985-03-20', gender: 'Male' }
];

// Render Vendors
function renderVendors() {
  const tbody = document.getElementById('vendorTbody');
  tbody.innerHTML = '';
  vendors.forEach(v => {
    tbody.innerHTML += `
      <tr>
        <td>${v.name}</td>
        <td>${v.email}</td>
        <td>${v.dob}</td>
        <td>${v.gender}</td>
        <td>
          <button class="btn btn-warning btn-block mt-2">Suspend</button>
          <button class="btn btn-info btn-block mt-2">Edit</button>
          <button class="btn btn-danger btn-block mt-2" data-toggle="modal" data-target="#exampleModa2" onclick="showConfirmation('${v.id}','${v.name}', 'deleteVendor')">Delete Account</button>
        </td>
      </tr>
    `;
  });
}

// Confirmation Modal Handler
function showConfirmation(userid, username, action) {
  let url = '';
  let message = '';
  let btnTitle = '';

  if (action === 'deleteVendor') {
    url = '#'; // dummy action
    message = `Are you sure you want to delete vendor '${username}'?`;
    btnTitle = 'Delete Vendor';
  }

  document.getElementById('exampleModalLabel2').innerText = message;
  document.getElementById('submitBtn').innerText = btnTitle;
  document.cform.action = url;
}

renderVendors();
</script>

