
<?php
// application/controllers/Upload.php
class Upload extends CI_Controller {

    private $uploadId;
    private $fileName;
    private $parts = [];

    public function __construct() {
        parent::__construct();
        $this->load->library('Aws_s3');
    }

    public function myview(){
        $this->load->view('myview');
    }
    // Start Upload
    public function startUpload() {
        $fileName = $this->input->post('fileName');  // File name from client
        if (!$fileName) {
            echo json_encode(['error' => 'Missing file name']);
            return;
        }

        $this->uploadId = $this->aws_s3->startUpload($fileName);
        if (isset($this->uploadId['error'])) {
            echo json_encode(['error' => $this->uploadId['error']]);
            return;
        }

        echo json_encode(['uploadId' => $this->uploadId]);
    }

    // Upload Part
    public function uploadPart() {
        $uploadId = $this->input->post('uploadId');
        $fileName = $this->input->post('fileName');
        $partNumber = $this->input->post('partNumber');
        $fileContent = file_get_contents($_FILES['file']['tmp_name']);  // Get file content

        if (!$uploadId || !$fileName || !$partNumber || !$fileContent) {
            echo json_encode(['error' => 'Missing parameters']);
            return;
        }

        $etag = $this->aws_s3->uploadPart($uploadId, $fileName, $partNumber, $fileContent);
        if (isset($etag['error'])) {
            echo json_encode(['error' => $etag['error']]);
            return;
        }

        if (!isset($_SESSION['parts'])) {
            $_SESSION['parts'] = [];
        }
        $_SESSION['parts'][] = [
            'ETag'       => $etag,
            'PartNumber' => $partNumber,
        ];
        // Track the uploaded part's ETag and part number
        $this->parts[] = [
            'ETag'       => $etag,
            'PartNumber' => $partNumber,
        ];

        echo json_encode(['status' => 'chunk_uploaded','parts'=>   $_SESSION['parts']]);
    }

    // Complete Upload
    public function completeUpload() {
        $uploadId = $this->input->post('uploadId');
        $fileName = $this->input->post('fileName');
    
        if (!$uploadId || !$fileName) {
            echo json_encode(['error' => 'Missing uploadId or fileName']);
            return;
        }
    
        if (!isset($_SESSION['parts']) || empty($_SESSION['parts'])) {
            echo json_encode(['error' => 'No parts found for this upload']);
            return;
        }

     
        // Complete the upload using the stored parts
        $fileUrl = $this->aws_s3->completeUpload($uploadId, $fileName, $_SESSION['parts']);
        unset($_SESSION['parts']);
      
        if (isset($fileUrl['error'])) {
            echo json_encode(['error' => $fileUrl['error']]);
            return;
        }
    
        // Clear parts from session after completion
        unset($_SESSION['parts']);
    
        echo json_encode(['message' => 'Upload complete', 'fileUrl' => $fileUrl]);
    }
    
}
