<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark"><?php echo (isset($event)) ? 'Edit Product' : 'Add Country' ?>
                </h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?= base_url(); ?>/dashboard">Dashboard</a></li>
                    <li class="breadcrumb-item active"><?php echo (isset($event)) ? 'Edit Product' : 'Add Product' ?></li>
                </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <?php
            if(isset($event)){
                $endPoint = "updateproduct";
            }else{
                $endPoint = "insertproduct";
            }
        ?>
        <form method="post" id="customer_add" class="card" action="<?php echo base_url() . "dashboard/". $endPoint ; ?>" enctype="multipart/form-data">
            <div class="card-body">

                <div class="row">
                    <input type="hidden" name="id" value="<?php echo (isset($event)) ? $event['id'] : '' ?>">

                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Product Title</label>
                            <input type="text" required="true" class="form-control" value="<?php echo (isset($event)) ? $event['title'] : '' ?>" name="title" placeholder="Title">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Short Description</label>
                            <input type="text" required="true" class="form-control" value="<?php echo (isset($event)) ? $event['shortDescription'] : '' ?>" name="shortDescription" placeholder="Short Description" maxlength="256">
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Price</label>
                            <input type="number" required="true" class="form-control" value="<?php echo (isset($event)) ? $event['price'] : '' ?>" name="price" placeholder="Price">
                        </div>
                    </div>

                    <div class="col-6">
                        <div class="form-group">
                            <label class="form-label">Image</label>
                            <input type="file" class="form-control" name="image">
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="form-group">
                            <label class="form-label">Long Description</label><br>
                            <textarea name="description" rows="10" cols="80"><?php echo (isset($event)) ? $event['description'] : '' ?></textarea>
                        </div>
                    </div>

                    <div class="modal-footer">

                        <button type="submit" class="btn btn-primary"> <?php echo (isset($event)) ? 'Update Product' : 'Add Product' ?></button>
                    </div>
                </div>
        </form>
    </div>
</section>
<!-- /.content -->