(function () {
  const second = 1000,
        minute = second * 60,
        hour = minute * 60,
        day = hour * 24;

  let countDown;
  
  // Check if countdown is stored in local storage
  const storedCountdown = localStorage.getItem('countdown');
  if (storedCountdown) {
    countDown = parseInt(storedCountdown);
  } else {
    // If not stored, set countdown to 7 days, 12 hours, and 43 minutes from current time
    countDown = new Date().getTime() + (7 * day) + (12 * hour) + (43 * minute);
    localStorage.setItem('countdown', countDown); // Store the initial countdown time
  }

  const x = setInterval(function() {    

    const now = new Date().getTime(),
          distance = countDown - now;

    document.getElementById("days").innerText = Math.floor(distance / (day)),
    document.getElementById("hours").innerText = Math.floor((distance % (day)) / (hour)),
    document.getElementById("minutes").innerText = Math.floor((distance % (hour)) / (minute)),
    document.getElementById("seconds").innerText = Math.floor((distance % (minute)) / second);

    //do something later when date is reached
    if (distance < 0) {
      document.getElementById("headline").innerText = "Started";
      document.getElementById("countdown").style.display = "none";
      document.getElementById("content").style.display = "block";
      clearInterval(x);
      localStorage.removeItem('countdown'); // Remove countdown from local storage when it's finished
    }
    //seconds
  }, 0);
}());
