<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Terms & Condition</title>
    <link
      rel="stylesheet"
      type="text/css"
      href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css"
    />
    <link
      rel="stylesheet"
      type="text/css"
      href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
    />
    <link rel="stylesheet" type="text/css" href="css/home.css" />
    <link rel="stylesheet" type="text/css" href="css/styles.css" />
    <link rel="stylesheet" type="text/css" href="css/responsive.css" />
    <style type="text/css">
      header {
        height: 100% !important;
      }

      .service-categories {
        padding: 2% 15%;
      }
      .service-categories h1,
      .service-categories h2,
      .service-categories h4,
      .service-categories p {
        color: #000;
        text-align: justify;
      }
      .service-categories h2 {
        font-size: 2rem;
      }
      .service-categories p {
        font-size: 1.6rem;
      }
      .home-image-box {
        margin-top: 4rem;
      }
      @media (max-width: 1700px) {
        h4 {
          font-size: 1.2rem;
        }
      }
      @media (max-width: 1605px) {
        .box-padding {
          padding: 3rem 1rem;
          color: #000;
        }
        .services p {
          font-size: 1.6rem;
          width: 100%;
        }
      }
      @media (max-width: 600px) {
        .service-categories {
          padding: 2% 2%;
        }
        .home-image-box {
          margin-top: 1rem;
        }
      }
    </style>
  </head>
  <body>
    <header>
      <div class="top-img">
        <nav class="navbar navbar-expand-lg bg-light">
          <div class="container-fluid">
            <a class="navbar-brand desktop-view" href="#"
              ><img src="img/logo.png" class="img-fluid"
            /></a>
            <button
              class="navbar-toggler"
              type="button"
              data-bs-toggle="collapse"
              data-bs-target="#navbarSupportedContent"
              aria-controls="navbarSupportedContent"
              aria-expanded="false"
              aria-label="Toggle navigation"
            >
              <span class="navbar-toggler-icon"></span>
            </button>
            <div
              class="collapse navbar-collapse nav-link-list"
              id="navbarSupportedContent"
            >
              <ul class="navbar-nav ms-auto mb-2 mb-lg-0 link-list">
                <li class="nav-item">
                  <a class="nav-link active" aria-current="page" href="#"
                    >Home</a
                  >
                </li>
                <li class="nav-item">
                  <a class="nav-link" href="#">Services</a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" href="#">Sign up</a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" href="#">Log-in</a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" href="#">Store</a>
                </li>
              </ul>
              <div class="d-flex select-btn baf">
                <button class="btn btn-dark" type="submit">
                  Become a Fixer
                </button>
              </div>
            </div>
          </div>
        </nav>
      </div>

      <div class="top">
        <div class="d-flex justify-content-end desktop-view">
          <div>
            <img src="img/man.png" class="img-fluid" />
          </div>
        </div>

        <div
          class="d-flex justify-content-between mobile-view align-items-start"
        >
          <div class="top-left home-search-icon">
            <div class="d-flex justify-content-start">
              <div class="form">
                <img src="img/footer_logo.png" class="img-fluid" />
              </div>
            </div>
          </div>
          <div>
            <img src="img/man.png" class="img-fluid" />
          </div>
        </div>
      </div>

      <div class="top-bottom">
        <div class="d-flex">
          <div
            class="top-text d-flex justify-content-center align-items-center"
          >
            <h1 class="text-center top-home-text">
              Go Fix It Now <a href="" style="color: #fff"><u>Terms </u> </a>
            </h1>
          </div>

          <div class="home-image-box">
            <img src="img/terms_box_img.png" class="img-fluid" />
          </div>
        </div>
      </div>
    </header>

    <section class="service-categories">
      <h1 class="text-center">Go Fix It Now ltd Terms & Conditions</h1>

      <br />
      <br />
      <p>
        These Terms of Service serve as a legally binding agreement between you
        and Go Fix It Now, governing your utilization of the Go Fix It Now
        Platform. The Go Fix It Now Platform encompasses Go Fix It Now's website
        (www.gofixitnow.co.uk), mobile applications (referred to as the "Apps"),
        as well as associated services, information, and communications. It is
        imperative to note that all personal data you submit to the Go Fix It
        Now Platform, or that we collect about you, is subject to our Privacy
        Policy. A copy of our Privacy Policy can be found at
        <a href="privacy.php">Here</a>. <br />
        <br />
        By utilizing the Go Fix It Now Platform, you acknowledge that you have
        reviewed the Privacy Policy. Your consent during registration and
        continued use of the Go Fix It Now Platform signifies your acceptance
        and agreement to all the terms and conditions outlined in these Terms of
        Service, the Privacy Policy, and any future amendments or additions to
        this Agreement that we may publish periodically. Should any future
        changes to this Agreement be deemed unacceptable to you or result in
        non-compliance, it is your responsibility to deactivate your account and
        cease all usage of the Go Fix It Now Platform. <br />
        <br />
        The Privacy Policy is incorporated by reference into these Terms of
        Service and, together, they form the "Agreement." If you do not agree to
        be bound by this Agreement and adhere to its terms, you are prohibited
        from using or accessing the Go Fix It Now Platform. Please be aware that
        Section [19-22], which contains jurisdiction-specific provisions,
        outlines the resolution of disputes between users and Go Fix It Now. By
        acknowledging the Terms of Service and/or utilizing the Go Fix It Now
        Platform, <br />
        <br />
        you explicitly acknowledge that you have read, comprehended, and
        unconditionally agreed to be bound by this Agreement, accepting all of
        its terms. Using the Go Fix It Now Platform in a country other than the
        one in which you registered implies your acceptance and agreement to all
        the terms and conditions outlined in the Agreement applicable to that
        country Some key provisions outlined in the Terms of Service are as
        follows:

        <br /><br />

        1. Eligibility: To utilize or access the Go Fix It Now Platform, you
        must meet the minimum age requirement set by the jurisdiction in which
        you reside. For users based in the UK, this age requirement is 18 years.
        Additionally, you must possess the legal capacity to enter into binding
        contracts. <br /><br />
        2. Technology Disclaimer: You acknowledge that the technology utilized
        by the Go Fix It Now Platform is provided on an "as is" basis, without
        any warranties. <br />
        <br />
        3. Limited Liability: Go Fix It Now assumes no responsibility or
        liability for any actions taken by users on the platform or the
        performance of Fixers. It is important to note that Go Fix It Now does
        not supervise, scope, direct, control, or monitor the work carried out
        by Fixers. <br />
        <br />
        4. Client Responsibility: Clients are solely responsible for evaluating
        the qualifications of the Fixers they choose to hire. Go Fix It Now does
        not endorse or warrant the expertise or abilities of Fixers.
        <br /><br />
        5. Independent Contractor Status: Fixers are considered independent
        contractors of Clients and are not employees, independent contractors,
        or service providers of Go Fix It Now. <br /><br />
        6. Indemnification: By agreeing to these Terms of Service, you agree to
        hold Go Fix It Now harmless and indemnify the company against any claims
        arising from your use of the platform or any content submitted from your
        account. These are just a few of the important points covered in the
        Terms of Service. It is essential that you read and understand the
        complete document before using the Go Fix It Now Platform.
      </p>
      <br /><br />
      <h2>1. The Go Fix It Now Platform Connects Fixers and Clients</h2>
      <p>
        The Go Fix It Now Platform is an advanced web-based communication tool
        that facilitates seamless connections between Clients and Fixers. In
        this particular context, "Clients" refers to both individuals and
        businesses seeking short-term services, known as "Jobs," from skilled
        Fixers. Conversely, "Fixers" represent businesses that are eager to
        undertake Jobs on behalf of Clients. Collectively, Clients and Fixers
        are referred to as "Users" within this platform. It is important to note
        that when Users agree to the terms of a Job with one another, a Service
        Agreement is formed directly between the two parties involved. It is
        crucial to emphasize that Fixers operating within this platform are
        independent business owners. They function as independent contractors
        for Clients and are not to be considered employees, partners,
        representatives, agents, joint ventures, independent contractors, or
        franchisees of Go Fix It Now. It is worth mentioning that Go Fix It Now
        does not engage in any task performance nor does it employ individuals
        for such purposes. Instead, our platform serves as an online
        marketplace, connecting Clients who require services with qualified
        Service Providers (Fixers) who possess the necessary skills to undertake
        a diverse range of tasks. Users must acknowledge that Go Fix It Now does
        not supervise, scope, direct, control, or monitor the work performed by
        Fixers. As such, we explicitly disclaim any responsibility or liability
        for the quality and completion of the work performed, as well as any
        issues arising from the Jobs in any capacity.
      </p>
      <br />
      <h2>2. User Background Checks and User Representations and Warranties</h2>
      <p>
        through the chat thread, be punctual and available as agreed upon with
        your Fixer or Client, and utilize the approved third-party payment
        service provider for transactions on the platform. - You will conduct
        yourself professionally and responsibly during interactions with other
        Users. - You will use your real name or business name and an up-to-date
        photo on your profile. - You will comply with all applicable local,
        state, provincial, national, or international laws and customs while
        using the Go Fix It Now Platform, acting in good faith. - You will not
        use the platform for the purchase or delivery of alcohol, controlled
        substances, or any other illegal services. - If you are entering into
        this Agreement on behalf of a company or organization, you have the
        authority to act on its behalf and bind it to this Agreement. - Unless
        promptly disclosed to Go Fix It Now in writing, you do not possess any
        motivation, status, or interest that may reasonably concern Go Fix It
        Now in connection with the platform. Additional Representations and
        Warranties for Fixers Fixers additionally represent and warrant the
        following: - When using the Go Fix It Now Platform, you operate as a
        sole proprietor, partnership, limited liability company, limited
        liability partnership, corporation, or other business entity. - You are
        engaged in an independently established business similar to the services
        provided for Clients through the platform and maintain an independent
        clientele. - You possess the unrestricted right to work in the
        jurisdiction where you will perform Tasks. - If a Task requires a
        business license or business tax registration in a specific
        jurisdiction, you have obtained the necessary documentation. - You are
        responsible for obtaining any required licenses, permits, or
        registrations before offering services and undertaking Tasks. - You
        possess the appropriate insurance coverage for your business operations
        and services. - You will honor your commitments to other Users on the
        platform, including responding promptly to invitations, performing Tasks
        as agreed upon with Clients, and delivering high-quality services
        promptly. - You will only offer and provide services that align with
        your skills and expertise, ensuring compliance with all applicable laws.
        - You will not engage in any fraudulent, deceptive, or misleading
        practices while using the platform. - You will fulfill all tax
        obligations and legal requirements arising from your use of the Go Fix
        It Now Platform. - You will not engage in any activity that may harm the
        reputation of Go Fix It Now or its Users. - You will promptly notify Go
        Fix It Now of any changes to your registration information.
      </p>

      <br />
      <h2>3. Contract between Clients and Fixers</h2>
      <p>
        Please be advised that the formation of a legally binding contract,
        referred to as the "Service Agreement," occurs when both parties, namely
        the User and the other User, agree upon the terms of a Task. It is
        important to note that the terms of the Service Agreement encompass the
        terms outlined in Section 3, the engagement terms proposed and accepted
        on the Go Fix It Now Platform, and any other contractual terms mutually
        accepted by the Fixer and their Client, provided that these terms do not
        conflict with the terms in this Agreement, including Section 3, and do
        not expand Go Fix It Now's obligations or restrict its rights under this
        Agreement. It is crucial to understand that Go Fix It Now is not a party
        to any Service Agreement, and the formation of such an agreement does
        not establish an employment or other service relationship between Go Fix
        It Now and the Fixer, nor does it create an employment relationship
        between the Client and the Fixer. <br />
        Users are not authorized to enter into written or oral contracts,
        whether implied or express, on behalf of Go Fix It Now. Go Fix It Now's
        role, beyond facilitating connections between Clients and Fixers through
        its web-based communications platform, is to act as a limited payment
        collection agent for the Fixer. This entails facilitating payment for
        Jobs on behalf of the Fixer through the Go Fix It Now Platform using the
        PSP. It is important to note that in assuming the role of a limited
        payment collection agent, Go Fix It Now does not possess any other
        agency or authority to act on behalf of the Fixer, and therefore, it
        assumes no liability or responsibility for any actions or omissions of
        the Fixer, whether within or outside of the Go Fix It Now Platform.
        However, with the Client's prior approval, the Fixer is not obligated to
        personally perform the Task and may engage Fixer Assistants, such as
        assistants, helpers, subcontractors, or other personnel. For safety
        purposes, these Fixer Assistants must undergo a background check through
        the Go Fix It Now Platform. Failure on the part of the Fixer to comply
        with this requirement will be considered a violation of the Terms of
        Service and may result in removal from the Go Fix It Now Platform. The
        Fixer assumes full responsibility for the acts and omissions of their
        Fixer Assistants and is fully accountable for the lawful payment of
        their compensation, benefits, and expenses, as well as any necessary tax
        withholdings. It is the Client's responsibility to verify that any Fixer
        Assistants are registered Fixers on the Go Fix It Now Platform, as the
        Client enters into separate Service Agreements with the Fixer and each
        Fixer Assistant. When using the Go Fix It Now Platform, Clients have the
        sole discretion to decide whether they will be present during the Task
        or not. <br />
        Clients who choose not to be present during the Task acknowledge that if
        someone else books the Task on their behalf or is present during its
        execution, they are appointing that person as their agent, referred to
        as the "Client's Agent." In such cases, the Fixer may take direction
        from the Client's Agent as if it were given by the Client themselves.
        <br />
        If you are acting as a Client's Agent and using the Go Fix It Now
        Platform on behalf of a Client, you confirm that you have the authority
        to act as their agent and bind them to all provisions of the Terms of
        Service. The Client assumes full responsibility for the acts and
        omissions of their Client's Agents. It is important to note that the
        Client's Agents are considered third parties for the Happiness Pledge
        and are therefore excluded from it. The Client is obligated to fully
        compensate their Fixer(s) for all Task services through the PSP, as
        indicated on the Go Fix It Now Platform, at the agreed-upon rates
        specified in the Service Agreement. Each User must comply with the
        Service Agreement and this Agreement throughout the engagement,
        performance, and completion of a Job.
      </p>
      <br />
      <h2>4. Billing and Payment</h2>
      <p>
        Users of the Go Fix It Now Platform engage in contractual agreements for
        Tasks directly with other Users. It is important to note that Go Fix It
        Now does not participate as a party in any contracts for Tasks or
        services. Payment for services facilitated through the Go Fix It Now
        Platform is made directly from the Client to the Fixer via the Payment
        Service Provider (PSP), and not through Go Fix It Now. It is important
        to understand that Go Fix It Now is not obligated to compensate the
        Fixer if the Client fails to make payment for services. To ensure a
        smooth transaction, the Task Payment, service charge, and platform fee
        must be paid through the PSP. Users of the Go Fix It Now Platform will
        be required to provide their payment method details to both Go Fix It
        Now and the PSP. <br />

        Fixers hold the responsibility of accurately invoicing their Clients
        within 24 hours of completing the work, regardless of whether the job is
        fully completed or ongoing in nature. Clients are expected to fulfill
        the payment obligation outlined in the invoice(s) for each Job. This
        invoice will include the agreed-upon pricing terms for the Task provided
        by the Fixer, any agreed-upon out- of-pocket expenses, the service
        charge assessed by Go Fix It Now for the use of the platform, and the
        platform fee (also known as Trust & Support Fee) assessed by Go Fix It
        Now to cover various business objectives such as customer support and
        the Happiness Pledge. In certain cases, cancellation fees may also be
        applicable. <br />
        It is important to note that any tips or gratuities added by the Client
        or at their direction will go directly to the Fixer. Additionally,
        Clients may be subject to credit card processing fees equal to 3% of the
        total expenses if the expenses related to a Job individually or
        collectively within 30 days exceed £300. Fixers are responsible for
        paying registration fees (if applicable), cancellation fees (if
        applicable), and repayment of any erroneous payments.
        <br />
        Fixers are required to set up an account with the PSP, which may involve
        registration, agreement to the PSP Services Agreement, and completion of
        a vetting process or account validation as requested by the PSP. By
        accepting these Terms of Service, each Fixer acknowledges that they have
        reviewed and agreed to the PSP Services Agreement. It is important to
        note that Go Fix It Now is not a party to the PSP Services Agreement and
        holds no obligations, responsibilities, or liabilities towards any Fixer
        or other party under the PSP Services Agreement.
        <br />
        To ensure the security of User information and prevent fraud, Go Fix It
        Now and/or the PSP may validate an account before activation and before
        each booking. As part of this validation process, temporary charges may
        be placed on the associated account and subsequently refunded within 1-3
        business days. The amount of the temporary charge may vary depending on
        the estimated value of the Task and expenses, due to varying
        requirements from the PSP and credit card issuers.
        <br />
        Upon receiving confirmation through the Go Fix It Now Platform or via
        email that a Job has been completed, the Client automatically authorizes
        the PSP to process the corresponding invoice(s). In the event of a
        cancellation or failure to appear at the scheduled time for performance,
        Users may be billed a one-hour cancellation fee at the Fixer's hourly
        rate through the PSP.
        <br />
        Go Fix It Now reserves the right, though not the obligation, to take
        certain actions in response to requests from Clients or Fixers, or upon
        notice of potential fraud, unauthorized charges, or misuse of the
        platform. These actions may include placing a hold on Job Payments,
        out-of-pocket expenses, tips, or gratuities (if applicable), or
        arranging for refunds or credits through the PSP. Users of the Go Fix It
        Now Platform are responsible for any taxes, including VAT, that are
        required to be paid on the Tasks provided under the Agreement.
      </p>
      <br />
      <h2>5. Contests, Gift Cards, and Promotional Codes</h2>
      <p>
        Go Fix It Now may occasionally offer promotional opportunities and
        contests to our Users. These promotions are solely at the discretion of
        Go Fix It Now and can be implemented, modified, or removed without prior
        notice. The liability of Go Fix It Now, its Affiliates, and corporate
        partners about these promotions is subject to the limitations outlined
        in Section 17 of our Terms of Service. We provide Go Fix It Now gift
        cards ("Gift Cards") and promotional codes ("Promo Codes") that can be
        used to partially or fully pay for Task Payments and our service charge
        and platform fee. However, they cannot be used for reimbursement of
        out-of-pocket expenses or tips associated with a Task provided through
        the Go Fix It Now Platform. (a) Promo Codes: <br />
        Promo Codes are offered by Go Fix It Now to reduce the amount a Client
        pays for a Task Payment, service charge, and/or platform fee. The use of
        Promo Codes does not affect the amount received by a Fixer. Promo Codes
        are intended solely as a promotional initiative and do not create a
        relationship between Go Fix It Now, the Fixer, or the Client, nor do
        they constitute wages, fees, or other payments to the Fixer. <br />
        You must use Promo Codes by their specific terms and conditions. Each
        new user can only use a Promo Code once, regardless of the email address
        used during registration. Go Fix It Now reserves the right to withhold
        or deduct credits or benefits obtained through the use of a Promo Code
        if it was used in error, fraudulently, illegally, or in violation of the
        applicable terms and conditions or this Agreement. (b) Gift Cards: Gift
        cards can only be used for Jobs performed on the Go Fix It Now Platform,
        and they are non-replaceable if lost or stolen. They have no expiration
        date and no cash value, except as required by law.
        <br />
        Gift Cards must be directly entered into the Client account and cannot
        be accepted by Fixers as a payment method. Gift Cards cannot be combined
        with other Gift Cards, gift certificates, or Promo Codes. There is no
        associated credit card, credit line, overdraft protection, or deposit
        account with Gift Cards. Reloading or adding value to Gift Cards is not
        currently possible. If a Gift Card's balance is insufficient to cover a
        purchase, the Gift Card holder must pay the remaining amount through
        another means. Unused Gift Card balances are non-transferable.
        <br />
        Go Fix It Now reserves the right to correct the balance of a Gift Card
        if a billing error is identified. We also reserve the right to limit the
        quantity of Gift Cards purchased by individuals or entities and to
        cancel a Gift Card if it was obtained through fraudulent or unauthorized
        means. The use of Gift Cards is subject to this Agreement, and using a
        Gift Card signifies acceptance of these terms and conditions.
        <br />
        You agree to adhere to all terms and conditions related to Gift Cards.
      </p>
      <br />
      <h2>6. Public Areas; Acceptable Use</h2>
      <p>
        The Go Fix It Now Platform is equipped with various features, including
        profiles, email systems, blogs, message boards, reviews, ratings, task
        postings, chat areas, news groups, forums, communities, and other
        communication facilities ("Public Areas") that facilitate User
        interaction. These Public Areas are intended solely for relevant and
        appropriate communication among Users. To maintain the safety and
        integrity of the Go Fix It Now Platform, it is advised that Users
        refrain from sharing personal contact information with other Users.
        <br />
        The Go Fix It Now Platform must not be utilized for any of the following
        purposes: - Defaming, abusing, harassing, stalking, threatening,
        intimidating, misrepresenting, misleading, or otherwise violating the
        rights of others, including Users and Go Fix It Now staff. - Publishing,
        posting, uploading, distributing, or disseminating any profane,
        defamatory, infringing, obscene, or unlawful language, material, or
        information. - Uploading files that contain software or other material
        that violates the intellectual property rights of any User, third party,
        or Go Fix It Now, or infringes upon rights of privacy or publicity.
        <br />Uploading files or scripts that may cause damage to Go Fix It Now
        or its Users' computers, such as Trojan horses, corrupt files, SQL
        injections, worms, timebombs, cancelbots, or any other harmful software.
        - Advertising or offering to sell goods or services unrelated to the Job
        services for commercial purposes on the Go Fix It Now Platform. -
        Posting or completing Tasks that involve the purchase of gift cards or
        money orders without obtaining pre-authorization from Go Fix It Now,
        <br />
        posting ratings or reviews on third-party websites in violation of their
        terms of use, or engaging in any illegal, dangerous, harmful, or
        otherwise inappropriate activity as determined by Go Fix It Now in its
        sole discretion. - Conducting or forwarding surveys, contests, pyramid
        schemes, or chain letters. - Impersonating another person or allowing
        any other person or entity to use your user profile to post or view
        comments. While using the Go Fix It Now Platform, it is prohibited to: -
        Use the platform for unauthorized or illegal purposes, including posting
        or performing Tasks in violation of local, state, provincial, national,
        or international law.
        <br />
        Post or upload content without obtaining the necessary rights and
        permissions to do so. - Spam by repeatedly posting the same Task. -
        Download files posted by other Users that are known or reasonably should
        be known to be illegally distributed. - Restrict or inhibit other Users
        from using and enjoying the Public Areas. - Imply or state that any
        statements made, whether on or off the Go Fix It Now Platform, are
        endorsed by Go Fix It Now without prior written consent. <br />Use
        automated processes or devices to collect, mine, republish,
        redistribute, transmit, sell, license, download, manage, or index the Go
        Fix It Now Platform or the personal information of others. - Frame or
        enclose the Go Fix It Now Platform or any portion thereof. - Hack or
        interfere with the Go Fix It Now Platform, its servers, or any connected
        networks. - Adapt, alter, license, sublicense, or translate the Go Fix
        It Now Platform for personal or commercial use. - Remove, alter, or
        misuse any copyrights, trademarks, or proprietary marks or rights owned
        by Go Fix It Now and Affiliates. <br />
        Upload offensive and/or harmful content, including content that promotes
        racism, bigotry, hatred, or physical harm against any individual or
        group. - Upload content that exploits people in an abusive, violent, or
        sexual manner. - Use the platform to solicit for other businesses,
        websites, or services, or to contact Users for employment, contracting,
        or any purpose unrelated to the use of the Go Fix It Now Platform as
        outlined in this agreement. - Collect the personal information of Users
        through electronic or other means. - Use the Go Fix It Now Platform or
        Task services in violation of this agreement. <br />
        Use the Go Fix It Now Platform falsely or misleadingly, or to access or
        obtain Go Fix It Now's trade secret information for public disclosure or
        other purposes. - Attempt to circumvent the payments system, service
        charge, or platform fee, such as by making or processing payments
        outside of the Go Fix It Now Platform, providing inaccurate information
        on invoices, or invoicing fraudulently. - Register under different
        usernames or identities after account suspension or termination, or
        register using multiple usernames or false identities, or register using
        a false or disposable email or phone number. <br />
        Encourage any third party to engage in the aforementioned restricted
        activities. - Utilize tools to mask your IP address, such as the TOR
        network. Please note that all submissions made to Public Areas will be
        publicly accessible, and you will be identified by your name or login
        identification when communicating in these areas. Go Fix It Now is not
        responsible for the actions of Users regarding any information or
        materials posted in Public Areas.
      </p>
      <br />
      <h2>7. Mobile App Updates and Upgrades</h2>
      <p>
        By installing the application(s), you hereby acknowledge and grant
        consent to the installation of the aforementioned application(s) and any
        subsequent updates or upgrades that may be released through the Go Fix
        It Now Platform. It is important to note that the application(s),
        including any updates or upgrades, may initiate automatic communication
        between your device and Go Fix It Now's servers to facilitate the
        functionality of the application(s) and record usage metrics.
        Furthermore, it is possible that the application(s) may impact your
        device's preferences or data associated with the application(s), and may
        also collect personal information in accordance with our Privacy Policy.
        It is within your prerogative to uninstall the application(s) at your
        discretion.
      </p>
      <br />
      <h2>8. Deactivation and Suspension</h2>
      <p>
        In the event of a potential breach of this Agreement, Go Fix It Now
        reserves the right to suspend your access to the Go Fix It Now Platform
        pending an investigation. If it is determined that you have breached any
        provision of this Agreement, Go Fix It Now may deactivate your account
        or impose limitations on your use of the platform. You will be notified
        in writing of this determination and if you wish to appeal, please
        contact policies@gofixitnow.com within 14 days of receiving the notice,
        providing grounds for your appeal. <br />
        If your account is suspended, deactivated, or limited as per Section 8,
        you are strictly prohibited from creating a new account using your name,
        a fictitious name, or the name of any third party, even if you are
        acting on their behalf. This Agreement will remain legally binding even
        after your access to the Go Fix It Now Platform is suspended,
        terminated, or limited, and Go Fix It Now reserves the right to take
        appropriate legal action by the terms of this Agreement. <br />
        Go Fix It Now reserves the sole discretion to modify or discontinue any
        part of the Go Fix It Now Platform, whether temporarily or permanently.
        You will be notified of any such modifications or discontinuations as
        required by law. To the extent permitted by law, Go Fix It Now shall not
        be held liable for any modifications or discontinuations of the
        platform. Furthermore, Go Fix It Now has the authority to restrict
        individuals from completing registration as a Fixer if their presence
        poses a threat to the safety and integrity of the platform or if such
        restriction is necessary to address other reasonable business concerns.
        <br />
        You have the right to terminate this Agreement at any time by ceasing
        all use of the Go Fix It Now Platform and deactivating your account.
        However, certain provisions of this Agreement will continue to be
        enforceable even after its expiration or termination, ensuring their
        full force and effect regardless of the conclusion of this Agreement or
        your use of the Go Fix It Now Platform
      </p>
      <br />

      <h2>9. Account, Password, Security, and Telephone Communications</h2>
      <p>
        To utilize the Go Fix It Now Platform, you must complete the
        registration process and establish an account. Please note that as the
        sole authorized user of your account, it is your responsibility to
        maintain the confidentiality of any login credentials, passwords, and
        account numbers provided by you or issued to you by Go Fix It Now for
        accessing the platform. <br />
        You bear full and exclusive liability for any activities conducted under
        your password or account, even if such activities were not authorized by
        you. It is important to acknowledge that Go Fix It Now does not exercise
        control over the utilization of any user's account and explicitly
        disclaims any liability arising therefrom. If you suspect unauthorized
        usage of your password or account, or if you suspect any breach of
        security, it is incumbent upon you to promptly notify Go Fix It Now.
        Please be advised that telephone conversations involving Go Fix It Now,
        its agents, and affiliates may be subject to monitoring and recording
        for quality control and training purposes. As a user, you affirm the
        accuracy and truthfulness of any contact information provided to Go Fix
        It Now, its agents and affiliates, as well as other users. <br />
        This includes but is not limited to, your name, business name, mailing
        address, email address, residential or business telephone number, and/or
        mobile telephone number. Moreover, you confirm that you are the rightful
        subscriber or owner of any telephone number you provide, and it is
        strictly prohibited to furnish a phone number that does not belong to
        you. Should we discover that any information supplied during the
        registration process is false or inaccurate, <br />
        We reserve the right to suspend or deactivate your account. Furthermore,
        if any changes occur to your contact information, you must promptly
        inform Go Fix It Now before the implementation of said changes by
        visiting help.gofixitnow.com. In the event of a change in ownership of
        your telephone numbers, you may notify Go Fix It Now by texting "STOP"
        to any text message sent to the retiring phone number.
      </p>
      <br />

      <h2>10. User Generated Content</h2>
      <p>
        The term "User Generated Content" refers to any information and
        materials that you provide to Go Fix It Now, its corporate partners, or
        other users about your registration and use of the Go Fix It Now
        Platform, as well as your participation in promotional campaigns
        organized by Go Fix It Now. <br />
        This includes any information and materials that you post or transmit
        for use in Public Areas. It is important to note that you are solely
        responsible for your User Generated Content, and we simply act as a
        conduit for its online distribution and publication. Please be aware
        that Go Fix It Now is not involved in the creation or development of
        User Generated Content. <br />
        We do not assume any responsibility for such content and cannot be held
        liable for any claims arising from or relating to it. Additionally,
        while we do not have an obligation to monitor or review User Generated
        Content, we reserve the right to limit or remove any content that does
        not comply with the terms of our agreement. <br />
        By providing User Generated Content, you represent and warrant that it
        will be truthful, accurate, complete, and not misleading. It should not
        involve the transfer or sale of illegal, counterfeit, or stolen items.
        Furthermore, it should not infringe on any third party's privacy rights
        or any intellectual property rights, such as copyright, patent,
        trademark, trade secret, or rights of publicity or personality. <br />
        It should also comply with all applicable laws and regulations,
        including those governing export control, consumer protection, unfair
        competition, anti-discrimination, incitement of hatred, false or
        misleading advertising, anti-spam, and privacy. Additionally, your
        content should not be defamatory, libelous, malicious, threatening,
        harassing, obscene, harmful to minors, or contain any viruses or
        malicious scripts. <br />
        It is important to note that your User Generated Content should not
        claim or suggest in any way that you are employed or directly affiliated
        with Go Fix It Now. It should not create any liability for us or cause
        us to lose the services of our Internet Service Providers or other
        partners or suppliers. <br />
        On the Go Fix It Now Platform, you may come across User Generated
        Content in the form of reviews and ratings for specific Fixers. Please
        note that such Feedback represents the opinion of the user who provided
        it and not the opinion of Go Fix It Now. We do not verify or approve
        Feedback and cannot be held responsible or liable for it. We encourage
        users to provide objective, constructive, and honest Feedback about
        their experiences with other users. <br />
        While we are not obligated to investigate the accuracy or reliability of
        any remarks posted by users, we may choose to do so at our discretion.
        It is important to understand that Feedback allows users to share their
        experiences, and you should not complain or take action simply because
        you disagree with the feedback. If you believe that a review violates
        our agreement or our Ratings and Reviews Policy, you may request its
        removal by contacting our Support team. <br />
        Each client should conduct their own research to ensure that a specific
        Fixer has the necessary qualifications for a task. At Go Fix It Now, we
        respect the rights of others and expect our users to do the same. If you
        believe that any User Generated Content on the Go Fix It Now Platform is
        objectionable or infringes upon your rights or the rights of others, we
        encourage you to notify us. <br />
        If you come across User Generated Content that promotes crimes against
        humanity, incites hatred and/or violence, or involves child pornography,
        it is your duty to inform us immediately. Such notifications can be made
        through the Go Fix It Now platform or by sending a written communication
        to our address at 5 Brayford Square London E1 0SG.
      </p>
      <br />

      <h2>11. Links to Third-Party Websites</h2>
      <p>
        The Go Fix It Now Platform may include hyperlinks to third-party
        websites. These links should not be interpreted as an endorsement or
        affiliation with those websites, their content, or their operators. They
        are provided solely as a service for information, reference, and
        convenience. Go Fix It Now does not control these websites and is not
        responsible for their availability, accuracy, content, advertising,
        products, or services. <br />
        It is your responsibility to assess the content and usefulness of
        information obtained from these websites. You acknowledge and agree that
        Go Fix It Now is not involved in the creation or development of
        third-party websites and disclaims any responsibility for them. <br />
        Go Fix It Now cannot be held liable for any claims arising from or
        related to third-party websites. Furthermore, Go Fix It Now has no
        obligation to monitor, review, or remove links to third-party websites,
        but reserves the right to limit or remove such links at its discretion.
        <br />
        The use of any website controlled, owned, or operated by a third party
        is subject to the terms and conditions of use and privacy policies of
        those websites. Accessing such third-party websites is done at your own
        risk. Go Fix It Now explicitly disclaims any liability that may arise
        from your use or viewing of websites or other materials associated with
        links on the Go Fix It Now Platform. By using the links on the Go Fix It
        Now Platform. <br />
        You agree to hold Go Fix It Now harmless from any liability that may
        result. As part of the functionality of the Go Fix It Now Platform, you
        have the option to link your account with third- party social networking
        service providers (such as Facebook or Google). <br />
        This can be done by either providing your login information through the
        Go Fix It Now Platform or granting Go Fix It Now access to your
        Third-Party Account, as permitted by the terms and conditions of each
        Third-Party Account. You confirm that you have the right to disclose
        your Third-Party Account login information and grant Go Fix It Now
        access to your Third-Party Account without violating any terms and
        conditions, and without obligating Go Fix It Now to pay fees or be
        subject to usage limitations imposed by the third-party service
        providers.
        <br />
        By granting Go Fix It Now access to your Third-Party Accounts, you
        understand that Go Fix It Now may access, make available, and store your
        public profile and other information provided in your Third-Party
        Account, which will be accessible through your Go Fix It Now account.
        <br />This includes friend lists and additional information specified
        during the linking process. Unless otherwise stated, all content from
        Third-Party Accounts will be considered User Generated Content.
        Depending on the Third-Party Accounts you choose and your privacy
        settings, personally identifiable information or personal data that you
        post on your Third-Party Accounts may be accessible through your Go Fix
        It Now account.
        <br />
        Please note that if a Third-Party Account becomes unavailable or Go Fix
        It Now's access is terminated, the associated content may no longer be
        available on the Go Fix It Now Platform. You can disconnect your
        Third-Party Accounts from your Go Fix It Now account at any time by
        revoking permissions in your Third-Party Account settings.
        <br />Please be aware that your relationship with the third-party
        service providers associated with your Third-Party Accounts is solely
        governed by your agreements with them. Go Fix It Now does not review SNS
        Content for accuracy, legality, or non-infringement, and is not
        responsible for any SNS Content.
      </p>
      <br />

      <h2>12. Go Fix It Now Operates as an Online Marketplace</h2>
      <p>
        Go Fix It Now functions as an esteemed online platform that serves as a
        conduit between Clients and service providers (known as Fixers) who
        possess a desire to undertake a diverse range of Tasks. It is crucial to
        note that Go Fix It Now does not engage in the execution of Jobs nor
        does it employ individuals to carry out such tasks. <br />
        Fixers, operating as independent business owners, are typically involved
        in a self-established business that aligns with the nature of the
        services rendered for Clients via the Go Fix It Now Platform. It is
        important to emphasize that Go Fix It Now does not exercise control or
        direct the performance of services by Fixers, nor does it determine
        their work locations or hours. Fixers, in their capacity, provide
        services under their own name or business identity, and not under the
        auspices of Go Fix It Now.
        <br />Furthermore, Fixers are responsible for procuring the tools and
        supplies required to fulfill their services; Go Fix It Now does not
        provide any such equipment or materials. Fixers are afforded the freedom
        to maintain a clientele without any restrictions imposed by Go Fix It
        Now, and they are also at liberty to offer and provide their services
        through alternative platforms, including those in direct competition.
        <br />
        Go Fix It Now does not impose regulations on Fixers' working hours or
        terms. Additionally, Fixers possess the autonomy to accept or decline
        Clients and contracts without incurring any penalties. However, if
        Fixers chooses to accept a Client or contract via the Go Fix It Now
        Platform, it is expected that they fulfill their contractual
        obligations. The rates established for Fixers are determined by Go Fix
        It Now, with a commission of 20% retained to facilitate the provision of
        services.
        <br />It is vital to note that the Go Fix It Now Platform does not
        operate as an employment agency or business, and Go Fix It Now does not
        function as an employer for any User. Fixers acknowledge and affirm that
        they are accountable for exercising their business judgment when
        entering into Service Agreements and executing Tasks. Depending on how
        they exercise this business judgment, there exists the potential for
        individual profit or loss.
      </p>
      <br />
      <h2>13. Go Fix It Now Happiness Guarantee</h2>
      <p>
        The Go Fix It Now Happiness Guarantee, which applies to the country
        where the Job is performed, is an integral part of this Agreement and is
        incorporated by reference. Fixers possess the authority to determine the
        categories in which they are qualified to task and establish the scope
        of the Task directly with their Client. <br />
        Go Fix It Now does not oversee, monitor, or direct how a Fixer carries
        out a Task, nor does it monitor Jobs or chat threads between Users.
        Additionally, Go Fix It Now does not assume any responsibility for the
        actions of Users. Clients are strongly advised to verify with their
        Fixer that they possess the necessary qualifications to perform the Jobs
        before the Task takes place.
        <br />Go Fix It Now does not assume liability for the acts or omissions
        of Users, nor does it provide insurance coverage for any losses incurred
        by Users. However, Go Fix It Now is committed to ensuring Users'
        satisfaction with their experience using the Go Fix It Now Platform, and
        the Happiness Guarantee is designed to promote continued utilization of
        the platform. Payments made under the Happiness Guarantee are entirely
        discretionary and subject to specific conditions, limitations, and
        exclusions outlined in the Happiness Guarantee. <br />It is important to
        note that the Happiness Guarantee does not supersede any of the terms
        outlined in the Terms of Service or the Privacy Policy, including any
        limitations on liability specified in these terms. In the unlikely event
        of a conflict between the Happiness Guarantee and these Terms of
        Service, the Terms of Service take precedence over any conflicting
        interpretation of the Happiness Guarantee.
        <br />
        Lastly, it is essential to understand that the Happiness Guarantee does
        not function as insurance, and Go Fix It Now is not to be regarded as an
        insurer in the traditional sense for regulatory purposes.
      </p>
      <br />
      <h2>14. Intellectual Property Rights</h2>
      <p>
        All intellectual property, including text, graphics, editorial content,
        data, formatting, graphs, designs, HTML, look and feel, photographs,
        music, sounds, images, software, videos, typefaces, and other content,
        including Go Fix It Now designs, trademarks, and logos (collectively
        referred to as "Proprietary Material"), that users encounter on the Go
        Fix It Now Platform is the exclusive property of Go Fix It Now Ltd.
        <br />
        This ownership excludes User Generated Content, for which users grant Go
        Fix It Now a license to use as outlined in Article 10. The Proprietary
        Material is protected by all applicable copyright, patent, and other
        proprietary rights laws, both domestically and internationally. Users
        are strictly prohibited from copying, downloading, using, redesigning,
        reconfiguring, or retransmitting any content from the Go Fix It Now
        Platform without obtaining express prior written consent from Go Fix It
        Now and, if applicable, the rights holder of the User-Generated Content.
        Any unauthorized use of the Proprietary Material is expressly forbidden.
        <br />
        The service marks and trademarks associated with Go Fix It Now,
        including but not limited to Go Fix It Now, Fix It Now for Good, and
        their respective logos, are service marks owned by Go Fix It Now Ltd.
        Any other trademarks, service marks, logos, and/or trade names displayed
        on the Go Fix It Now Platform belong to their respective owners. Users
        are not permitted to copy or use any of these marks, logos, or trade
        names without obtaining the express prior written consent of the
        respective owner.
      </p>
      <br />
      <h2>15. Copyright Complaints and Copyright Agent</h2>
      <p>
        Go Fix It Now prioritizes the protection of intellectual property and
        expects its Users to adhere to the same principle. If you have a genuine
        belief that any materials provided on or through the Go Fix It Now
        Platform infringe upon your copyright or other intellectual property
        rights, we kindly request that you provide the following information to
        Go Fix It Now's Copyright Agent at: Go Fix It Now, 5 Brayford Square,
        London, E10SG, UK or copyright@gofixitnow.co.uk: - <br />
        <br />
        A comprehensive description of the copyrighted work that you claim has
        been infringed, including the URL or specific location on the Go Fix It
        Now Platform where the allegedly infringing material is visible. Please
        provide sufficient details to enable Go Fix It Now to locate the
        material, and explain the basis for your belief that an infringement has
        occurred. - Details regarding the location of the original or an
        authorized copy of the copyrighted work, such as the URL where it is
        posted or the name of the publication in which it is published.
        <br />
        Your complete contact information, including your name, address,
        telephone number, and email address. - A statement from you affirming
        your good faith belief that the disputed use is not authorized by the
        copyright owner, its agent, or the law. - A statement from you, made
        under penalty of perjury, confirming the accuracy of the information
        provided in your notice and asserting that you are the copyright owner
        or authorized to act on behalf of the copyright owner. - Your electronic
        or physical signature as the copyright owner or as the person authorized
        to act on behalf of the copyright owner. We appreciate your cooperation
        in this matter and assure you that we will handle your complaint with
        the utmost professionalism and diligence.
      </p>
      <br />
      <h2>16. Confidential Information</h2>
      <p>
        Acknowledging the importance and value of Confidential Information, it
        is imperative that you, as a user of the Go Fix It Now platform, adhere
        to the following guidelines. For the duration of your account's
        existence on Go Fix It Now, and for an additional period of ten years
        after its termination, you are strictly prohibited from disclosing,
        transferring, or utilizing any Confidential Information, unless it is
        solely to use the Go Fix It Now platform by the Terms of Service. <br />
        If it is necessary to share the Confidential Information with your
        authorized employees or agents, they must also be bound by the
        obligation to maintain its confidentiality. It is your responsibility to
        make every effort to safeguard the Confidential Information from
        unauthorized disclosure, transfer, or use. Should you become aware of
        any circumstances that may constitute unauthorized disclosure, transfer,
        or use of Confidential Information, you must promptly inform Go Fix It
        Now in writing. Upon deactivation of your User account or termination of
        this Agreement, regardless of the reason, you are required to promptly
        return all original materials and copies containing Confidential
        Information to Go Fix It Now.
        <br />
        The term "Confidential Information" encompasses all trade secrets,
        confidential and proprietary information, as well as any other data or
        information about Go Fix It Now that is not publicly known or accessible
        to third parties who could derive value from its use or disclosure. This
        includes technical data, research, product plans, services, customers,
        software, developments, inventions, processes, technology, designs,
        engineering, marketing, finances, and other proprietary materials. It
        also includes any confidential information relating to Go Fix It Now's
        business, operations, properties, staff, users, partners, or any other
        business-related information obtained in writing, orally, through
        drawings, or by observation.
      </p>
      <br />
      <h2>16. Confidential Information</h2>
      <p>
        It is acknowledged that the Confidential Information, as defined below,
        held by Go Fix It Now is a valuable and unique asset. By agreeing to
        these Terms of Service, you are bound to not disclose, transfer, or use
        any Confidential Information for any purpose other than the use of the
        Go Fix It Now Platform. This obligation extends for the lifetime of your
        account on Go Fix It Now, plus an additional 10 years thereafter. <br />
        If it is necessary to disclose the Confidential Information to your
        authorized employees and agents, they must also be bound by the same
        confidentiality obligations. You are required to make every effort to
        protect the Confidential Information from unauthorized disclosure,
        transfer, or use. If any circumstances arise that may constitute
        unauthorized disclosure, transfer, or use of the Confidential
        Information, you must promptly notify Go Fix It Now in writing. Upon
        deactivation of your User account or termination of this Agreement, for
        any reason, you are obligated to promptly return all originals and
        copies of materials containing the Confidential Information to Go Fix It
        Now.
        <br />
        The term "Confidential Information" encompasses Go Fix It Now's trade
        secrets, confidential and proprietary information, and any other
        information and data that is not generally known to the public or third
        parties who could derive value from its use or disclosure. This includes
        technical data, know-how, research, product plans, products, services,
        customers, markets, software, developments, inventions, processes,
        formulas, technology, designs, drawings, engineering, hardware
        configuration information, marketing, finances, strategic and other
        proprietary materials, as well as confidential information relating to
        Go Fix It Now's business, operations, or properties. This includes
        information about Go Fix It Now's staff, Users, partners, or any other
        business information that is disclosed or obtained in writing, orally,
        by drawings, or through observation.
      </p>
      <br />
      <h2>17. Disclaimer of Warranties</h2>
      <p>
        Use of the Go Fix It Now Platform is entirely at your own risk. The
        technology provided by the platform is offered on an "as is" basis,
        without any warranties or conditions of any kind, whether express or
        implied. This includes but is not limited to warranties or conditions of
        merchantability, fitness for a particular purpose, good and workmanlike
        services, and non-infringement. Go Fix It Now makes no warranties or
        representations regarding the accuracy or completeness of the content
        provided through the platform or the content of any linked sites. <br />
        We assume no liability or responsibility in contract, warranty, or tort
        for any errors, mistakes, or inaccuracies of content. Furthermore, we
        are not liable for any personal injury or property damage resulting from
        your access to and use of the platform, or any access to or use of our
        secure servers and/or any personal or financial information stored
        therein. We also disclaim responsibility for events beyond our
        reasonable control.
        <br />
        Go Fix It Now does not warrant, endorse, guarantee, or assume
        responsibility for any services advertised or offered by third parties
        through the platform or any linked websites. We will not be a party to
        or in any way be responsible for monitoring any transaction between you
        and other users or third-party providers of products or services.
        <br />
        As with any purchase, you should use your best judgment and exercise
        caution where appropriate. Additionally, Go Fix It Now and its
        affiliates do not warrant that access to the platform will be
        uninterrupted or error-free. We do not make any warranty regarding the
        results that may be obtained from the use of the platform, or the
        timeliness, accuracy, reliability, completeness, or content of any task,
        service, information, or materials provided through or in connection
        with the use of the platform.
        <br />We are not responsible for the conduct, whether online or offline,
        of any user. Furthermore, we do not warrant that the platform is free
        from computer viruses, system failures, worms, trojan horses, or other
        harmful components or malfunctions, including during hyperlinks to or
        from third-party websites. We will implement appropriate security
        measures to protect any personal information supplied by you.
        Notwithstanding any feature provided to expedite the selection process,
        each client is responsible for determining the task and selecting their
        fixer. Go Fix It Now does not warrant any goods or services purchased by
        a client and does not recommend any particular fixer.
        <br />
        We do not provide any warranties or guarantees regarding a fixer's
        ability, professional accreditation, registration, or license.
        Furthermore, you acknowledge and agree that Go Fix It Now is only
        willing to provide the platform if you agree to certain limitations of
        our liability to you and third parties. Therefore, you agree not to hold
        Go Fix It Now and its affiliates, or their corporate partners, liable
        for any claims, demands, damages, expenses, losses, governmental
        obligations, suits, and/or controversies of every kind and nature, known
        and unknown, suspected and unsuspected, disclosed and undisclosed,
        direct, indirect, incidental, actual, consequential, economic, special,
        or exemplary, including attorneys' fees and costs.
        <br />
        This includes liabilities that have arisen or may arise relating to your
        or any other party's use of or inability to use the platform, including
        any liabilities arising in connection with the conduct, act, or omission
        of any user, any dispute with any user, any instruction, advice, act, or
        service provided by Go Fix It Now and its affiliates, and any
        destruction of your user-generated content. Under no circumstances will
        Go Fix It Now and its affiliates or their corporate partners be liable
        for any direct, indirect, incidental, actual, consequential, economic,
        special, or exemplary damages arising out of or in any way connected
        with your use of or inability to use the platform or the task services.
        <br />
        This includes but is not limited to lost profits, loss of data, loss of
        goodwill, service interruption, computer damage, system failure, failure
        to store any information or other content maintained or transmitted by
        Go Fix It Now, the cost of substitute products or services, or
        attorneys' fees and costs. Some jurisdictions may not allow the
        exclusion of certain warranties or limitation of incidental or
        consequential damages, in which case the above limitations may not apply
        to you in their entirety.
        <br />
        Go Fix It Now and its affiliates expressly disclaim any liability that
        may arise between users of the platform. We also do not accept any
        liability concerning the quality or fitness of any work performed via
        the platform. If, notwithstanding the foregoing exclusions, it is
        determined that Go Fix It Now and its affiliates or their corporate
        partners are liable for damages, in no event will the aggregate
        liability exceed the total fees paid by you to Go Fix It Now (if you are
        a client) or the total task payments paid to you by clients (if you are
        a fixer) during the six months prior to the time such claim arose, to
        the extent permitted by applicable law.
      </p>
      <br />
      <h2>18. Indemnification</h2>
      <p>
        By accepting these terms, you acknowledge and agree to hold Go Fix It
        Now and its affiliates harmless from any liabilities arising from the
        following circumstances: <br />
        <br />
        (i) Your use or inability to use the Go Fix It Now Platform or your
        participation in it. <br />
        (ii) Your participation in Jobs, including your ability or inability to
        perform them or receive payment for them. <br />
        (iii) Your breach or violation of this agreement. <br />
        (iv) Your violation of any law or the rights of any user or third party.
        <br />
        (v) Your failure to uphold the representations and warranties outlined
        in Section 2. <br />
        (vi) Any content submitted by you or using your account on the Go Fix It
        Now Platform, including any potential infringement on third-party
        intellectual rights or illegality. <br />
        (vii) If you are a client, the actions or omissions of any agents
        representing the client. Go Fix It Now reserves the right, at its sole
        discretion, to assume the exclusive defense and control over any matter
        subject to your indemnification, at its own expense. You are prohibited
        from settling any claim or matter without prior written consent from Go
        Fix It Now.
      </p>
      <br />
      <h2>19. Dispute Resolution</h2>
      <p>
        To expedite the resolution process and minimize the costs associated
        with any potential disputes, disagreements, or claims arising from or
        about your utilization of the Go Fix It Now Platform, your affiliation
        with Go Fix It Now, Jobs, or this Agreement (including previous
        versions), ("Dispute"), both you and Go Fix It Now agree to initially
        engage in amicable negotiations for a minimum period of 30 days before
        pursuing any out-of-court settlement options (such as mediation). To
        send such notifications, your designated address shall be the one
        associated with your account, accompanied by an email copy sent to the
        email address provided to Go Fix It Now. Go Fix It Now's address for
        such notifications is as follows: Attention: Legal Go Fix It Now, 5
        Brayford Square, London, E1 0SG.
      </p>
      <br />
      <h2>20. App Store Sourced Apps</h2>
      <p>
        The conditions outlined below pertain to any application accessed or
        downloaded from the Apple AppStore, referred to as an "App Store Sourced
        Application": It is important to recognize and agree that the Agreement
        is solely between you and Go Fix It Now. Apple is not a party to this
        Agreement, except as a third-party beneficiary as described below.
        Additionally, it is crucial to note that Go Fix It Now, and not Apple,
        is exclusively responsible for the App Store Sourced Application and its
        content. <br />
        Your use of the App Store Sourced Application must adhere to the App
        Store Terms of Service. Please be aware that Apple has no obligation
        whatsoever to provide maintenance and support services for the App Store
        Sourced Application. If the App Store Sourced Application fails to meet
        any applicable warranty, you may notify Apple. <br />
        Apple will then refund the purchase price for the App Store Sourced
        Application to you. However, it is important to note that to the maximum
        extent permitted by applicable law, Apple will have no other warranty
        obligation concerning the App Store Sourced Application. Any other
        claims, losses, liabilities, damages, costs, or expenses resulting from
        a failure to meet any warranty will be the sole responsibility of Go Fix
        It Now, subject to the warranty limitations and exclusions outlined in
        this Agreement.
        <br />
        Both you and Go Fix It Now acknowledge that Apple is not responsible for
        addressing any claims you or any third party may have regarding the App
        Store Sourced Application or your possession and use of it. This
        includes, but is not limited to, product liability claims, claims of
        non- compliance with legal or regulatory requirements, and claims
        arising under consumer protection or similar legislation. In the event
        of a third-party claim alleging that the App Store Sourced Application
        or your possession and use of it infringes on their intellectual
        property rights, Go Fix It Now (and not Apple) will be solely
        responsible for investigating, defending, settling, and discharging any
        such intellectual property infringement claim, to the extent required by
        this Agreement. <br />
        Both you and Go Fix It Now acknowledge and agree that Apple, along with
        its subsidiaries, are third-party beneficiaries of this Agreement about
        your license of the App Store Sourced Application. Upon your acceptance
        of the terms and conditions of this Agreement, Apple will have the right
        (and will be deemed to have accepted the right) to enforce this
        Agreement about your license of the App Store Sourced Application
        against you as a third-party beneficiary. It is crucial to comply with
        all applicable third-party terms of agreement when using the App Store
        Sourced Application, in addition to any other terms outlined in this
        Agreement.
      </p>
      <br />
      <h2>21. No Agency; No Employment</h2>
      <p>
        This Agreement does not establish or suggest the existence of any
        agency, partnership, joint venture, employer-employee, or
        franchisor-franchisee relationship.
      </p>
      <br />
      <h2>22. General Provisions</h2>
      <p>
        Failure by Go Fix It Now to enforce any provision(s) of this Agreement
        shall not be considered a waiver of any provision or right. This
        Agreement represents the comprehensive and exclusive agreement between
        you and Go Fix It Now regarding its subject matter, superseding and
        governing any previous agreements or communications, unless otherwise
        specified in the Arbitration Agreement in Section 28A. However, this
        Agreement does not override other agreements concerning different
        subject matters that you may have with Go Fix It Now. If a provision is
        found to be partially or wholly invalid, illegal, or unenforceable, it
        will be modified or restructured to the extent necessary to ensure its
        validity, legality, and enforceability. <br />
        If modification or restructuring is not feasible, the provision will be
        removed from the Agreement without affecting the validity, legality, or
        enforceability of the remaining provisions. You acknowledge and consent
        that we have the right to assign or transfer this Agreement without
        requiring your consent, including but not limited to assignments to a
        parent or subsidiary, an acquirer of assets, or any other successor or
        acquirer. <br />
        Once the assignment of the Agreement becomes effective, Go Fix It Now
        will be released from all rights, obligations, and liabilities to you
        that arise after the effective date of the assignment, and the assignee
        entity will assume responsibility for fulfilling this Agreement. You are
        not permitted to assign or transfer this Agreement without our prior
        written approval. Any assignment made in violation of this Section 22
        will be considered null and void. This Agreement will benefit Go Fix It
        Now, its successors, and assigns.
      </p>
      <br />

      <h2>23. Licensing</h2>
      <p>
        Fixers are solely responsible for identifying and obtaining any
        necessary licenses, permits, or registrations before providing services
        and undertaking Jobs. It is important to note that certain types of
        Tasks and services may be strictly prohibited, and Fixers must exercise
        caution to avoid engaging in such prohibited Jobs and services.
        Non-compliance with these regulations may result in penalties, including
        fines and other law enforcement actions. <br />
        If you have any inquiries regarding the application of
        national/state/provincial/territorial and local laws to your Jobs and
        services on the Go Fix It Now Platform, it is advisable to seek
        appropriate legal guidance. Please be aware that Go Fix It Now does not
        supervise, scope, direct, control, or monitor a Fixer's work or
        performance of Jobs. <br />
        It is the responsibility of Clients to assess whether a Fixer possesses
        the necessary qualifications to carry out a specific Task. Clients may
        find it beneficial to consult their
        national/state/provincial/territorial or local requirements to determine
        if certain Tasks require the expertise of a licensed or registered
        professional. Additionally, Clients are encouraged to communicate with
        their Fixer regarding any potential hazards, obstacles, or impediments
        at the Task location, both visible and concealed, that may affect the
        successful completion of the jobs.
      </p>
      <br />
      <h2>24. Changes to this Agreement and the Go Fix It Now Platform</h2>
      <p>
        Go Fix It Now, as the sole authority, reserves the right to exercise its
        discretion in modifying, amending, supplementing, suspending,
        discontinuing, or removing any provisions outlined in this Agreement.
        This includes the Terms of Service, Privacy Policy, and Happiness
        Pledge. Additionally, Go Fix It Now holds the prerogative to review,
        enhance, modify, or terminate the Go Fix It Now Platform, as well as any
        content or information provided through it, either temporarily or
        permanently. Such actions may be taken at any time, with or without
        prior notice, and without incurring any liability on the part of Go Fix
        It Now. <br />
        We will make reasonable efforts to inform you of any significant changes
        to this Agreement via email. However, please note that we cannot be held
        liable for any failure to do so. If any future alterations to this
        Agreement are unacceptable to you or lead to non-compliance with its
        terms, it is imperative that you deactivate your account and immediately
        cease using the Go Fix It Now Platform. <br />
        By continuing to use the Go Fix It Now Platform after any modifications
        to this Agreement, you fully and irrevocably accept all such changes,
        unless prohibited by applicable laws or regulations in your
        jurisdiction. Furthermore, Go Fix It Now reserves the right to impose
        restrictions on certain features or limit your access to all or a
        portion of the Go Fix It Now Platform without prior notice or liability.
      </p>
      <br />
      <h2>25. No Rights of Third Parties</h2>
      <p>
        The provisions outlined in this Agreement are exclusively intended for
        the benefit of the Parties involved, as well as their successors and
        permitted assigns. It is important to note that these provisions should
        not be interpreted as conferring any rights upon third parties, except
        those specifically outlined in Section 20. Furthermore, this Agreement
        does not provide any person or entity, other than the User, with any
        interest, remedy, claim, liability, reimbursement, cause of action, or
        any other form of legal recourse about the agreements or provisions
        contained herein or anticipated hereby. It is imperative to understand
        that individuals who are not party to this Agreement are not entitled to
        enforce any of its terms. However, it should be noted that a Client's
        Agent may act on behalf of their respective Client.
      </p>
      <br />
      <h2>26. Notices and Consent to Receive Notices Electronically</h2>
      <p>
        By agreeing to this Agreement, you hereby acknowledge and consent to
        receive any agreements, notices, disclosures, and other communications
        (hereinafter referred to as "Notices") electronically. These Notices may
        be delivered to you via email or by posting them on the Sites. It is
        understood that all electronically provided Notices fulfill any legal
        requirement for written communication. In the absence of any specific
        instructions in this Agreement, all Notices about this Agreement must be
        in writing and shall be considered duly given upon receipt. This
        includes personal delivery, certified or registered mail with return
        receipt requested, electronic confirmation of receipt via facsimile or
        email, or on the date indicated as delivered according to the tracking
        information provided by a recognized overnight delivery service if sent
        for next-day delivery by such service. Should you have any inquiries
        about these Terms of Service or the Go Fix It Now Platform, please do
        not hesitate to contact us. You may reach us via email at
        help@gofixitnow.co.uk or by mail at the following address: 5 Brayford
        Square, London, E1 0SG, United Kingdom.
      </p>
      <br />
      <h2>27. Consent to Electronic Signatures</h2>
      <p>
        By utilizing the Go Fix It Now Platform, you hereby grant consent to
        engage in electronic transactions exclusively through the aforementioned
        platform. It is duly noted that your electronic signature holds equal
        legal significance as your handwritten signature. Additionally, you
        affirm that your selection of an item, button, icon, or any comparable
        action using a keypad, mouse, or other device shall be regarded as your
        signature, equivalent to a manual signing. Furthermore, you explicitly
        acknowledge that the validity of your electronic signature does not
        necessitate any certification authority or third-party authentication,
        and the absence thereof shall not impede the enforceability of said
        electronic signature.
      </p>
      <br />
      <h2>Worker Classification and Withholdings:</h2>
      <p>
        Go Fix It Now does not have a roster of Fixers in its employ. It is
        important to note that Go Fix It Now cannot be held accountable for any
        workers' compensation or tax obligations, including but not limited to
        sales taxes, unemployment or employment insurance, social security,
        disability insurance, or any other relevant federal or state
        withholdings that may arise from a User's utilization of the Go Fix It
        Now Platform. It is the responsibility of each User to accurately
        classify their workers by pertinent legal regulations.
      </p>
      <br />
      <h2>Media and User-Generated Content:</h2>
      <p>
        By accepting the terms outlined in this agreement, you are granting Go
        Fix It Now a non-exclusive, worldwide, perpetual, irrevocable,
        royalty-free, fully paid, unrestricted, sublicensable (through multiple
        tiers), and transferable right to exercise all copyrights, publicity
        rights, and any other rights you have in your User Generated Content and
        any accompanying Media. <br />
        This includes but is not limited to any videotape, film, recording,
        photograph, voice, or sound effects that you provide to Go Fix It Now.
        In exchange for the use of the Go Fix It Now Platform, you authorize Go
        Fix It Now to utilize your User Generated Content and Media in any media
        format, known or unknown, for marketing, operating, and improving upon
        the Go Fix It Now Platform. This includes the following rights. <br />
        The ability to use, view, copy, adapt, modify, distribute, license,
        transfer, publicly display, perform, transmit, stream, broadcast,
        access, view, and otherwise exploit your Media and User Generated
        Content. - The permission to exhibit, distribute, display, transmit, and
        broadcast your Media or User Generated Content (or portions thereof) on
        any media platforms, including the Internet. Additionally, Go Fix It Now
        may use, reproduce, modify, or create derivatives of your User Generated
        Content or Media, including your picture, silhouette, and other
        reproductions of your physical likeness. <br />
        The ability to use, view, copy, adapt, modify, distribute, license,
        transfer, publicly display, perform, transmit, stream, broadcast,
        access, view, and otherwise exploit your Media and User Generated
        Content. - The permission to exhibit, distribute, display, transmit, and
        broadcast your Media or User Generated Content (or portions thereof) on
        any media platforms, including the Internet. Additionally, Go Fix It Now
        may use, reproduce, modify, or create derivatives of your User Generated
        Content or Media, including your picture, silhouette, and other
        reproductions of your physical likeness. <br />
        The right to reproduce any recordings of your voice, as well as any
        related instrumental, musical, or sound effects, made in connection with
        the Go Fix It Now Platform or any promotional campaigns. - The ability
        to use your Media, Physical Likeness, and Voice in the advertising,
        marketing, and/or publicizing of the Go Fix It Now Platform across all
        media formats and distribution channels. - The right to use your name
        and identity in connection with the Go Fix It Now Platform or any
        promotional campaigns. Furthermore, by agreeing to these terms, you are
        waiving any moral rights associated with the Media. You warrant and
        represent that you have the lawful authority to grant these rights and
        that they do not negatively impact any third-party rights. <br />
        It is important to note that Go Fix It Now will not provide any
        financial or other remuneration for the use of your Media, Physical
        Likeness, or Voice, whether it be for initial transmission or subsequent
        playback. By accepting these terms, you release Go Fix It Now and its
        affiliates from any claims or causes of action, known or unknown,
        including but not limited to defamation, invasion of privacy, data
        protection, publicity or personality rights, or any similar matters,
        related to the use and exploitation of your identity, Physical Likeness,
        Media, or Voice in connection with the Go Fix It Now Platform.
      </p>
      <br />
      <h2>28. ACKNOWLEDGEMENT AND CONSENT:</h2>
      <br />
      <h4>
        I HEREBY AFFIRM MY COMPREHENSION AND ACCEPTANCE OF THE AFOREMENTIONED
        TERMS OF SERVICE, ALONG WITH THE PRIVACY POLICY AND HAPPINESS PLEDGE. I
        ACKNOWLEDGE THAT MY UTILIZATION OF THE GO FIX IT NOW PLATFORM IS A CLEAR
        INDICATION OF MY CONSENT TO BE LEGALLY BOUND BY THE TERMS AND CONDITIONS
        OUTLINED IN THIS AGREEMENT.
      </h4>
      <br />
      <p>
        I HEREBY ACKNOWLEDGE THAT I HAVE READ AND UNDERSTAND THE FOREGOING TERMS
        OF SERVICE, AS WELL AS THE PRIVACY POLICY AND HAPPINESS PLEDGE, AND
        AGREE THAT MY USE OF THE GO FIX IT NOW PLATFORM IS AN ACKNOWLEDGMENT OF
        MY AGREEMENT TO BE BOUND BY THE TERMS AND CONDITIONS OF THIS AGREEMENT.
      </p>
      <br />
    </section>

    <footer class="desktop-view">
      <div class="container-fluid">
        <div class="row">
          <div class="col-xl-3">
            <h2>Download our app</h2>
            <img src="img/app_store.png" class="img-fluid" /> <br />
            <img src="img/play_store.png" class="img-fluid" />
          </div>

          <div class="col-xl-3">
            <br />
            <h1>Discover</h1>
            <br />
            <ul>
              <li><a href="">Become a Fixer</a></li>
              <li><a href="">Services By City</a></li>
              <li><a href="">All Services</a></li>
              <li><a href="">Help</a></li>
            </ul>
          </div>
          <div class="col-xl-3">
            <br />
            <h1>Company</h1>
            <br />
            <ul>
              <li><a href="">About Us</a></li>
              <li><a href="">Careers</a></li>
              <li><a href="">Terms & Privacy</a></li>
            </ul>
          </div>
          <div class="col-xl-3">
            <div class="footer_logo">
              <img src="img/footer_logo.png" class="img-fluid" />
            </div>
            <div class="d-flex align-items-end f_icon">
              <h2>Follow Us</h2>
              <img src="img/linkdin.png" class="img-fluid" />
              <img src="img/fb.png" class="img-fluid" />
              <img src="img/insta.png" class="img-fluid" />

              <img src="img/utube.png" class="img-fluid ut" />
            </div>
          </div>
        </div>
      </div>
    </footer>

    <footer class="mobile-view">
      <div class="container-fluid">
        <div class="row">
          <div class="d-flex justify-content-between">
            <div class="">
              <br />
              <h1>Discover</h1>
              <br />
              <ul>
                <li><a href="">Become a Fixer</a></li>
                <li><a href="">Services By City</a></li>
                <li><a href="">All Services</a></li>
                <li><a href="">Help</a></li>
              </ul>
            </div>
            <div class="col-sm-6">
              <br />
              <h1>Company</h1>
              <br />
              <ul>
                <li><a href="">About Us</a></li>
                <li><a href="">Careers</a></li>
                <li><a href="">Terms & Privacy</a></li>
              </ul>
            </div>
          </div>

          <div class="d-flex justify-content-between">
            <div class="col-sm-6">
              <h2>Download our app</h2>
              <img src="img/app_store.png" class="img-fluid" /> <br />
              <img src="img/play_store.png" class="img-fluid" />
            </div>
            <div class="col-sm-6">
              <div class="footer_logo">
                <img src="img/footer_logo.png" class="img-fluid" />
              </div>
              <div class="d-flex align-items-end f_icon flex-wrap">
                <h2>Follow Us</h2>
                <img src="img/linkdin.png" class="img-fluid" />
                <img src="img/fb.png" class="img-fluid" />
                <img src="img/insta.png" class="img-fluid" />

                <img src="img/utube.png" class="img-fluid ut" />
              </div>
            </div>
          </div>
        </div>
      </div>
    </footer>
  </body>
  <script
    src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"
    integrity="sha384-kenU1KFdBIe4zVF0s0G1M5b4hcpxyD9F7jL+jjXkk+Q2h455rYXK/7HAuoJl+0I4"
    crossorigin="anonymous"
  ></script>
  <script
    src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"
    integrity="sha384-oBqDVmMz9ATKxIep9tiCxS/Z9fNfEXiDAYTujMAeBAsjFuCZSmKbSSUnQlmh/jp3"
    crossorigin="anonymous"
  ></script>
  <script
    src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.min.js"
    integrity="sha384-cuYeSxntonz0PPNlHhBs68uyIAVpIIOZZ5JqeqvYYIcEL727kskC66kF92t6Xl2V"
    crossorigin="anonymous"
  ></script>
</html>
