<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Login extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->library('encryption');
        $this->load->helper('string');
        $this->load->helper('cookie');
        $this->load->model('login_model','common');
        $this->load->library('email');

        /*cache control*/
        $this->output->set_header('Last-Modified: ' . gmdate("D, d M Y H:i:s") . ' GMT');
        ('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
        $this->output->set_header('Pragma: no-cache');
        $this->output->set_header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
    }

    //Default function, redirects to logged in user area
    public function index()
    {
        $check = $this->login_model->check_remember_me_token();
        if ($check) {
            redirect(base_url() . 'Site/dashboardseller', 'refresh');
        } else {
            redirect(base_url() . 'Site/', 'refresh');
        }
        // if ($this->session->userdata('login_email'))
        //     redirect(base_url() . 'Site/', 'refresh');

        // else {
        //     // Initialize empty array
        //     $data = array();
        //     $credentials = $this->login_model->check_remember_me_token();

        //     if ($credentials !== FALSE) {
        //         $data['remember'] = 'checked';
        //         $data['username'] = $credentials->username;
        //         $data['password'] = $this->encryption->decrypt($credentials->password);
        //     } else {
        //         $data['remember'] = '';
        //         $data['username'] = '';
        //         $data['password'] = '';
        //     }

        //     if ($this->session->flashdata('login_notification') === 'invalid login') {
        //         $data['login_failed'] = TRUE;
        //     } else {
        //         $data['login_failed'] = FALSE;
        //     }

        //     $this->load->view('login', $data);
        // }
    }

    // Process the login request based on credentials provided
    function process()
    {
        $username =$this->input->post('username');
        $password =$this->input->post('password');

        $confirmation = $this->login_model->check_login_credentials($username, $password);
        echo json_encode($confirmation);
       exit;
        if ($confirmation) {
            redirect(base_url() . 'Site/dashboardseller', 'refresh');
        } else {
            $this->session->set_flashdata('login_notification', 'invalid login');
            redirect(base_url() . 'Site/', 'refresh');
        }
    }

    function forgotPassword()
    {
        $username = $this->input->post('username');
        $password = time();

        $confirmation = $this->login_model->forgotPassword($username, $password);

        $this->email->from('moiz73.mg@gmail.com', 'Support');
        $this->email->to($this->input->post('email'));

        $this->email->subject('Forgot Password');
        $this->email->message('Your password has been reset. \r\n Your new password is {unwrap} ' . strval($password) . ' {/unwrap}');

        $this->email->send();

        echo json_encode($confirmation);
    }

    //signup
    function signup()
    {
        $lol = array();
        $details["email"] = $this->input->post('username');
        $details["name"] = $this->input->post('name');
        $details["password"] = $this->input->post('password');
        $details["number"] = "Null";
        $details["degree"] = "Not Available";
        $details["university"] = "Null";
        $details["imageURL"] = "Null";
        $details["description"] = "Not Available";
        $details["rating"] = 5;

        $firebase = $this->firebase->init();
        $db = $firebase->createDatabase();

        $auth = $firebase->createAuth();
        $userProperties = [
            'email' => $this->input->post('username'),
            'emailVerified' => false,

            'password' => $this->input->post('password'),
            'displayName' => $this->input->post('name'),
            'disabled' => false,
        ];
        try {
            $createdUser = $auth->createUser($userProperties);
            $signInResult = $auth->signInWithEmailAndPassword($userProperties['email'], $userProperties['password']);
            $my = $signInResult->data();
            $mydata['user_id'] = $my['localId'];
            $details["userId"] = $my['localId'];
            $details["accountId"] = $this->accountcreate($this->input->post('username'));
            $details["accountstatus"] = false;
            $this->common->adddatamodel("Users",$mydata['user_id'],$details);

         //   $postRef = $db->getReference('Users/' . $mydata['user_id'])->set($details);
           // $postKey = $postRef->getKey();
            $lol['success'] = 1;
            $auth->sendEmailVerificationLink($this->input->post('username'));
            $lol['msg'] = "Your account has been created Successfully.
            A verification email has been sent to your provided email address. 
            Please verify your email and proceed to SignIn.";
        } catch (Kreait\Firebase\Exception\Auth\EmailExists $e) {
            // Another error has occurred
            $lol['success'] = 0;
            $lol['msg'] = $e->getMessage();
        } catch (Kreait\Firebase\Exception\Auth\PhoneNumberExists $e) {
            $lol['success'] = 0;
            $lol['msg'] = $e->getMessage();
        } catch (Kreait\Firebase\Exception\InvalidArgumentException $e) {
            $lol['success'] = 0;
            $lol['msg'] = $e->getMessage();
        }

        echo json_encode($lol);
    }

    function accountcreate($email){
        $curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://www.buzzwaretech.com/bandy/api/jobriesrcreateaccount',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => array('email' => 'sheelakhan@gmail.com','country' => 'us'),
));

$response = curl_exec($curl);
//var_dump($response);
$mydata=json_decode($response,true);
// var_dump($mydata);
// curl_close($curl);
// echo "<pre>";
return $mydata['return_data'];
//echo "</pre>";
    }

    // Test page for debugging
    function test()
    {
        var_dump($this->encryption->encrypt('admin'));
    }

    // Log out of the current session
    function logout()
    {

        // Clear login credentials if any
        $this->login_model->destroy_session();
        $this->login_model->clear_remember_me_token();


        // Redirect back to main login screen
        // $this->session->set_flashdata('login_notification', 'logged_out');
        redirect(base_url() . 'Site/', 'refresh');
    }
}
