<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Orders_model extends CI_Model
{

  function __construct()
  {
    parent::__construct();
    $this->load->model('users_model');
    $this->load->model('chat_model');
    $this->load->model('common');
  }

  function getAllOrders($user)
  {
    $jak=$this->common->readdatafromcollectionbetween2where("Jobs","postedBy","!=",$lid);
    $db = $this->firebase->getdatabase();
    $orders = $db->getReference('Orders/' . $user)->getSnapshot()->getValue();
    // $data = NULL;
    // if (!empty($orders))
    //   foreach ($orders as $id => $order) {
    //     $data[$id]["budget"] = $order["budget"];
    //     $data[$id]["title"] = $order["title"];
    //     $data[$id]["note"] = $order["note"];
    //     $data[$id]["jobID"] = $order["jobID"];
    //     $data[$id]["postedAt"] = $order["postedAt"];
    //     $data[$id]["deliveredAt"] = $order["deliveredAt"];
    //     $data[$id]["status"] = $order["status"];
    //     $data[$id]["deliveryTime"] = $order["deliveryTime"];
    //     $userdata = $this->users_model->getUser($order["jobPostedBy"]);
    //     $data[$id]["offeredBy"] = $userdata["name"];
    //   }
    return $data;
  }

  function getActiveOrders($user)
  {
    $db = $this->firebase->getdatabase();
    $orders = $db->getReference('Orders/' . $user)->getSnapshot()->getValue();
    $data = NULL;
    if (!empty($orders)) {
      foreach ($orders as $id => $order) {
        if ($order["status"] != "completed") {
          $data[$id]["budget"] = $order["budget"];
          $data[$id]["title"] = $order["title"];
          $data[$id]["note"] = $order["note"];
          $data[$id]["jobID"] = $order["jobID"];
          $data[$id]["postedAt"] = $order["postedAt"];
          $data[$id]["deliveredAt"] = $order["deliveredAt"];
          $data[$id]["status"] = $order["status"];
          $data[$id]["deliveryTime"] = $order["deliveryTime"];
          $userdata = $this->users_model->getUser($order["jobPostedBy"]);
          $data[$id]["offeredBy"] = $userdata["name"];
        }
      }
    }

    return $data;
  }

  function getOrderDetails($user, $orderId)
  {
    // $db = $this->firebase->getdatabase();
    // $data = $db->getReference('Orders/' . $user . '/' . $orderId)->getSnapshot()->getValue();
    $data=$this->common->readdatadocument("Orders",$orderId);
    return $data;
  }

  function getAverageRating($user)
  {
    $db = $this->firebase->getdatabase();
    $reviews = $db->getReference('SellerReviews/' . $user)->getSnapshot()->getValue();
    if (!empty($reviews)) {
      if (count($reviews) > 0) {
        $sum = 0.0;
        foreach ($reviews as $review_by => $review) {
          $sum = $sum + (float)$review["rating"];
        }
        $avg = $sum / count($reviews);
      } else {
        $avg = "Nill";
      }
    } else {
      $avg = "Nill";
    }

    return $avg;
  }

  function getEarningInMonth($user)
  {
    $db = $this->firebase->getdatabase();
    $orders = $db->getReference('Orders/' . $user)->getSnapshot()->getValue();
    $earningInMonth = 0;
    if (!empty($orders)) {
      foreach ($orders as $id => $order) {
        if ($order["status"] == "completed") {
          $earningInMonth = ($order["budget"] * 80 / 100) + $earningInMonth;
        }
      }
    }
    return $earningInMonth;
  }
}
