<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Login extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->library('encryption');
        $this->load->helper(['string', 'cookie']);
        $this->load->model('login_model');
        $this->load->library('email');

        // Cache control headers
        $this->output->set_header('Last-Modified: ' . gmdate("D, d M Y H:i:s") . ' GMT');
        $this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate');
        $this->output->set_header('Pragma: no-cache');
        $this->output->set_header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
    }

    public function index()
    {
        $check = $this->login_model->check_remember_me_token();
        if ($check) {
            redirect(base_url('Site/dashboardseller'), 'refresh');
        } else {
            redirect(base_url('Site'), 'refresh');
        }
    }

    function process()
    {
        $username = $this->input->post('username');
        $password = $this->input->post('password');
        $confirmation = $this->login_model->check_login_credentials($username, $password);
        echo json_encode($confirmation);
    }

    function forgotPassword()
    {
        $email = $this->input->post('email');
        $password = time(); // temporary password
        $confirmation = $this->login_model->forgotPassword($email, $password);

        $this->email->from('moiz73.mg@gmail.com', 'Support');
        $this->email->to($email);
        $this->email->subject('Forgot Password');
        $this->email->message("Your password has been reset. Your new password is: $password");
        $this->email->send();

        echo json_encode($confirmation);
    }

    function signup()
    {
        $response = [];

        $details = [
            "email" => $this->input->post('username'),
            "name" => $this->input->post('name'),
            "password" => $this->input->post('password'),
            "number" => "Null",
            "degree" => "Not Available",
            "university" => "Null",
            "imageURL" => "Null",
            "description" => "Not Available",
            "rating" => 5
        ];

        $firestore = $this->firebase->getFirestore();
        $auth = $this->firebase->auth();

        $userProperties = [
            'email' => $details['email'],
            'emailVerified' => true,
            'password' => $details['password'],
            'displayName' => $details['name'],
            'disabled' => false,
        ];


        try {
            $createdUser = $auth->createUser($userProperties);
            $userId = $createdUser->uid;

            // Store user details in Firestore
            $firestore->collection('Users')->document($userId)->set($details);

            $auth->sendEmailVerificationLink($details['email']);

            $response['success'] = 1;
            $response['msg'] = "Your account has been created successfully. A verification email has been sent.";
        } catch (Kreait\Firebase\Exception\Auth\EmailExists $e) {
            $response['success'] = 0;
            $response['msg'] = "Email already exists.";
        } catch (Throwable $e) {
            $response['success'] = 0;
            $response['msg'] = $e->getMessage();
        }

        echo json_encode($response);
    }

    function test()
    {
        var_dump($this->encryption->encrypt('admin'));
    }

    function logout()
    {
        $this->login_model->destroy_session();
        $this->login_model->clear_remember_me_token();
        redirect(base_url('Site'), 'refresh');
    }
}
