<?php
defined('BASEPATH') or exit('No direct script access allowed');

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

class Site extends CI_Controller
{



	public function __construct()
	{
		parent::__construct();
		$this->load->library('firebase');
		//$this->load->model('gigs_model');
		$this->load->model('jobs_model');
		$this->load->model('users_model');
		$this->load->model('chat_model');
		$this->load->model('offers_model');
		$this->load->model('orders_model');
		$this->load->model('login_model');
		$this->load->model('categories_model');
		$this->load->library('encryption');
	}

	public function index()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
		}
		$this->data['gigs'] = $this->gigs_model->getRandomGigs();

		$this->data['categories'] = $this->categories_model->getAllCategories();
		$this->load->view('home', $this->data);
	}

	public function logout()
	{
		$this->login_model->clear_remember_me_token();
		$this->session->sess_destroy();
		redirect(base_url());
	}


	public function ordersbuyer()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['userdata'] = $this->users_model->getUser($this->session->userdata('user'));
		$this->data['activeOrders'] = $this->orders_model->getActiveOrders($this->session->userdata('user'));
		// print_r("active orders : ", $this->data['activeOrders']);
		$this->data['allOrders'] = $this->orders_model->getAllOrders($this->session->userdata('user'));



		$this->load->view('orders_buyer', $this->data);
	}

	public function gigsbuyer()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['userdata'] = $this->users_model->getUser($this->session->userdata('user'));

		$this->data['activeGigs'] = $this->gigs_model->getActiveGigs($this->session->userdata('user'));


		$this->data['allGigs'] = $this->gigs_model->getAllGigs($this->session->userdata('user'));
		$this->load->view('gigs_buyer', $this->data);
	}

	public function earningsbuyer()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->load->view('earnings_buyer');
	}

	public function workrequestbuyer($categoryId = "")
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['userdata'] = $this->users_model->getUser($this->session->userdata('user'));
		if ($categoryId != "") {
			$this->data['jobs'] = $this->jobs_model->getJobsByCategory($categoryId);
		} else {
			$this->data['jobs'] = $this->jobs_model->getAllJobs();
		}
		$this->data['categories'] = $this->categories_model->getAllCategories();
		$this->data['categoryId'] = $categoryId;
		$this->load->view('workrequest_buyer', $this->data);
	}

	public function dashboardbuyer()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['userdata'] = $this->users_model->getUser($this->session->userdata('user'));
		$this->data['gigs'] = $this->gigs_model->getGigs($this->session->userdata('user'));
		echo "gigs : ";
		print_r($this->data['gigs']);
		$this->data['inbox'] = $this->chat_model->getInbox($this->session->userdata('user'));

		$this->data['activeOrders'] = $this->orders_model->getActiveOrders($this->session->userdata('user'));
		echo "active orders : ";
		print_r($this->data['activeOrders']);
		$this->data['averageRating'] = $this->orders_model->getAverageRating($this->session->userdata('user'));
		$this->data['earningInMonth'] = $this->orders_model->getEarningInMonth($this->session->userdata('user'));

		$this->load->view('dashboard_buyer', $this->data);
	}

	public function messagebuyer()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['userdata'] = $this->users_model->getUser($this->session->userdata('user'));
		$this->data['inbox'] = $this->chat_model->getInbox($this->session->userdata('user'));
		$temp = NULL;
		if ($this->input->get('conversation') != "" && $this->input->get('conversation') != Null  && $this->input->get('conversation')) {
			$this->data['conversationWith'] = $this->input->get('conversation');
		} else {
			if ($this->data['inbox'] && $this->data['inbox'] != "" && $this->data['inbox'] != NULL)
				$temp = array_keys($this->data['inbox']);
			else
				$temp = NULL;
			if ($temp != NULL && $temp[0] != "" && $temp[0] != Null && $temp[0])
				$this->data['conversationWith'] = $temp[0];
			else
				$this->data['conversationWith'] = Null;
		}
		$this->data['conversationWithId'] = $this->data['conversationWith'];
		$this->data['chat'] = $this->chat_model->getConversationByUser($this->session->userdata('user'), $this->data['conversationWith']);
		$this->data['conversationWith'] = $this->users_model->getUsername($this->data['conversationWith']);

		$this->load->view('message_buyer', $this->data);
	}

	public function radial()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->load->view('radial-menu');
	}



	public function creategig()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$data['categories'] = $this->categories_model->getAllCategories();
		// echo "<pre>";
		// print_r($this->session->userdata('user'));
		// echo "</pre>";
		$this->load->view('create-gig', $data);
	}

	public function editgig()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data["gigId"] = $this->input->get('gigId');
		$this->data["gigDetails"] = $this->gigs_model->getGigDetails($this->session->userdata('user'), $this->data["gigId"]);
		$this->data['categories'] = $this->categories_model->getAllCategories();
		$this->load->view('edit-gig', $this->data);
	}

	public function addgigdata()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}

		$db = $this->firebase->getFirestore();
		$storage = $this->firebase->storage();
		$defaultBucket = $storage->getBucket();

		$data = $this->input->post();
		$userId = $this->session->userdata('user');
		$timestamp = time();

		$data['gigPostedBy'] = $userId;
		$data['user_id'] = $userId;
		$data['postedAt'] = $timestamp;

		// Upload helper
		$uploadImage = function ($fileKey) use ($defaultBucket) {
			if ($_FILES[$fileKey]['tmp_name'] != '') {
				$uploadedFile = $defaultBucket->upload(
					file_get_contents($_FILES[$fileKey]['tmp_name']),
					[
						'name' => "gigImage_" . rand() . "_" . time() . "_" . $_FILES[$fileKey]['name'],
					]
				);
				return $uploadedFile->info()['mediaLink'];
			}
			return "";
		};

		// Attach files if present
		$data['firstImage'] = $uploadImage('firstImage');
		$data['secondImage'] = $uploadImage('secondImage');
		$data['thirdImage'] = $uploadImage('thirdImage');
		$data['attachment'] = $uploadImage('attachment');

		$db->collection('Gigs')
			->document((string)$timestamp)
			->set($data);


		$this->session->set_flashdata("flash_message", "GiG has Been Added Successfully");
		redirect(base_url() . 'Site/creategig');
	}

	// public function addgigdata()
	// {
	// 	if (!$this->login_model->check_remember_me_token()) {
	// 		$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
	// 		redirect(base_url());
	// 	}

	// 	$db = $this->firebase->getFirestore();
	// 	$storage = $this->firebase->storage();
	// 	$defaultBucket = $storage->getBucket();

	// 	$data = $this->input->post();

	// 	// Get the logged-in user ID from session
	// 	$userId = $this->session->userdata('user'); // Make sure 'user' holds Firebase UID or consistent user ID
	// 	$timestamp = time();

	// 	// Set both fields
	// 	$data['gigPostedBy'] = $userId;
	// 	$data['user_id'] = $userId; // <- This fixes the issue

	// 	$uploadImage = function ($fileKey) use ($defaultBucket) {
	// 		if ($_FILES[$fileKey]['tmp_name'] != '') {
	// 			$uploadedFile = $defaultBucket->upload(
	// 				file_get_contents($_FILES[$fileKey]['tmp_name']),
	// 				[
	// 					'name' => "gigImage_" . rand() . "_" . time() . "_" . $_FILES[$fileKey]['name'],
	// 				]
	// 			);
	// 			return $uploadedFile->info()['mediaLink'];
	// 		}
	// 		return "";
	// 	};

	// 	// Handle uploads
	// 	$data['firstImage'] = $uploadImage('firstImage');
	// 	$data['secondImage'] = $uploadImage('secondImage');
	// 	$data['thirdImage'] = $uploadImage('thirdImage');
	// 	$data['attachment'] = $uploadImage('attachment');
	// 	$data['postedAt'] = $timestamp;

	// 	// Save to both Gigs and AllGigs
	// 	$db->collection('Gigs')
	// 		->document($userId)
	// 		->collection('UserGigs')
	// 		->document((string)$timestamp)
	// 		->set($data);

	// 	$db->collection('AllGigs')
	// 		->document((string)$timestamp)
	// 		->set($data);

	// 	$this->session->set_flashdata("flash_message", "GiG has Been Added Successfully");
	// 	redirect(base_url() . 'Site/creategig');
	// }

	// public function addgigdata()
	// {
	// 	if (!$this->login_model->check_remember_me_token()) {
	// 		$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
	// 		redirect(base_url());
	// 	}
	// 	$db = $this->firebase->getFirestore();

	// 	$storage = $this->firebase->storage();
	// 	$defaultBucket = $storage->getBucket();


	// 	$data = $this->input->post();
	// 	$data['gigPostedBy'] = $this->session->userdata('user');
	// 	$timestamp = time();

	// 	$uploadImage = function ($fileKey) use ($defaultBucket) {
	// 		if ($_FILES[$fileKey]['tmp_name'] != '') {
	// 			$uploadedFile = $defaultBucket->upload(
	// 				file_get_contents($_FILES[$fileKey]['tmp_name']),
	// 				[
	// 					'name' => "gigImage" . rand() . time() . $_FILES[$fileKey]['name'],
	// 				]
	// 			);
	// 			return $uploadedFile->info()['mediaLink'];
	// 		}
	// 		return "";
	// 	};

	// 	$data['firstImage'] = $uploadImage('firstImage');
	// 	$data['secondImage'] = $uploadImage('secondImage');
	// 	$data['thirdImage'] = $uploadImage('thirdImage');
	// 	$data['attachment'] = $uploadImage('attachment');
	// 	$data['postedAt'] = $timestamp;

	// 	$db->collection('Gigs')
	// 		->document($data['gigPostedBy'])
	// 		->collection('UserGigs')
	// 		->document((string)$timestamp)
	// 		->set($data);


	// 	$data = $db->collection('AllGigs')
	// 		->document((string)$timestamp)
	// 		->set($data);



	// 	$this->session->set_flashdata("flash_message", "GiG has Been Added Successfully");
	// 	redirect(base_url() . 'Site/creategig');
	// }

	public function editgigdata()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}

		$db = $this->firebase->getFirestore();
		$storage = $this->firebase->storage();
		$defaultBucket = $storage->getBucket();

		$data = $this->input->post();
		$userId = $this->session->userdata('user');
		$gigId = $data["gigId"];

		$data['gigPostedBy'] = $userId;
		$data['user_id'] = $userId; // 🔁 Keep consistent with your gig schema

		// Uploading images
		$uploadImage = function ($fileKey) use ($defaultBucket) {
			if (!empty($_FILES[$fileKey]['tmp_name'])) {
				$uploadedFile = $defaultBucket->upload(
					file_get_contents($_FILES[$fileKey]['tmp_name']),
					[
						'name' => "gigImage" . rand() . time() . $_FILES[$fileKey]['name'],
					]
				);
				return $uploadedFile->info()['mediaLink'];
			}
			return null;
		};

		if ($url = $uploadImage('firstImage')) $data['firstImage'] = $url;
		if ($url = $uploadImage('secondImage')) $data['secondImage'] = $url;
		if ($url = $uploadImage('thirdImage')) $data['thirdImage'] = $url;
		if ($url = $uploadImage('attachment')) $data['attachment'] = $url;

		// ✅ Save directly in Gigs/{gigId}
		$db->collection('Gigs')
			->document($gigId)
			->set($data, ['merge' => true]);

		$this->session->set_flashdata("flash_message", "GiG has Been Edited Successfully");
		redirect(base_url() . 'Site/gigdetailbuyer/' . $gigId);
	}



	public function gigdetailbuyer($id)
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}


		$db = $this->firebase->getFirestore();

		$userId = $this->session->userdata('user');

		$snapshot = $db->collection('Gigs')
			->document($id)
			->snapshot();

		$data['gigdetail'] = $snapshot->data();
		$data['gig_id'] = $id;

		$this->load->view('gig_detail_buyer', $data);
	}

	//--


	public function dashboardseller()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['userdata'] = $this->users_model->getUser($this->session->userdata('user'));
		$this->data['gigs'] = $this->gigs_model->getGigs($this->session->userdata('user'));
		$this->data['getRandomGigs'] = $this->gigs_model->getRandomGigs();

		$this->data['categories'] = $this->categories_model->getAllCategories();
		$this->data['likegigs'] = $this->gigs_model->getlikeGigs($this->session->userdata('user'));
		$this->data['savegigs'] = $this->gigs_model->getsavedGigs($this->session->userdata('user'));
		$this->load->view('dashboard_seller', $this->data);
	}

	public function category($catId)
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['gigs'] = $this->gigs_model->getGigsByCategory($catId);
		$this->data['categories'] = $this->categories_model->getAllCategories();
		$this->load->view('gigs_categories', $this->data);
	}

	public function searchServices()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$tag = $this->input->post('tag');
		$this->data['gigs'] = $this->gigs_model->getGigsByTags($tag);
		$this->data['categories'] = $this->categories_model->getAllCategories();
		$this->load->view('gigs_categories', $this->data);
	}

	public function serviceByCategory()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		if (!empty($this->input->get('subCategory'))) {
			$subCatId = $this->input->get('subCategory');
		}
		if (!empty($this->input->get('category'))) {
			$catId = $this->input->get('category');
		}

		if (!empty($subCatId) && $subCatId != "") {
			$this->data['gigs'] = $this->gigs_model->getGigsBySubCategory($catId, $subCatId);
		} else {
			$this->data['gigs'] = $this->gigs_model->getGigsByCategory($catId);
		}
		$this->data['categories'] = $this->categories_model->getAllCategories();
		$this->load->view('gigs_categories', $this->data);
	}

	public function postrequestseller()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$jobs = $this->jobs_model->getJobPostedBy($this->session->userdata('user'));
		$this->data['jobsCount'] = count($jobs);
		$this->data['categories'] = $this->categories_model->getAllCategories();
		$this->load->view('postrequest_seller', $this->data);
	}


	public function ordersseller()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}

		$userId = $this->session->userdata('user');

		// Firestore data fetch
		$this->data['userdata'] = $this->users_model->getUser($userId);
		$this->data['activeOrders'] = $this->orders_model->getActiveOrders($userId);
		$this->data['allOrders'] = $this->orders_model->getAllOrders($userId);
		$this->data['categories'] = $this->categories_model->getAllCategories();

		$this->load->view('orders_seller', $this->data);
	}



	public function projectdetailsseller()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$order = $this->input->get();
		$this->data['orderDetails'] = $this->orders_model->getOrderDetails($this->session->userdata('user'), $order['orderId']);
		$this->load->view('projectdetails_seller', $this->data);
	}

	public function projectdetailsbuyer()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$order = $this->input->get();
		$this->data['orderDetails'] = $this->orders_model->getOrderDetails($this->session->userdata('user'), $order['orderId']);
		// print_r($this->data['orderDetails']);
		// exit;
		$this->load->view('projectdetails_buyer', $this->data);
	}


	public function profileseller()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['avgRating'] = $this->orders_model->getAverageRating($this->session->userdata('user'));
		$this->data['totalOrders'] = $this->orders_model->totalOrders($this->session->userdata('user'));
		$this->data['earning'] = $this->orders_model->getEarningInMonth($this->session->userdata('user'));
		$this->data['reviews'] = $this->orders_model->getReviews($this->session->userdata('user'));
		$this->data['userdata'] = $this->users_model->getUser($this->session->userdata('user'));
		$this->load->view('profile_seller', $this->data);
	}


	public function messageseller()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['userdata'] = $this->users_model->getUser($this->session->userdata('user'));
		$this->data['inbox'] = $this->chat_model->getInbox($this->session->userdata('user'));
		$temp = NULL;
		if ($this->input->get('conversation') != "" && $this->input->get('conversation') != Null  && $this->input->get('conversation')) {
			$this->data['conversationWith'] = $this->input->get('conversation');
		} else {
			if ($this->data['inbox'] && $this->data['inbox'] != "" && $this->data['inbox'] != NULL)
				$temp = array_keys($this->data['inbox']);
			else
				$temp = NULL;
			if ($temp != NULL && $temp[0] != "" && $temp[0] != Null && $temp[0])
				$this->data['conversationWith'] = $temp[0];
			else
				$this->data['conversationWith'] = Null;
		}
		$this->data['conversationWithId'] = $this->data['conversationWith'];
		$this->data['chat'] = $this->chat_model->getConversationByUser($this->session->userdata('user'), $this->data['conversationWith']);
		$this->data['conversationWith'] = $this->users_model->getUsername($this->data['conversationWith']);
		// echo "<pre>";
		// echo $this->session->userdata('user');
		// print_r($this->data);
		// echo "</pre>";
		$this->load->view('message_seller', $this->data);
	}
	public function gigdetailseller($user_id, $id)
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}

		$firestore  = $this->firebase->getFirestore();

		// Changed this line to match flat structure
		$gigRef = $firestore->collection('Gigs')->document($id);
		$gigSnapshot = $gigRef->snapshot();

		if (!$gigSnapshot->exists()) {
			show_404();
		}

		$my_id = $this->session->userdata('user');
		$data['gigdetail'] = $gigSnapshot->data();
		$data['gig_id'] = $id;

		// Pull correct user ID from gig data
		$data['gig_poster_id'] = $data['gigdetail']['user_id'] ?? '';

		// Favorite status
		$favRef = $firestore->collection('favoriateGig')->document($my_id)->collection('gigs')->document($id);
		$data['liked'] = $favRef->snapshot()->exists() ? "true" : "false";

		// Save status
		$saveRef = $firestore->collection('saveGig')->document($my_id)->collection('gigs')->document($id);
		$data['saved'] = $saveRef->snapshot()->exists() ? "true" : "false";

		$this->load->view('gig_detail_seller', $data);
	}


	// public function gigdetailseller($user_id, $id)
	// {
	// 	if (!$this->login_model->check_remember_me_token()) {
	// 		$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
	// 		redirect(base_url());
	// 	}

	// 	$firestore  = $this->firebase->getFirestore();


	// 	$gigRef = $firestore->collection('Gigs')->document($user_id)->collection('UserGigs')->document($id);
	// 	$gigSnapshot = $gigRef->snapshot();

	// 	if (!$gigSnapshot->exists()) {
	// 		show_404();
	// 	}

	// 	$my_id = $this->session->userdata('user');
	// 	$data['gigdetail'] = $gigSnapshot->data();
	// 	$data['gig_id'] = $id;
	// 	$data['gig_poster_id'] = $user_id;

	// 	// Favorite status
	// 	$favRef = $firestore->collection('favoriateGig')->document($my_id)->collection('gigs')->document($id);
	// 	$data['liked'] = $favRef->snapshot()->exists() ? "true" : "false";

	// 	// Save status
	// 	$saveRef = $firestore->collection('saveGig')->document($my_id)->collection('gigs')->document($id);
	// 	$data['saved'] = $saveRef->snapshot()->exists() ? "true" : "false";

	// 	$this->load->view('gig_detail_seller', $data);
	// }

	public function savegig()
	{
		$details = $this->input->post();
		$firestore = $this->firebase->getFirestore();

		$firestore->database()
			->collection('saveGig')
			->document($this->session->userdata('user'))
			->collection('gigs')
			->document($this->input->post('gig_id'))
			->set($details);
	}


	public function unsavegig()
	{
		$firestore =  $this->firebase->getFirestore();

		$firestore->database()
			->collection('saveGig')
			->document($this->session->userdata('user'))
			->collection('gigs')
			->document($this->input->post('gig_id'))
			->delete();
	}

	public function orderGig()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}

		$details = $this->input->post();
		$jobId = time();

		$details["jobID"] = $jobId;
		$details["amount"] = $details["budget"];
		$details["totalAmount"] = $details["budget"];
		$details["conversationWith"] = $details["gigPostedBy"];
		$details["note"] = $details["description"];
		$details["orderId"] = $jobId;
		$details["postedAt"] = $jobId;
		$details["status"] = "active";
		$details["deliveryTime"] = "";
		$details["deliveredAt"] = "";
		$details["offeredBy"] = $this->session->userdata('user');
		$details["jobPostedBy"] = $this->session->userdata('user');

		$jobDetails = [
			"postedBy" => $this->session->userdata('user'),
			"budget" => $details["budget"],
			"catID" => $details["catID"],
			"deliveryTime" => "",
			"posteAt" => $jobId,
			"ext" => "",
			"image_path" => "",
			"name" => $details["title"],
			"note" => $details["description"],
			"type" => ""
		];

		$db = $this->firebase->getFirestore();

		// Save job
		$db->collection('Jobs')->document((string)$jobId)->set($jobDetails);

		// Save order for buyer and seller
		$dd  = $db->collection('Orders')->document($details["jobPostedBy"])->collection('user_orders')->document((string)$jobId)->set($details);

		$db->collection('Orders')->document($details["conversationWith"])->collection('user_orders')->document((string)$jobId)->set($details);

		redirect(base_url() . 'site/ordersseller');
	}



	public function addtofavoraite()
	{
		$orderDetails = $this->input->post();
		$firestore = $this->firebase->getFirestore();

		$firestore->database()
			->collection('favoriateGig')
			->document($this->session->userdata('user'))
			->collection('gigs')
			->document($this->input->post('gig_id'))
			->set($orderDetails);
	}

	//removetofavoraite

	public function removetofavoraite()
	{
		$firestore = $this->firebase->getFirestore();

		$firestore->database()
			->collection('favoriateGig')
			->document($this->session->userdata('user'))
			->collection('gigs')
			->document($this->input->post('gig_id'))
			->delete();
	}



	public function gigs()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['gigs'] = $this->gigs_model->getGigs($this->session->userdata('login_user'));
		exit;
	}

	public function forgotPassword()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['userdata'] = $this->users_model->getUser($this->session->userdata('user'));
		$this->load->view('forgot-password', $this->data);
	}

	public function changePassword()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$data = $this->input->post();
		$data["user"] = $this->session->userdata('user');
		if ($data["password"] != $data["confirmPassword"]) {
			$this->session->set_flashdata("error_message", "New Password And Confirm Password Doesn't Match!");
			redirect($_SERVER['HTTP_REFERER'], 'refresh');
		}
		$response = $this->users_model->changePassword($data);
		if (!$response) {
			$this->session->set_flashdata("error_message", "Password Doesn't Match!");
			redirect($_SERVER['HTTP_REFERER'], 'refresh');
		}
		$this->session->set_flashdata("flash_message", "Password Updated Successfully!");
		redirect($_SERVER['HTTP_REFERER'], 'refresh');
	}

	public function addOrder()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}

		$data = json_decode($this->input->get('orderDetails'));
		$orderDetails["conversationWith"] = $data->conversationWith;
		$orderDetails["jobPostedBy"] = $data->jobPostedBy;
		$orderDetails["jobID"] = $data->jobID;
		$orderDetails["note"] = $data->note;
		$orderDetails["amount"] = $data->amount;
		$orderDetails["budget"] = $data->budget;

		$jobDetails = $this->jobs_model->getJobDetails($orderDetails["jobID"]);
		$orderDetails["title"] = $jobDetails["name"];
		$orderDetails["deliveryTime"] = $jobDetails["deliveryTime"];

		if ($orderDetails["jobPostedBy"] == $orderDetails["conversationWith"]) {
			$orderDetails["offeredBy"] = $this->session->userdata('user');
		} else {
			$orderDetails["offeredBy"] = $orderDetails["conversationWith"];
		}

		$orderDetails["deliveredAt"] = "";
		$orderDetails["status"] = "active";
		$orderDetails["orderId"] = time();
		$orderDetails["postedAt"] = $orderDetails["orderId"];

		$db = $this->firebase->getFirestore();


		$db->collection('Orders')
			->document($this->session->userdata('user'))
			->collection('UserOrders')
			->document((string) $orderDetails["orderId"])
			->set($orderDetails);

		$db->collection('Orders')
			->document($orderDetails["conversationWith"])
			->collection('UserOrders')
			->document((string) $orderDetails["orderId"])
			->set($orderDetails);

		redirect(base_url('/site/ordersseller'), 'refresh');
	}

	public function post_request()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}

		$currrnttime = strtotime(date("Y-m-d h:i:sa"));

		// Get Firebase Storage
		$storage = $this->firebase->storage();
		$defaultBucket = $storage->getBucket();

		$cat_name = "";
		$category = $this->categories_model->getCategory($this->input->post('category'));
		$cat_name = !empty($category) ? $category["name"] : "Other";

		$details = array(
			'note' => $this->input->post('description'),
			'catID' => $this->input->post('category'),
			'name' => $cat_name,
			'deliveryTime' => $this->input->post('deliveryTime'),
			'budget' => $this->input->post('budget'),
			'postedBy' => $this->session->userdata('user'),
			'posteAt' => $currrnttime,
			'attachment' => NULL,
		);

		if ($_FILES['product_file']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['product_file']['tmp_name']),
				[
					'name' => "buyerrequest" . rand() . time() . $_FILES['product_file']['name'],
				]
			);

			$details['image_path'] = $uploadedFile->info()['mediaLink'];
			$details['type'] = "file";
			$details['ext'] = pathinfo($_FILES['product_file']['name'], PATHINFO_EXTENSION);
		} else {
			$details['image_path'] = "";
			$details['type'] = "";
			$details['ext'] = "";
		}

		// Save to Firestore
		$db = $this->firebase->getFirestore();
		$db->collection('Jobs')->document((string) $currrnttime)->set($details);

		$this->session->set_flashdata("flash_message", "Request has Been Added Successfully");
		redirect(base_url() . 'Site/postrequestseller');
	}


	public function sendOffer()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}

		$details = $this->input->post();
		// $details['postedBy'] = $this->jobs_model->getJobPostedBy($this->input->post("jobId"));
		$details['jobDetails'] = $this->jobs_model->getJobPostedBy($this->input->post("jobId"));


		$currrnttime = time();
		$biderID = $this->session->userdata('user');
		// $reciverID = $details['postedBy']['postedBy'];
		$reciverID = $details['jobDetails']['postedBy'];



		$d['last_message'] = "You Send Offer";
		$d['status'] = "1";
		$d['type'] = 'offer';
		$d['time'] = $currrnttime;
		$details['time'] = $currrnttime;

		$d['offerInfo'] = $details;

		$db = $this->firebase->getFirestore();

		// Sender chat
		$db->collection('Chat')
			->document($biderID)
			->collection('MessageList')
			->document($reciverID)
			->set($d);


		$db->collection('Chat')
			->document($biderID)
			->collection('Message')
			->document($reciverID)
			->collection('Msgs')
			->document((string)$currrnttime)
			->set($d);


		// Receiver chat
		$d['last_message'] = "You Received Offer";
		$d['status'] = "0";
		$d['to'] = $biderID;

		$db->collection('Chat')
			->document($reciverID)
			->collection('MessageList')
			->document($biderID)
			->set($d);

		$db->collection('Chat')
			->document($reciverID)
			->collection('Message')
			->document($biderID)
			->collection('Msgs')
			->document((string)$currrnttime)
			->set($d);


		$dd = $this->offers_model->add_seller_offer($details);




		redirect($_SERVER['HTTP_REFERER'], 'refresh');
	}

	public function sendMessage()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}

		// Message saving logic stays in chat_model (assume it's updated for Firestore)
		$this->chat_model->add_message($this->input->post());
		redirect($_SERVER['HTTP_REFERER'], 'refresh');
	}


	// privacy policy page
	public function privacypolicynew()
	{
		$this->load->view('privacypolicynew');
	}
	public function privacypolicy()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->load->view('privacypolicy');
	}
	// terms of services page 
	public function termsofservices()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->load->view('termsofservices');
	}

	public function findafreelancer()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['gigs'] = $this->gigs_model->getRandomGigs();
		$this->data['categories'] = $this->categories_model->getAllCategories();
		$this->load->view('gigs_categories', $this->data);
	}

	public function makeSitemap()
	{

		// APPPATH will automatically figure out the correct path
		include APPPATH . 'libraries/SitemapPHP/Sitemap.php';
		require_once('application/libraries/SitemapPHP/Sitemap.php');

		// your website url
		$sitemap = new Sitemap('http://joberis.com');

		// This will also need to be set by you. 
		// the full server path to the sitemap folder 
		$sitemap->setPath('/home/jobecksm/public_html/sitemap/');

		// the name of the file that is being written to
		$sitemap->setFilename('customsitemap');

		// etc etc etc 

	}
}
