<?php
defined('BASEPATH') or exit('No direct script access allowed');

require_once APPPATH . '../vendor/autoload.php';

use Kreait\Firebase\Factory;
use Kreait\Firebase\Auth;
use Kreait\Firebase\Storage;
use Google\Cloud\Firestore\FirestoreClient;

class Firebase
{
    protected $factory;
    protected $firestore;
    protected $auth;

    public function __construct()
    {
        $this->CI = &get_instance();

        $serviceAccountPath = $this->CI->config->item('firebase_app_key');

        $this->factory = (new Factory)->withServiceAccount($serviceAccountPath);

        $this->firestore = $this->factory->createFirestore()->database();
        $this->auth = $this->factory->createAuth();
    }

    public function getFirestore()
    {
        return $this->firestore;
    }

    public function auth()
    {
        return $this->auth;
    }

    public function storage()
    {
        return $this->factory->createStorage();
    }
}
