<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Chat_model extends CI_Model
{

  function __construct()
  {
    parent::__construct();
    $this->load->model('users_model');
  }

  function getAllGigs()
  {
    $db = $this->firebase->getFirestore();
    $documents = $db->collection('AllGigs')->documents();

    $data = [];
    foreach ($documents as $doc) {
      if ($doc->exists()) {
        $data[$doc->id()] = $doc->data();
      }
    }
    return $data;
  }

  function getChat($user)
  {
    $db = $this->firebase->getFirestore();
    $documents = $db->collection('Chat')->document($user)->collections();

    $data = [];
    foreach ($documents as $collection) {
      $subDocs = $collection->documents();
      foreach ($subDocs as $doc) {
        $data[$collection->id()][$doc->id()] = $doc->data();
      }
    }
    return $data;
  }

  function getInbox($user)
  {
    $db = $this->firebase->getFirestore();
    $chatCollections = $db->collection('Chat')->document($user)->collections();

    $data = NULL;
    foreach ($chatCollections as $collection) {
      $sender = $collection->id();
      if ($sender != "MessageList") {
        $userdata = $this->users_model->getUser($sender);
        $data[$sender]["user"] = $userdata["name"] ?? "";
        $conversation = $this->getConversation($user, $sender);
        $data[$sender]["last_message"] = $conversation["last_message"] ?? "";
        $data[$sender]["time"] = $conversation["time"] ?? "";
      }
    }
    return $data;
  }

  function getConversation($user, $sender)
  {
    $db = $this->firebase->getFirestore();
    $doc = $db->collection('Chat')->document($user)->collection('MessageList')->document($sender)->snapshot();
    if ($doc->exists()) {
      return $doc->data();
    }
    return NULL;
  }

  function getConversationByUser($user, $sender)
  {
    $db = $this->firebase->getFirestore();
    if ($sender) {
      $messages = $db->collection('Chat')->document($user)->collection($sender)->orderBy('time')->documents();
    } else {
      return NULL;
    }

    $data = [];
    foreach ($messages as $doc) {
      $message = $doc->data();
      $message["sender"] = ($message["from"] == $this->session->userdata('user')) ? "You" : $this->users_model->getUsername($message["from"]);
      $data[$doc->id()] = $message;
    }
    return $data;
  }

  public function add_message($details)
  {
    $details["seen"] = "no";
    $details["time"] = time();
    $details["timeWithFormat"] = date('h:i a', time());

    $list = [
      "last_message" => $details["message"],
      "time" => $details["time"],
      "type" => $details["type"]
    ];

    $db = $this->firebase->getFirestore();

    $db->collection('Chat')->document($details["to"])->collection($details["from"])->add($details);
    $db->collection('Chat')->document($details["from"])->collection($details["to"])->add($details);

    $list["status"] = "1";
    $db->collection('Chat')->document($details["from"])->collection('MessageList')->document($details["to"])->set($list);

    $list["status"] = "0";
    $db->collection('Chat')->document($details["to"])->collection('MessageList')->document($details["from"])->set($list);

    return true;
  }

  public function add_offer($details)
  {
    if ($details["postedBy"] == $this->session->userdata('user')) {
      $details["postedBy"] = $details["to"];
    }

    $data = [
      "biderID" => $this->session->userdata('user'),
      "from" => $this->session->userdata('user'),
      "jobID" => $details['jobId'],
      "jobPostedBy" => $details['postedBy'],
      "to" => $details['postedBy'],
      'type' => "offers",
      "offerInfo" => $details,
      "time" => $details["time"]
    ];

    $db = $this->firebase->getFirestore();

    $db->collection('Chat')->document($this->session->userdata('user'))->collection($details['postedBy'])->add($data);
    $db->collection('Chat')->document($details['postedBy'])->collection($this->session->userdata('user'))->add($data);
  }
}
