<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Gigs_model extends CI_Model
{

  function __construct()
  {
    parent::__construct();
  }

  function getAllGigs()
  {
    $db = $this->firebase->getFirestore();
    $data = $db->collection('AllGigs')->documents();
    return $data;
  }


  public function getRandomGigs()
  {
    $db = $this->firebase->getFirestore();
    $gigsRef = $db->collection('Gigs')->documents();

    $data = [];

    foreach ($gigsRef as $gigDoc) {
      if (!$gigDoc->exists()) continue;

      $gigId = $gigDoc->id();
      $gig = $gigDoc->data();
      $userId = $gig['user_id'] ?? $gig['gigPostedBy'] ?? '';

      $data[$gigId] = $gig;

      // Add user info
      $userSnapshot = $db->collection('Users')->document($userId)->snapshot();
      $data[$gigId]['user_info'] = $userSnapshot->exists() ? $userSnapshot->data() : NULL;
    }

    return $data;
  }





  function getGigsByCategory($catId)
  {
    $db = $this->firebase->getFirestore();
    $gigs = $db->collection('Gigs')->where('catID', '=', $catId)->documents();

    $data = NULL;
    if (!empty($gigs)) {
      foreach ($gigs as $doc) {
        if ($doc->exists()) {
          $gig = $doc->data();
          $id = $doc->id();

          $data[$id]["catID"] = $gig["catID"] ?? "";
          $data[$id]["subCatID"] = $gig["subCatID"] ?? "";
          $data[$id]["attachment"] = $gig["attachment"] ?? "";
          $data[$id]["deliveryTime"] = $gig["deliveryTime"] ?? "";
          $data[$id]["description"] = $gig["description"] ?? "";
          $data[$id]["Premiumgigdescription"] = $gig["Premiumgigdescription"] ?? "";
          $data[$id]["Standardgigdescription"] = $gig["Standardgigdescription"] ?? "";
          $data[$id]["firstImage"] = $gig["firstImage"] ?? "";
          $data[$id]["price"] = $gig["price"] ?? "";
          $data[$id]["premiumprices"] = $gig["premiumprices"] ?? "";
          $data[$id]["standardprices"] = $gig["standardprices"] ?? "";
          $data[$id]["revisions"] = $gig["revisions"] ?? "";
          $data[$id]["secondImage"] = $gig["secondImage"] ?? "";
          $data[$id]["tags"] = $gig["tags"] ?? "";
          $data[$id]["title"] = $gig["title"] ?? "";
          $data[$id]["thirdImage"] = $gig["thirdImage"] ?? "";

          $userId = $gig["user_id"] ?? "";
          $data[$id]["user_id"] = $userId;

          if (!empty($userId)) {
            $userDoc = $db->collection('Users')->document($userId)->snapshot();
            $data[$id]["user_info"] = $userDoc->exists() ? $userDoc->data() : NULL;
          } else {
            $data[$id]["user_info"] = NULL;
          }
        }
      }
    }
    return $data;
  }

  function getGigsBySubCategory($catId, $subCatId)
  {
    $db = $this->firebase->getFirestore();
    $gigs = $db->collection('Gigs')
      ->where('catID', '=', $catId)
      ->where('subCatID', '=', $subCatId)
      ->documents();

    $data = NULL;
    if (!empty($gigs)) {
      foreach ($gigs as $doc) {
        if ($doc->exists()) {
          $gig = $doc->data();
          $id = $doc->id();

          $data[$id]["catID"] = $gig["catID"] ?? '';
          $data[$id]["subCatID"] = $gig["subCatID"] ?? '';
          $data[$id]["attachment"] = $gig["attachment"] ?? '';
          $data[$id]["deliveryTime"] = $gig["deliveryTime"] ?? '';
          $data[$id]["description"] = $gig["description"] ?? '';
          $data[$id]["Premiumgigdescription"] = $gig["Premiumgigdescription"] ?? '';
          $data[$id]["Standardgigdescription"] = $gig["Standardgigdescription"] ?? '';
          $data[$id]["firstImage"] = $gig["firstImage"] ?? '';
          $data[$id]["price"] = $gig["price"] ?? '';
          $data[$id]["premiumprices"] = $gig["premiumprices"] ?? '';
          $data[$id]["standardprices"] = $gig["standardprices"] ?? '';
          $data[$id]["revisions"] = $gig["revisions"] ?? '';
          $data[$id]["secondImage"] = $gig["secondImage"] ?? '';
          $data[$id]["tags"] = $gig["tags"] ?? '';
          $data[$id]["title"] = $gig["title"] ?? '';
          $data[$id]["thirdImage"] = $gig["thirdImage"] ?? '';

          $userId = $gig["user_id"] ?? '';
          $data[$id]["user_id"] = $userId;

          if (!empty($userId)) {
            $userDoc = $db->collection('Users')->document($userId)->snapshot();
            $data[$id]["user_info"] = $userDoc->exists() ? $userDoc->data() : NULL;
          } else {
            $data[$id]["user_info"] = NULL;
          }
        }
      }
    }
    return $data;
  }

  function getGigsByTags($tag)
  {
    $db = $this->firebase->getFirestore();
    $gigs = $db->collection('Gigs')->documents();

    $data = NULL;
    if (!empty($gigs)) {
      foreach ($gigs as $doc) {
        if ($doc->exists()) {
          $gig = $doc->data();
          $id = $doc->id();

          $tags = $gig["tags"] ?? '';
          if (stripos($tags, $tag) !== false) {
            $data[$id]["catID"] = $gig["catID"] ?? '';
            $data[$id]["subCatID"] = $gig["subCatID"] ?? '';
            $data[$id]["attachment"] = $gig["attachment"] ?? '';
            $data[$id]["deliveryTime"] = $gig["deliveryTime"] ?? '';
            $data[$id]["description"] = $gig["description"] ?? '';
            $data[$id]["Premiumgigdescription"] = $gig["Premiumgigdescription"] ?? '';
            $data[$id]["Standardgigdescription"] = $gig["Standardgigdescription"] ?? '';
            $data[$id]["firstImage"] = $gig["firstImage"] ?? '';
            $data[$id]["price"] = $gig["price"] ?? '';
            $data[$id]["premiumprices"] = $gig["premiumprices"] ?? '';
            $data[$id]["standardprices"] = $gig["standardprices"] ?? '';
            $data[$id]["revisions"] = $gig["revisions"] ?? '';
            $data[$id]["secondImage"] = $gig["secondImage"] ?? '';
            $data[$id]["tags"] = $tags;
            $data[$id]["title"] = $gig["title"] ?? '';
            $data[$id]["thirdImage"] = $gig["thirdImage"] ?? '';

            $userId = $gig["user_id"] ?? '';
            $data[$id]["user_id"] = $userId;

            if (!empty($userId)) {
              $userDoc = $db->collection('Users')->document($userId)->snapshot();
              $data[$id]["user_info"] = $userDoc->exists() ? $userDoc->data() : NULL;
            } else {
              $data[$id]["user_info"] = NULL;
            }
          }
        }
      }
    }
    return $data;
  }

  function getlikeGigs($user)
  {
    $db = $this->firebase->getFirestore();
    $data = NULL;

    $favorites = $db->collection('favoriateGig')->document($user)->collection('items')->documents();

    if (!empty($favorites)) {
      foreach ($favorites as $doc) {
        if ($doc->exists()) {
          $ck = $doc->data();
          $gigUserId = $ck['giguser_id'];
          $gigId = $ck['gig_id'];

          $gigDoc = $db->collection('Gigs')->document($gigId)->snapshot();

          if ($gigDoc->exists()) {
            $gig = $gigDoc->data();
            $id = $doc->id();

            $data[$id]["catID"] = $gig["catID"] ?? '';
            $data[$id]["subCatID"] = $gig["subCatID"] ?? '';
            $data[$id]['user_id'] = $gigUserId;
            $data[$id]["attachment"] = $gig["attachment"] ?? '';
            $data[$id]["deliveryTime"] = $gig["deliveryTime"] ?? '';
            $data[$id]["description"] = $gig["description"] ?? '';
            $data[$id]["Premiumgigdescription"] = $gig["Premiumgigdescription"] ?? '';
            $data[$id]["Standardgigdescription"] = $gig["Standardgigdescription"] ?? '';
            $data[$id]["firstImage"] = $gig["firstImage"] ?? '';
            $data[$id]["price"] = $gig["price"] ?? '';
            $data[$id]["premiumprices"] = $gig["premiumprices"] ?? '';
            $data[$id]["standardprices"] = $gig["standardprices"] ?? '';
            $data[$id]["revisions"] = $gig["revisions"] ?? '';
            $data[$id]["secondImage"] = $gig["secondImage"] ?? '';
            $data[$id]["tags"] = $gig["tags"] ?? '';
            $data[$id]["thirdImage"] = $gig["thirdImage"] ?? '';
            $data[$id]["title"] = $gig["title"] ?? '';

            $userDoc = $db->collection('Users')->document($gigUserId)->snapshot();
            $data[$id]["user_info"] = $userDoc->exists() ? $userDoc->data() : NULL;
          }
        }
      }
    }
    return $data;
  }

  function getsavedGigs($user)
  {
    $db = $this->firebase->getFirestore();
    $data = NULL;

    $saved = $db->collection('saveGig')->document($user)->collection('items')->documents();

    if (!empty($saved)) {
      foreach ($saved as $doc) {
        if ($doc->exists()) {
          $ck = $doc->data();
          $gigUserId = $ck['giguser_id'];
          $gigId = $ck['gig_id'];

          $gigDoc = $db->collection('Gigs')->document($gigId)->snapshot();

          if ($gigDoc->exists()) {
            $gig = $gigDoc->data();
            $id = $doc->id();

            $data[$id]["catID"] = $gig["catID"] ?? '';
            $data[$id]["subCatID"] = $gig["subCatID"] ?? '';
            $data[$id]['user_id'] = $gigUserId;
            $data[$id]["attachment"] = $gig["attachment"] ?? '';
            $data[$id]["deliveryTime"] = $gig["deliveryTime"] ?? '';
            $data[$id]["description"] = $gig["description"] ?? '';
            $data[$id]["Premiumgigdescription"] = $gig["Premiumgigdescription"] ?? '';
            $data[$id]["Standardgigdescription"] = $gig["Standardgigdescription"] ?? '';
            $data[$id]["firstImage"] = $gig["firstImage"] ?? '';
            $data[$id]["price"] = $gig["price"] ?? '';
            $data[$id]["premiumprices"] = $gig["premiumprices"] ?? '';
            $data[$id]["standardprices"] = $gig["standardprices"] ?? '';
            $data[$id]["revisions"] = $gig["revisions"] ?? '';
            $data[$id]["secondImage"] = $gig["secondImage"] ?? '';
            $data[$id]["tags"] = $gig["tags"] ?? '';
            $data[$id]["thirdImage"] = $gig["thirdImage"] ?? '';
            $data[$id]["title"] = $gig["title"] ?? '';

            $userDoc = $db->collection('Users')->document($gigUserId)->snapshot();
            $data[$id]["user_info"] = $userDoc->exists() ? $userDoc->data() : NULL;
          }
        }
      }
    }
    return $data;
  }

  function getGigs($user)
  {
    $db = $this->firebase->getFirestore();
    // $gigs = $db->collection('Gigs')->document($user)->collection('UserGigs')->documents();
    $gigs = $db->collection('Gigs')->where('user_id', '=', $user)->documents();


    $data = NULL;
    if (!empty($gigs)) {
      foreach ($gigs as $gigDoc) {
        if ($gigDoc->exists()) {
          $gig = $gigDoc->data();
          $id = $gigDoc->id();

          $data[$id]["catID"] = $gig["catID"] ?? '';
          $data[$id]["subCatID"] = $gig["subCatID"] ?? '';
          $data[$id]["attachment"] = $gig["attachment"] ?? '';
          $data[$id]["deliveryTime"] = $gig["deliveryTime"] ?? '';
          $data[$id]["description"] = $gig["description"] ?? '';
          $data[$id]["Premiumgigdescription"] = $gig["Premiumgigdescription"] ?? '';
          $data[$id]["Standardgigdescription"] = $gig["Standardgigdescription"] ?? '';
          $data[$id]["firstImage"] = $gig["firstImage"] ?? '';
          $data[$id]["price"] = $gig["price"] ?? '';
          $data[$id]["premiumprices"] = $gig["premiumprices"] ?? '';
          $data[$id]["standardprices"] = $gig["standardprices"] ?? '';
          $data[$id]["revisions"] = $gig["revisions"] ?? '';
          $data[$id]["secondImage"] = $gig["secondImage"] ?? '';
          $data[$id]["tags"] = $gig["tags"] ?? '';
          $data[$id]["thirdImage"] = $gig["thirdImage"] ?? '';
          $data[$id]["title"] = $gig["title"] ?? '';
        }
      }
    }
    return $data;
  }

  function getGigDetails($user, $gigId)
  {
    $db = $this->firebase->getFirestore();
    // $gigDoc = $db->collection('Gigs')->document($user)->collection('items')->document($gigId)->snapshot();
    $gigDoc = $db->collection('Gigs')->document($gigId)->snapshot();

    if ($gigDoc->exists()) {
      return $gigDoc->data();
    }
    return NULL;
  }

  function getActiveGigs($user)
  {
    $db = $this->firebase->getFirestore();
    $gigs = $db->collection('Gigs')->where('user_id', '=', $user)->documents();


    $data = NULL;
    if (!empty($gigs)) {
      foreach ($gigs as $gigDoc) {
        if ($gigDoc->exists()) {
          $gig = $gigDoc->data();
          $id = $gigDoc->id();

          $data[$id]["catID"] = $gig["catID"] ?? '';
          $data[$id]["subCatID"] = $gig["subCatID"] ?? '';
          $data[$id]["attachment"] = $gig["attachment"] ?? '';
          $data[$id]["deliveryTime"] = $gig["deliveryTime"] ?? '';
          $data[$id]["description"] = $gig["description"] ?? '';
          $data[$id]["Premiumgigdescription"] = $gig["Premiumgigdescription"] ?? '';
          $data[$id]["Standardgigdescription"] = $gig["Standardgigdescription"] ?? '';
          $data[$id]["firstImage"] = $gig["firstImage"] ?? '';
          $data[$id]["price"] = $gig["price"] ?? '';
          $data[$id]["premiumprices"] = $gig["premiumprices"] ?? '';
          $data[$id]["standardprices"] = $gig["standardprices"] ?? '';
          $data[$id]["revisions"] = $gig["revisions"] ?? '';
          $data[$id]["secondImage"] = $gig["secondImage"] ?? '';
          $data[$id]["tags"] = $gig["tags"] ?? '';
          $data[$id]["thirdImage"] = $gig["thirdImage"] ?? '';
          $data[$id]["title"] = $gig["title"] ?? '';
        }
      }
    }
    return $data;
  }
}
