<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Jobs_model extends CI_Model
{

  function __construct()
  {
    parent::__construct();
  }

  function getAllJobs()
  {
    $lid = $this->session->userdata('user');

    $db = $this->firebase->getFirestore();
    $documents = $db->collection('Jobs')->documents();
    $jak = array();

    foreach ($documents as $doc) {
      $c = $doc->data();
      if (isset($c['postedBy']) && $c['postedBy'] == $lid) {
        array_push($jak, $c);
      }
    }

    return  $jak;
  }

  function getJobsByCategory($catId)
  {
    $lid = $this->session->userdata('user');

    $db = $this->firebase->getFirestore();
    $documents = $db->collection('Jobs')->documents();
    $jak = array();

    foreach ($documents as $doc) {
      $c = $doc->data();
      if ($c['postedBy'] != $lid && $c['catID'] == $catId) {
        array_push($jak, $c);
      }
    }

    return  $jak;
  }

  function getJobPostedBy($user)
  {
    $lid = $this->session->userdata('user');

    $db = $this->firebase->getFirestore();
    $doc = $db->collection('Jobs')->document($user)->snapshot();
    return $doc->exists() ? $doc->data() : [];

    if ($doc->exists()) {
      $data = $doc->data();
      $data['jobId'] = $user;
      return $data;
    }
    return [];
  }

  public function add_job($details)
  {
    $db = $this->firebase->getFirestore();
    $db->collection('Jobs')->document($details["posteAt"])->set($details);
    return $details["posteAt"];
  }

  public function getJobDetails($jobId)
  {
    $db = $this->firebase->getFirestore();
    $doc = $db->collection('Jobs')->document($jobId)->snapshot();
    if ($doc->exists()) {
      return $doc->data();
    }
    return [];
  }
}
