<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Orders_model extends CI_Model
{
  function __construct()
  {
    parent::__construct();
    $this->load->model('users_model');
    $this->load->model('chat_model');
  }

  function getAllOrders($user)
  {
    $db = $this->firebase->getFirestore();
    $orders = $db->collection('Orders')->document($user)->collection('user_orders')->documents();
    $data = NULL;
    foreach ($orders as $doc) {
      if ($doc->exists()) {
        $order = $doc->data();
        $id = $doc->id();
        $data[$id] = [
          "budget" => $order["budget"] ?? '',
          "title" => $order["title"] ?? '',
          "note" => $order["note"] ?? '',
          "jobID" => $order["jobID"] ?? '',
          "postedAt" => $order["postedAt"] ?? '',
          "deliveredAt" => $order["deliveredAt"] ?? '',
          "status" => $order["status"] ?? '',
          "deliveryTime" => $order["deliveryTime"] ?? ''
        ];
        $userdata = $this->users_model->getUser($order["jobPostedBy"] ?? '');
        $data[$id]["offeredBy"] = $userdata["name"] ?? '';
      }
    }
    return $data;
  }

  function getActiveOrders($user)
  {
    $db = $this->firebase->getFirestore();
    $orders = $db->collection('Orders')->document($user)->collection('user_orders')->documents();
    $data = NULL;
    foreach ($orders as $doc) {
      if ($doc->exists()) {
        $order = $doc->data();
        if ($order["status"] != "completed") {
          $id = $doc->id();
          $data[$id] = [
            "budget" => $order["budget"] ?? '',
            "title" => $order["title"] ?? '',
            "note" => $order["note"] ?? '',
            "jobID" => $order["jobID"] ?? '',
            "postedAt" => $order["postedAt"] ?? '',
            "deliveredAt" => $order["deliveredAt"] ?? '',
            "status" => $order["status"] ?? '',
            "deliveryTime" => $order["deliveryTime"] ?? ''
          ];
          $userdata = $this->users_model->getUser($order["jobPostedBy"] ?? '');
          $data[$id]["offeredBy"] = $userdata["name"] ?? '';
        }
      }
    }
    return $data;
  }
  // public function getActiveOrders($userId)
  // {
  //   $db = $this->firebase->getFirestore();
  //   $orders = [];

  //   // Query all active orders where user is buyer
  //   $buyerOrders = $db->collectionGroup('user_orders')
  //     ->where('buyerId', '=', $userId)
  //     ->where('status', '!=', 'completed')
  //     ->documents();

  //   foreach ($buyerOrders as $doc) {
  //     if ($doc->exists()) {
  //       $order = $doc->data();
  //       $id = $doc->id();
  //       $orders[$id] = [
  //         "budget" => $order["budget"] ?? '',
  //         "title" => $order["title"] ?? '',
  //         "note" => $order["note"] ?? '',
  //         "jobID" => $order["jobID"] ?? '',
  //         "postedAt" => $order["postedAt"] ?? '',
  //         "deliveredAt" => $order["deliveredAt"] ?? '',
  //         "status" => $order["status"] ?? '',
  //         "deliveryTime" => $order["deliveryTime"] ?? '',
  //         "role" => "buyer"
  //       ];
  //       $userdata = $this->users_model->getUser($order["jobPostedBy"] ?? '');
  //       $orders[$id]["offeredBy"] = $userdata["name"] ?? '';
  //     }
  //   }

  //   // Query all active orders where user is seller
  //   $sellerOrders = $db->collectionGroup('user_orders')
  //     ->where('sellerId', '=', $userId)
  //     ->where('status', '!=', 'completed')
  //     ->documents();

  //   foreach ($sellerOrders as $doc) {
  //     if ($doc->exists()) {
  //       $order = $doc->data();
  //       $id = $doc->id();
  //       $orders[$id] = [
  //         "budget" => $order["budget"] ?? '',
  //         "title" => $order["title"] ?? '',
  //         "note" => $order["note"] ?? '',
  //         "jobID" => $order["jobID"] ?? '',
  //         "postedAt" => $order["postedAt"] ?? '',
  //         "deliveredAt" => $order["deliveredAt"] ?? '',
  //         "status" => $order["status"] ?? '',
  //         "deliveryTime" => $order["deliveryTime"] ?? '',
  //         "role" => "seller"
  //       ];
  //       $userdata = $this->users_model->getUser($order["jobPostedBy"] ?? '');
  //       $orders[$id]["offeredBy"] = $userdata["name"] ?? '';
  //     }
  //   }

  //   return $orders;
  // }


  function getReviews($user)
  {
    $db = $this->firebase->getFirestore();
    $reviews = $db->collection('SellerReviews')->document($user)->collection('user_orders')->documents();
    $data = NULL;
    foreach ($reviews as $doc) {
      if ($doc->exists()) {
        $order = $doc->data();
        $id = $doc->id();
        $data[$id] = [
          "comment" => $order["comment"] ?? '',
          "rating" => $order["rating"] ?? '',
          "reviewedAt" => $order["reviewedAt"] ?? '',
          "reviewedBy" => $order["reviewedBy"] ?? ''
        ];
        $userdata = $this->users_model->getUser($order["reviewedBy"] ?? '');
        $data[$id]["offeredBy"] = $userdata["name"] ?? '';
        $data[$id]["imageURL"] = (!isset($userdata["imageURL"]) || in_array($userdata["imageURL"], [NULL, "NULL", "Not Available"]))
          ? base_url("assets/images/28.png")
          : $userdata["imageURL"];
      }
    }
    return $data;
  }

  function getOrderDetails($user, $orderId)
  {
    $db = $this->firebase->getFirestore();
    $doc = $db->collection('Orders')->document($user)->collection('user_orders')->document($orderId)->snapshot();
    return $doc->exists() ? $doc->data() : NULL;
  }

  function getAverageRating($user)
  {
    $db = $this->firebase->getFirestore();
    $reviews = $db->collection('SellerReviews')->document($user)->collection('user_orders')->documents();
    $count = 0;
    $sum = 0.0;
    foreach ($reviews as $doc) {
      if ($doc->exists()) {
        $sum += floatval($doc->data()["rating"] ?? 0);
        $count++;
      }
    }
    return $count > 0 ? ($sum / $count) : "Nill";
  }

  function totalOrders($user)
  {
    $db = $this->firebase->getFirestore();
    $reviews = $db->collection('SellerReviews')->document($user)->collection('user_orders')->documents();
    $count = 0;
    foreach ($reviews as $doc) {
      if ($doc->exists()) {
        $count++;
      }
    }
    return $count > 0 ? $count : "Nill";
  }

  function getEarningInMonth($user)
  {
    $db = $this->firebase->getFirestore();
    $orders = $db->collection('Orders')->document($user)->collection('user_orders')->documents();
    $earningInMonth = 0;
    foreach ($orders as $doc) {
      if ($doc->exists()) {
        $order = $doc->data();
        if (($order["status"] ?? '') == "completed") {
          $earningInMonth += ($order["budget"] ?? 0) * 0.8;
        }
      }
    }
    return $earningInMonth;
  }
}
