<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Users_model extends CI_Model
{

  function __construct()
  {
    parent::__construct();
  }

  function getAllGigs()
  {
    $db = $this->firebase->getFirestore();
    $documents = $db->collection('AllGigs')->documents();
    $data = [];

    foreach ($documents as $doc) {
      if ($doc->exists()) {
        $data[$doc->id()] = $doc->data();
      }
    }

    return $data;
  }

  function getUser($user)
  {
    $db = $this->firebase->getFirestore();
    $doc = $db->collection('Users')->document($user)->snapshot();

    if ($doc->exists()) {
      return $doc->data();
    } else {
      return null;
    }
  }
  function getUsername($user)
  {
    if (!isset($user) || trim($user) === '') {
      log_message('error', 'getUsername called with empty user ID');
      return "";
    }

    $db = $this->firebase->getFirestore();
    $doc = $db->collection('Users')->document($user)->snapshot();

    if ($doc->exists() && isset($doc->data()["name"])) {
      return $doc->data()["name"];
    } else {
      return "";
    }
  }


  function changePassword($data)
  {
    $db = $this->firebase->getFirestore();
    $docRef = $db->collection('Users')->document($data["user"]);
    $doc = $docRef->snapshot();

    if (!$doc->exists()) {
      return FALSE;
    }

    $userData = $doc->data();

    if ($data["oldPassword"] !== $userData["password"]) {
      return FALSE;
    }

    $docRef->update([
      ['path' => 'password', 'value' => $data["password"]]
    ]);

    return TRUE;
  }
}
