<?php
if (!empty($getRandomGigs)) {
  foreach ($getRandomGigs as $gigId => $gig) { ?>
    <a href="<?php echo base_url() . 'site/gigdetailseller/' . ($gig['gigPostedBy'] ?? $gig['user_id'] ?? '') . '/' . $gigId; ?>">
      <div class="col-12 col-sm-8 col-md-6 col-lg-3">
        <div class="card car-cat-view-gigs p-3">
          <div class="two-image-rating">
            <div class="fixed-price">
              <?php if (!empty($gig['firstImage'])): ?>
                <img src="<?php echo $gig['firstImage']; ?>" alt="gig-image" style="width: 100%; height: 200px; object-fit: cover;">
              <?php else: ?>
                <img src="<?php echo base_url() . 'assets/images/default-gig.png'; ?>" alt="default-gig-image" style="width: 100%; height: 200px; object-fit: cover;">
              <?php endif; ?>
              <div class="pos d-non">
                <p class="m-0 font-weight-bolder"><?php echo $gig['price'] ?? '0'; ?> USD</p>
                <span class="text-right">Fixed Price</span>
              </div>
            </div>
          </div>
          <div class="card-body p-0">
            <h4 class="card-title job-detail-rating my-3"><?php echo $gig['title'] ?? 'No Title'; ?></h4>
            <div class="card-review d-flex">
              <?php if (!empty($gig['user_info']['imageURL'])): ?>
                <img class="img-fluid rounded-circle rounded mr-3 cmnt-image" src="<?php echo $gig['user_info']['imageURL']; ?>" alt="" style="width: 40px; height: 40px; object-fit: cover;">
              <?php else: ?>
                <img class="img-fluid rounded-circle rounded mr-3 cmnt-image" src="<?php echo base_url() . 'assets/images/default-avatar.png'; ?>" alt="" style="width: 40px; height: 40px; object-fit: cover;">
              <?php endif; ?>
              <div class="coments d-flex flex-column">
                <a href="#" class="username-rating"><?php echo $gig['user_info']['name'] ?? 'Unknown'; ?></a>
                <div class="star-ratings">
                  <?php
                  $total_rating = 5;
                  $myrating = $gig['user_info']['rating'] ?? 5;
                  $remaining_rating = $total_rating - $myrating;

                  for ($i = 0; $i < $myrating; $i++) { ?>
                    <span class="fa fa-star checked"></span>
                  <?php } ?>

                  <?php for ($i = 0; $i < $remaining_rating; $i++) { ?>
                    <span class="fa fa-star"></span>
                  <?php } ?>

                  <span class="rating-number"> (<?php echo $myrating . ".0"; ?>)</span>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </a>
  <?php }
} else { ?>
  <div class="col-12">
    <p class="text-center">No gigs found.</p>
  </div>
<?php } ?>