<div class="main-profile-box skillsprofile-box bg-white p-4">

  <!-- Description Section -->
  <div class="description-profile">
    <div class="d-flex flex-row justify-content-between">
      <p class="lead">Description</p>
      <i class="fa fa-pencil" data-toggle="modal" data-target="#profilemodal" aria-hidden="true" style="cursor:pointer;"></i>
    </div>
    <span class="detail-desc"><?= $userdata['description'] ?? 'No description added.' ?></span>
  </div>
  <hr>

  <!-- Education Section -->
  <div class="education-box-inner mb-4 description-profile">
    <p class="lead">Education</p>
    <?php if (!empty($userdata['education']) && is_array($userdata['education'])): ?>
      <?php foreach ($userdata['education'] as $id => $education): ?>
        <p class="qualification"><?= $education['title'] ?? '' ?></p>
        <span class="detail-desc"><?= $education['subject'] ?? '' ?></span>
      <?php endforeach; ?>
    <?php else: ?>
      <p class="text-muted">No education added.</p>
    <?php endif; ?>
  </div>
  <hr>

  <!-- Skills Section -->
  <div class="education-box-inner description-profile">
    <p class="lead">Skills</p>
    <div class="input-tags-field">
      <div class="input-tags-profile-seller">
        <?php if (!empty($userdata['skills']) && is_array($userdata['skills'])): ?>
          <?php foreach ($userdata['skills'] as $id => $skill): ?>
            <button type="button" class="btn btn-light"><?= $skill['name'] ?? '' ?></button>
          <?php endforeach; ?>
        <?php else: ?>
          <p class="text-muted">No skills added.</p>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>

<!-- Edit Modal -->
<div class="modal" id="profilemodal" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Edit Data</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">

        <!-- Description Edit -->
        <div class="form-group">
          <label class="form-label">Description</label>
          <textarea class="form-control" name="description" placeholder="Add description"><?= $userdata['description'] ?? '' ?></textarea>
        </div>

        <!-- Education Edit (just an example, not full dynamic handling) -->
        <div class="form-group">
          <label class="form-label">Education</label>
          <input class="form-control" name="education" placeholder="Add education" value="<?= $userdata['education'][1]['title'] ?? '' ?>" />
        </div>

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-primary">Save changes</button>
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>