<div class="view-jobs-section">
  <div class="row justify-content-center">
    <?php
    if (!empty($gigs)) {
      $gigCount = 0;
      foreach ($gigs as $l => $gr) {
        $title = $gr['title'] ?? 'No Title';
        $price = $gr['price'] ?? 'N/A';
        $firstImage = $gr['firstImage'] ?? base_url('assets/default-image.jpg');
        $userId = $gr['user_id'] ?? '0000';
        $userName = $gr['user_info']['name'] ?? 'Unknown';
        $userRating = (int)($gr['user_info']['rating'] ?? 0);
        $userRating = max(0, min(5, $userRating)); // keep rating between 0–5
        $remainingRating = 5 - $userRating;

        $cardClass = $gigCount > 3 ? "moreBox" : "";
        $style = $gigCount > 3 ? "display: none;" : "";
    ?>
        <div class="col-12 col-sm-8 col-md-6 col-lg-3 blogBox <?= $cardClass ?>" onclick="window.location='<?= base_url('site/gigdetailseller/' . $userId . '/' . $l) ?>'" style="cursor: pointer; <?= $style ?>">


          <div class="card car-cat-view-jobs p-0">
            <div class="two-image-rating">
              <div class="fixed-price">
                <img class="img-fluid w-100" src="<?php echo $firstImage; ?>" alt="Gig Image" style="border-radius:1.5rem">
                <div class="pos">
                  <p class="m-0 font-weight-bolder"><?php echo $price; ?></p>
                  <span class="text-right">Fixed Price</span>
                </div>
              </div>
            </div>
            <div class="card-body p-3">
              <h4 class="card-title job-detail-rating my-3"><?php echo $title; ?></h4>
              <div class="card-review d-flex">
                <img class="img-fluid rounded-circl rounded mr-3 cmnt-image" src="<?php echo $firstImage; ?>" alt="User Image">
                <div class="coments d-flex flex-column">
                  <a href="#" class="username-rating"><?php echo $userName; ?></a>
                  <div class="star-ratings">
                    <?php for ($i = 0; $i < $userRating; $i++) { ?>
                      <span class="fa fa-star checked"></span>
                    <?php } ?>
                    <?php for ($i = 0; $i < $remainingRating; $i++) { ?>
                      <span class="fa fa-star"></span>
                    <?php } ?>
                    <span class="rating-number"> (<?php echo $userRating; ?>.0)</span>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      <?php
        $gigCount++;
      }
    } else {
      ?>
      <div class="jumbotron bg-white px-4 py-4">
        <div class="d-flex justify-content-center align-items-center flex-column flex-md-row">
          No Active Jobs
        </div>
      </div>
    <?php } ?>
  </div>

  <!-- Load more button -->
  <div class="d-flex justify-content-center mt-4">
    <button type="button" class="btn btn-primary font-weight-bold shadow-none text-uppercase" id="loadMore" style="background-color: #318ce7;">Load More</button>
  </div>
</div>