<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Chat_model extends CI_Model
{

  function __construct()
  {
    parent::__construct();
    $this->load->model('users_model');
  }

  function getAllGigs()
  {
    $db = $this->firebase->getdatabase();
    $data = $db->getReference('AllGigs')->getSnapshot()->getValue();
    return $data;
  }

  function getChat($user)
  {
    $db = $this->firebase->getdatabase();
    $data = $db->getReference('Chat/' . $user)->getSnapshot()->getValue();
    return $data;
  }

  function getInbox($user)
  {
    $db = $this->firebase->getdatabase();
    $chat = $db->getReference('Chat/' . $user)->getSnapshot()->getValue();
    $data = NULL;
    if (!empty($chat) && $chat != "" && $chat != NULL) {
      foreach ($chat as $sender => $conversation) {
        if ($sender != "MessageList") {
          $userdata = $this->users_model->getUser($sender);
          $data[$sender]["user"] = $userdata["name"];
          $conversation = $this->getConversation($user, $sender);
          if (!empty($conversation)) {
            $data[$sender]["last_message"] = $conversation["last_message"];
            $data[$sender]["time"] = $conversation["time"];
          } else {
            $data[$sender]["last_message"] = "";
            $data[$sender]["time"] = "";
          }
        }
      }
    }
    return $data;
  }

  function getConversation($user, $sender)
  {
    $db = $this->firebase->getdatabase();
    $conversation = $db->getReference('Chat/' . $user . '/MessageList///' . $sender)->orderByChild('time')->getSnapshot()->getValue();
    if ($conversation && !empty($conversation)) {
      $data["last_message"] = $conversation["last_message"];
      $data["time"] = $conversation["time"];
    } else {
      $data = NULL;
    }
    return $data;
  }

  function getConversationByUser($user, $sender)
  {
    $db = $this->firebase->getdatabase();
    if ($sender && $sender != "" && $sender != NULL)
      $conversation = $db->getReference('Chat/' . $user . '/' . $sender)->orderByChild('time')->getSnapshot()->getValue();
    else
      $conversation = NULL;
    if ($conversation && $conversation != "" && $conversation != Null) {
      $data = $conversation;
      foreach ($conversation as $key => $message) {
        if ($message["from"] == $this->session->userdata['user']) {
          $data[$key]["sender"] = "You";
        } else {
          $data[$key]["sender"] = $this->users_model->getUsername($message["from"]);
        }
      }
    } else {
      $data = Null;
    }
    return $data;
  }

  public function add_message($details)
  {
    $details["seen"] = "no";
    $details["time"] = time();
    $details["timeWithFormat"] = date('h:i a', time());

    $list["last_message"] = $details["message"];
    $list["time"] = time();
    $list["type"] = $details["type"];

    $db = $this->firebase->getdatabase();
    $postRef = $db->getReference('Chat/' . $details["to"] . '/' . $details["from"])->push($details);
    $postKey = $postRef->getKey();
    $postRef = $db->getReference('Chat/' . $details["from"] . '/' . $details["to"])->push($details);
    $postKey = $postRef->getKey();

    $list["status"] = "1";
    $postRef = $db->getReference('Chat/' . $details["from"] . '/MessageList/' . $details["to"])->update($list);
    $postKey = $postRef->getKey();
    $list["status"] = "0";
    $postRef = $db->getReference('Chat/' . $details["to"] . '/MessageList/' . $details["from"])->update($list);
    $postKey = $postRef->getKey();

    return $postKey;
  }

  public function add_offer($details)
  {
    if ($details["postedBy"] == $this->session->userdata['user']) {
      $details["postedBy"] = $details["to"];
    }
    $data["biderID"] = $this->session->userdata['user'];
    $data["from"] = $this->session->userdata['user'];
    $data["jobID"] = $details['jobId'];
    $data["jobPostedBy"] = $details['postedBy'];
    $data["to"] = $details['postedBy'];
    $data['type'] = "offers";
    $data["offerInfo"] = $details;
    $data["time"] = $details["time"];
    $db = $this->firebase->getdatabase();
    $postRef = $db->getReference('Chat/' . $this->session->userdata['user'] . '/' . $details['postedBy'])->push($data);
    $postKey = $postRef->getKey();
    $postRef = $db->getReference('Chat/' . $details['postedBy'] . '/' . $this->session->userdata['user'])->push($data);
    $postKey = $postRef->getKey();
    return;
  }
}
