<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Gigs_model extends CI_Model
{

  function __construct()
  {
    parent::__construct();
  }

  function getAllGigs()
  {
    $db = $this->firebase->getdatabase();
    $data = $db->getReference('AllGigs')->getSnapshot()->getValue();
    return $data;
  }

  function getRandomGigs()
  {
    $db = $this->firebase->getdatabase();
    $gigs = $db->getReference('Gigs')->getSnapshot()->getValue();


    $data = NULL;
    if (!empty($gigs)) {
      foreach ($gigs as $i => $l) {
        foreach ($l as $id => $gig) {
          if (!empty($gig)) {
            $data[$id]['user_id'] = $i;
            $data[$id]["catID"] = $gig["catID"];
            $data[$id]["subCatID"] = $gig["subCatID"];
            $data[$id]["attachment"] = $gig["attachment"];
            $data[$id]["deliveryTime"] = $gig["deliveryTime"];
            $data[$id]["description"] = $gig["description"];
            $data[$id]["Premiumgigdescription"] = $gig["Premiumgigdescription"];
            $data[$id]["Standardgigdescription"] = $gig["Standardgigdescription"];
            $data[$id]["firstImage"] = $gig["firstImage"];
            $data[$id]["price"] = $gig["price"];
            $data[$id]["premiumprices"] = $gig["premiumprices"];
            $data[$id]["standardprices"] = $gig["standardprices"];
            $data[$id]["revisions"] = $gig["revisions"];
            $data[$id]["secondImage"] = $gig["secondImage"];
            $data[$id]["tags"] = $gig["tags"];
            // $data[$id]["thirdImage"] = $gig["thirdImage"];
            $data[$id]["title"] = $gig["title"];
            $data[$id]["user_info"] = $db->getReference('Users/' . $i)->getSnapshot()->getValue();
          }
        }
      }
    }
    return $data;
  }

  function getGigsByCategory($catId)
  {
    $db = $this->firebase->getdatabase();
    $gigs = $db->getReference('Gigs')->getSnapshot()->getValue();

    $data = NULL;
    if (!empty($gigs)) {
      foreach ($gigs as $i => $l) {
        foreach ($l as $id => $gig) {
          if (!empty($gig)) {
            if ($gig["catID"] == $catId) {
              $data[$id]['user_id'] = $i;
              $data[$id]["catID"] = $gig["catID"];
              $data[$id]["subCatID"] = $gig["subCatID"];
              $data[$id]["attachment"] = $gig["attachment"];
              $data[$id]["deliveryTime"] = $gig["deliveryTime"];
              $data[$id]["description"] = $gig["description"];
              $data[$id]["Premiumgigdescription"] = $gig["Premiumgigdescription"];
              $data[$id]["Standardgigdescription"] = $gig["Standardgigdescription"];
              $data[$id]["firstImage"] = $gig["firstImage"];
              $data[$id]["price"] = $gig["price"];
              $data[$id]["premiumprices"] = $gig["premiumprices"];
              $data[$id]["standardprices"] = $gig["standardprices"];
              $data[$id]["revisions"] = $gig["revisions"];
              $data[$id]["secondImage"] = $gig["secondImage"];
              $data[$id]["tags"] = $gig["tags"];
              $data[$id]["title"] = $gig["title"];
              $data[$id]["user_info"] = $db->getReference('Users/' . $i)->getSnapshot()->getValue();
            }
          }
        }
      }
    }
    return $data;
  }

  function getGigsBySubCategory($catId, $subCatId)
  {
    $db = $this->firebase->getdatabase();
    $gigs = $db->getReference('Gigs')->getSnapshot()->getValue();

    $data = NULL;
    if (!empty($gigs)) {
      foreach ($gigs as $i => $l) {
        foreach ($l as $id => $gig) {
          if (!empty($gig)) {
            if ($gig["catID"] == $catId && $gig["subCatID"] == $subCatId) {
              $data[$id]['user_id'] = $i;
              $data[$id]["catID"] = $gig["catID"];
              $data[$id]["subCatID"] = $gig["subCatID"];
              $data[$id]["attachment"] = $gig["attachment"];
              $data[$id]["deliveryTime"] = $gig["deliveryTime"];
              $data[$id]["description"] = $gig["description"];
              $data[$id]["Premiumgigdescription"] = $gig["Premiumgigdescription"];
              $data[$id]["Standardgigdescription"] = $gig["Standardgigdescription"];
              $data[$id]["firstImage"] = $gig["firstImage"];
              $data[$id]["price"] = $gig["price"];
              $data[$id]["premiumprices"] = $gig["premiumprices"];
              $data[$id]["standardprices"] = $gig["standardprices"];
              $data[$id]["revisions"] = $gig["revisions"];
              $data[$id]["secondImage"] = $gig["secondImage"];
              $data[$id]["tags"] = $gig["tags"];
              $data[$id]["title"] = $gig["title"];
              $data[$id]["user_info"] = $db->getReference('Users/' . $i)->getSnapshot()->getValue();
            }
          }
        }
      }
    }
    return $data;
  }

  function getGigsByTags($tag)
  {
    $db = $this->firebase->getdatabase();
    $gigs = $db->getReference('Gigs')->getSnapshot()->getValue();

    $data = NULL;
    if (!empty($gigs)) {
      foreach ($gigs as $i => $l) {
        foreach ($l as $id => $gig) {
          if (!empty($gig)) {
            if (strpos($gig["tags"], $tag) !== false) {
              $data[$id]['user_id'] = $i;
              $data[$id]["catID"] = $gig["catID"];
              $data[$id]["subCatID"] = $gig["subCatID"];
              $data[$id]["attachment"] = $gig["attachment"];
              $data[$id]["deliveryTime"] = $gig["deliveryTime"];
              $data[$id]["description"] = $gig["description"];
              $data[$id]["Premiumgigdescription"] = $gig["Premiumgigdescription"];
              $data[$id]["Standardgigdescription"] = $gig["Standardgigdescription"];
              $data[$id]["firstImage"] = $gig["firstImage"];
              $data[$id]["price"] = $gig["price"];
              $data[$id]["premiumprices"] = $gig["premiumprices"];
              $data[$id]["standardprices"] = $gig["standardprices"];
              $data[$id]["revisions"] = $gig["revisions"];
              $data[$id]["secondImage"] = $gig["secondImage"];
              $data[$id]["tags"] = $gig["tags"];
              $data[$id]["title"] = $gig["title"];
              $data[$id]["user_info"] = $db->getReference('Users/' . $i)->getSnapshot()->getValue();
            }
          }
        }
      }
    }
    return $data;
  }

  function getlikeGigs($user)
  {
    $db = $this->firebase->getdatabase();
    $x = array();
    $data = NULL;
    $gia = $db->getReference('favoriateGig/' . $user)->getSnapshot()->getValue();
    if (!empty($gia)) {
      foreach ($gia as $id => $ck) {
        //echo $id;
        $gig = $db->getReference('Gigs/' . $ck['giguser_id'] . '/' . $ck['gig_id'])->getSnapshot()->getValue();

        if (!empty($gig)) {
          $data[$id]["catID"] = $gig["catID"];
          $data[$id]["subCatID"] = $gig["subCatID"];
          $data[$id]['user_id'] = $ck['giguser_id'];
          $data[$id]["attachment"] = $gig["attachment"];
          $data[$id]["deliveryTime"] = $gig["deliveryTime"];
          $data[$id]["description"] = $gig["description"];
          $data[$id]["Premiumgigdescription"] = $gig["Premiumgigdescription"];
          $data[$id]["Standardgigdescription"] = $gig["Standardgigdescription"];
          $data[$id]["firstImage"] = $gig["firstImage"];
          $data[$id]["price"] = $gig["price"];
          $data[$id]["premiumprices"] = $gig["premiumprices"];
          $data[$id]["standardprices"] = $gig["standardprices"];
          $data[$id]["revisions"] = $gig["revisions"];
          $data[$id]["secondImage"] = $gig["secondImage"];
          $data[$id]["tags"] = $gig["tags"];
          $data[$id]["thirdImage"] = $gig["thirdImage"];
          $data[$id]["title"] = $gig["title"];
          $data[$id]["user_info"] = $db->getReference('Users/' . $ck['giguser_id'])->getSnapshot()->getValue();
        }
      }
    }
    return $data;
  }

  function getsavedGigs($user)
  {
    $db = $this->firebase->getdatabase();
    $x = array();
    $data = NULL;
    $gia = $db->getReference('saveGig/' . $user)->getSnapshot()->getValue();
    if (!empty($gia)) {
      foreach ($gia as $id => $ck) {
        //echo $id;
        $gig = $db->getReference('Gigs/' . $ck['giguser_id'] . '/' . $ck['gig_id'])->getSnapshot()->getValue();

        if (!empty($gig)) {

          $data[$id]["catID"] = $gig["catID"];
          $data[$id]["subCatID"] = $gig["subCatID"];
          $data[$id]['user_id'] = $ck['giguser_id'];
          $data[$id]["attachment"] = $gig["attachment"];
          $data[$id]["deliveryTime"] = $gig["deliveryTime"];
          $data[$id]["description"] = $gig["description"];
          $data[$id]["Premiumgigdescription"] = $gig["Premiumgigdescription"];
          $data[$id]["Standardgigdescription"] = $gig["Standardgigdescription"];
          $data[$id]["firstImage"] = $gig["firstImage"];
          $data[$id]["price"] = $gig["price"];
          $data[$id]["premiumprices"] = $gig["premiumprices"];
          $data[$id]["standardprices"] = $gig["standardprices"];
          $data[$id]["revisions"] = $gig["revisions"];
          $data[$id]["secondImage"] = $gig["secondImage"];
          $data[$id]["tags"] = $gig["tags"];
          $data[$id]["thirdImage"] = $gig["thirdImage"];
          $data[$id]["title"] = $gig["title"];
          $data[$id]["user_info"] = $db->getReference('Users/' . $ck['giguser_id'])->getSnapshot()->getValue();
        }
      }
    }
    return $data;
  }


  function getGigs($user)
  {
    $db = $this->firebase->getdatabase();
    $gigs = $db->getReference('Gigs/' . $user)->getSnapshot()->getValue();

    $data = NULL;
    if (!empty($gigs)) {
      foreach ($gigs as $id => $gig) {

        $data[$id]["catID"] = $gig["catID"];
        $data[$id]["subCatID"] = $gig["subCatID"];
        $data[$id]["attachment"] = $gig["attachment"];
        $data[$id]["deliveryTime"] = $gig["deliveryTime"];
        $data[$id]["description"] = $gig["description"];
        $data[$id]["Premiumgigdescription"] = $gig["Premiumgigdescription"];
        $data[$id]["Standardgigdescription"] = $gig["Standardgigdescription"];
        $data[$id]["firstImage"] = $gig["firstImage"];
        $data[$id]["price"] = $gig["price"];
        $data[$id]["premiumprices"] = $gig["premiumprices"];
        $data[$id]["standardprices"] = $gig["standardprices"];
        $data[$id]["revisions"] = $gig["revisions"];
        $data[$id]["secondImage"] = $gig["secondImage"];
        $data[$id]["tags"] = $gig["tags"];
        $data[$id]["thirdImage"] = $gig["thirdImage"];
        $data[$id]["title"] = $gig["title"];
      }
    }
    return $data;
  }

  function getGigDetails($user, $gigId)
  {
    $db = $this->firebase->getdatabase();
    $gigDetails = $db->getReference('Gigs/' . $user . '/' . $gigId)->getSnapshot()->getValue();

    $data = NULL;
    if (!empty($gigDetails)) {
      return $gigDetails;
    }
    return $data;
  }

  function getActiveGigs($user)
  {
    $db = $this->firebase->getdatabase();
    $gigs = $db->getReference('Gigs/' . $user)->getSnapshot()->getValue();
    $data = NULL;
    if (!empty($gigs)) {
      foreach ($gigs as $id => $gig) {
        $data[$id]["catID"] = $gig["catID"];
        $data[$id]["subCatID"] = $gig["subCatID"];
        $data[$id]["attachment"] = $gig["attachment"];
        $data[$id]["deliveryTime"] = $gig["deliveryTime"];
        $data[$id]["description"] = $gig["description"];
        $data[$id]["Premiumgigdescription"] = $gig["Premiumgigdescription"];
        $data[$id]["Standardgigdescription"] = $gig["Standardgigdescription"];
        $data[$id]["firstImage"] = $gig["firstImage"];
        $data[$id]["price"] = $gig["price"];
        $data[$id]["premiumprices"] = $gig["premiumprices"];
        $data[$id]["standardprices"] = $gig["standardprices"];
        $data[$id]["revisions"] = $gig["revisions"];
        $data[$id]["secondImage"] = $gig["secondImage"];
        $data[$id]["tags"] = $gig["tags"];
        $data[$id]["thirdImage"] = $gig["thirdImage"];
        $data[$id]["title"] = $gig["title"];
      }
    }
    return $data;
  }
}
