<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Login_model extends CI_Model
{

    function __construct()
    {
        parent::__construct();
    }

    public function create_session($name, $key)
    {
        // Setup login session for given email
        $this->session->set_userdata('name', $name);
        $this->session->set_userdata('user', $key);
    }

    public function get_session_info()
    {
        if ($this->session->userdata('login_type')) {
            $first_name = $this->db->select('first_name')->where('user_id', $this->session->userdata('login_id'))->get('users')->row_array()['first_name'];
            $last_name = $this->db->select('last_name')->where('user_id', $this->session->userdata('login_id'))->get('users')->row_array()['last_name'];
            $profile_pic = $this->db->select('profile_pic')->where('user_id', $this->session->userdata('login_id'))->get('users')->row_array()['profile_pic'];
            $role = $this->db->select('role')->where('user_id', $this->session->userdata('login_id'))->get('users')->row_array()['role'];
            $about_me = $this->db->select('about_me')->where('user_id', $this->session->userdata('login_id'))->get('users')->row_array()['about_me'];
            $email = $this->db->select('email')->where('user_id', $this->session->userdata('login_id'))->get('users')->row_array()['email'];
            $email_notifications = $this->db->select('email_notifications')->where('user_id', $this->session->userdata('login_id'))->get('users')->row_array()['email_notifications'];
            $offset = $this->db->select('offset')->where('user_id', $this->session->userdata('login_id'))->get('users')->row_array()['offset'];
            $timezone = $this->db->select('timezone')->where('user_id', $this->session->userdata('login_id'))->get('users')->row_array()['timezone'];
            $dst_start = $this->db->select('dst_start')->where('user_id', $this->session->userdata('login_id'))->get('users')->row_array()['dst_start'];
            $dst_end = $this->db->select('dst_end')->where('user_id', $this->session->userdata('login_id'))->get('users')->row_array()['dst_end'];

            // Add the current timezone corrected time to page data
            $date = new DateTime('now', new DateTimeZone('UTC'));
            $date->setTimezone(new DateTimeZone($timezone));

            $dst_start = new DateTime($dst_start, new DateTimeZone('UTC'));
            $dst_end = new DateTime($dst_end, new DateTimeZone('UTC'));
            $dst_start->setTimezone(new DateTimeZone($timezone));
            $dst_end->setTimezone(new DateTimeZone($timezone));

            $info = array(
                'first_name' => $first_name,
                'last_name' => $last_name,
                'profile_pic' => $profile_pic,
                'role' => $role,
                'email' => $email,
                'about_me' => $about_me,
                'email_notifications' => $email_notifications,
                'timezone' => $timezone,
                'id' => $this->session->userdata('login_id'),
            );

            return $info;
        } else {
            return NULL;
        }
    }

    public function destroy_session()
    {
        // Destroy the local session
        $this->session->sess_destroy();
    }

    public function check_login_credentials($username, $password)
    {
        $data = array();
        $firebase = $this->firebase->init();
        $db = $firebase->createDatabase();
        $auth = $firebase->createAuth();
        try {
            $userdata = $auth->getUserByEmail($username);
        
            if ($userdata->emailVerified) {
                $signInResult = $auth->signInWithEmailAndPassword($username, $password);
                $my = $signInResult->data();
                $data['success'] = 1;
                $data['result'] = $my;
                $this->set_remember_me_token($username);
                $da = $db->getReference('Users')->orderByChild('email')->equalTo($username)->getSnapshot()->getValue();
                foreach ($da as $key => $user) {
                    $this->create_session($user["name"], $key);
                }
            } else {
                $data['success'] = 0;
                $data['msg'] = "Email is not verified. Please Verify the email address to continue.";
                $auth->sendEmailVerificationLink($username);
                $this->clear_remember_me_token();
            }
        } catch (Kreait\Firebase\Auth\SignIn\FailedToSignIn $e) {
            $data['success'] = 0;
            $data['msg'] = $e->getMessage();
            $this->clear_remember_me_token();
        }
        return $data;
    }

    public function forgotPassword($username, $password)
    {
        $data = array();
        $firebase = $this->firebase->init();
        $db = $firebase->createDatabase();
        $auth = $firebase->createAuth();
        try {
            $userdata = $auth->getUserByEmail($username);
            $properties = [
                'password' => strval($password)
            ];
            $auth->updateUser(strval($userdata->uid), $properties);
            $data['success'] = 1;
            $data['msg'] = "A verification email is sent to your provided email address. Please check your email.";
            $this->clear_remember_me_token();
        } catch (Kreait\Firebase\Auth\SignIn\FailedToSignIn $e) {
            $data['success'] = 0;
            $data['msg'] = $e->getMessage();
            $this->clear_remember_me_token();
        }
        return $data;
    }



    public function set_remember_me_token($id)
    {
        $cookie = array(
            'name'   => 'remember_me_token',
            'value'  => $id,
            'expire' => '1209600',  // Two weeks
            'path'   => '/'
        );

        // Create/Update the remember me cookie
        $this->input->set_cookie($cookie);
    }

    public function clear_remember_me_token()
    {
        $cookie = array(
            'name'   => 'remember_me_token',
            'value'  => '',
            'expire' => '',  // To delete the cookie, set expiration blank
        );

        // Delete the remember me cookie
        $this->input->set_cookie($cookie);
    }

    public function check_remember_me_token()
    {
        $browser_cookie = $this->input->cookie('remember_me_token');


        if ($browser_cookie !== NULL) {
            $firebase = $this->firebase->init();
            $db = $firebase->createDatabase();
            $auth = $firebase->createAuth();
            $query = $db->getReference('Users')->orderByChild('email')->equalTo($browser_cookie)->getSnapshot()->getValue();
            foreach ($query as $key => $user) {
                $this->create_session($user["name"], $key);
                $data['success'] = 1;
                return TRUE;
            }
            return FALSE;
        } else {
            return FALSE;
        }
    }
}
