<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Site extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();
		//$this->load->model('gigs_model');
		$this->load->model('jobs_model');
		$this->load->model('users_model');
		$this->load->model('chat_model');
		$this->load->model('offers_model');
		$this->load->model('orders_model');
		$this->load->model('login_model');
		$this->load->model('categories_model');
		$this->load->library('encryption');
	}

	public function index()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
		}
		$this->data['gigs'] = $this->gigs_model->getRandomGigs();
		$this->data['categories'] = $this->categories_model->getAllCategories();
		$this->load->view('home', $this->data);
	}

	public function logout()
	{
		$this->login_model->clear_remember_me_token();
		$this->session->sess_destroy();
		redirect(base_url());
	}


	public function ordersbuyer()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['userdata'] = $this->users_model->getUser($this->session->userdata('user'));
		$this->data['activeOrders'] = $this->orders_model->getActiveOrders($this->session->userdata('user'));
		$this->data['allOrders'] = $this->orders_model->getAllOrders($this->session->userdata('user'));
		$this->load->view('orders_buyer', $this->data);
	}

	public function gigsbuyer()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['userdata'] = $this->users_model->getUser($this->session->userdata('user'));
		$this->data['activeGigs'] = $this->gigs_model->getActiveGigs($this->session->userdata('user'));
		$this->data['allGigs'] = $this->gigs_model->getAllGigs($this->session->userdata('user'));
		$this->load->view('gigs_buyer', $this->data);
	}

	public function earningsbuyer()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->load->view('earnings_buyer');
	}

	public function workrequestbuyer($categoryId = "")
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['userdata'] = $this->users_model->getUser($this->session->userdata('user'));
		if ($categoryId != "") {
			$this->data['jobs'] = $this->jobs_model->getJobsByCategory($categoryId);
		} else {
			$this->data['jobs'] = $this->jobs_model->getAllJobs();
		}
		$this->data['categories'] = $this->categories_model->getAllCategories();
		$this->data['categoryId'] = $categoryId;
		$this->load->view('workrequest_buyer', $this->data);
	}

	public function dashboardbuyer()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['userdata'] = $this->users_model->getUser($this->session->userdata('user'));
		$this->data['gigs'] = $this->gigs_model->getGigs($this->session->userdata('user'));
		$this->data['inbox'] = $this->chat_model->getInbox($this->session->userdata('user'));
		$this->data['activeOrders'] = $this->orders_model->getActiveOrders($this->session->userdata('user'));
		$this->data['averageRating'] = $this->orders_model->getAverageRating($this->session->userdata('user'));
		$this->data['earningInMonth'] = $this->orders_model->getEarningInMonth($this->session->userdata('user'));
		$this->load->view('dashboard_buyer', $this->data);
	}

	public function messagebuyer()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['userdata'] = $this->users_model->getUser($this->session->userdata('user'));
		$this->data['inbox'] = $this->chat_model->getInbox($this->session->userdata('user'));
		$temp = NULL;
		if ($this->input->get('conversation') != "" && $this->input->get('conversation') != Null  && $this->input->get('conversation')) {
			$this->data['conversationWith'] = $this->input->get('conversation');
		} else {
			if ($this->data['inbox'] && $this->data['inbox'] != "" && $this->data['inbox'] != NULL)
				$temp = array_keys($this->data['inbox']);
			else
				$temp = NULL;
			if ($temp != NULL && $temp[0] != "" && $temp[0] != Null && $temp[0])
				$this->data['conversationWith'] = $temp[0];
			else
				$this->data['conversationWith'] = Null;
		}
		$this->data['conversationWithId'] = $this->data['conversationWith'];
		$this->data['chat'] = $this->chat_model->getConversationByUser($this->session->userdata('user'), $this->data['conversationWith']);
		$this->data['conversationWith'] = $this->users_model->getUsername($this->data['conversationWith']);
		$this->load->view('message_buyer', $this->data);
	}

	public function radial()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->load->view('radial-menu');
	}



	public function creategig()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$data['categories'] = $this->categories_model->getAllCategories();
		// echo "<pre>";
		// print_r($this->session->userdata('user'));
		// echo "</pre>";
		$this->load->view('create-gig', $data);
	}

	public function editgig()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data["gigId"] = $this->input->get('gigId');
		$this->data["gigDetails"] = $this->gigs_model->getGigDetails($this->session->userdata('user'), $this->data["gigId"]);
		$this->data['categories'] = $this->categories_model->getAllCategories();
		$this->load->view('edit-gig', $this->data);
	}

	public function addgigdata()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$firebase = $this->firebase->init();
		$storage = $firebase->createStorage();
		$defaultBucket = $storage->getBucket();

		$data = $this->input->post();
		$data['gigPostedBy'] = $this->session->userdata('user');

		if ($_FILES['firstImage']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['firstImage']['tmp_name']),
				[
					'name' => "gigImage" . rand() . time() . $_FILES['firstImage']['name'],
				]
			);

			$data['firstImage'] = $uploadedFile->info()['mediaLink'];
		} else {
			$data['firstImage'] = "";
		}

		if ($_FILES['secondImage']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['secondImage']['tmp_name']),
				[
					'name' => "gigImage" . rand() . time() . $_FILES['secondImage']['name'],
				]
			);

			$data['secondImage'] = $uploadedFile->info()['mediaLink'];
		} else {
			$data['secondImage'] = "";
		}

		if ($_FILES['thirdImage']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['thirdImage']['tmp_name']),
				[
					'name' => "gigImage" . rand() . time() . $_FILES['thirdImage']['name'],
				]
			);

			$data['thirdImage'] = $uploadedFile->info()['mediaLink'];
		} else {
			$data['thirdImage'] = "";
		}

		if ($_FILES['attachment']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['attachment']['tmp_name']),
				[
					'name' => "gigImage" . rand() . time() . $_FILES['attachment']['name'],
				]
			);

			$data['attachment'] = $uploadedFile->info()['mediaLink'];
		} else {
			$data['attachment'] = "";
		}

		$db = $firebase->createDatabase();
		$mytime = strtotime(date("Y-m-d h:i:sa"));
		$db->getReference('Gigs/' . $this->session->userdata('user') . '/' . $mytime)->update($data);
		$this->session->set_flashdata("flash_message", "GiG has Been Added Successfuly");
		redirect(base_url() . 'Site/creategig');
	}

	public function editgigdata()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$firebase = $this->firebase->init();
		$storage = $firebase->createStorage();
		$defaultBucket = $storage->getBucket();
		$db = $firebase->createDatabase();
		$data = $this->input->post();
		$data['gigPostedBy'] = $this->session->userdata('user');
		$db->getReference('Gigs/' . $this->session->userdata('user') . '/' . $data["gigId"])->update($data);

		if ($_FILES['firstImage']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['firstImage']['tmp_name']),
				[
					'name' => "gigImage" . rand() . time() . $_FILES['firstImage']['name'],
				]
			);

			$data['firstImage'] = $uploadedFile->info()['mediaLink'];
			$db->getReference('Gigs/' . $this->session->userdata('user') . '/' . $data["gigId"])->update($data);
		}

		if ($_FILES['secondImage']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['secondImage']['tmp_name']),
				[
					'name' => "gigImage" . rand() . time() . $_FILES['secondImage']['name'],
				]
			);

			$data['secondImage'] = $uploadedFile->info()['mediaLink'];
			$db->getReference('Gigs/' . $this->session->userdata('user') . '/' . $data["gigId"])->update($data);
		}

		if ($_FILES['thirdImage']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['thirdImage']['tmp_name']),
				[
					'name' => "gigImage" . rand() . time() . $_FILES['thirdImage']['name'],
				]
			);

			$data['thirdImage'] = $uploadedFile->info()['mediaLink'];
			$db->getReference('Gigs/' . $this->session->userdata('user') . '/' . $data["gigId"])->update($data);
		}

		if ($_FILES['attachment']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['attachment']['tmp_name']),
				[
					'name' => "gigImage" . rand() . time() . $_FILES['attachment']['name'],
				]
			);

			$data['attachment'] = $uploadedFile->info()['mediaLink'];
			$db->getReference('Gigs/' . $this->session->userdata('user') . '/' . $data["gigId"])->update($data);
		}
		$this->session->set_flashdata("flash_message", "GiG has Been Edited Successfuly");
		redirect(base_url() . 'Site/gigdetailbuyer/' . $data["gigId"]);
	}

	public function gigdetailbuyer($id)
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$firebase = $this->firebase->init();
		$db = $firebase->createDatabase();
		$user_id = $this->session->userdata('user');
		$x = $db->getReference('Gigs/' . $this->session->userdata('user') . '/' . $id)->getSnapshot()->getValue();
		$data['gigdetail'] = $x;
		$data['gig_id'] = $id;
		$this->load->view('gig_detail_buyer', $data);
	}


	public function dashboardseller()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['userdata'] = $this->users_model->getUser($this->session->userdata('user'));
		$this->data['gigs'] = $this->gigs_model->getGigs($this->session->userdata('user'));
		$this->data['getRandomGigs'] = $this->gigs_model->getRandomGigs();
		$this->data['categories'] = $this->categories_model->getAllCategories();
		$this->data['likegigs'] = $this->gigs_model->getlikeGigs($this->session->userdata('user'));
		$this->data['savegigs'] = $this->gigs_model->getsavedGigs($this->session->userdata('user'));
		$this->load->view('dashboard_seller', $this->data);
	}

	public function category($catId)
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['gigs'] = $this->gigs_model->getGigsByCategory($catId);
		$this->data['categories'] = $this->categories_model->getAllCategories();
		$this->load->view('gigs_categories', $this->data);
	}

	public function searchServices()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$tag = $this->input->post('tag');
		$this->data['gigs'] = $this->gigs_model->getGigsByTags($tag);
		$this->data['categories'] = $this->categories_model->getAllCategories();
		$this->load->view('gigs_categories', $this->data);
	}

	public function serviceByCategory()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		if (!empty($this->input->get('subCategory'))) {
			$subCatId = $this->input->get('subCategory');
		}
		if (!empty($this->input->get('category'))) {
			$catId = $this->input->get('category');
		}

		if (!empty($subCatId) && $subCatId != "") {
			$this->data['gigs'] = $this->gigs_model->getGigsBySubCategory($catId, $subCatId);
		} else {
			$this->data['gigs'] = $this->gigs_model->getGigsByCategory($catId);
		}
		$this->data['categories'] = $this->categories_model->getAllCategories();
		$this->load->view('gigs_categories', $this->data);
	}

	public function postrequestseller()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$jobs = $this->jobs_model->getJobPostedBy($this->session->userdata('user'));
		$this->data['jobsCount'] = count($jobs);
		$this->data['categories'] = $this->categories_model->getAllCategories();
		$this->load->view('postrequest_seller', $this->data);
	}


	public function ordersseller()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['userdata'] = $this->users_model->getUser($this->session->userdata('user'));
		$this->data['activeOrders'] = $this->orders_model->getActiveOrders($this->session->userdata('user'));
		$this->data['allOrders'] = $this->orders_model->getAllOrders($this->session->userdata('user'));
		$this->data['categories'] = $this->categories_model->getAllCategories();
		$this->load->view('orders_seller', $this->data);
	}


	public function projectdetailsseller()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$order = $this->input->get();
		$this->data['orderDetails'] = $this->orders_model->getOrderDetails($this->session->userdata('user'), $order['orderId']);
		$this->load->view('projectdetails_seller', $this->data);
	}

	public function projectdetailsbuyer()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$order = $this->input->get();
		$this->data['orderDetails'] = $this->orders_model->getOrderDetails($this->session->userdata('user'), $order['orderId']);
		// print_r($this->data['orderDetails']);
		// exit;
		$this->load->view('projectdetails_buyer', $this->data);
	}


	public function profileseller()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['userdata'] = $this->users_model->getUser($this->session->userdata('user'));
		$this->load->view('profile_seller', $this->data);
	}


	public function messageseller()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['userdata'] = $this->users_model->getUser($this->session->userdata('user'));
		$this->data['inbox'] = $this->chat_model->getInbox($this->session->userdata('user'));
		$temp = NULL;
		if ($this->input->get('conversation') != "" && $this->input->get('conversation') != Null  && $this->input->get('conversation')) {
			$this->data['conversationWith'] = $this->input->get('conversation');
		} else {
			if ($this->data['inbox'] && $this->data['inbox'] != "" && $this->data['inbox'] != NULL)
				$temp = array_keys($this->data['inbox']);
			else
				$temp = NULL;
			if ($temp != NULL && $temp[0] != "" && $temp[0] != Null && $temp[0])
				$this->data['conversationWith'] = $temp[0];
			else
				$this->data['conversationWith'] = Null;
		}
		$this->data['conversationWithId'] = $this->data['conversationWith'];
		$this->data['chat'] = $this->chat_model->getConversationByUser($this->session->userdata('user'), $this->data['conversationWith']);
		$this->data['conversationWith'] = $this->users_model->getUsername($this->data['conversationWith']);
		$this->load->view('message_seller', $this->data);
	}

	public function gigdetailseller($user_id, $id)
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		//	echo $user_id;
		$firebase = $this->firebase->init();
		$db = $firebase->createDatabase();
		$my_id = $this->session->userdata('user');
		$x = $db->getReference('Gigs/' . $user_id . '/' . $id)->getSnapshot()->getValue();
		$likestatus = $db->getReference('favoriateGig/' . $my_id . '/' . $id)->getSnapshot()->getValue();
		if (!empty($likestatus)) {
			$data['liked'] = "true";
		} else {
			$data['liked'] = "false";
		}
		$savestatus = $db->getReference('saveGig/' . $my_id . '/' . $id)->getSnapshot()->getValue();
		if (!empty($savestatus)) {
			$data['saved'] = "true";
		} else {
			$data['saved'] = "false";
		}

		//print_r($x);
		$data['gigdetail'] = $x;
		$data['gig_id'] = $id;
		$data['gig_poster_id'] = $user_id;
		$this->load->view('gig_detail_seller', $data);
	}
	function savegig()
	{
		$orderDetails = $this->input->post();
		$firebase = $this->firebase->init();
		$db = $firebase->createDatabase();
		$db->getReference('saveGig/' . $this->session->userdata('user') . '/' . $this->input->post('gig_id'))->update($orderDetails);
	}

	function unsavegig()
	{
		//		print_r($this->input->post());
		$orderDetails = $this->input->post();
		$firebase = $this->firebase->init();
		$db = $firebase->createDatabase();
		$db->getReference('saveGig/' . $this->session->userdata('user') . '/' . $this->input->post('gig_id'))->remove();
	}
	public function orderGig()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$details = $this->input->post();
		$details["jobID"] = time();
		$details["amount"] = $details["budget"];
		$details["totalAmount"] = $details["budget"];
		$details["conversationWith"] = $details["gigPostedBy"];
		$details["note"] = $details["description"];
		$details["orderId"] = $details["jobID"];
		$details["postedAt"] = $details["jobID"];
		$details["status"] = "active";
		$details["deliveryTime"] = "";
		$details["deliveredAt"] = "";
		$details["offeredBy"] = $this->session->userdata('user');
		$details["jobPostedBy"] = $this->session->userdata('user');

		$jobDetails["postedBy"] = $this->session->userdata('user');
		$jobDetails["budget"] = $details["budget"];
		$jobDetails["catID"] = $details["catID"];
		$jobDetails["deliveryTime"] = "";
		$jobDetails["posteAt"] = $details["jobID"];
		$jobDetails["ext"] = "";
		$jobDetails["image_path"] = "";
		$jobDetails["name"] = $details["title"];
		$jobDetails["note"] = $details["description"];
		$jobDetails["type"] = "";

		$db = $this->firebase->getdatabase();
		$postRef = $db->getReference('Jobs/' . $jobDetails["posteAt"])->set($jobDetails);
		$postRef = $db->getReference('Orders/' . $details["jobPostedBy"] . '/' . $details["jobID"])->set($details);
		$postRef = $db->getReference('Orders/' . $details["conversationWith"] . '/' . $details["jobID"])->set($details);
		$postKey = $postRef->getKey();

		redirect(base_url() . 'site/ordersseller');
	}


	function addtofavoraite()
	{
		//		print_r($this->input->post());
		$orderDetails = $this->input->post();
		$firebase = $this->firebase->init();
		$db = $firebase->createDatabase();
		$db->getReference('favoriateGig/' . $this->session->userdata('user') . '/' . $this->input->post('gig_id'))->update($orderDetails);
	}
	//removetofavoraite

	function removetofavoraite()
	{
		//		print_r($this->input->post());
		$orderDetails = $this->input->post();
		$firebase = $this->firebase->init();
		$db = $firebase->createDatabase();
		$db->getReference('favoriateGig/' . $this->session->userdata('user') . '/' . $this->input->post('gig_id'))->remove();;
	}


	public function gigs()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['gigs'] = $this->gigs_model->getGigs($this->session->userdata('login_user'));
		print_r($this->data['gigs']);
		exit;
	}

	public function forgotPassword()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['userdata'] = $this->users_model->getUser($this->session->userdata('user'));
		$this->load->view('forgot-password', $this->data);
	}

	public function changePassword()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$data = $this->input->post();
		$data["user"] = $this->session->userdata('user');
		if ($data["password"] != $data["confirmPassword"]) {
			$this->session->set_flashdata("error_message", "New Password And Confirm Password Doesn't Match!");
			redirect($_SERVER['HTTP_REFERER'], 'refresh');
		}
		$response = $this->users_model->changePassword($data);
		if (!$response) {
			$this->session->set_flashdata("error_message", "Password Doesn't Match!");
			redirect($_SERVER['HTTP_REFERER'], 'refresh');
		}
		$this->session->set_flashdata("flash_message", "Password Updated Successfully!");
		redirect($_SERVER['HTTP_REFERER'], 'refresh');
	}


	public function addOrder()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$data = json_decode($this->input->get('orderDetails'));
		$orderDetails["conversationWith"] = $data->conversationWith;
		$orderDetails["jobPostedBy"] = $data->jobPostedBy;
		$orderDetails["jobID"] = $data->jobID;
		$orderDetails["note"] = $data->note;
		$orderDetails["amount"] = $data->amount;
		$orderDetails["budget"] = $data->budget;
		$jobDetails = $this->jobs_model->getJobDetails($orderDetails["jobID"]);
		$orderDetails["title"] = $jobDetails["name"];
		$orderDetails["deliveryTime"] = $jobDetails["deliveryTime"];
		if ($orderDetails["jobPostedBy"] == $orderDetails["conversationWith"]) {
			$orderDetails["offeredBy"] = $this->session->userdata('user');
		} else {
			$orderDetails["offeredBy"] = $orderDetails["conversationWith"];
		}

		$orderDetails["deliveryTime"] = $jobDetails["deliveryTime"];
		$orderDetails["deliveredAt"] = "";
		$orderDetails["status"] = "active";
		$orderDetails["orderId"] = time();
		$orderDetails["postedAt"] = $orderDetails["orderId"];

		$firebase = $this->firebase->init();
		$db = $firebase->createDatabase();
		$db->getReference('Orders/' . $this->session->userdata('user') . '/' . $orderDetails["orderId"])->update($orderDetails);
		$db->getReference('Orders/' . $orderDetails["conversationWith"] . '/' . $orderDetails["orderId"])->update($orderDetails);
		redirect(base_url('/site/ordersseller'), 'refresh');
	}



	public function post_request()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$currrnttime = strtotime(date("Y-m-d h:i:sa"));
		$data = array();
		$firebase = $this->firebase->init();
		$db = $firebase->createDatabase();
		$storage = $firebase->createStorage();
		$defaultBucket = $storage->getBucket();
		$cat_name = "";
		$category = $this->categories_model->getCategory($this->input->post('category'));
		if (!empty($category)) {
			$cat_name = $category["name"];
		} else {
			$cat_name = "Other";
		}
		$details = array(
			'note' => $this->input->post('description'),
			'catID' => $this->input->post('category'),
			'name' => $cat_name,
			'deliveryTime' => $this->input->post('deliveryTime'),
			'budget' => $this->input->post('budget'),
			'postedBy' => $this->session->userdata('user'),
			'posteAt' => $currrnttime,
			'attachment' => NULL,
		);



		if ($_FILES['product_file']['tmp_name'] != '') {
			$uploadedFile = $defaultBucket->upload(
				file_get_contents($_FILES['product_file']['tmp_name']),
				[
					'name' => "buyerrequest" . rand() . time() . $_FILES['product_file']['name'],
				]
			);

			$details['image_path'] = $uploadedFile->info()['mediaLink'];
			$details['type'] = "file";
			$details['ext'] = pathinfo($_FILES['product_file']['name'], PATHINFO_EXTENSION);
		} else {
			$details['image_path'] = "";
			$details['type'] = "";
			$details['ext'] = "";
		}
		$db->getReference("Jobs/" . $currrnttime)
			->update($details);
		$this->session->set_flashdata("flash_message", "Request  has Been Added Successfuly");
		redirect(base_url() . 'Site/postrequestseller');
	}

	public function sendOffer()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$firebase = $this->firebase->init();
		$db = $firebase->createDatabase();
		$details = $this->input->post();
		$details["postedBy"] = $this->jobs_model->getJobPostedBy($this->input->post("jobId"));

		////Insert into chat First show in list
		$currrnttime = strtotime(date("Y-m-d h:i:sa"));
		/////send recive Offer in message list//
		$mychatlist = array();
		$biderID = $this->session->userdata['user'];

		if ($details["postedBy"] == $biderID) {
			$biderID = $details["to"];
		}

		$d['last_message'] = "You Send Offer";
		$d['status'] = "1";
		$d['type'] = 'offer';

		$d['time'] = time();
		$details['time'] = $d['time'];

		///add in messgaelist both user//
		$postRef = $db->getReference('Chat/' . $biderID . '/MessageList/' . $details['postedBy'])->update($d);

		$d['last_message'] = "You Recived Offer";
		$d['status'] = "0";
		$d['type'] = 'offer';
		$d['to'] = $biderID;
		$d['from'] = $details['postedBy'];
		$postRef = $db->getReference('Chat/' .  $details['postedBy'] . '/MessageList/' . $biderID)->update($d);
		////
		$response = $this->offers_model->add_seller_offer($details);
		$response = $this->chat_model->add_offer($details);
		redirect($_SERVER['HTTP_REFERER'], 'refresh');
	}

	public function sendMessage()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$response = $this->chat_model->add_message($this->input->post());
		redirect($_SERVER['HTTP_REFERER'], 'refresh');
	}

	// privacy policy page
	public function privacypolicy()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->load->view('privacypolicy');
	}
	// terms of services page 
	public function termsofservices()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->load->view('termsofservices');
	}

	public function findafreelancer()
	{
		if (!$this->login_model->check_remember_me_token()) {
			$this->session->set_flashdata('msg', 'You are not logged in. Please login to continue.');
			redirect(base_url());
		}
		$this->data['gigs'] = $this->gigs_model->getRandomGigs();
		$this->data['categories'] = $this->categories_model->getAllCategories();
		$this->load->view('gigs_categories', $this->data);
	}
}
